/*
 * Decompiled with CFR 0.152.
 */
package com.android.monkeyrunner;

import com.android.monkeyrunner.doc.MonkeyRunnerExported;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyBoolean;
import org.python.core.PyDictionary;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyNone;
import org.python.core.PyObject;
import org.python.core.PyReflectedField;
import org.python.core.PyReflectedFunction;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PyTuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JythonUtils {
    private static final Logger LOG = Logger.getLogger(JythonUtils.class.getCanonicalName());
    private static final Map<Class<? extends PyObject>, Class<?>> PYOBJECT_TO_JAVA_OBJECT_MAP;
    private static final Predicate<AccessibleObject> SHOULD_BE_DOCUMENTED;
    private static final Predicate<Field> IS_FIELD_STATIC;

    private JythonUtils() {
    }

    public static ArgParser createArgParser(PyObject[] pyObjectArray, String[] stringArray) {
        Method method;
        Class<?> clazz;
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        StackTraceElement stackTraceElement = stackTraceElementArray[2];
        String string = stackTraceElement.getMethodName();
        String string2 = stackTraceElement.getClassName();
        try {
            clazz = Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOG.log(Level.SEVERE, "Got exception: ", classNotFoundException);
            return null;
        }
        try {
            method = clazz.getMethod(string, PyObject[].class, String[].class);
        }
        catch (SecurityException securityException) {
            LOG.log(Level.SEVERE, "Got exception: ", securityException);
            return null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LOG.log(Level.SEVERE, "Got exception: ", noSuchMethodException);
            return null;
        }
        MonkeyRunnerExported monkeyRunnerExported = method.getAnnotation(MonkeyRunnerExported.class);
        return new ArgParser(string, pyObjectArray, stringArray, monkeyRunnerExported.args());
    }

    public static double getFloat(ArgParser argParser, int n) {
        PyObject pyObject = argParser.getPyObject(n);
        if (Py.isInstance((PyObject)pyObject, (PyObject)PyFloat.TYPE)) {
            return ((PyFloat)pyObject).asDouble();
        }
        if (Py.isInstance((PyObject)pyObject, (PyObject)PyInteger.TYPE)) {
            return ((PyInteger)pyObject).asDouble();
        }
        throw Py.TypeError((String)("Unable to parse argument: " + n));
    }

    public static double getFloat(ArgParser argParser, int n, double d) {
        PyObject pyObject = argParser.getPyObject(n, (PyObject)new PyFloat(d));
        if (Py.isInstance((PyObject)pyObject, (PyObject)PyFloat.TYPE)) {
            return ((PyFloat)pyObject).asDouble();
        }
        if (Py.isInstance((PyObject)pyObject, (PyObject)PyInteger.TYPE)) {
            return ((PyInteger)pyObject).asDouble();
        }
        throw Py.TypeError((String)("Unable to parse argument: " + n));
    }

    public static List<Object> getList(ArgParser argParser, int n) {
        PyObject pyObject = argParser.getPyObject(n, Py.None);
        if (Py.isInstance((PyObject)pyObject, (PyObject)PyNone.TYPE)) {
            return Collections.emptyList();
        }
        ArrayList arrayList = Lists.newArrayList();
        PyList pyList = (PyList)pyObject;
        for (int i = 0; i < pyList.__len__(); ++i) {
            PyObject pyObject2 = pyList.__getitem__(i);
            Class<?> clazz = PYOBJECT_TO_JAVA_OBJECT_MAP.get(pyObject2.getClass());
            if (clazz == null) continue;
            arrayList.add(pyObject2.__tojava__(clazz));
        }
        return arrayList;
    }

    public static Map<String, Object> getMap(ArgParser argParser, int n) {
        PyObject pyObject = argParser.getPyObject(n, Py.None);
        if (Py.isInstance((PyObject)pyObject, (PyObject)PyNone.TYPE)) {
            return Collections.emptyMap();
        }
        HashMap hashMap = Maps.newHashMap();
        PyDictionary pyDictionary = (PyDictionary)pyObject;
        PyList pyList = pyDictionary.items();
        for (int i = 0; i < pyList.__len__(); ++i) {
            PyTuple pyTuple = (PyTuple)pyList.__getitem__(i);
            String string = (String)pyTuple.__getitem__(0).__str__().__tojava__(String.class);
            PyObject pyObject2 = pyTuple.__getitem__(1);
            Class<?> clazz = PYOBJECT_TO_JAVA_OBJECT_MAP.get(pyObject2.getClass());
            if (clazz == null) continue;
            hashMap.put(string, pyObject2.__tojava__(clazz));
        }
        return hashMap;
    }

    private static PyObject convertObject(Object object) {
        if (object instanceof String) {
            return new PyString((String)object);
        }
        if (object instanceof Double) {
            return new PyFloat(((Double)object).doubleValue());
        }
        if (object instanceof Integer) {
            return new PyInteger(((Integer)object).intValue());
        }
        if (object instanceof Float) {
            float f = ((Float)object).floatValue();
            return new PyFloat(f);
        }
        if (object instanceof Boolean) {
            return new PyBoolean(((Boolean)object).booleanValue());
        }
        return Py.None;
    }

    public static PyDictionary convertMapToDict(Map<String, Object> map) {
        HashMap hashMap = Maps.newHashMap();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            hashMap.put(new PyString(entry.getKey()), JythonUtils.convertObject(entry.getValue()));
        }
        return new PyDictionary((Map)hashMap);
    }

    public static void convertDocAnnotationsForClass(Class<?> clazz, PyObject pyObject) {
        MonkeyRunnerExported monkeyRunnerExported;
        PyReflectedFunction pyReflectedFunction;
        String string;
        PyObject pyObject2;
        Object object;
        Object object2;
        Preconditions.checkNotNull((Object)pyObject);
        Preconditions.checkArgument((boolean)(pyObject instanceof PyStringMap));
        if (clazz.isAnnotationPresent(MonkeyRunnerExported.class)) {
            object2 = clazz.getAnnotation(MonkeyRunnerExported.class);
            object = JythonUtils.buildClassDoc((MonkeyRunnerExported)object2, clazz);
            pyObject.__setitem__("__doc__", (PyObject)new PyString((String)object));
        }
        object2 = Sets.newHashSet();
        for (PyObject pyObject3 : pyObject.asIterable()) {
            object2.add(pyObject3.toString());
        }
        object2 = Collections2.filter((Collection)object2, (Predicate)new Predicate<String>(){

            public boolean apply(String string) {
                return !string.startsWith("__");
            }
        });
        for (Method accessibleObject : clazz.getMethods()) {
            if (!accessibleObject.isAnnotationPresent(MonkeyRunnerExported.class) || (pyObject2 = pyObject.__finditem__(string = accessibleObject.getName())) == null || !(pyObject2 instanceof PyReflectedFunction)) continue;
            pyReflectedFunction = (PyReflectedFunction)pyObject2;
            monkeyRunnerExported = accessibleObject.getAnnotation(MonkeyRunnerExported.class);
            pyReflectedFunction.__doc__ = new PyString(JythonUtils.buildDoc(monkeyRunnerExported));
            object2.remove(string);
        }
        for (AccessibleObject accessibleObject : clazz.getFields()) {
            if (!accessibleObject.isAnnotationPresent(MonkeyRunnerExported.class) || (pyObject2 = pyObject.__finditem__(string = ((Field)accessibleObject).getName())) == null || !(pyObject2 instanceof PyReflectedField)) continue;
            pyReflectedFunction = (PyReflectedField)pyObject2;
            monkeyRunnerExported = ((Field)accessibleObject).getAnnotation(MonkeyRunnerExported.class);
            object2.remove(string);
        }
        object = object2.iterator();
        while (object.hasNext()) {
            String string2 = (String)object.next();
            pyObject.__delitem__(string2);
        }
    }

    private static String buildClassDoc(MonkeyRunnerExported monkeyRunnerExported, Class<?> clazz) {
        Collection collection = Collections2.filter(Arrays.asList(clazz.getFields()), SHOULD_BE_DOCUMENTED);
        Collection collection2 = Collections2.filter((Collection)collection, IS_FIELD_STATIC);
        Collection collection3 = Collections2.filter((Collection)collection, (Predicate)Predicates.not(IS_FIELD_STATIC));
        StringBuilder stringBuilder = new StringBuilder();
        for (String object : JythonUtils.splitString(monkeyRunnerExported.doc(), 80)) {
            stringBuilder.append(object).append("\n");
        }
        if (collection2.size() > 0) {
            stringBuilder.append("\nClass Fields: \n");
            for (Field field : collection2) {
                stringBuilder.append(JythonUtils.buildFieldDoc(field));
            }
        }
        if (collection3.size() > 0) {
            stringBuilder.append("\n\nFields: \n");
            for (Field field : collection3) {
                stringBuilder.append(JythonUtils.buildFieldDoc(field));
            }
        }
        return stringBuilder.toString();
    }

    private static String buildFieldDoc(Field field) {
        MonkeyRunnerExported monkeyRunnerExported = field.getAnnotation(MonkeyRunnerExported.class);
        StringBuilder stringBuilder = new StringBuilder();
        int n = 5 + field.getName().length();
        String string = JythonUtils.makeIndent(n);
        stringBuilder.append("  ").append(field.getName()).append(" - ");
        boolean bl = true;
        for (String string2 : JythonUtils.splitString(monkeyRunnerExported.doc(), 80 - n)) {
            if (bl) {
                bl = false;
                stringBuilder.append(string2).append("\n");
                continue;
            }
            stringBuilder.append(string).append(string2).append("\n");
        }
        return stringBuilder.toString();
    }

    private static String buildDoc(MonkeyRunnerExported monkeyRunnerExported) {
        Collection<String> collection = JythonUtils.splitString(monkeyRunnerExported.doc(), 80);
        StringBuilder stringBuilder = new StringBuilder();
        for (String stringArray : collection) {
            stringBuilder.append(stringArray).append("\n");
        }
        if (monkeyRunnerExported.args() != null && monkeyRunnerExported.args().length > 0) {
            String[] stringArray2 = monkeyRunnerExported.args();
            String[] stringArray = monkeyRunnerExported.argDocs();
            stringBuilder.append("\n  Args:\n");
            for (int i = 0; i < monkeyRunnerExported.args().length; ++i) {
                stringBuilder.append("    ").append(stringArray2[i]);
                if (stringArray == null || stringArray.length <= i) continue;
                stringBuilder.append(" - ");
                int n = stringArray2[i].length() + 3 + 4;
                Collection<String> collection2 = JythonUtils.splitString(stringArray[i], 80 - n);
                boolean bl = true;
                String string = JythonUtils.makeIndent(n);
                for (String string2 : collection2) {
                    if (bl) {
                        bl = false;
                        stringBuilder.append(string2).append("\n");
                        continue;
                    }
                    stringBuilder.append(string).append(string2).append("\n");
                }
            }
        }
        return stringBuilder.toString();
    }

    private static String makeIndent(int n) {
        if (n == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (n > 0) {
            stringBuffer.append(' ');
            --n;
        }
        return stringBuffer.toString();
    }

    private static Collection<String> splitString(String string, int n) {
        BreakIterator breakIterator = BreakIterator.getLineInstance();
        breakIterator.setText(string);
        ArrayList arrayList = Lists.newArrayList();
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = breakIterator.first();
        int n3 = breakIterator.next();
        while (n3 != -1) {
            String string2 = string.substring(n2, n3);
            if (stringBuilder.length() + string2.length() < n) {
                stringBuilder.append(string2);
            } else {
                arrayList.add(stringBuilder.toString());
                stringBuilder = new StringBuilder(string2);
            }
            n2 = n3;
            n3 = breakIterator.next();
        }
        arrayList.add(stringBuilder.toString());
        return arrayList;
    }

    public static Set<String> getMethodNames(Class<?> clazz) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Method method : clazz.getMethods()) {
            if (!method.isAnnotationPresent(MonkeyRunnerExported.class)) continue;
            hashSet.add(method.getName());
        }
        return hashSet;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put(PyString.class, String.class);
        builder.put(PyFloat.class, Double.class);
        builder.put(PyInteger.class, Integer.class);
        builder.put(PyBoolean.class, Boolean.class);
        PYOBJECT_TO_JAVA_OBJECT_MAP = builder.build();
        SHOULD_BE_DOCUMENTED = new Predicate<AccessibleObject>(){

            public boolean apply(AccessibleObject accessibleObject) {
                return accessibleObject.isAnnotationPresent(MonkeyRunnerExported.class);
            }
        };
        IS_FIELD_STATIC = new Predicate<Field>(){

            public boolean apply(Field field) {
                return (field.getModifiers() & 8) != 0;
            }
        };
    }
}

