/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.tools.lint.Main;
import com.android.tools.lint.Reporter;
import com.android.tools.lint.Warning;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.google.common.annotations.Beta;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public class XmlReporter
extends Reporter {
    private final Writer mWriter;

    public XmlReporter(Main main, File file) throws IOException {
        super(main, file);
        this.mWriter = new BufferedWriter(Files.newWriter(file, Charsets.UTF_8));
    }

    @Override
    public void write(int n, int n2, List<Warning> list) throws IOException {
        this.mWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<issues>\n");
        if (list.size() > 0) {
            for (Warning warning : list) {
                this.mWriter.write(10);
                XmlReporter.indent(this.mWriter, 1);
                this.mWriter.write("<issue");
                XmlReporter.writeAttribute(this.mWriter, 2, "id", warning.issue.getId());
                XmlReporter.writeAttribute(this.mWriter, 2, "severity", warning.severity.getDescription());
                XmlReporter.writeAttribute(this.mWriter, 2, "message", warning.message);
                assert (warning.file != null == (warning.location != null));
                if (warning.file != null) assert (warning.location.getFile() == warning.file);
                Location location = warning.location;
                if (location != null) {
                    this.mWriter.write(">\n");
                    while (location != null) {
                        XmlReporter.indent(this.mWriter, 2);
                        this.mWriter.write("<location");
                        String string = this.mClient.getDisplayPath(warning.project, location.getFile());
                        XmlReporter.writeAttribute(this.mWriter, 3, "file", string);
                        Position position = location.getStart();
                        if (position != null) {
                            int n3 = position.getLine();
                            int n4 = position.getColumn();
                            if (n3 >= 0) {
                                XmlReporter.writeAttribute(this.mWriter, 3, "line", Integer.toString(n3 + 1));
                                if (n4 >= 0) {
                                    XmlReporter.writeAttribute(this.mWriter, 3, "column", Integer.toString(n4 + 1));
                                }
                            }
                        }
                        this.mWriter.write("/>\n");
                        location = location.getSecondary();
                    }
                    XmlReporter.indent(this.mWriter, 1);
                    this.mWriter.write("</issue>\n");
                    continue;
                }
                this.mWriter.write(10);
                XmlReporter.indent(this.mWriter, 1);
                this.mWriter.write("/>\n");
            }
        }
        this.mWriter.write("\n</issues>\n");
        this.mWriter.close();
        String string = this.mOutput.getAbsolutePath();
        System.out.println(String.format("Wrote HTML report to %1$s", string));
    }

    private static void writeAttribute(Writer writer, int n, String string, String string2) throws IOException {
        writer.write(10);
        XmlReporter.indent(writer, n);
        writer.write(string);
        writer.write(61);
        writer.write(34);
        int n2 = string2.length();
        block6: for (int i = 0; i < n2; ++i) {
            char c = string2.charAt(i);
            switch (c) {
                case '\"': {
                    writer.write("&quot;");
                    continue block6;
                }
                case '\'': {
                    writer.write("&apos;");
                    continue block6;
                }
                case '&': {
                    writer.write("&amp;");
                    continue block6;
                }
                case '<': {
                    writer.write("&lt;");
                    continue block6;
                }
                default: {
                    writer.write(c);
                }
            }
        }
        writer.write(34);
    }

    private static void indent(Writer writer, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            writer.write("    ");
        }
    }
}

