/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewer;

import com.android.ddmlib.Log;
import com.android.ddmuilib.ImageLoader;
import com.android.hierarchyviewer.HierarchyViewerApplicationDirector;
import com.android.hierarchyviewer.actions.AboutAction;
import com.android.hierarchyviewer.actions.LoadAllViewsAction;
import com.android.hierarchyviewer.actions.QuitAction;
import com.android.hierarchyviewer.actions.ShowOverlayAction;
import com.android.hierarchyviewer.util.ActionButton;
import com.android.hierarchyviewerlib.HierarchyViewerDirector;
import com.android.hierarchyviewerlib.actions.CapturePSDAction;
import com.android.hierarchyviewerlib.actions.DisplayViewAction;
import com.android.hierarchyviewerlib.actions.DumpDisplayListAction;
import com.android.hierarchyviewerlib.actions.InspectScreenshotAction;
import com.android.hierarchyviewerlib.actions.InvalidateAction;
import com.android.hierarchyviewerlib.actions.LoadOverlayAction;
import com.android.hierarchyviewerlib.actions.LoadViewHierarchyAction;
import com.android.hierarchyviewerlib.actions.PixelPerfectAutoRefreshAction;
import com.android.hierarchyviewerlib.actions.RefreshPixelPerfectAction;
import com.android.hierarchyviewerlib.actions.RefreshPixelPerfectTreeAction;
import com.android.hierarchyviewerlib.actions.RefreshViewAction;
import com.android.hierarchyviewerlib.actions.RefreshWindowsAction;
import com.android.hierarchyviewerlib.actions.RequestLayoutAction;
import com.android.hierarchyviewerlib.actions.SavePixelPerfectAction;
import com.android.hierarchyviewerlib.actions.SaveTreeViewAction;
import com.android.hierarchyviewerlib.device.DeviceBridge;
import com.android.hierarchyviewerlib.models.DeviceSelectionModel;
import com.android.hierarchyviewerlib.models.PixelPerfectModel;
import com.android.hierarchyviewerlib.models.TreeViewModel;
import com.android.hierarchyviewerlib.ui.DeviceSelector;
import com.android.hierarchyviewerlib.ui.LayoutViewer;
import com.android.hierarchyviewerlib.ui.PixelPerfect;
import com.android.hierarchyviewerlib.ui.PixelPerfectControls;
import com.android.hierarchyviewerlib.ui.PixelPerfectLoupe;
import com.android.hierarchyviewerlib.ui.PixelPerfectPixelPanel;
import com.android.hierarchyviewerlib.ui.PixelPerfectTree;
import com.android.hierarchyviewerlib.ui.PropertyViewer;
import com.android.hierarchyviewerlib.ui.TreeView;
import com.android.hierarchyviewerlib.ui.TreeViewControls;
import com.android.hierarchyviewerlib.ui.TreeViewOverview;
import com.android.menubar.IMenuBarEnhancer;
import com.android.menubar.MenuBarEnhancer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;

public class HierarchyViewerApplication
extends ApplicationWindow {
    private static final String APP_NAME = "Hierarchy Viewer";
    private static final int INITIAL_WIDTH = 1280;
    private static final int INITIAL_HEIGHT = 800;
    private static HierarchyViewerApplication sMainWindow;
    private Image mDeviceViewImage;
    private Image mPixelPerfectImage;
    private Image mTreeViewImage;
    private Image mDeviceViewSelectedImage;
    private Image mPixelPerfectSelectedImage;
    private Image mTreeViewSelectedImage;
    private Button mTreeViewButton;
    private Button mPixelPerfectButton;
    private Button mDeviceViewButton;
    private Label mProgressLabel;
    private ProgressBar mProgressBar;
    private String mProgressString;
    private Composite mDeviceSelectorPanel;
    private Composite mTreeViewPanel;
    private Composite mPixelPerfectPanel;
    private StackLayout mMainWindowStackLayout;
    private DeviceSelector mDeviceSelector;
    private Composite mStatusBar;
    private TreeView mTreeView;
    private Composite mMainWindow;
    private Image mOnBlackImage;
    private Image mOnWhiteImage;
    private Button mOnBlackWhiteButton;
    private Button mShowExtras;
    private LayoutViewer mLayoutViewer;
    private PixelPerfectLoupe mPixelPerfectLoupe;
    private Composite mTreeViewControls;
    private ActionButton dumpDisplayList;
    private HierarchyViewerDirector mDirector;
    private SelectionListener deviceViewButtonSelectionListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            HierarchyViewerApplication.this.mDeviceViewButton.setSelection(true);
            HierarchyViewerApplication.this.showDeviceSelector();
        }
    };
    private SelectionListener treeViewButtonSelectionListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            HierarchyViewerApplication.this.mTreeViewButton.setSelection(true);
            HierarchyViewerApplication.this.showTreeView();
        }
    };
    private SelectionListener pixelPerfectButtonSelectionListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            HierarchyViewerApplication.this.mPixelPerfectButton.setSelection(true);
            HierarchyViewerApplication.this.showPixelPerfect();
        }
    };
    private SelectionListener onBlackWhiteSelectionListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (HierarchyViewerApplication.this.mLayoutViewer.getOnBlack()) {
                HierarchyViewerApplication.this.mLayoutViewer.setOnBlack(false);
                HierarchyViewerApplication.this.mOnBlackWhiteButton.setImage(HierarchyViewerApplication.this.mOnBlackImage);
            } else {
                HierarchyViewerApplication.this.mLayoutViewer.setOnBlack(true);
                HierarchyViewerApplication.this.mOnBlackWhiteButton.setImage(HierarchyViewerApplication.this.mOnWhiteImage);
            }
        }
    };
    private SelectionListener showExtrasSelectionListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            HierarchyViewerApplication.this.mLayoutViewer.setShowExtras(HierarchyViewerApplication.this.mShowExtras.getSelection());
        }
    };
    private SelectionListener loadAllViewsSelectionListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            HierarchyViewerApplication.this.mShowExtras.setSelection(true);
            HierarchyViewerApplication.this.showExtrasSelectionListener.widgetSelected(null);
        }
    };
    private TreeViewModel.ITreeChangeListener mTreeChangeListener = new TreeViewModel.ITreeChangeListener(){

        public void selectionChanged() {
        }

        public void treeChanged() {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    if (TreeViewModel.getModel().getTree() == null) {
                        HierarchyViewerApplication.this.showDeviceSelector();
                        HierarchyViewerApplication.this.mTreeViewButton.setEnabled(false);
                    } else {
                        HierarchyViewerApplication.this.showTreeView();
                        HierarchyViewerApplication.this.mTreeViewButton.setEnabled(true);
                    }
                }
            });
        }

        public void viewportChanged() {
        }

        public void zoomChanged() {
        }
    };
    private PixelPerfectModel.IImageChangeListener mImageChangeListener = new PixelPerfectModel.IImageChangeListener(){

        public void crosshairMoved() {
        }

        public void treeChanged() {
        }

        public void imageChanged() {
        }

        public void imageLoaded() {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    if (PixelPerfectModel.getModel().getImage() == null) {
                        HierarchyViewerApplication.this.mPixelPerfectButton.setEnabled(false);
                        HierarchyViewerApplication.this.showDeviceSelector();
                    } else {
                        HierarchyViewerApplication.this.mPixelPerfectButton.setEnabled(true);
                        HierarchyViewerApplication.this.showPixelPerfect();
                    }
                }
            });
        }

        public void overlayChanged() {
        }

        public void overlayTransparencyChanged() {
        }

        public void selectionChanged() {
        }

        public void zoomChanged() {
        }
    };

    public static final HierarchyViewerApplication getMainWindow() {
        return sMainWindow;
    }

    public HierarchyViewerApplication() {
        super(null);
        sMainWindow = this;
        this.addMenuBar();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(APP_NAME);
        ImageLoader imageLoader = ImageLoader.getLoader(HierarchyViewerDirector.class);
        Image image = imageLoader.loadImage("sdk-hierarchyviewer-128.png", Display.getDefault());
        shell.setImage(image);
    }

    public MenuManager createMenuManager() {
        return new MenuManager();
    }

    public void run() {
        block2: {
            this.setBlockOnOpen(true);
            try {
                this.open();
            }
            catch (SWTException sWTException) {
                if (this.getShell().isDisposed()) break block2;
                throw sWTException;
            }
        }
        TreeViewModel.getModel().removeTreeChangeListener(this.mTreeChangeListener);
        PixelPerfectModel.getModel().removeImageChangeListener(this.mImageChangeListener);
        ImageLoader.dispose();
        this.mDirector.stopListenForDevices();
        this.mDirector.stopDebugBridge();
        this.mDirector.terminate();
    }

    protected void initializeBounds() {
        Rectangle rectangle = Display.getDefault().getPrimaryMonitor().getBounds();
        this.getShell().setSize(Math.min(rectangle.width, 1280), Math.min(rectangle.height, 800));
        this.getShell().setLocation(rectangle.x + (rectangle.width - 1280) / 2, rectangle.y + (rectangle.height - 800) / 2);
    }

    private void loadResources() {
        ImageLoader imageLoader = ImageLoader.getLoader(HierarchyViewerDirector.class);
        this.mTreeViewImage = imageLoader.loadImage("tree-view.png", Display.getDefault());
        this.mTreeViewSelectedImage = imageLoader.loadImage("tree-view-selected.png", Display.getDefault());
        this.mPixelPerfectImage = imageLoader.loadImage("pixel-perfect-view.png", Display.getDefault());
        this.mPixelPerfectSelectedImage = imageLoader.loadImage("pixel-perfect-view-selected.png", Display.getDefault());
        this.mDeviceViewImage = imageLoader.loadImage("device-view.png", Display.getDefault());
        this.mDeviceViewSelectedImage = imageLoader.loadImage("device-view-selected.png", Display.getDefault());
        this.mOnBlackImage = imageLoader.loadImage("on-black.png", Display.getDefault());
        this.mOnWhiteImage = imageLoader.loadImage("on-white.png", Display.getDefault());
    }

    protected Control createContents(Composite composite) {
        this.mDirector = HierarchyViewerApplicationDirector.createDirector();
        this.mDirector.initDebugBridge();
        this.mDirector.startListenForDevices();
        this.mDirector.populateDeviceSelectionModel();
        TreeViewModel.getModel().addTreeChangeListener(this.mTreeChangeListener);
        PixelPerfectModel.getModel().addImageChangeListener(this.mImageChangeListener);
        this.loadResources();
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        composite2.setLayout((Layout)gridLayout);
        this.mMainWindow = new Composite(composite2, 0);
        this.mMainWindow.setLayoutData((Object)new GridData(1808));
        this.mMainWindowStackLayout = new StackLayout();
        this.mMainWindow.setLayout((Layout)this.mMainWindowStackLayout);
        this.buildDeviceSelectorPanel(this.mMainWindow);
        this.buildTreeViewPanel(this.mMainWindow);
        this.buildPixelPerfectPanel(this.mMainWindow);
        this.buildStatusBar(composite2);
        this.showDeviceSelector();
        return composite2;
    }

    private void buildStatusBar(Composite composite) {
        this.mStatusBar = new Composite(composite, 0);
        this.mStatusBar.setLayoutData((Object)new GridData(768));
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 2;
        formLayout.marginHeight = 2;
        this.mStatusBar.setLayout((Layout)formLayout);
        this.mDeviceViewButton = new Button(this.mStatusBar, 2);
        this.mDeviceViewButton.setImage(this.mDeviceViewImage);
        this.mDeviceViewButton.setToolTipText("Switch to the window selection view");
        this.mDeviceViewButton.addSelectionListener(this.deviceViewButtonSelectionListener);
        FormData formData = new FormData();
        formData.left = new FormAttachment();
        this.mDeviceViewButton.setLayoutData((Object)formData);
        this.mTreeViewButton = new Button(this.mStatusBar, 2);
        this.mTreeViewButton.setImage(this.mTreeViewImage);
        this.mTreeViewButton.setEnabled(false);
        this.mTreeViewButton.setToolTipText("Switch to the tree view");
        this.mTreeViewButton.addSelectionListener(this.treeViewButtonSelectionListener);
        FormData formData2 = new FormData();
        formData2.left = new FormAttachment((Control)this.mDeviceViewButton, 2);
        this.mTreeViewButton.setLayoutData((Object)formData2);
        this.mPixelPerfectButton = new Button(this.mStatusBar, 2);
        this.mPixelPerfectButton.setImage(this.mPixelPerfectImage);
        this.mPixelPerfectButton.setEnabled(false);
        this.mPixelPerfectButton.setToolTipText("Switch to the pixel perfect view");
        this.mPixelPerfectButton.addSelectionListener(this.pixelPerfectButtonSelectionListener);
        FormData formData3 = new FormData();
        formData3.left = new FormAttachment((Control)this.mTreeViewButton, 2);
        this.mPixelPerfectButton.setLayoutData((Object)formData3);
        this.mTreeViewControls = new TreeViewControls(this.mStatusBar);
        FormData formData4 = new FormData();
        formData4.left = new FormAttachment((Control)this.mPixelPerfectButton, 2);
        formData4.top = new FormAttachment((Control)this.mTreeViewButton, 0, 0x1000000);
        formData4.width = 552;
        this.mTreeViewControls.setLayoutData((Object)formData4);
        this.mProgressLabel = new Label(this.mStatusBar, 131072);
        this.mProgressBar = new ProgressBar(this.mStatusBar, 65794);
        FormData formData5 = new FormData();
        formData5.right = new FormAttachment(100, 0);
        formData5.top = new FormAttachment((Control)this.mTreeViewButton, 0, 0x1000000);
        this.mProgressBar.setLayoutData((Object)formData5);
        FormData formData6 = new FormData();
        formData6.right = new FormAttachment((Control)this.mProgressBar, -2);
        formData6.top = new FormAttachment((Control)this.mTreeViewButton, 0, 0x1000000);
        this.mProgressLabel.setLayoutData((Object)formData6);
        if (this.mProgressString == null) {
            this.mProgressLabel.setVisible(false);
            this.mProgressBar.setVisible(false);
        } else {
            this.mProgressLabel.setText(this.mProgressString);
        }
    }

    private void buildDeviceSelectorPanel(Composite composite) {
        this.mDeviceSelectorPanel = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        this.mDeviceSelectorPanel.setLayout((Layout)gridLayout);
        Composite composite2 = new Composite(this.mDeviceSelectorPanel, 0);
        composite2.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.marginHeight = 0;
        gridLayout2.marginWidth = 0;
        gridLayout2.verticalSpacing = 0;
        gridLayout2.horizontalSpacing = 0;
        composite2.setLayout((Layout)gridLayout2);
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayoutData((Object)new GridData(1040));
        GridLayout gridLayout3 = new GridLayout(3, true);
        gridLayout3.marginHeight = 2;
        gridLayout3.marginWidth = 2;
        gridLayout3.verticalSpacing = 2;
        gridLayout3.horizontalSpacing = 2;
        composite3.setLayout((Layout)gridLayout3);
        ActionButton actionButton = new ActionButton(composite3, RefreshWindowsAction.getAction());
        actionButton.setLayoutData(new GridData(1808));
        ActionButton actionButton2 = new ActionButton(composite3, LoadViewHierarchyAction.getAction());
        actionButton2.setLayoutData(new GridData(1808));
        ActionButton actionButton3 = new ActionButton(composite3, InspectScreenshotAction.getAction());
        actionButton3.setLayoutData(new GridData(1808));
        Composite composite4 = new Composite(this.mDeviceSelectorPanel, 2048);
        composite4.setLayoutData((Object)new GridData(1808));
        composite4.setLayout((Layout)new FillLayout());
        this.mDeviceSelector = new DeviceSelector(composite4, true, true);
    }

    public void buildTreeViewPanel(Composite composite) {
        this.mTreeViewPanel = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        this.mTreeViewPanel.setLayout((Layout)gridLayout);
        Composite composite2 = new Composite(this.mTreeViewPanel, 0);
        composite2.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.marginHeight = 0;
        gridLayout2.marginWidth = 0;
        gridLayout2.verticalSpacing = 0;
        gridLayout2.horizontalSpacing = 0;
        composite2.setLayout((Layout)gridLayout2);
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayoutData((Object)new GridData(1040));
        GridLayout gridLayout3 = new GridLayout(7, true);
        gridLayout3.marginHeight = 2;
        gridLayout3.marginWidth = 2;
        gridLayout3.verticalSpacing = 2;
        gridLayout3.horizontalSpacing = 2;
        composite3.setLayout((Layout)gridLayout3);
        ActionButton actionButton = new ActionButton(composite3, SaveTreeViewAction.getAction(this.getShell()));
        actionButton.setLayoutData(new GridData(1808));
        ActionButton actionButton2 = new ActionButton(composite3, CapturePSDAction.getAction(this.getShell()));
        actionButton2.setLayoutData(new GridData(1808));
        ActionButton actionButton3 = new ActionButton(composite3, RefreshViewAction.getAction());
        actionButton3.setLayoutData(new GridData(1808));
        ActionButton actionButton4 = new ActionButton(composite3, DisplayViewAction.getAction(this.getShell()));
        actionButton4.setLayoutData(new GridData(1808));
        ActionButton actionButton5 = new ActionButton(composite3, InvalidateAction.getAction());
        actionButton5.setLayoutData(new GridData(1808));
        ActionButton actionButton6 = new ActionButton(composite3, RequestLayoutAction.getAction());
        actionButton6.setLayoutData(new GridData(1808));
        this.dumpDisplayList = new ActionButton(composite3, DumpDisplayListAction.getAction());
        this.dumpDisplayList.setLayoutData(new GridData(1808));
        SashForm sashForm = new SashForm(this.mTreeViewPanel, 65792);
        sashForm.setLayoutData((Object)new GridData(1808));
        Composite composite4 = new Composite((Composite)sashForm, 2048);
        composite4.setLayout((Layout)new FillLayout());
        this.mTreeView = new TreeView(composite4);
        SashForm sashForm2 = new SashForm((Composite)sashForm, 66048);
        sashForm.SASH_WIDTH = 4;
        sashForm.setWeights(new int[]{7, 3});
        Composite composite5 = new Composite((Composite)sashForm2, 2048);
        composite5.setLayout((Layout)new FillLayout());
        new TreeViewOverview(composite5);
        Composite composite6 = new Composite((Composite)sashForm2, 2048);
        composite6.setLayout((Layout)new FillLayout());
        new PropertyViewer(composite6);
        Composite composite7 = new Composite((Composite)sashForm2, 0);
        GridLayout gridLayout4 = new GridLayout();
        gridLayout4.marginHeight = 0;
        gridLayout4.marginWidth = 0;
        gridLayout4.verticalSpacing = 1;
        gridLayout4.horizontalSpacing = 1;
        composite7.setLayout((Layout)gridLayout4);
        Composite composite8 = new Composite(composite7, 0);
        composite8.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout5 = new GridLayout(2, false);
        gridLayout5.marginHeight = 0;
        gridLayout5.marginWidth = 0;
        gridLayout5.marginRight = 2;
        gridLayout5.verticalSpacing = 0;
        gridLayout5.horizontalSpacing = 0;
        composite8.setLayout((Layout)gridLayout5);
        Composite composite9 = new Composite(composite8, 0);
        composite9.setLayoutData((Object)new GridData(1040));
        RowLayout rowLayout = new RowLayout(256);
        rowLayout.marginBottom = 0;
        rowLayout.marginTop = 0;
        rowLayout.marginRight = 0;
        rowLayout.marginLeft = 0;
        rowLayout.pack = true;
        rowLayout.center = true;
        composite9.setLayout((Layout)rowLayout);
        this.mOnBlackWhiteButton = new Button(composite9, 8);
        this.mOnBlackWhiteButton.setImage(this.mOnWhiteImage);
        this.mOnBlackWhiteButton.addSelectionListener(this.onBlackWhiteSelectionListener);
        this.mOnBlackWhiteButton.setToolTipText("Change layout viewer background color");
        this.mShowExtras = new Button(composite9, 32);
        this.mShowExtras.setText("Show Extras");
        this.mShowExtras.addSelectionListener(this.showExtrasSelectionListener);
        this.mShowExtras.setToolTipText("Show images");
        ActionButton actionButton7 = new ActionButton(composite8, LoadAllViewsAction.getAction());
        actionButton7.setLayoutData(new GridData(3, 2, true, true));
        actionButton7.addSelectionListener(this.loadAllViewsSelectionListener);
        Composite composite10 = new Composite(composite7, 2048);
        composite10.setLayoutData((Object)new GridData(1808));
        composite10.setLayout((Layout)new FillLayout());
        this.mLayoutViewer = new LayoutViewer(composite10);
        sashForm2.SASH_WIDTH = 4;
        sashForm2.setWeights(new int[]{238, 332, 416});
    }

    private void buildPixelPerfectPanel(Composite composite) {
        this.mPixelPerfectPanel = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        this.mPixelPerfectPanel.setLayout((Layout)gridLayout);
        Composite composite2 = new Composite(this.mPixelPerfectPanel, 0);
        composite2.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.marginHeight = 0;
        gridLayout2.marginWidth = 0;
        gridLayout2.verticalSpacing = 0;
        gridLayout2.horizontalSpacing = 0;
        composite2.setLayout((Layout)gridLayout2);
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayoutData((Object)new GridData(1040));
        GridLayout gridLayout3 = new GridLayout(6, true);
        gridLayout3.marginHeight = 2;
        gridLayout3.marginWidth = 2;
        gridLayout3.verticalSpacing = 2;
        gridLayout3.horizontalSpacing = 2;
        composite3.setLayout((Layout)gridLayout3);
        ActionButton actionButton = new ActionButton(composite3, SavePixelPerfectAction.getAction(this.getShell()));
        actionButton.setLayoutData(new GridData(1808));
        ActionButton actionButton2 = new ActionButton(composite3, RefreshPixelPerfectAction.getAction());
        actionButton2.setLayoutData(new GridData(1808));
        ActionButton actionButton3 = new ActionButton(composite3, RefreshPixelPerfectTreeAction.getAction());
        actionButton3.setLayoutData(new GridData(1808));
        ActionButton actionButton4 = new ActionButton(composite3, LoadOverlayAction.getAction(this.getShell()));
        actionButton4.setLayoutData(new GridData(1808));
        ActionButton actionButton5 = new ActionButton(composite3, ShowOverlayAction.getAction());
        actionButton5.setLayoutData(new GridData(1808));
        ActionButton actionButton6 = new ActionButton(composite3, PixelPerfectAutoRefreshAction.getAction());
        actionButton6.setLayoutData(new GridData(1808));
        SashForm sashForm = new SashForm(this.mPixelPerfectPanel, 65792);
        sashForm.setLayoutData((Object)new GridData(1808));
        sashForm.SASH_WIDTH = 4;
        Composite composite4 = new Composite((Composite)sashForm, 2048);
        composite4.setLayout((Layout)new FillLayout());
        new PixelPerfectTree(composite4);
        Composite composite5 = new Composite((Composite)sashForm, 0);
        GridLayout gridLayout4 = new GridLayout();
        gridLayout4.marginHeight = 0;
        gridLayout4.marginWidth = 0;
        gridLayout4.verticalSpacing = 0;
        gridLayout4.horizontalSpacing = 0;
        composite5.setLayout((Layout)gridLayout4);
        Composite composite6 = new Composite(composite5, 2048);
        composite6.setLayoutData((Object)new GridData(1808));
        GridLayout gridLayout5 = new GridLayout();
        gridLayout5.marginHeight = 0;
        gridLayout5.marginWidth = 0;
        gridLayout5.verticalSpacing = 0;
        gridLayout5.horizontalSpacing = 0;
        composite6.setLayout((Layout)gridLayout5);
        this.mPixelPerfectLoupe = new PixelPerfectLoupe(composite6);
        this.mPixelPerfectLoupe.setLayoutData(new GridData(1808));
        PixelPerfectPixelPanel pixelPerfectPixelPanel = new PixelPerfectPixelPanel(composite6);
        pixelPerfectPixelPanel.setLayoutData(new GridData(768));
        PixelPerfectControls pixelPerfectControls = new PixelPerfectControls(composite5);
        pixelPerfectControls.setLayoutData(new GridData(768));
        Composite composite7 = new Composite((Composite)sashForm, 2048);
        composite7.setLayout((Layout)new FillLayout());
        new PixelPerfect(composite7);
        sashForm.setWeights(new int[]{272, 376, 346});
    }

    public void showOverlayInLoupe(boolean bl) {
        this.mPixelPerfectLoupe.setShowOverlay(bl);
    }

    public void startTask(final String string) {
        this.mProgressString = string;
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                if (HierarchyViewerApplication.this.mProgressLabel != null && HierarchyViewerApplication.this.mProgressBar != null) {
                    HierarchyViewerApplication.this.mProgressLabel.setText(string);
                    HierarchyViewerApplication.this.mProgressLabel.setVisible(true);
                    HierarchyViewerApplication.this.mProgressBar.setVisible(true);
                    HierarchyViewerApplication.this.mStatusBar.layout();
                }
            }
        });
    }

    public void endTask() {
        this.mProgressString = null;
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                if (HierarchyViewerApplication.this.mProgressLabel != null && HierarchyViewerApplication.this.mProgressBar != null) {
                    HierarchyViewerApplication.this.mProgressLabel.setVisible(false);
                    HierarchyViewerApplication.this.mProgressBar.setVisible(false);
                }
            }
        });
    }

    public void showDeviceSelector() {
        MenuManager menuManager = this.getMenuBarManager();
        menuManager.removeAll();
        MenuManager menuManager2 = new MenuManager("&File");
        IMenuBarEnhancer iMenuBarEnhancer = MenuBarEnhancer.setupMenuManager((String)APP_NAME, (Display)this.getShell().getDisplay(), (IMenuManager)menuManager2, (IAction)AboutAction.getAction(this.getShell()), null, (IAction)QuitAction.getAction());
        if (iMenuBarEnhancer.getMenuBarMode() == IMenuBarEnhancer.MenuBarMode.GENERIC) {
            menuManager.add((IContributionItem)menuManager2);
        }
        MenuManager menuManager3 = new MenuManager("&Devices");
        menuManager.add((IContributionItem)menuManager3);
        menuManager3.add((IAction)RefreshWindowsAction.getAction());
        menuManager3.add((IAction)LoadViewHierarchyAction.getAction());
        menuManager3.add((IAction)InspectScreenshotAction.getAction());
        menuManager.updateAll(true);
        this.mDeviceViewButton.setSelection(true);
        this.mDeviceViewButton.setImage(this.mDeviceViewSelectedImage);
        this.mTreeViewButton.setSelection(false);
        this.mTreeViewButton.setImage(this.mTreeViewImage);
        this.mPixelPerfectButton.setSelection(false);
        this.mPixelPerfectButton.setImage(this.mPixelPerfectImage);
        this.mMainWindowStackLayout.topControl = this.mDeviceSelectorPanel;
        this.mMainWindow.layout();
        this.mDeviceSelector.setFocus();
        this.mTreeViewControls.setVisible(false);
    }

    public void showTreeView() {
        MenuManager menuManager = this.getMenuBarManager();
        menuManager.removeAll();
        MenuManager menuManager2 = new MenuManager("&File");
        IMenuBarEnhancer iMenuBarEnhancer = MenuBarEnhancer.setupMenuManager((String)APP_NAME, (Display)this.getShell().getDisplay(), (IMenuManager)menuManager2, (IAction)AboutAction.getAction(this.getShell()), null, (IAction)QuitAction.getAction());
        if (iMenuBarEnhancer.getMenuBarMode() == IMenuBarEnhancer.MenuBarMode.GENERIC) {
            menuManager.add((IContributionItem)menuManager2);
        }
        MenuManager menuManager3 = new MenuManager("&Tree View");
        menuManager.add((IContributionItem)menuManager3);
        menuManager3.add((IAction)SaveTreeViewAction.getAction(this.getShell()));
        menuManager3.add((IAction)CapturePSDAction.getAction(this.getShell()));
        menuManager3.add((IContributionItem)new Separator());
        menuManager3.add((IAction)RefreshViewAction.getAction());
        menuManager3.add((IAction)DisplayViewAction.getAction(this.getShell()));
        DeviceBridge.ViewServerInfo viewServerInfo = DeviceSelectionModel.getModel().getSelectedDeviceInfo();
        if (viewServerInfo != null && viewServerInfo.protocolVersion >= 4) {
            menuManager3.add((IAction)DumpDisplayListAction.getAction());
            this.dumpDisplayList.setVisible(true);
        } else {
            this.dumpDisplayList.setVisible(false);
        }
        menuManager3.add((IContributionItem)new Separator());
        menuManager3.add((IAction)InvalidateAction.getAction());
        menuManager3.add((IAction)RequestLayoutAction.getAction());
        menuManager.updateAll(true);
        this.mDeviceViewButton.setSelection(false);
        this.mDeviceViewButton.setImage(this.mDeviceViewImage);
        this.mTreeViewButton.setSelection(true);
        this.mTreeViewButton.setImage(this.mTreeViewSelectedImage);
        this.mPixelPerfectButton.setSelection(false);
        this.mPixelPerfectButton.setImage(this.mPixelPerfectImage);
        this.mMainWindowStackLayout.topControl = this.mTreeViewPanel;
        this.mMainWindow.layout();
        this.mTreeView.setFocus();
        this.mTreeViewControls.setVisible(true);
    }

    public void showPixelPerfect() {
        MenuManager menuManager = this.getMenuBarManager();
        menuManager.removeAll();
        MenuManager menuManager2 = new MenuManager("&File");
        IMenuBarEnhancer iMenuBarEnhancer = MenuBarEnhancer.setupMenuManager((String)APP_NAME, (Display)this.getShell().getDisplay(), (IMenuManager)menuManager2, (IAction)AboutAction.getAction(this.getShell()), null, (IAction)QuitAction.getAction());
        if (iMenuBarEnhancer.getMenuBarMode() == IMenuBarEnhancer.MenuBarMode.GENERIC) {
            menuManager.add((IContributionItem)menuManager2);
        }
        MenuManager menuManager3 = new MenuManager("&Pixel Perfect");
        menuManager3.add((IAction)SavePixelPerfectAction.getAction(this.getShell()));
        menuManager3.add((IAction)RefreshPixelPerfectAction.getAction());
        menuManager3.add((IAction)RefreshPixelPerfectTreeAction.getAction());
        menuManager3.add((IAction)PixelPerfectAutoRefreshAction.getAction());
        menuManager3.add((IContributionItem)new Separator());
        menuManager3.add((IAction)LoadOverlayAction.getAction(this.getShell()));
        menuManager3.add((IAction)ShowOverlayAction.getAction());
        menuManager.add((IContributionItem)menuManager3);
        menuManager.updateAll(true);
        this.mDeviceViewButton.setSelection(false);
        this.mDeviceViewButton.setImage(this.mDeviceViewImage);
        this.mTreeViewButton.setSelection(false);
        this.mTreeViewButton.setImage(this.mTreeViewImage);
        this.mPixelPerfectButton.setSelection(true);
        this.mPixelPerfectButton.setImage(this.mPixelPerfectSelectedImage);
        this.mMainWindowStackLayout.topControl = this.mPixelPerfectPanel;
        this.mMainWindow.layout();
        this.mPixelPerfectLoupe.setFocus();
        this.mTreeViewControls.setVisible(false);
    }

    public static void main(String[] stringArray) {
        Thread.setDefaultUncaughtExceptionHandler(new UncaughtHandler());
        Display.setAppName((String)"HierarchyViewer");
        new HierarchyViewerApplication().run();
    }

    private static class UncaughtHandler
    implements Thread.UncaughtExceptionHandler {
        private UncaughtHandler() {
        }

        public void uncaughtException(Thread thread, Throwable throwable) {
            Log.e("HierarchyViewer", "shutting down due to uncaught exception");
            Log.e("HierarchyViewer", throwable);
            System.exit(1);
        }
    }
}

