/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewer;

import com.android.hierarchyviewer.HierarchyViewerApplication;
import com.android.hierarchyviewerlib.HierarchyViewerDirector;
import com.android.sdklib.SdkConstants;
import java.io.File;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class HierarchyViewerApplicationDirector
extends HierarchyViewerDirector {
    private final ExecutorService mExecutor = Executors.newSingleThreadExecutor();

    public static HierarchyViewerDirector createDirector() {
        sDirector = new HierarchyViewerApplicationDirector();
        return sDirector;
    }

    public void terminate() {
        super.terminate();
        this.mExecutor.shutdown();
    }

    public String getAdbLocation() {
        String string = System.getProperty("com.android.hierarchyviewer.bindir");
        if (string != null && string.length() != 0) {
            File file = new File(new File(string).getParent(), "platform-tools");
            if (file.isDirectory()) {
                return file.getAbsolutePath() + File.separator + SdkConstants.FN_ADB;
            }
            return string + File.separator + SdkConstants.FN_ADB;
        }
        return SdkConstants.FN_ADB;
    }

    public void executeInBackground(final String string, final Runnable runnable) {
        this.mExecutor.execute(new Runnable(){

            public void run() {
                HierarchyViewerApplication.getMainWindow().startTask(string);
                runnable.run();
                HierarchyViewerApplication.getMainWindow().endTask();
            }
        });
    }
}

