/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewer.actions;

import com.android.ddmuilib.ImageLoader;
import com.android.hierarchyviewer.HierarchyViewerApplication;
import com.android.hierarchyviewerlib.HierarchyViewerDirector;
import com.android.hierarchyviewerlib.actions.ImageAction;
import com.android.hierarchyviewerlib.models.PixelPerfectModel;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ShowOverlayAction
extends Action
implements ImageAction,
PixelPerfectModel.IImageChangeListener {
    private static ShowOverlayAction sAction;
    private Image mImage;

    private ShowOverlayAction() {
        super("Show In &Loupe", 2);
        this.setAccelerator(SWT.MOD1 + 76);
        ImageLoader imageLoader = ImageLoader.getLoader(HierarchyViewerDirector.class);
        this.mImage = imageLoader.loadImage("show-overlay.png", Display.getDefault());
        this.setImageDescriptor(ImageDescriptor.createFromImage((Image)this.mImage));
        this.setToolTipText("Show the overlay in the loupe view");
        this.setEnabled(PixelPerfectModel.getModel().getOverlayImage() != null);
        PixelPerfectModel.getModel().addImageChangeListener(this);
    }

    public static ShowOverlayAction getAction() {
        if (sAction == null) {
            sAction = new ShowOverlayAction();
        }
        return sAction;
    }

    public void run() {
        HierarchyViewerApplication.getMainWindow().showOverlayInLoupe(sAction.isChecked());
    }

    public Image getImage() {
        return this.mImage;
    }

    public void crosshairMoved() {
    }

    public void treeChanged() {
    }

    public void imageChanged() {
    }

    public void imageLoaded() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                Image image = PixelPerfectModel.getModel().getOverlayImage();
                ShowOverlayAction.this.setEnabled(image != null);
            }
        });
    }

    public void overlayChanged() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                ShowOverlayAction.this.setEnabled(PixelPerfectModel.getModel().getOverlayImage() != null);
            }
        });
    }

    public void overlayTransparencyChanged() {
    }

    public void selectionChanged() {
    }

    public void zoomChanged() {
    }
}

