/*
 * Decompiled with CFR 0.152.
 */
package com.android.appauth;

import com.android.appauth.ASN1;
import com.android.appauth.Base64;
import java.math.BigInteger;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

public class SSLKeyLoader {
    private static final String HEADER_PRIVATE = "-----BEGIN RSA PRIVATE KEY-----";
    private static final String FOOTER_PRIVATE = "-----END RSA PRIVATE KEY-----";

    public static RSAPrivateKey loadPrivateKey(byte[] byArray) {
        PrivateKey privateKey = new PrivateKey();
        try {
            SSLKeyLoader.loadKeyPair(byArray, privateKey, null);
            return privateKey;
        }
        catch (ASN1.ParseError parseError) {
            return null;
        }
    }

    public static RSAPublicKey loadPublicKey(byte[] byArray) {
        PublicKey publicKey = new PublicKey();
        try {
            SSLKeyLoader.loadKeyPair(byArray, null, publicKey);
            return publicKey;
        }
        catch (ASN1.ParseError parseError) {
            return null;
        }
    }

    private static void loadKeyPair(byte[] byArray, PrivateKey privateKey, PublicKey publicKey) throws ASN1.ParseError {
        byArray = SSLKeyLoader.decodeWrapper(byArray);
        ASN1 aSN1 = new ASN1(byArray);
        aSN1.parse(48, aSN1);
        aSN1.parseInt();
        BigInteger bigInteger = aSN1.parseBigInteger();
        BigInteger bigInteger2 = aSN1.parseBigInteger();
        if (publicKey != null) {
            publicKey.modulus = bigInteger;
            publicKey.exponent = bigInteger2;
        }
        if (privateKey != null) {
            BigInteger bigInteger3 = aSN1.parseBigInteger();
            privateKey.modulus = bigInteger;
            privateKey.exponent = bigInteger3;
        }
    }

    private static byte[] decodeWrapper(byte[] byArray) {
        String string = new String(byArray);
        int n = string.indexOf(HEADER_PRIVATE);
        if (n < 0) {
            return null;
        }
        int n2 = string.indexOf(FOOTER_PRIVATE, n += HEADER_PRIVATE.length());
        if (n2 < 0) {
            return null;
        }
        string = string.substring(n, n2 - 1);
        return Base64.decode(string, 0);
    }

    static class PublicKey
    implements RSAPublicKey {
        BigInteger modulus;
        BigInteger exponent;
        static final byte[] OID = new byte[]{48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0};

        PublicKey() {
        }

        @Override
        public BigInteger getModulus() {
            return this.modulus;
        }

        @Override
        public BigInteger getPublicExponent() {
            return this.exponent;
        }

        @Override
        public String getFormat() {
            return null;
        }

        @Override
        public String getAlgorithm() {
            return "RSA";
        }

        @Override
        public byte[] getEncoded() {
            try {
                byte[] byArray = this.modulus.toByteArray();
                byte[] byArray2 = this.exponent.toByteArray();
                int n = ASN1.hsize(byArray.length) + byArray.length;
                int n2 = 1 + ASN1.hsize(n += ASN1.hsize(byArray2.length) + byArray2.length) + n;
                int n3 = OID.length + ASN1.hsize(n2) + n2;
                byte[] byArray3 = new byte[ASN1.hsize(n3) + n3];
                int n4 = 0;
                n4 += ASN1.header(48, n3, byArray3, n4);
                System.arraycopy(OID, 0, byArray3, n4, OID.length);
                n4 += OID.length;
                n4 += ASN1.header(3, n2, byArray3, n4);
                byArray3[n4++] = 0;
                n4 += ASN1.header(48, n, byArray3, n4);
                n4 += ASN1.header(2, byArray.length, byArray3, n4);
                System.arraycopy(byArray, 0, byArray3, n4, byArray.length);
                n4 += byArray.length;
                n4 += ASN1.header(2, byArray2.length, byArray3, n4);
                System.arraycopy(byArray2, 0, byArray3, n4, byArray2.length);
                n4 += byArray.length;
                return byArray3;
            }
            catch (ASN1.ParseError parseError) {
                return null;
            }
        }
    }

    static class PrivateKey
    implements RSAPrivateKey {
        BigInteger modulus;
        BigInteger exponent;

        PrivateKey() {
        }

        @Override
        public BigInteger getModulus() {
            return this.modulus;
        }

        @Override
        public BigInteger getPrivateExponent() {
            return this.exponent;
        }

        @Override
        public byte[] getEncoded() {
            return null;
        }

        @Override
        public String getFormat() {
            return null;
        }

        @Override
        public String getAlgorithm() {
            return "RSA";
        }
    }
}

