/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib;

import com.android.ddmlib.AllocationInfo;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.IStackTraceInfo;
import com.android.ddmuilib.DdmUiPreferences;
import com.android.ddmuilib.ImageLoader;
import com.android.ddmuilib.StackTracePanel;
import com.android.ddmuilib.TableHelper;
import com.android.ddmuilib.TablePanel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class AllocationPanel
extends TablePanel {
    private static final String PREFS_ALLOC_COL_NUMBER = "allocPanel.Col00";
    private static final String PREFS_ALLOC_COL_SIZE = "allocPanel.Col0";
    private static final String PREFS_ALLOC_COL_CLASS = "allocPanel.Col1";
    private static final String PREFS_ALLOC_COL_THREAD = "allocPanel.Col2";
    private static final String PREFS_ALLOC_COL_TRACE_CLASS = "allocPanel.Col3";
    private static final String PREFS_ALLOC_COL_TRACE_METHOD = "allocPanel.Col4";
    private static final String PREFS_ALLOC_SASH = "allocPanel.sash";
    private static final String PREFS_STACK_COL_CLASS = "allocPanel.stack.col0";
    private static final String PREFS_STACK_COL_METHOD = "allocPanel.stack.col1";
    private static final String PREFS_STACK_COL_FILE = "allocPanel.stack.col2";
    private static final String PREFS_STACK_COL_LINE = "allocPanel.stack.col3";
    private static final String PREFS_STACK_COL_NATIVE = "allocPanel.stack.col4";
    private Composite mAllocationBase;
    private Table mAllocationTable;
    private TableViewer mAllocationViewer;
    private StackTracePanel mStackTracePanel;
    private Table mStackTraceTable;
    private Button mEnableButton;
    private Button mRequestButton;
    private Button mTraceFilterCheck;
    private final AllocationInfo.AllocationSorter mSorter = new AllocationInfo.AllocationSorter();
    private TableColumn mSortColumn;
    private Image mSortUpImg;
    private Image mSortDownImg;
    private String mFilterText = null;

    protected Control createControl(Composite composite) {
        final IPreferenceStore iPreferenceStore = DdmUiPreferences.getStore();
        Display display = composite.getDisplay();
        this.mSortUpImg = ImageLoader.getDdmUiLibLoader().loadImage("sort_up.png", display);
        this.mSortDownImg = ImageLoader.getDdmUiLibLoader().loadImage("sort_down.png", display);
        this.mAllocationBase = new Composite(composite, 0);
        this.mAllocationBase.setLayout((Layout)new FormLayout());
        Composite composite2 = new Composite(this.mAllocationBase, 0);
        composite2.setLayout((Layout)new GridLayout(6, false));
        this.mEnableButton = new Button(composite2, 8);
        this.mEnableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Client client = AllocationPanel.this.getCurrentClient();
                ClientData.AllocationTrackingStatus allocationTrackingStatus = client.getClientData().getAllocationStatus();
                if (allocationTrackingStatus == ClientData.AllocationTrackingStatus.ON) {
                    client.enableAllocationTracker(false);
                } else {
                    client.enableAllocationTracker(true);
                }
                client.requestAllocationStatus();
            }
        });
        this.mRequestButton = new Button(composite2, 8);
        this.mRequestButton.setText("Get Allocations");
        this.mRequestButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AllocationPanel.this.getCurrentClient().requestAllocationDetails();
            }
        });
        this.setUpButtons(false, ClientData.AllocationTrackingStatus.OFF);
        Composite composite3 = new Composite(composite2, 0);
        GridData gridData = new GridData(768);
        composite3.setLayoutData((Object)gridData);
        new Label(composite2, 0).setText("Filter:");
        final Text text = new Text(composite2, 2048);
        gridData = new GridData(768);
        text.setLayoutData((Object)gridData);
        gridData.widthHint = 200;
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                AllocationPanel.this.mFilterText = text.getText().trim();
                AllocationPanel.this.mAllocationViewer.refresh();
            }
        });
        this.mTraceFilterCheck = new Button(composite2, 32);
        this.mTraceFilterCheck.setText("Inc. trace");
        this.mTraceFilterCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AllocationPanel.this.mAllocationViewer.refresh();
            }
        });
        this.mAllocationTable = new Table(composite2, 65538);
        gridData = new GridData(1808);
        this.mAllocationTable.setLayoutData((Object)gridData);
        gridData.horizontalSpan = 6;
        this.mAllocationTable.setHeaderVisible(true);
        this.mAllocationTable.setLinesVisible(true);
        final TableColumn tableColumn = TableHelper.createTableColumn(this.mAllocationTable, "Alloc Order", 131072, "Alloc Order", PREFS_ALLOC_COL_NUMBER, iPreferenceStore);
        tableColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AllocationPanel.this.setSortColumn(tableColumn, AllocationInfo.SortMode.NUMBER);
            }
        });
        final TableColumn tableColumn2 = TableHelper.createTableColumn(this.mAllocationTable, "Allocation Size", 131072, "888", PREFS_ALLOC_COL_SIZE, iPreferenceStore);
        tableColumn2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AllocationPanel.this.setSortColumn(tableColumn2, AllocationInfo.SortMode.SIZE);
            }
        });
        final TableColumn tableColumn3 = TableHelper.createTableColumn(this.mAllocationTable, "Allocated Class", 16384, "Allocated Class", PREFS_ALLOC_COL_CLASS, iPreferenceStore);
        tableColumn3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AllocationPanel.this.setSortColumn(tableColumn3, AllocationInfo.SortMode.CLASS);
            }
        });
        final TableColumn tableColumn4 = TableHelper.createTableColumn(this.mAllocationTable, "Thread Id", 16384, "999", PREFS_ALLOC_COL_THREAD, iPreferenceStore);
        tableColumn4.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AllocationPanel.this.setSortColumn(tableColumn4, AllocationInfo.SortMode.THREAD);
            }
        });
        final TableColumn tableColumn5 = TableHelper.createTableColumn(this.mAllocationTable, "Allocated in", 16384, "utime", PREFS_ALLOC_COL_TRACE_CLASS, iPreferenceStore);
        tableColumn5.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AllocationPanel.this.setSortColumn(tableColumn5, AllocationInfo.SortMode.IN_CLASS);
            }
        });
        final TableColumn tableColumn6 = TableHelper.createTableColumn(this.mAllocationTable, "Allocated in", 16384, "utime", PREFS_ALLOC_COL_TRACE_METHOD, iPreferenceStore);
        tableColumn6.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AllocationPanel.this.setSortColumn(tableColumn6, AllocationInfo.SortMode.IN_METHOD);
            }
        });
        switch (this.mSorter.getSortMode()) {
            case SIZE: {
                this.mSortColumn = tableColumn2;
                break;
            }
            case CLASS: {
                this.mSortColumn = tableColumn3;
                break;
            }
            case THREAD: {
                this.mSortColumn = tableColumn4;
                break;
            }
            case IN_CLASS: {
                this.mSortColumn = tableColumn5;
                break;
            }
            case IN_METHOD: {
                this.mSortColumn = tableColumn6;
            }
        }
        this.mSortColumn.setImage(this.mSorter.isDescending() ? this.mSortDownImg : this.mSortUpImg);
        this.mAllocationViewer = new TableViewer(this.mAllocationTable);
        this.mAllocationViewer.setContentProvider((IContentProvider)new AllocationContentProvider());
        this.mAllocationViewer.setLabelProvider((IBaseLabelProvider)new AllocationLabelProvider());
        this.mAllocationViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                AllocationInfo allocationInfo = AllocationPanel.this.getAllocationSelection(selectionChangedEvent.getSelection());
                AllocationPanel.this.updateAllocationStackTrace(allocationInfo);
            }
        });
        final Sash sash = new Sash(this.mAllocationBase, 256);
        Color color = composite.getDisplay().getSystemColor(16);
        sash.setBackground(color);
        this.mStackTracePanel = new StackTracePanel();
        this.mStackTraceTable = this.mStackTracePanel.createPanel(this.mAllocationBase, PREFS_STACK_COL_CLASS, PREFS_STACK_COL_METHOD, PREFS_STACK_COL_FILE, PREFS_STACK_COL_LINE, PREFS_STACK_COL_NATIVE, iPreferenceStore);
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment((Control)sash, 0);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        composite2.setLayoutData((Object)formData);
        final FormData formData2 = new FormData();
        formData2.top = iPreferenceStore != null && iPreferenceStore.contains(PREFS_ALLOC_SASH) ? new FormAttachment(0, iPreferenceStore.getInt(PREFS_ALLOC_SASH)) : new FormAttachment(50, 0);
        formData2.left = new FormAttachment(0, 0);
        formData2.right = new FormAttachment(100, 0);
        sash.setLayoutData((Object)formData2);
        formData = new FormData();
        formData.top = new FormAttachment((Control)sash, 0);
        formData.bottom = new FormAttachment(100, 0);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        this.mStackTraceTable.setLayoutData((Object)formData);
        sash.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Rectangle rectangle = sash.getBounds();
                Rectangle rectangle2 = AllocationPanel.this.mAllocationBase.getClientArea();
                int n = rectangle2.height - rectangle.height - 100;
                event.y = Math.max(Math.min(event.y, n), 100);
                if (event.y != rectangle.y) {
                    formData2.top = new FormAttachment(0, event.y);
                    iPreferenceStore.setValue(AllocationPanel.PREFS_ALLOC_SASH, event.y);
                    AllocationPanel.this.mAllocationBase.layout();
                }
            }
        });
        return this.mAllocationBase;
    }

    public void dispose() {
        this.mSortUpImg.dispose();
        this.mSortDownImg.dispose();
        super.dispose();
    }

    public void setFocus() {
        this.mAllocationTable.setFocus();
    }

    public void clientChanged(final Client client, int n) {
        if (client == this.getCurrentClient()) {
            if ((n & 0x200) != 0) {
                try {
                    this.mAllocationTable.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            AllocationPanel.this.mAllocationViewer.refresh();
                            AllocationPanel.this.updateAllocationStackCall();
                        }
                    });
                }
                catch (SWTException sWTException) {}
            } else if ((n & 0x400) != 0) {
                try {
                    this.mAllocationTable.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            AllocationPanel.this.setUpButtons(true, client.getClientData().getAllocationStatus());
                        }
                    });
                }
                catch (SWTException sWTException) {
                    // empty catch block
                }
            }
        }
    }

    public void deviceSelected() {
    }

    public void clientSelected() {
        if (this.mAllocationTable.isDisposed()) {
            return;
        }
        Client client = this.getCurrentClient();
        this.mStackTracePanel.setCurrentClient(client);
        this.mStackTracePanel.setViewerInput(null);
        if (client != null) {
            this.setUpButtons(true, client.getClientData().getAllocationStatus());
        } else {
            this.setUpButtons(false, ClientData.AllocationTrackingStatus.OFF);
        }
        this.mAllocationViewer.setInput((Object)client);
    }

    private void updateAllocationStackCall() {
        Client client = this.getCurrentClient();
        if (client != null) {
            AllocationInfo allocationInfo = this.getAllocationSelection(null);
            if (allocationInfo != null) {
                this.updateAllocationStackTrace(allocationInfo);
            } else {
                this.updateAllocationStackTrace(null);
            }
        }
    }

    private void updateAllocationStackTrace(AllocationInfo allocationInfo) {
        this.mStackTracePanel.setViewerInput((IStackTraceInfo)allocationInfo);
    }

    protected void setTableFocusListener() {
        this.addTableToFocusListener(this.mAllocationTable);
        this.addTableToFocusListener(this.mStackTraceTable);
    }

    private AllocationInfo getAllocationSelection(ISelection iSelection) {
        IStructuredSelection iStructuredSelection;
        Object object;
        if (iSelection == null) {
            iSelection = this.mAllocationViewer.getSelection();
        }
        if (iSelection instanceof IStructuredSelection && (object = (iStructuredSelection = (IStructuredSelection)iSelection).getFirstElement()) instanceof AllocationInfo) {
            return (AllocationInfo)object;
        }
        return null;
    }

    private void setUpButtons(boolean bl, ClientData.AllocationTrackingStatus allocationTrackingStatus) {
        if (bl) {
            switch (allocationTrackingStatus) {
                case UNKNOWN: {
                    this.mEnableButton.setText("?");
                    this.mEnableButton.setEnabled(false);
                    this.mRequestButton.setEnabled(false);
                    break;
                }
                case OFF: {
                    this.mEnableButton.setText("Start Tracking");
                    this.mEnableButton.setEnabled(true);
                    this.mRequestButton.setEnabled(false);
                    break;
                }
                case ON: {
                    this.mEnableButton.setText("Stop Tracking");
                    this.mEnableButton.setEnabled(true);
                    this.mRequestButton.setEnabled(true);
                }
            }
        } else {
            this.mEnableButton.setEnabled(false);
            this.mRequestButton.setEnabled(false);
            this.mEnableButton.setText("Start Tracking");
        }
    }

    private void setSortColumn(TableColumn tableColumn, AllocationInfo.SortMode sortMode) {
        this.mSorter.setSortMode(sortMode);
        this.mAllocationTable.setRedraw(false);
        if (this.mSortColumn != tableColumn) {
            this.mSortColumn.setImage(null);
        }
        this.mSortColumn = tableColumn;
        if (this.mSorter.isDescending()) {
            this.mSortColumn.setImage(this.mSortDownImg);
        } else {
            this.mSortColumn.setImage(this.mSortUpImg);
        }
        this.mAllocationTable.setRedraw(true);
        this.mAllocationViewer.refresh();
    }

    private AllocationInfo[] getFilteredAllocations(AllocationInfo[] allocationInfoArray, String string) {
        ArrayList<AllocationInfo> arrayList = new ArrayList<AllocationInfo>();
        Locale locale = Locale.getDefault();
        string = string.toLowerCase(locale);
        boolean bl = this.mTraceFilterCheck.getSelection();
        for (AllocationInfo allocationInfo : allocationInfoArray) {
            if (!allocationInfo.filter(string, bl, locale)) continue;
            arrayList.add(allocationInfo);
        }
        return arrayList.toArray(new AllocationInfo[arrayList.size()]);
    }

    private static class AllocationLabelProvider
    implements ITableLabelProvider {
        private AllocationLabelProvider() {
        }

        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public String getColumnText(Object object, int n) {
            if (object instanceof AllocationInfo) {
                AllocationInfo allocationInfo = (AllocationInfo)object;
                switch (n) {
                    case 0: {
                        return Integer.toString(allocationInfo.getAllocNumber());
                    }
                    case 1: {
                        return Integer.toString(allocationInfo.getSize());
                    }
                    case 2: {
                        return allocationInfo.getAllocatedClass();
                    }
                    case 3: {
                        return Short.toString(allocationInfo.getThreadId());
                    }
                    case 4: {
                        return allocationInfo.getFirstTraceClassName();
                    }
                    case 5: {
                        return allocationInfo.getFirstTraceMethodName();
                    }
                }
            }
            return null;
        }

        public void addListener(ILabelProviderListener iLabelProviderListener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object object, String string) {
            return false;
        }

        public void removeListener(ILabelProviderListener iLabelProviderListener) {
        }
    }

    private class AllocationContentProvider
    implements IStructuredContentProvider {
        private AllocationContentProvider() {
        }

        public Object[] getElements(Object object) {
            Object[] objectArray;
            if (object instanceof Client && (objectArray = ((Client)object).getClientData().getAllocations()) != null) {
                if (AllocationPanel.this.mFilterText != null && AllocationPanel.this.mFilterText.length() > 0) {
                    objectArray = AllocationPanel.this.getFilteredAllocations((AllocationInfo[])objectArray, AllocationPanel.this.mFilterText);
                }
                Arrays.sort(objectArray, AllocationPanel.this.mSorter);
                return objectArray;
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }
}

