/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib;

import com.android.ddmlib.EmulatorConsole;
import com.android.ddmlib.IDevice;
import com.android.ddmuilib.DdmUiPreferences;
import com.android.ddmuilib.ImageLoader;
import com.android.ddmuilib.SelectionDependentPanel;
import com.android.ddmuilib.TableHelper;
import com.android.ddmuilib.location.CoordinateControls;
import com.android.ddmuilib.location.GpxParser;
import com.android.ddmuilib.location.KmlParser;
import com.android.ddmuilib.location.TrackContentProvider;
import com.android.ddmuilib.location.TrackLabelProvider;
import com.android.ddmuilib.location.TrackPoint;
import com.android.ddmuilib.location.WayPoint;
import com.android.ddmuilib.location.WayPointContentProvider;
import com.android.ddmuilib.location.WayPointLabelProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class EmulatorControlPanel
extends SelectionDependentPanel {
    private static final double DEFAULT_LONGITUDE = -122.084095;
    private static final double DEFAULT_LATITUDE = 37.422006;
    private static final String SPEED_FORMAT = "Speed: %1$dX";
    private static final String[][] GSM_MODES = new String[][]{{"unregistered", EmulatorConsole.GsmMode.UNREGISTERED.getTag()}, {"home", EmulatorConsole.GsmMode.HOME.getTag()}, {"roaming", EmulatorConsole.GsmMode.ROAMING.getTag()}, {"searching", EmulatorConsole.GsmMode.SEARCHING.getTag()}, {"denied", EmulatorConsole.GsmMode.DENIED.getTag()}};
    private static final String[] NETWORK_SPEEDS = new String[]{"Full", "GSM", "HSCSD", "GPRS", "EDGE", "UMTS", "HSDPA"};
    private static final String[] NETWORK_LATENCIES = new String[]{"None", "GPRS", "EDGE", "UMTS"};
    private static final int[] PLAY_SPEEDS = new int[]{1, 2, 5, 10, 20, 50};
    private static final String RE_PHONE_NUMBER = "^[+#0-9]+$";
    private static final String PREFS_WAYPOINT_COL_NAME = "emulatorControl.waypoint.name";
    private static final String PREFS_WAYPOINT_COL_LONGITUDE = "emulatorControl.waypoint.longitude";
    private static final String PREFS_WAYPOINT_COL_LATITUDE = "emulatorControl.waypoint.latitude";
    private static final String PREFS_WAYPOINT_COL_ELEVATION = "emulatorControl.waypoint.elevation";
    private static final String PREFS_WAYPOINT_COL_DESCRIPTION = "emulatorControl.waypoint.desc";
    private static final String PREFS_TRACK_COL_NAME = "emulatorControl.track.name";
    private static final String PREFS_TRACK_COL_COUNT = "emulatorControl.track.count";
    private static final String PREFS_TRACK_COL_FIRST = "emulatorControl.track.first";
    private static final String PREFS_TRACK_COL_LAST = "emulatorControl.track.last";
    private static final String PREFS_TRACK_COL_COMMENT = "emulatorControl.track.comment";
    private EmulatorConsole mEmulatorConsole;
    private Composite mParent;
    private Label mVoiceLabel;
    private Combo mVoiceMode;
    private Label mDataLabel;
    private Combo mDataMode;
    private Label mSpeedLabel;
    private Combo mNetworkSpeed;
    private Label mLatencyLabel;
    private Combo mNetworkLatency;
    private Label mNumberLabel;
    private Text mPhoneNumber;
    private Button mVoiceButton;
    private Button mSmsButton;
    private Label mMessageLabel;
    private Text mSmsMessage;
    private Button mCallButton;
    private Button mCancelButton;
    private TabFolder mLocationFolders;
    private Button mDecimalButton;
    private Button mSexagesimalButton;
    private CoordinateControls mLongitudeControls;
    private CoordinateControls mLatitudeControls;
    private Button mGpxUploadButton;
    private Table mGpxWayPointTable;
    private Table mGpxTrackTable;
    private Button mKmlUploadButton;
    private Table mKmlWayPointTable;
    private Button mPlayGpxButton;
    private Button mGpxBackwardButton;
    private Button mGpxForwardButton;
    private Button mGpxSpeedButton;
    private Button mPlayKmlButton;
    private Button mKmlBackwardButton;
    private Button mKmlForwardButton;
    private Button mKmlSpeedButton;
    private Image mPlayImage;
    private Image mPauseImage;
    private Thread mPlayingThread;
    private boolean mPlayingTrack;
    private int mPlayDirection = 1;
    private int mSpeed;
    private int mSpeedIndex;
    private final SelectionAdapter mDirectionButtonAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            Button button = (Button)selectionEvent.getSource();
            if (!button.getSelection()) {
                button.setSelection(true);
                return;
            }
            if (button == EmulatorControlPanel.this.mGpxForwardButton || button == EmulatorControlPanel.this.mKmlForwardButton) {
                EmulatorControlPanel.this.mGpxBackwardButton.setSelection(false);
                EmulatorControlPanel.this.mGpxForwardButton.setSelection(true);
                EmulatorControlPanel.this.mKmlBackwardButton.setSelection(false);
                EmulatorControlPanel.this.mKmlForwardButton.setSelection(true);
                EmulatorControlPanel.this.mPlayDirection = 1;
            } else {
                EmulatorControlPanel.this.mGpxBackwardButton.setSelection(true);
                EmulatorControlPanel.this.mGpxForwardButton.setSelection(false);
                EmulatorControlPanel.this.mKmlBackwardButton.setSelection(true);
                EmulatorControlPanel.this.mKmlForwardButton.setSelection(false);
                EmulatorControlPanel.this.mPlayDirection = -1;
            }
        }
    };
    private final SelectionAdapter mSpeedButtonAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            EmulatorControlPanel.this.mSpeedIndex = (EmulatorControlPanel.this.mSpeedIndex + 1) % PLAY_SPEEDS.length;
            EmulatorControlPanel.this.mSpeed = PLAY_SPEEDS[EmulatorControlPanel.this.mSpeedIndex];
            EmulatorControlPanel.this.mGpxSpeedButton.setText(String.format(EmulatorControlPanel.SPEED_FORMAT, EmulatorControlPanel.this.mSpeed));
            EmulatorControlPanel.this.mGpxPlayControls.pack();
            EmulatorControlPanel.this.mKmlSpeedButton.setText(String.format(EmulatorControlPanel.SPEED_FORMAT, EmulatorControlPanel.this.mSpeed));
            EmulatorControlPanel.this.mKmlPlayControls.pack();
            if (EmulatorControlPanel.this.mPlayingThread != null) {
                EmulatorControlPanel.this.mPlayingThread.interrupt();
            }
        }
    };
    private Composite mKmlPlayControls;
    private Composite mGpxPlayControls;

    public void deviceSelected() {
        this.handleNewDevice(this.getCurrentDevice());
    }

    public void clientSelected() {
    }

    protected Control createControl(Composite composite) {
        this.mParent = composite;
        final ScrolledComposite scrolledComposite = new ScrolledComposite(composite, 512);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setLayoutData((Object)new GridData(1808));
        final Composite composite2 = new Composite((Composite)scrolledComposite, 0);
        scrolledComposite.setContent((Control)composite2);
        composite2.setLayout((Layout)new GridLayout(1, false));
        scrolledComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                Rectangle rectangle = scrolledComposite.getClientArea();
                scrolledComposite.setMinSize(composite2.computeSize(rectangle.width, -1));
            }
        });
        this.createRadioControls(composite2);
        this.createCallControls(composite2);
        this.createLocationControls(composite2);
        this.doEnable(false);
        composite2.layout();
        Rectangle rectangle = scrolledComposite.getClientArea();
        scrolledComposite.setMinSize(composite2.computeSize(rectangle.width, -1));
        return scrolledComposite;
    }

    private void createRadioControls(Composite composite) {
        Group group = new Group(composite, 0);
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)new GridLayout(2, false));
        group.setText("Telephony Status");
        Composite composite2 = new Composite((Composite)group, 0);
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.marginRight = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginBottom = 0;
        composite2.setLayout((Layout)gridLayout);
        this.mVoiceLabel = new Label(composite2, 0);
        this.mVoiceLabel.setText("Voice:");
        this.mVoiceLabel.setAlignment(131072);
        this.mVoiceMode = new Combo(composite2, 8);
        this.mVoiceMode.setLayoutData((Object)new GridData(768));
        for (String[] stringArray : GSM_MODES) {
            this.mVoiceMode.add(stringArray[0]);
        }
        this.mVoiceMode.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EmulatorControlPanel.this.setVoiceMode(EmulatorControlPanel.this.mVoiceMode.getSelectionIndex());
            }
        });
        this.mSpeedLabel = new Label(composite2, 0);
        this.mSpeedLabel.setText("Speed:");
        this.mSpeedLabel.setAlignment(131072);
        this.mNetworkSpeed = new Combo(composite2, 8);
        this.mNetworkSpeed.setLayoutData((Object)new GridData(768));
        for (String[] stringArray : NETWORK_SPEEDS) {
            this.mNetworkSpeed.add((String)stringArray);
        }
        this.mNetworkSpeed.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EmulatorControlPanel.this.setNetworkSpeed(EmulatorControlPanel.this.mNetworkSpeed.getSelectionIndex());
            }
        });
        this.mDataLabel = new Label(composite2, 0);
        this.mDataLabel.setText("Data:");
        this.mDataLabel.setAlignment(131072);
        this.mDataMode = new Combo(composite2, 8);
        this.mDataMode.setLayoutData((Object)new GridData(768));
        for (String[] stringArray : GSM_MODES) {
            this.mDataMode.add(stringArray[0]);
        }
        this.mDataMode.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EmulatorControlPanel.this.setDataMode(EmulatorControlPanel.this.mDataMode.getSelectionIndex());
            }
        });
        this.mLatencyLabel = new Label(composite2, 0);
        this.mLatencyLabel.setText("Latency:");
        this.mLatencyLabel.setAlignment(131072);
        this.mNetworkLatency = new Combo(composite2, 8);
        this.mNetworkLatency.setLayoutData((Object)new GridData(768));
        for (String[] stringArray : NETWORK_LATENCIES) {
            this.mNetworkLatency.add((String)stringArray);
        }
        this.mNetworkLatency.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EmulatorControlPanel.this.setNetworkLatency(EmulatorControlPanel.this.mNetworkLatency.getSelectionIndex());
            }
        });
        Label label = new Label((Composite)group, 0);
        label.setLayoutData((Object)new GridData(768));
    }

    private void createCallControls(Composite composite) {
        Group group = new Group(composite, 0);
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)new GridLayout(1, false));
        group.setText("Telephony Actions");
        Composite composite2 = new Composite((Composite)group, 0);
        composite2.setLayoutData((Object)new GridData(1808));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginRight = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginBottom = 0;
        composite2.setLayout((Layout)gridLayout);
        this.mNumberLabel = new Label(composite2, 0);
        this.mNumberLabel.setText("Incoming number:");
        this.mPhoneNumber = new Text(composite2, 18436);
        this.mPhoneNumber.setLayoutData((Object)new GridData(768));
        this.mPhoneNumber.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                EmulatorControlPanel.this.doEnable(EmulatorControlPanel.this.mEmulatorConsole != null);
            }
        });
        this.mVoiceButton = new Button(composite2, 16);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.mVoiceButton.setText("Voice");
        this.mVoiceButton.setLayoutData((Object)gridData);
        this.mVoiceButton.setEnabled(false);
        this.mVoiceButton.setSelection(true);
        this.mVoiceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EmulatorControlPanel.this.doEnable(true);
                if (EmulatorControlPanel.this.mVoiceButton.getSelection()) {
                    EmulatorControlPanel.this.mCallButton.setText("Call");
                } else {
                    EmulatorControlPanel.this.mCallButton.setText("Send");
                }
            }
        });
        this.mSmsButton = new Button(composite2, 16);
        this.mSmsButton.setText("SMS");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.mSmsButton.setLayoutData((Object)gridData);
        this.mSmsButton.setEnabled(false);
        this.mMessageLabel = new Label(composite2, 0);
        gridData = new GridData();
        gridData.verticalAlignment = 128;
        this.mMessageLabel.setLayoutData((Object)gridData);
        this.mMessageLabel.setText("Message:");
        this.mMessageLabel.setEnabled(false);
        this.mSmsMessage = new Text(composite2, 19010);
        gridData = new GridData(768);
        this.mSmsMessage.setLayoutData((Object)gridData);
        gridData.heightHint = 70;
        this.mSmsMessage.setEnabled(false);
        Composite composite3 = new Composite((Composite)group, 0);
        composite3.setLayoutData((Object)new GridData(768));
        gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite3.setLayout((Layout)gridLayout);
        this.mCallButton = new Button(composite3, 8);
        this.mCallButton.setText("Call");
        this.mCallButton.setEnabled(false);
        this.mCallButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (EmulatorControlPanel.this.mEmulatorConsole != null) {
                    if (EmulatorControlPanel.this.mVoiceButton.getSelection()) {
                        EmulatorControlPanel.this.processCommandResult(EmulatorControlPanel.this.mEmulatorConsole.call(EmulatorControlPanel.this.mPhoneNumber.getText().trim()));
                    } else {
                        String string = EmulatorControlPanel.this.mSmsMessage.getText();
                        string = string.replaceAll("\\\\", "\\\\\\\\");
                        string = string.replaceAll("\r\n", "\\\\n");
                        string = string.replaceAll("\n", "\\\\n");
                        string = string.replaceAll("\r", "\\\\n");
                        EmulatorControlPanel.this.processCommandResult(EmulatorControlPanel.this.mEmulatorConsole.sendSms(EmulatorControlPanel.this.mPhoneNumber.getText().trim(), string));
                    }
                }
            }
        });
        this.mCancelButton = new Button(composite3, 8);
        this.mCancelButton.setText("Hang Up");
        this.mCancelButton.setEnabled(false);
        this.mCancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (EmulatorControlPanel.this.mEmulatorConsole != null && EmulatorControlPanel.this.mVoiceButton.getSelection()) {
                    EmulatorControlPanel.this.processCommandResult(EmulatorControlPanel.this.mEmulatorConsole.cancelCall(EmulatorControlPanel.this.mPhoneNumber.getText().trim()));
                }
            }
        });
    }

    private void createLocationControls(Composite composite) {
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(768));
        label.setText("Location Controls");
        this.mLocationFolders = new TabFolder(composite, 0);
        this.mLocationFolders.setLayoutData((Object)new GridData(768));
        Composite composite2 = new Composite((Composite)this.mLocationFolders, 0);
        TabItem tabItem = new TabItem(this.mLocationFolders, 0);
        tabItem.setText("Manual");
        tabItem.setControl((Control)composite2);
        this.createManualLocationControl(composite2);
        ImageLoader imageLoader = ImageLoader.getDdmUiLibLoader();
        this.mPlayImage = imageLoader.loadImage("play.png", this.mParent.getDisplay());
        this.mPauseImage = imageLoader.loadImage("pause.png", this.mParent.getDisplay());
        Composite composite3 = new Composite((Composite)this.mLocationFolders, 0);
        tabItem = new TabItem(this.mLocationFolders, 0);
        tabItem.setText("GPX");
        tabItem.setControl((Control)composite3);
        this.createGpxLocationControl(composite3);
        Composite composite4 = new Composite((Composite)this.mLocationFolders, 0);
        composite4.setLayout((Layout)new FillLayout());
        tabItem = new TabItem(this.mLocationFolders, 0);
        tabItem.setText("KML");
        tabItem.setControl((Control)composite4);
        this.createKmlLocationControl(composite4);
    }

    private void createManualLocationControl(Composite composite) {
        composite.setLayout((Layout)new GridLayout(1, false));
        this.mDecimalButton = new Button(composite, 16);
        this.mDecimalButton.setLayoutData((Object)new GridData(768));
        this.mDecimalButton.setText("Decimal");
        this.mSexagesimalButton = new Button(composite, 16);
        this.mSexagesimalButton.setLayoutData((Object)new GridData(768));
        this.mSexagesimalButton.setText("Sexagesimal");
        final Composite composite2 = new Composite(composite, 0);
        final StackLayout stackLayout = new StackLayout();
        composite2.setLayout((Layout)stackLayout);
        final Composite composite3 = new Composite(composite2, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        composite3.setLayout((Layout)gridLayout);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.mLongitudeControls = new CoordinateControls();
        this.mLatitudeControls = new CoordinateControls();
        Label label = new Label(composite3, 0);
        label.setText("Longitude");
        this.mLongitudeControls.createDecimalText(composite3);
        label = new Label(composite3, 0);
        label.setText("Latitude");
        this.mLatitudeControls.createDecimalText(composite3);
        final Composite composite4 = new Composite(composite2, 0);
        gridLayout = new GridLayout(7, false);
        composite4.setLayout((Layout)gridLayout);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        label = new Label(composite4, 0);
        label.setText("Longitude");
        this.mLongitudeControls.createSexagesimalDegreeText(composite4);
        label = new Label(composite4, 0);
        label.setText("\u00b0");
        this.mLongitudeControls.createSexagesimalMinuteText(composite4);
        label = new Label(composite4, 0);
        label.setText("'");
        this.mLongitudeControls.createSexagesimalSecondText(composite4);
        label = new Label(composite4, 0);
        label.setText("\"");
        label = new Label(composite4, 0);
        label.setText("Latitude");
        this.mLatitudeControls.createSexagesimalDegreeText(composite4);
        label = new Label(composite4, 0);
        label.setText("\u00b0");
        this.mLatitudeControls.createSexagesimalMinuteText(composite4);
        label = new Label(composite4, 0);
        label.setText("'");
        this.mLatitudeControls.createSexagesimalSecondText(composite4);
        label = new Label(composite4, 0);
        label.setText("\"");
        stackLayout.topControl = composite3;
        this.mDecimalButton.setSelection(true);
        this.mDecimalButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                stackLayout.topControl = EmulatorControlPanel.this.mDecimalButton.getSelection() ? composite3 : composite4;
                composite2.layout();
            }
        });
        Button button = new Button(composite, 8);
        button.setText("Send");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (EmulatorControlPanel.this.mEmulatorConsole != null) {
                    EmulatorControlPanel.this.processCommandResult(EmulatorControlPanel.this.mEmulatorConsole.sendLocation(EmulatorControlPanel.this.mLongitudeControls.getValue(), EmulatorControlPanel.this.mLatitudeControls.getValue(), 0.0));
                }
            }
        });
        this.mLongitudeControls.setValue(-122.084095);
        this.mLatitudeControls.setValue(37.422006);
    }

    private void createGpxLocationControl(Composite composite) {
        IPreferenceStore iPreferenceStore = DdmUiPreferences.getStore();
        composite.setLayout((Layout)new GridLayout(1, false));
        this.mGpxUploadButton = new Button(composite, 8);
        this.mGpxUploadButton.setText("Load GPX...");
        this.mGpxWayPointTable = new Table(composite, 66304);
        GridData gridData = new GridData(768);
        this.mGpxWayPointTable.setLayoutData((Object)gridData);
        gridData.heightHint = 100;
        this.mGpxWayPointTable.setHeaderVisible(true);
        this.mGpxWayPointTable.setLinesVisible(true);
        TableHelper.createTableColumn(this.mGpxWayPointTable, "Name", 16384, "Some Name", PREFS_WAYPOINT_COL_NAME, iPreferenceStore);
        TableHelper.createTableColumn(this.mGpxWayPointTable, "Longitude", 16384, "-199.999999", PREFS_WAYPOINT_COL_LONGITUDE, iPreferenceStore);
        TableHelper.createTableColumn(this.mGpxWayPointTable, "Latitude", 16384, "-199.999999", PREFS_WAYPOINT_COL_LATITUDE, iPreferenceStore);
        TableHelper.createTableColumn(this.mGpxWayPointTable, "Elevation", 16384, "99999.9", PREFS_WAYPOINT_COL_ELEVATION, iPreferenceStore);
        TableHelper.createTableColumn(this.mGpxWayPointTable, "Description", 16384, "Some Description", PREFS_WAYPOINT_COL_DESCRIPTION, iPreferenceStore);
        final TableViewer tableViewer = new TableViewer(this.mGpxWayPointTable);
        tableViewer.setContentProvider((IContentProvider)new WayPointContentProvider());
        tableViewer.setLabelProvider((IBaseLabelProvider)new WayPointLabelProvider());
        tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                IStructuredSelection iStructuredSelection;
                Object object;
                ISelection iSelection = selectionChangedEvent.getSelection();
                if (iSelection instanceof IStructuredSelection && (object = (iStructuredSelection = (IStructuredSelection)iSelection).getFirstElement()) instanceof WayPoint) {
                    WayPoint wayPoint = (WayPoint)object;
                    if (EmulatorControlPanel.this.mEmulatorConsole != null && !EmulatorControlPanel.this.mPlayingTrack) {
                        EmulatorControlPanel.this.processCommandResult(EmulatorControlPanel.this.mEmulatorConsole.sendLocation(wayPoint.getLongitude(), wayPoint.getLatitude(), wayPoint.getElevation()));
                    }
                }
            }
        });
        this.mGpxTrackTable = new Table(composite, 66304);
        gridData = new GridData(768);
        this.mGpxTrackTable.setLayoutData((Object)gridData);
        gridData.heightHint = 100;
        this.mGpxTrackTable.setHeaderVisible(true);
        this.mGpxTrackTable.setLinesVisible(true);
        TableHelper.createTableColumn(this.mGpxTrackTable, "Name", 16384, "Some very long name", PREFS_TRACK_COL_NAME, iPreferenceStore);
        TableHelper.createTableColumn(this.mGpxTrackTable, "Point Count", 131072, "9999", PREFS_TRACK_COL_COUNT, iPreferenceStore);
        TableHelper.createTableColumn(this.mGpxTrackTable, "First Point Time", 16384, "999-99-99T99:99:99Z", PREFS_TRACK_COL_FIRST, iPreferenceStore);
        TableHelper.createTableColumn(this.mGpxTrackTable, "Last Point Time", 16384, "999-99-99T99:99:99Z", PREFS_TRACK_COL_LAST, iPreferenceStore);
        TableHelper.createTableColumn(this.mGpxTrackTable, "Comment", 16384, "-199.999999", PREFS_TRACK_COL_COMMENT, iPreferenceStore);
        final TableViewer tableViewer2 = new TableViewer(this.mGpxTrackTable);
        tableViewer2.setContentProvider((IContentProvider)new TrackContentProvider());
        tableViewer2.setLabelProvider((IBaseLabelProvider)new TrackLabelProvider());
        tableViewer2.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                IStructuredSelection iStructuredSelection;
                Object object;
                ISelection iSelection = selectionChangedEvent.getSelection();
                if (iSelection instanceof IStructuredSelection && (object = (iStructuredSelection = (IStructuredSelection)iSelection).getFirstElement()) instanceof GpxParser.Track) {
                    GpxParser.Track track = (GpxParser.Track)object;
                    if (EmulatorControlPanel.this.mEmulatorConsole != null && !EmulatorControlPanel.this.mPlayingTrack) {
                        TrackPoint[] trackPointArray = track.getPoints();
                        EmulatorControlPanel.this.processCommandResult(EmulatorControlPanel.this.mEmulatorConsole.sendLocation(trackPointArray[0].getLongitude(), trackPointArray[0].getLatitude(), trackPointArray[0].getElevation()));
                    }
                    EmulatorControlPanel.this.mPlayGpxButton.setEnabled(true);
                    EmulatorControlPanel.this.mGpxBackwardButton.setEnabled(true);
                    EmulatorControlPanel.this.mGpxForwardButton.setEnabled(true);
                    EmulatorControlPanel.this.mGpxSpeedButton.setEnabled(true);
                    return;
                }
                EmulatorControlPanel.this.mPlayGpxButton.setEnabled(false);
                EmulatorControlPanel.this.mGpxBackwardButton.setEnabled(false);
                EmulatorControlPanel.this.mGpxForwardButton.setEnabled(false);
                EmulatorControlPanel.this.mGpxSpeedButton.setEnabled(false);
            }
        });
        this.mGpxUploadButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                GpxParser gpxParser;
                FileDialog fileDialog = new FileDialog(EmulatorControlPanel.this.mParent.getShell(), 4096);
                fileDialog.setText("Load GPX File");
                fileDialog.setFilterExtensions(new String[]{"*.gpx"});
                String string = fileDialog.open();
                if (string != null && (gpxParser = new GpxParser(string)).parse()) {
                    tableViewer.setInput((Object)gpxParser.getWayPoints());
                    tableViewer2.setInput((Object)gpxParser.getTracks());
                }
            }
        });
        this.mGpxPlayControls = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(5, false);
        this.mGpxPlayControls.setLayout((Layout)gridLayout);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.mGpxPlayControls.setLayoutData((Object)new GridData(768));
        this.mPlayGpxButton = new Button(this.mGpxPlayControls, 0x800008);
        this.mPlayGpxButton.setImage(this.mPlayImage);
        this.mPlayGpxButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (!EmulatorControlPanel.this.mPlayingTrack) {
                    IStructuredSelection iStructuredSelection;
                    Object object;
                    ISelection iSelection = tableViewer2.getSelection();
                    if (!iSelection.isEmpty() && iSelection instanceof IStructuredSelection && (object = (iStructuredSelection = (IStructuredSelection)iSelection).getFirstElement()) instanceof GpxParser.Track) {
                        GpxParser.Track track = (GpxParser.Track)object;
                        EmulatorControlPanel.this.playTrack(track);
                    }
                } else {
                    EmulatorControlPanel.this.mPlayingTrack = false;
                    if (EmulatorControlPanel.this.mPlayingThread != null) {
                        EmulatorControlPanel.this.mPlayingThread.interrupt();
                    }
                }
            }
        });
        Label label = new Label(this.mGpxPlayControls, 514);
        gridData = new GridData(1040);
        label.setLayoutData((Object)gridData);
        gridData.heightHint = 0;
        ImageLoader imageLoader = ImageLoader.getDdmUiLibLoader();
        this.mGpxBackwardButton = new Button(this.mGpxPlayControls, 0x800002);
        this.mGpxBackwardButton.setImage(imageLoader.loadImage("backward.png", this.mParent.getDisplay()));
        this.mGpxBackwardButton.setSelection(false);
        this.mGpxBackwardButton.addSelectionListener((SelectionListener)this.mDirectionButtonAdapter);
        this.mGpxForwardButton = new Button(this.mGpxPlayControls, 0x800002);
        this.mGpxForwardButton.setImage(imageLoader.loadImage("forward.png", this.mParent.getDisplay()));
        this.mGpxForwardButton.setSelection(true);
        this.mGpxForwardButton.addSelectionListener((SelectionListener)this.mDirectionButtonAdapter);
        this.mGpxSpeedButton = new Button(this.mGpxPlayControls, 0x800008);
        this.mSpeedIndex = 0;
        this.mSpeed = PLAY_SPEEDS[this.mSpeedIndex];
        this.mGpxSpeedButton.setText(String.format(SPEED_FORMAT, this.mSpeed));
        this.mGpxSpeedButton.addSelectionListener((SelectionListener)this.mSpeedButtonAdapter);
        this.mPlayGpxButton.setEnabled(false);
        this.mGpxBackwardButton.setEnabled(false);
        this.mGpxForwardButton.setEnabled(false);
        this.mGpxSpeedButton.setEnabled(false);
    }

    private void createKmlLocationControl(Composite composite) {
        IPreferenceStore iPreferenceStore = DdmUiPreferences.getStore();
        composite.setLayout((Layout)new GridLayout(1, false));
        this.mKmlUploadButton = new Button(composite, 8);
        this.mKmlUploadButton.setText("Load KML...");
        this.mKmlWayPointTable = new Table(composite, 66304);
        GridData gridData = new GridData(768);
        this.mKmlWayPointTable.setLayoutData((Object)gridData);
        gridData.heightHint = 200;
        this.mKmlWayPointTable.setHeaderVisible(true);
        this.mKmlWayPointTable.setLinesVisible(true);
        TableHelper.createTableColumn(this.mKmlWayPointTable, "Name", 16384, "Some Name", PREFS_WAYPOINT_COL_NAME, iPreferenceStore);
        TableHelper.createTableColumn(this.mKmlWayPointTable, "Longitude", 16384, "-199.999999", PREFS_WAYPOINT_COL_LONGITUDE, iPreferenceStore);
        TableHelper.createTableColumn(this.mKmlWayPointTable, "Latitude", 16384, "-199.999999", PREFS_WAYPOINT_COL_LATITUDE, iPreferenceStore);
        TableHelper.createTableColumn(this.mKmlWayPointTable, "Elevation", 16384, "99999.9", PREFS_WAYPOINT_COL_ELEVATION, iPreferenceStore);
        TableHelper.createTableColumn(this.mKmlWayPointTable, "Description", 16384, "Some Description", PREFS_WAYPOINT_COL_DESCRIPTION, iPreferenceStore);
        final TableViewer tableViewer = new TableViewer(this.mKmlWayPointTable);
        tableViewer.setContentProvider((IContentProvider)new WayPointContentProvider());
        tableViewer.setLabelProvider((IBaseLabelProvider)new WayPointLabelProvider());
        this.mKmlUploadButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                KmlParser kmlParser;
                FileDialog fileDialog = new FileDialog(EmulatorControlPanel.this.mParent.getShell(), 4096);
                fileDialog.setText("Load KML File");
                fileDialog.setFilterExtensions(new String[]{"*.kml"});
                String string = fileDialog.open();
                if (string != null && (kmlParser = new KmlParser(string)).parse()) {
                    tableViewer.setInput((Object)kmlParser.getWayPoints());
                    EmulatorControlPanel.this.mPlayKmlButton.setEnabled(true);
                    EmulatorControlPanel.this.mKmlBackwardButton.setEnabled(true);
                    EmulatorControlPanel.this.mKmlForwardButton.setEnabled(true);
                    EmulatorControlPanel.this.mKmlSpeedButton.setEnabled(true);
                }
            }
        });
        tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                IStructuredSelection iStructuredSelection;
                Object object;
                ISelection iSelection = selectionChangedEvent.getSelection();
                if (iSelection instanceof IStructuredSelection && (object = (iStructuredSelection = (IStructuredSelection)iSelection).getFirstElement()) instanceof WayPoint) {
                    WayPoint wayPoint = (WayPoint)object;
                    if (EmulatorControlPanel.this.mEmulatorConsole != null && !EmulatorControlPanel.this.mPlayingTrack) {
                        EmulatorControlPanel.this.processCommandResult(EmulatorControlPanel.this.mEmulatorConsole.sendLocation(wayPoint.getLongitude(), wayPoint.getLatitude(), wayPoint.getElevation()));
                    }
                }
            }
        });
        this.mKmlPlayControls = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(5, false);
        this.mKmlPlayControls.setLayout((Layout)gridLayout);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.mKmlPlayControls.setLayoutData((Object)new GridData(768));
        this.mPlayKmlButton = new Button(this.mKmlPlayControls, 0x800008);
        this.mPlayKmlButton.setImage(this.mPlayImage);
        this.mPlayKmlButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (!EmulatorControlPanel.this.mPlayingTrack) {
                    Object object = tableViewer.getInput();
                    if (object instanceof WayPoint[]) {
                        EmulatorControlPanel.this.playKml((WayPoint[])object);
                    }
                } else {
                    EmulatorControlPanel.this.mPlayingTrack = false;
                    if (EmulatorControlPanel.this.mPlayingThread != null) {
                        EmulatorControlPanel.this.mPlayingThread.interrupt();
                    }
                }
            }
        });
        Label label = new Label(this.mKmlPlayControls, 514);
        gridData = new GridData(1040);
        label.setLayoutData((Object)gridData);
        gridData.heightHint = 0;
        ImageLoader imageLoader = ImageLoader.getDdmUiLibLoader();
        this.mKmlBackwardButton = new Button(this.mKmlPlayControls, 0x800002);
        this.mKmlBackwardButton.setImage(imageLoader.loadImage("backward.png", this.mParent.getDisplay()));
        this.mKmlBackwardButton.setSelection(false);
        this.mKmlBackwardButton.addSelectionListener((SelectionListener)this.mDirectionButtonAdapter);
        this.mKmlForwardButton = new Button(this.mKmlPlayControls, 0x800002);
        this.mKmlForwardButton.setImage(imageLoader.loadImage("forward.png", this.mParent.getDisplay()));
        this.mKmlForwardButton.setSelection(true);
        this.mKmlForwardButton.addSelectionListener((SelectionListener)this.mDirectionButtonAdapter);
        this.mKmlSpeedButton = new Button(this.mKmlPlayControls, 0x800008);
        this.mSpeedIndex = 0;
        this.mSpeed = PLAY_SPEEDS[this.mSpeedIndex];
        this.mKmlSpeedButton.setText(String.format(SPEED_FORMAT, this.mSpeed));
        this.mKmlSpeedButton.addSelectionListener((SelectionListener)this.mSpeedButtonAdapter);
        this.mPlayKmlButton.setEnabled(false);
        this.mKmlBackwardButton.setEnabled(false);
        this.mKmlForwardButton.setEnabled(false);
        this.mKmlSpeedButton.setEnabled(false);
    }

    public void setFocus() {
    }

    protected void postCreation() {
    }

    private synchronized void setDataMode(int n) {
        if (this.mEmulatorConsole != null) {
            this.processCommandResult(this.mEmulatorConsole.setGsmDataMode(EmulatorConsole.GsmMode.getEnum((String)GSM_MODES[n][1])));
        }
    }

    private synchronized void setVoiceMode(int n) {
        if (this.mEmulatorConsole != null) {
            this.processCommandResult(this.mEmulatorConsole.setGsmVoiceMode(EmulatorConsole.GsmMode.getEnum((String)GSM_MODES[n][1])));
        }
    }

    private synchronized void setNetworkLatency(int n) {
        if (this.mEmulatorConsole != null) {
            this.processCommandResult(this.mEmulatorConsole.setNetworkLatency(n));
        }
    }

    private synchronized void setNetworkSpeed(int n) {
        if (this.mEmulatorConsole != null) {
            this.processCommandResult(this.mEmulatorConsole.setNetworkSpeed(n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNewDevice(IDevice iDevice) {
        boolean bl;
        EmulatorControlPanel emulatorControlPanel;
        if (this.mParent.isDisposed()) {
            return;
        }
        EmulatorControlPanel emulatorControlPanel2 = this;
        synchronized (emulatorControlPanel2) {
            this.mEmulatorConsole = null;
        }
        try {
            if (iDevice != null) {
                emulatorControlPanel2 = null;
                emulatorControlPanel = null;
                EmulatorControlPanel emulatorControlPanel3 = this;
                synchronized (emulatorControlPanel3) {
                    this.mEmulatorConsole = EmulatorConsole.getConsole((IDevice)iDevice);
                    if (this.mEmulatorConsole != null) {
                        emulatorControlPanel2 = this.mEmulatorConsole.getGsmStatus();
                        emulatorControlPanel = this.mEmulatorConsole.getNetworkStatus();
                        if (emulatorControlPanel2 == null || emulatorControlPanel == null) {
                            this.mEmulatorConsole = null;
                        }
                    }
                }
                if (emulatorControlPanel2 != null && emulatorControlPanel != null && !(emulatorControlPanel3 = this.mParent.getDisplay()).isDisposed()) {
                    EmulatorControlPanel emulatorControlPanel4 = emulatorControlPanel2;
                    EmulatorControlPanel emulatorControlPanel5 = emulatorControlPanel;
                    emulatorControlPanel3.asyncExec(new Runnable((EmulatorConsole.GsmStatus)emulatorControlPanel4, (EmulatorConsole.NetworkStatus)emulatorControlPanel5){
                        final /* synthetic */ EmulatorConsole.GsmStatus val$f_gsm;
                        final /* synthetic */ EmulatorConsole.NetworkStatus val$f_netstatus;
                        {
                            this.val$f_gsm = gsmStatus;
                            this.val$f_netstatus = networkStatus;
                        }

                        public void run() {
                            if (this.val$f_gsm.voice != EmulatorConsole.GsmMode.UNKNOWN) {
                                EmulatorControlPanel.this.mVoiceMode.select(EmulatorControlPanel.this.getGsmComboIndex(this.val$f_gsm.voice));
                            } else {
                                EmulatorControlPanel.this.mVoiceMode.clearSelection();
                            }
                            if (this.val$f_gsm.data != EmulatorConsole.GsmMode.UNKNOWN) {
                                EmulatorControlPanel.this.mDataMode.select(EmulatorControlPanel.this.getGsmComboIndex(this.val$f_gsm.data));
                            } else {
                                EmulatorControlPanel.this.mDataMode.clearSelection();
                            }
                            if (this.val$f_netstatus.speed != -1) {
                                EmulatorControlPanel.this.mNetworkSpeed.select(this.val$f_netstatus.speed);
                            } else {
                                EmulatorControlPanel.this.mNetworkSpeed.clearSelection();
                            }
                            if (this.val$f_netstatus.latency != -1) {
                                EmulatorControlPanel.this.mNetworkLatency.select(this.val$f_netstatus.latency);
                            } else {
                                EmulatorControlPanel.this.mNetworkLatency.clearSelection();
                            }
                        }
                    });
                }
            }
            bl = false;
            emulatorControlPanel = this;
        }
        catch (Throwable throwable) {
            boolean bl2 = false;
            EmulatorControlPanel emulatorControlPanel6 = this;
            synchronized (emulatorControlPanel6) {
                bl2 = this.mEmulatorConsole != null;
            }
            this.enable(bl2);
            throw throwable;
        }
        synchronized (emulatorControlPanel) {
            bl = this.mEmulatorConsole != null;
        }
        this.enable(bl);
    }

    private void enable(final boolean bl) {
        try {
            Display display = this.mParent.getDisplay();
            display.asyncExec(new Runnable(){

                public void run() {
                    if (!EmulatorControlPanel.this.mParent.isDisposed()) {
                        EmulatorControlPanel.this.doEnable(bl);
                    }
                }
            });
        }
        catch (SWTException sWTException) {
            // empty catch block
        }
    }

    private boolean isValidPhoneNumber() {
        String string = this.mPhoneNumber.getText().trim();
        return string.matches(RE_PHONE_NUMBER);
    }

    protected void doEnable(boolean bl) {
        boolean bl2;
        this.mVoiceLabel.setEnabled(bl);
        this.mVoiceMode.setEnabled(bl);
        this.mDataLabel.setEnabled(bl);
        this.mDataMode.setEnabled(bl);
        this.mSpeedLabel.setEnabled(bl);
        this.mNetworkSpeed.setEnabled(bl);
        this.mLatencyLabel.setEnabled(bl);
        this.mNetworkLatency.setEnabled(bl);
        if (this.mPhoneNumber.isEnabled() != bl) {
            this.mNumberLabel.setEnabled(bl);
            this.mPhoneNumber.setEnabled(bl);
        }
        boolean bl3 = this.isValidPhoneNumber();
        this.mVoiceButton.setEnabled(bl && bl3);
        this.mSmsButton.setEnabled(bl && bl3);
        boolean bl4 = bl2 = bl && bl3 && this.mSmsButton.getSelection();
        if (this.mSmsMessage.isEnabled() != bl2) {
            this.mMessageLabel.setEnabled(bl2);
            this.mSmsMessage.setEnabled(bl2);
        }
        if (!bl) {
            this.mSmsMessage.setText("");
        }
        this.mCallButton.setEnabled(bl && bl3);
        this.mCancelButton.setEnabled(bl && bl3 && this.mVoiceButton.getSelection());
        if (!bl) {
            this.mVoiceMode.clearSelection();
            this.mDataMode.clearSelection();
            this.mNetworkSpeed.clearSelection();
            this.mNetworkLatency.clearSelection();
            if (this.mPhoneNumber.getText().length() > 0) {
                this.mPhoneNumber.setText("");
            }
        }
        this.mLocationFolders.setEnabled(bl);
        this.mDecimalButton.setEnabled(bl);
        this.mSexagesimalButton.setEnabled(bl);
        this.mLongitudeControls.setEnabled(bl);
        this.mLatitudeControls.setEnabled(bl);
        this.mGpxUploadButton.setEnabled(bl);
        this.mGpxWayPointTable.setEnabled(bl);
        this.mGpxTrackTable.setEnabled(bl);
        this.mKmlUploadButton.setEnabled(bl);
        this.mKmlWayPointTable.setEnabled(bl);
    }

    private int getGsmComboIndex(EmulatorConsole.GsmMode gsmMode) {
        for (int i = 0; i < GSM_MODES.length; ++i) {
            String[] stringArray = GSM_MODES[i];
            if (!gsmMode.getTag().equals(stringArray[1])) continue;
            return i;
        }
        return -1;
    }

    private boolean processCommandResult(final String string) {
        if (string != EmulatorConsole.RESULT_OK) {
            try {
                this.mParent.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (!EmulatorControlPanel.this.mParent.isDisposed()) {
                            MessageDialog.openError((Shell)EmulatorControlPanel.this.mParent.getShell(), (String)"Emulator Console", (String)string);
                        }
                    }
                });
            }
            catch (SWTException sWTException) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    private void playTrack(final GpxParser.Track track) {
        if (this.mEmulatorConsole != null) {
            this.mPlayGpxButton.setImage(this.mPauseImage);
            this.mPlayKmlButton.setImage(this.mPauseImage);
            this.mPlayingTrack = true;
            this.mPlayingThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Unable to fully structure code
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    block29: {
                        var1_1 = track.getPoints();
                        var2_3 = var1_1.length;
                        var3_4 = 0;
                        if (EmulatorControlPanel.access$400(EmulatorControlPanel.this) == -1) {
                            var3_4 = var2_3 - 1;
                        }
                        var4_5 = var3_4;
lbl8:
                        // 2 sources

                        while (var4_5 >= 0 && var4_5 < var2_3) {
                            if (EmulatorControlPanel.access$3000(EmulatorControlPanel.this)) ** GOTO lbl-1000
                            ** GOTO lbl21
                        }
                        break block29;
                        {
                            block30: {
                                catch (Throwable var19_20) {
                                    EmulatorControlPanel.access$3002(EmulatorControlPanel.this, false);
                                    try {
                                        EmulatorControlPanel.access$3200(EmulatorControlPanel.this).getDisplay().asyncExec(new Runnable(){

                                            public void run() {
                                                if (!EmulatorControlPanel.this.mPlayGpxButton.isDisposed()) {
                                                    EmulatorControlPanel.this.mPlayGpxButton.setImage(EmulatorControlPanel.this.mPlayImage);
                                                    EmulatorControlPanel.this.mPlayKmlButton.setImage(EmulatorControlPanel.this.mPlayImage);
                                                }
                                            }
                                        });
                                        throw var19_20;
                                    }
                                    catch (SWTException var20_21) {
                                        // empty catch block
                                    }
                                    throw var19_20;
                                }
lbl21:
                                // 1 sources

                                EmulatorControlPanel.access$3002(EmulatorControlPanel.this, false);
                                try {
                                    EmulatorControlPanel.access$3200(EmulatorControlPanel.this).getDisplay().asyncExec(new /* invalid duplicate definition of identical inner class */);
                                    return;
                                }
                                catch (SWTException var5_7) {
                                    // empty catch block
                                }
                                return;
lbl-1000:
                                // 1 sources

                                {
                                    var5_6 = var1_1[var4_5];
                                    var6_9 = EmulatorControlPanel.this;
                                    synchronized (var6_9) {
                                        if (EmulatorControlPanel.access$2100(EmulatorControlPanel.this) != null && EmulatorControlPanel.access$2500(EmulatorControlPanel.this, EmulatorControlPanel.access$2100(EmulatorControlPanel.this).sendLocation(var5_6.getLongitude(), var5_6.getLatitude(), var5_6.getElevation()))) break block30;
                                    }
                                }
                                EmulatorControlPanel.access$3002(EmulatorControlPanel.this, false);
                                try {
                                    EmulatorControlPanel.access$3200(EmulatorControlPanel.this).getDisplay().asyncExec(new /* invalid duplicate definition of identical inner class */);
                                    return;
                                }
                                catch (SWTException var7_11) {
                                    // empty catch block
                                }
                                return;
                            }
                            var6_8 = var4_5 + EmulatorControlPanel.access$400(EmulatorControlPanel.this);
                            if (var6_8 < 0 || var6_8 >= var2_3) ** GOTO lbl-1000
                            var7_10 = var1_1[var6_8];
                            var8_12 = var7_10.getTime() - var5_6.getTime();
                            if (var8_12 < 0L) {
                                var8_12 = -var8_12;
                            }
                            var10_13 = System.currentTimeMillis();
                            try {
                                24.sleep(var8_12 / (long)EmulatorControlPanel.access$700(EmulatorControlPanel.this));
                            }
                            catch (InterruptedException var12_14) {}
                            if (EmulatorControlPanel.access$3000(EmulatorControlPanel.this)) ** GOTO lbl-1000
                            EmulatorControlPanel.access$3002(EmulatorControlPanel.this, false);
                            try {
                                EmulatorControlPanel.access$3200(EmulatorControlPanel.this).getDisplay().asyncExec(new /* invalid duplicate definition of identical inner class */);
                                return;
                            }
                            catch (SWTException var13_16) {
                                // empty catch block
                            }
                            return;
lbl-1000:
                            // 3 sources

                            {
                                while ((var13_15 = System.currentTimeMillis() - var10_13) < (var15_17 = var8_12 / (long)EmulatorControlPanel.access$700(EmulatorControlPanel.this))) {
                                    try {
                                        24.sleep(var15_17 - var13_15);
                                    }
                                    catch (InterruptedException var17_18) {
                                        if (EmulatorControlPanel.access$3000(EmulatorControlPanel.this)) continue;
                                        EmulatorControlPanel.access$3002(EmulatorControlPanel.this, false);
                                        try {
                                            EmulatorControlPanel.access$3200(EmulatorControlPanel.this).getDisplay().asyncExec(new /* invalid duplicate definition of identical inner class */);
                                            return;
                                        }
                                        catch (SWTException var18_19) {
                                            // empty catch block
                                        }
                                        return;
                                    }
                                }
                            }
                        }
lbl-1000:
                        // 3 sources

                        {
                            var4_5 += EmulatorControlPanel.access$400(EmulatorControlPanel.this);
                            ** GOTO lbl8
                        }
                    }
                    EmulatorControlPanel.access$3002(EmulatorControlPanel.this, false);
                    try {
                        EmulatorControlPanel.access$3200(EmulatorControlPanel.this).getDisplay().asyncExec(new /* invalid duplicate definition of identical inner class */);
                        return;
                    }
                    catch (SWTException var1_2) {
                        return;
                    }
                }
            };
            this.mPlayingThread.start();
        }
    }

    private void playKml(final WayPoint[] wayPointArray) {
        if (this.mEmulatorConsole != null) {
            this.mPlayGpxButton.setImage(this.mPauseImage);
            this.mPlayKmlButton.setImage(this.mPauseImage);
            this.mPlayingTrack = true;
            this.mPlayingThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Unable to fully structure code
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    block29: {
                        var1_1 = wayPointArray.length;
                        var2_3 = 0;
                        if (EmulatorControlPanel.access$400(EmulatorControlPanel.this) == -1) {
                            var2_3 = var1_1 - 1;
                        }
                        var3_4 = var2_3;
lbl7:
                        // 2 sources

                        while (var3_4 >= 0 && var3_4 < var1_1) {
                            if (EmulatorControlPanel.access$3000(EmulatorControlPanel.this)) ** GOTO lbl-1000
                            ** GOTO lbl20
                        }
                        break block29;
                        {
                            block30: {
                                catch (Throwable var17_18) {
                                    EmulatorControlPanel.access$3002(EmulatorControlPanel.this, false);
                                    try {
                                        EmulatorControlPanel.access$3200(EmulatorControlPanel.this).getDisplay().asyncExec(new Runnable(){

                                            public void run() {
                                                if (!EmulatorControlPanel.this.mPlayGpxButton.isDisposed()) {
                                                    EmulatorControlPanel.this.mPlayGpxButton.setImage(EmulatorControlPanel.this.mPlayImage);
                                                    EmulatorControlPanel.this.mPlayKmlButton.setImage(EmulatorControlPanel.this.mPlayImage);
                                                }
                                            }
                                        });
                                        throw var17_18;
                                    }
                                    catch (SWTException var18_19) {
                                        // empty catch block
                                    }
                                    throw var17_18;
                                }
lbl20:
                                // 1 sources

                                EmulatorControlPanel.access$3002(EmulatorControlPanel.this, false);
                                try {
                                    EmulatorControlPanel.access$3200(EmulatorControlPanel.this).getDisplay().asyncExec(new /* invalid duplicate definition of identical inner class */);
                                    return;
                                }
                                catch (SWTException var4_6) {
                                    // empty catch block
                                }
                                return;
lbl-1000:
                                // 1 sources

                                {
                                    var4_5 = wayPointArray[var3_4];
                                    var5_8 = EmulatorControlPanel.this;
                                    synchronized (var5_8) {
                                        if (EmulatorControlPanel.access$2100(EmulatorControlPanel.this) != null && EmulatorControlPanel.access$2500(EmulatorControlPanel.this, EmulatorControlPanel.access$2100(EmulatorControlPanel.this).sendLocation(var4_5.getLongitude(), var4_5.getLatitude(), var4_5.getElevation()))) break block30;
                                    }
                                }
                                EmulatorControlPanel.access$3002(EmulatorControlPanel.this, false);
                                try {
                                    EmulatorControlPanel.access$3200(EmulatorControlPanel.this).getDisplay().asyncExec(new /* invalid duplicate definition of identical inner class */);
                                    return;
                                }
                                catch (SWTException var6_10) {
                                    // empty catch block
                                }
                                return;
                            }
                            var5_7 = var3_4 + EmulatorControlPanel.access$400(EmulatorControlPanel.this);
                            if (var5_7 < 0 || var5_7 >= var1_1) ** GOTO lbl-1000
                            var6_9 = 1000L;
                            if (var6_9 < 0L) {
                                var6_9 = -var6_9;
                            }
                            var8_11 = System.currentTimeMillis();
                            try {
                                25.sleep(var6_9 / (long)EmulatorControlPanel.access$700(EmulatorControlPanel.this));
                            }
                            catch (InterruptedException var10_12) {}
                            if (EmulatorControlPanel.access$3000(EmulatorControlPanel.this)) ** GOTO lbl-1000
                            EmulatorControlPanel.access$3002(EmulatorControlPanel.this, false);
                            try {
                                EmulatorControlPanel.access$3200(EmulatorControlPanel.this).getDisplay().asyncExec(new /* invalid duplicate definition of identical inner class */);
                                return;
                            }
                            catch (SWTException var11_14) {
                                // empty catch block
                            }
                            return;
lbl-1000:
                            // 3 sources

                            {
                                while ((var11_13 = System.currentTimeMillis() - var8_11) < (var13_15 = var6_9 / (long)EmulatorControlPanel.access$700(EmulatorControlPanel.this))) {
                                    try {
                                        25.sleep(var13_15 - var11_13);
                                    }
                                    catch (InterruptedException var15_16) {
                                        if (EmulatorControlPanel.access$3000(EmulatorControlPanel.this)) continue;
                                        EmulatorControlPanel.access$3002(EmulatorControlPanel.this, false);
                                        try {
                                            EmulatorControlPanel.access$3200(EmulatorControlPanel.this).getDisplay().asyncExec(new /* invalid duplicate definition of identical inner class */);
                                            return;
                                        }
                                        catch (SWTException var16_17) {
                                            // empty catch block
                                        }
                                        return;
                                    }
                                }
                            }
                        }
lbl-1000:
                        // 3 sources

                        {
                            var3_4 += EmulatorControlPanel.access$400(EmulatorControlPanel.this);
                            ** GOTO lbl7
                        }
                    }
                    EmulatorControlPanel.access$3002(EmulatorControlPanel.this, false);
                    try {
                        EmulatorControlPanel.access$3200(EmulatorControlPanel.this).getDisplay().asyncExec(new /* invalid duplicate definition of identical inner class */);
                        return;
                    }
                    catch (SWTException var1_2) {
                        return;
                    }
                }
            };
            this.mPlayingThread.start();
        }
    }

    static /* synthetic */ int access$400(EmulatorControlPanel emulatorControlPanel) {
        return emulatorControlPanel.mPlayDirection;
    }
}

