/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.ddmlib.RawImage;
import com.android.ddmlib.TimeoutException;
import com.android.ddmuilib.DdmUiPreferences;
import com.android.ddmuilib.ImageLoader;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.ImageTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ScreenShotDialog
extends Dialog {
    private Label mBusyLabel;
    private Label mImageLabel;
    private Button mSave;
    private IDevice mDevice;
    private RawImage mRawImage;
    private Clipboard mClipboard;
    private int mRotateCount = 0;

    public ScreenShotDialog(Shell shell) {
        this(shell, 67680);
        this.mClipboard = new Clipboard(shell.getDisplay());
    }

    public ScreenShotDialog(Shell shell, int n) {
        super(shell, n);
    }

    public void open(IDevice iDevice) {
        this.mDevice = iDevice;
        Shell shell = this.getParent();
        Shell shell2 = new Shell(shell, this.getStyle());
        shell2.setText("Device Screen Capture");
        this.createContents(shell2);
        shell2.pack();
        shell2.open();
        this.updateDeviceImage(shell2);
        Display display = shell.getDisplay();
        while (!shell2.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private void createContents(final Shell shell) {
        shell.setLayout((Layout)new GridLayout(5, true));
        Button button = new Button((Composite)shell, 8);
        button.setText("Refresh");
        GridData gridData = new GridData(64);
        gridData.widthHint = 80;
        button.setLayoutData((Object)gridData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ScreenShotDialog.this.updateDeviceImage(shell);
                for (int i = 0; i < ScreenShotDialog.this.mRotateCount; ++i) {
                    ScreenShotDialog.this.mRawImage = ScreenShotDialog.this.mRawImage.getRotated();
                }
                ScreenShotDialog.this.updateImageDisplay(shell);
            }
        });
        Button button2 = new Button((Composite)shell, 8);
        button2.setText("Rotate");
        gridData = new GridData(64);
        gridData.widthHint = 80;
        button2.setLayoutData((Object)gridData);
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (ScreenShotDialog.this.mRawImage != null) {
                    ScreenShotDialog.this.mRotateCount = (ScreenShotDialog.this.mRotateCount + 1) % 4;
                    ScreenShotDialog.this.mRawImage = ScreenShotDialog.this.mRawImage.getRotated();
                    ScreenShotDialog.this.updateImageDisplay(shell);
                }
            }
        });
        this.mSave = new Button((Composite)shell, 8);
        this.mSave.setText("Save");
        gridData = new GridData(64);
        gridData.widthHint = 80;
        this.mSave.setLayoutData((Object)gridData);
        this.mSave.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ScreenShotDialog.this.saveImage(shell);
            }
        });
        Button button3 = new Button((Composite)shell, 8);
        button3.setText("Copy");
        button3.setToolTipText("Copy the screenshot to the clipboard");
        gridData = new GridData(64);
        gridData.widthHint = 80;
        button3.setLayoutData((Object)gridData);
        button3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ScreenShotDialog.this.copy();
            }
        });
        Button button4 = new Button((Composite)shell, 8);
        button4.setText("Done");
        gridData = new GridData(64);
        gridData.widthHint = 80;
        button4.setLayoutData((Object)gridData);
        button4.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                shell.close();
            }
        });
        this.mBusyLabel = new Label((Composite)shell, 0);
        this.mBusyLabel.setText("Preparing...");
        gridData = new GridData(32);
        gridData.horizontalSpan = 5;
        this.mBusyLabel.setLayoutData((Object)gridData);
        this.mImageLabel = new Label((Composite)shell, 2048);
        gridData = new GridData(64);
        gridData.horizontalSpan = 5;
        this.mImageLabel.setLayoutData((Object)gridData);
        Display display = shell.getDisplay();
        this.mImageLabel.setImage(ImageLoader.createPlaceHolderArt(display, 50, 50, display.getSystemColor(9)));
        shell.setDefaultButton(button4);
    }

    private void copy() {
        this.mClipboard.setContents(new Object[]{this.mImageLabel.getImage().getImageData()}, new Transfer[]{ImageTransfer.getInstance()});
    }

    private void updateDeviceImage(Shell shell) {
        this.mBusyLabel.setText("Capturing...");
        shell.setCursor(shell.getDisplay().getSystemCursor(1));
        this.mRawImage = this.getDeviceImage();
        this.updateImageDisplay(shell);
    }

    private void updateImageDisplay(Shell shell) {
        Image image;
        if (this.mRawImage == null) {
            Display display = shell.getDisplay();
            image = ImageLoader.createPlaceHolderArt(display, 320, 240, display.getSystemColor(9));
            this.mSave.setEnabled(false);
            this.mBusyLabel.setText("Screen not available");
        } else {
            PaletteData paletteData = new PaletteData(this.mRawImage.getRedMask(), this.mRawImage.getGreenMask(), this.mRawImage.getBlueMask());
            ImageData imageData = new ImageData(this.mRawImage.width, this.mRawImage.height, this.mRawImage.bpp, paletteData, 1, this.mRawImage.data);
            image = new Image((Device)this.getParent().getDisplay(), imageData);
            this.mSave.setEnabled(true);
            this.mBusyLabel.setText("Captured image:");
        }
        this.mImageLabel.setImage(image);
        this.mImageLabel.pack();
        shell.pack();
        shell.setCursor(shell.getDisplay().getSystemCursor(0));
    }

    private RawImage getDeviceImage() {
        try {
            return this.mDevice.getScreenshot();
        }
        catch (IOException iOException) {
            Log.w((String)"ddms", (String)("Unable to get frame buffer: " + iOException.getMessage()));
            return null;
        }
        catch (TimeoutException timeoutException) {
            Log.w((String)"ddms", (String)"Unable to get frame buffer: timeout ");
            return null;
        }
        catch (AdbCommandRejectedException adbCommandRejectedException) {
            Log.w((String)"ddms", (String)("Unable to get frame buffer: " + adbCommandRejectedException.getMessage()));
            return null;
        }
    }

    private void saveImage(Shell shell) {
        FileDialog fileDialog = new FileDialog(shell, 8192);
        Calendar calendar = Calendar.getInstance();
        String string = String.format("device-%tF-%tH%tM%tS.png", calendar, calendar, calendar, calendar);
        fileDialog.setText("Save image...");
        fileDialog.setFileName(string);
        String string2 = DdmUiPreferences.getStore().getString("lastImageSaveDir");
        if (string2.length() == 0) {
            string2 = DdmUiPreferences.getStore().getString("imageSaveDir");
        }
        fileDialog.setFilterPath(string2);
        fileDialog.setFilterNames(new String[]{"PNG Files (*.png)"});
        fileDialog.setFilterExtensions(new String[]{"*.png"});
        string = fileDialog.open();
        if (string != null) {
            String string3 = new File(string).getParent();
            if (string3 != null) {
                DdmUiPreferences.getStore().setValue("lastImageSaveDir", string3);
            }
            Log.d((String)"ddms", (String)("Saving image to " + string));
            ImageData imageData = this.mImageLabel.getImage().getImageData();
            try {
                org.eclipse.swt.graphics.ImageLoader imageLoader = new org.eclipse.swt.graphics.ImageLoader();
                imageLoader.data = new ImageData[]{imageData};
                imageLoader.save(string, 5);
            }
            catch (SWTException sWTException) {
                Log.w((String)"ddms", (String)("Unable to save " + string + ": " + sWTException.getMessage()));
            }
        }
    }
}

