/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib;

import com.android.ddmlib.Client;
import com.android.ddmlib.IStackTraceInfo;
import com.android.ddmlib.ThreadInfo;
import com.android.ddmuilib.DdmUiPreferences;
import com.android.ddmuilib.StackTracePanel;
import com.android.ddmuilib.TableHelper;
import com.android.ddmuilib.TablePanel;
import java.util.Date;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Table;

public class ThreadPanel
extends TablePanel {
    private static final String PREFS_THREAD_COL_ID = "threadPanel.Col0";
    private static final String PREFS_THREAD_COL_TID = "threadPanel.Col1";
    private static final String PREFS_THREAD_COL_STATUS = "threadPanel.Col2";
    private static final String PREFS_THREAD_COL_UTIME = "threadPanel.Col3";
    private static final String PREFS_THREAD_COL_STIME = "threadPanel.Col4";
    private static final String PREFS_THREAD_COL_NAME = "threadPanel.Col5";
    private static final String PREFS_THREAD_SASH = "threadPanel.sash";
    private static final String PREFS_STACK_COL_CLASS = "threadPanel.stack.col0";
    private static final String PREFS_STACK_COL_METHOD = "threadPanel.stack.col1";
    private static final String PREFS_STACK_COL_FILE = "threadPanel.stack.col2";
    private static final String PREFS_STACK_COL_LINE = "threadPanel.stack.col3";
    private static final String PREFS_STACK_COL_NATIVE = "threadPanel.stack.col4";
    private Display mDisplay;
    private Composite mBase;
    private Label mNotEnabled;
    private Label mNotSelected;
    private Composite mThreadBase;
    private Table mThreadTable;
    private TableViewer mThreadViewer;
    private Composite mStackTraceBase;
    private Button mRefreshStackTraceButton;
    private Label mStackTraceTimeLabel;
    private StackTracePanel mStackTracePanel;
    private Table mStackTraceTable;
    private boolean mMustStopRecurringThreadUpdate = false;
    private boolean mRecurringThreadUpdateRunning = false;
    private Object mLock = new Object();
    private static final String[] THREAD_STATUS = new String[]{"zombie", "running", "timed-wait", "monitor", "wait", "init", "start", "native", "vmwait", "suspended"};

    protected Control createControl(Composite composite) {
        this.mDisplay = composite.getDisplay();
        final IPreferenceStore iPreferenceStore = DdmUiPreferences.getStore();
        this.mBase = new Composite(composite, 0);
        this.mBase.setLayout((Layout)new StackLayout());
        this.mNotEnabled = new Label(this.mBase, 0x1000040);
        this.mNotEnabled.setText("Thread updates not enabled for selected client\n(use toolbar button to enable)");
        this.mNotSelected = new Label(this.mBase, 0x1000040);
        this.mNotSelected.setText("no client is selected");
        this.mThreadBase = new Composite(this.mBase, 0);
        this.mThreadBase.setLayout((Layout)new FormLayout());
        this.mThreadTable = new Table(this.mThreadBase, 65538);
        this.mThreadTable.setHeaderVisible(true);
        this.mThreadTable.setLinesVisible(true);
        TableHelper.createTableColumn(this.mThreadTable, "ID", 131072, "888", PREFS_THREAD_COL_ID, iPreferenceStore);
        TableHelper.createTableColumn(this.mThreadTable, "Tid", 131072, "88888", PREFS_THREAD_COL_TID, iPreferenceStore);
        TableHelper.createTableColumn(this.mThreadTable, "Status", 16384, "timed-wait", PREFS_THREAD_COL_STATUS, iPreferenceStore);
        TableHelper.createTableColumn(this.mThreadTable, "utime", 131072, "utime", PREFS_THREAD_COL_UTIME, iPreferenceStore);
        TableHelper.createTableColumn(this.mThreadTable, "stime", 131072, "utime", PREFS_THREAD_COL_STIME, iPreferenceStore);
        TableHelper.createTableColumn(this.mThreadTable, "Name", 16384, "android.class.ReallyLongClassName.MethodName", PREFS_THREAD_COL_NAME, iPreferenceStore);
        this.mThreadViewer = new TableViewer(this.mThreadTable);
        this.mThreadViewer.setContentProvider((IContentProvider)new ThreadContentProvider());
        this.mThreadViewer.setLabelProvider((IBaseLabelProvider)new ThreadLabelProvider());
        this.mThreadViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                ThreadInfo threadInfo = ThreadPanel.this.getThreadSelection(selectionChangedEvent.getSelection());
                ThreadPanel.this.updateThreadStackTrace(threadInfo);
            }
        });
        this.mThreadViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                Client client;
                ThreadInfo threadInfo = ThreadPanel.this.getThreadSelection(doubleClickEvent.getSelection());
                if (threadInfo != null && (client = (Client)ThreadPanel.this.mThreadViewer.getInput()) != null) {
                    client.requestThreadStackTrace(threadInfo.getThreadId());
                }
            }
        });
        final Sash sash = new Sash(this.mThreadBase, 256);
        Color color = composite.getDisplay().getSystemColor(16);
        sash.setBackground(color);
        this.mStackTraceBase = new Composite(this.mThreadBase, 0);
        this.mStackTraceBase.setLayout((Layout)new GridLayout(2, false));
        this.mRefreshStackTraceButton = new Button(this.mStackTraceBase, 8);
        this.mRefreshStackTraceButton.setText("Refresh");
        this.mRefreshStackTraceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Client client;
                ThreadInfo threadInfo = ThreadPanel.this.getThreadSelection(null);
                if (threadInfo != null && (client = ThreadPanel.this.getCurrentClient()) != null) {
                    client.requestThreadStackTrace(threadInfo.getThreadId());
                }
            }
        });
        this.mStackTraceTimeLabel = new Label(this.mStackTraceBase, 0);
        this.mStackTraceTimeLabel.setLayoutData((Object)new GridData(768));
        this.mStackTracePanel = new StackTracePanel();
        this.mStackTraceTable = this.mStackTracePanel.createPanel(this.mStackTraceBase, PREFS_STACK_COL_CLASS, PREFS_STACK_COL_METHOD, PREFS_STACK_COL_FILE, PREFS_STACK_COL_LINE, PREFS_STACK_COL_NATIVE, iPreferenceStore);
        GridData gridData = new GridData(1808);
        this.mStackTraceTable.setLayoutData((Object)gridData);
        gridData.horizontalSpan = 2;
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment((Control)sash, 0);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        this.mThreadTable.setLayoutData((Object)formData);
        final FormData formData2 = new FormData();
        formData2.top = iPreferenceStore != null && iPreferenceStore.contains(PREFS_THREAD_SASH) ? new FormAttachment(0, iPreferenceStore.getInt(PREFS_THREAD_SASH)) : new FormAttachment(50, 0);
        formData2.left = new FormAttachment(0, 0);
        formData2.right = new FormAttachment(100, 0);
        sash.setLayoutData((Object)formData2);
        formData = new FormData();
        formData.top = new FormAttachment((Control)sash, 0);
        formData.bottom = new FormAttachment(100, 0);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        this.mStackTraceBase.setLayoutData((Object)formData);
        sash.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Rectangle rectangle = sash.getBounds();
                Rectangle rectangle2 = ThreadPanel.this.mThreadBase.getClientArea();
                int n = rectangle2.height - rectangle.height - 100;
                event.y = Math.max(Math.min(event.y, n), 100);
                if (event.y != rectangle.y) {
                    formData2.top = new FormAttachment(0, event.y);
                    iPreferenceStore.setValue(ThreadPanel.PREFS_THREAD_SASH, event.y);
                    ThreadPanel.this.mThreadBase.layout();
                }
            }
        });
        ((StackLayout)this.mBase.getLayout()).topControl = this.mNotSelected;
        return this.mBase;
    }

    public void setFocus() {
        this.mThreadTable.setFocus();
    }

    public void clientChanged(Client client, int n) {
        if (client == this.getCurrentClient()) {
            if ((n & 8) != 0 || (n & 0x10) != 0) {
                try {
                    this.mThreadTable.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            ThreadPanel.this.clientSelected();
                        }
                    });
                }
                catch (SWTException sWTException) {}
            } else if ((n & 0x100) != 0) {
                try {
                    this.mThreadTable.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            ThreadPanel.this.updateThreadStackCall();
                        }
                    });
                }
                catch (SWTException sWTException) {
                    // empty catch block
                }
            }
        }
    }

    public void deviceSelected() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clientSelected() {
        if (this.mThreadTable.isDisposed()) {
            return;
        }
        Client client = this.getCurrentClient();
        this.mStackTracePanel.setCurrentClient(client);
        if (client != null) {
            if (!client.isThreadUpdateEnabled()) {
                ((StackLayout)this.mBase.getLayout()).topControl = this.mNotEnabled;
                this.mThreadViewer.setInput(null);
                this.mMustStopRecurringThreadUpdate = true;
            } else {
                ((StackLayout)this.mBase.getLayout()).topControl = this.mThreadBase;
                this.mThreadViewer.setInput((Object)client);
                Object object = this.mLock;
                synchronized (object) {
                    if (!this.mRecurringThreadUpdateRunning) {
                        this.startRecurringThreadUpdate();
                    } else if (this.mMustStopRecurringThreadUpdate) {
                        this.mMustStopRecurringThreadUpdate = false;
                    }
                }
            }
        } else {
            ((StackLayout)this.mBase.getLayout()).topControl = this.mNotSelected;
            this.mThreadViewer.setInput(null);
        }
        this.mBase.layout();
    }

    private void updateThreadStackCall() {
        Client client = this.getCurrentClient();
        if (client != null) {
            ThreadInfo threadInfo = this.getThreadSelection(null);
            if (threadInfo != null) {
                this.updateThreadStackTrace(threadInfo);
            } else {
                this.updateThreadStackTrace(null);
            }
        }
    }

    private void updateThreadStackTrace(ThreadInfo threadInfo) {
        this.mStackTracePanel.setViewerInput((IStackTraceInfo)threadInfo);
        if (threadInfo != null) {
            this.mRefreshStackTraceButton.setEnabled(true);
            long l = threadInfo.getStackCallTime();
            if (l != 0L) {
                String string = new Date(l).toString();
                this.mStackTraceTimeLabel.setText(string);
            } else {
                this.mStackTraceTimeLabel.setText("");
            }
        } else {
            this.mRefreshStackTraceButton.setEnabled(true);
            this.mStackTraceTimeLabel.setText("");
        }
    }

    protected void setTableFocusListener() {
        this.addTableToFocusListener(this.mThreadTable);
        this.addTableToFocusListener(this.mStackTraceTable);
    }

    private void startRecurringThreadUpdate() {
        this.mRecurringThreadUpdateRunning = true;
        int n = 1000;
        this.mDisplay.timerExec(n, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = ThreadPanel.this.mLock;
                synchronized (object) {
                    if (!ThreadPanel.this.mMustStopRecurringThreadUpdate) {
                        Client client = ThreadPanel.this.getCurrentClient();
                        if (client != null) {
                            client.requestThreadUpdate();
                            ThreadPanel.this.mDisplay.timerExec(DdmUiPreferences.getThreadRefreshInterval() * 1000, (Runnable)this);
                        } else {
                            ThreadPanel.this.mRecurringThreadUpdateRunning = false;
                        }
                    } else {
                        ThreadPanel.this.mRecurringThreadUpdateRunning = false;
                        ThreadPanel.this.mMustStopRecurringThreadUpdate = false;
                    }
                }
            }
        });
    }

    private ThreadInfo getThreadSelection(ISelection iSelection) {
        IStructuredSelection iStructuredSelection;
        Object object;
        if (iSelection == null) {
            iSelection = this.mThreadViewer.getSelection();
        }
        if (iSelection instanceof IStructuredSelection && (object = (iStructuredSelection = (IStructuredSelection)iSelection).getFirstElement()) instanceof ThreadInfo) {
            return (ThreadInfo)object;
        }
        return null;
    }

    private static class ThreadLabelProvider
    implements ITableLabelProvider {
        private ThreadLabelProvider() {
        }

        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public String getColumnText(Object object, int n) {
            if (object instanceof ThreadInfo) {
                ThreadInfo threadInfo = (ThreadInfo)object;
                switch (n) {
                    case 0: {
                        return (threadInfo.isDaemon() ? "*" : "") + String.valueOf(threadInfo.getThreadId());
                    }
                    case 1: {
                        return String.valueOf(threadInfo.getTid());
                    }
                    case 2: {
                        if (threadInfo.getStatus() >= 0 && threadInfo.getStatus() < THREAD_STATUS.length) {
                            return THREAD_STATUS[threadInfo.getStatus()];
                        }
                        return "unknown";
                    }
                    case 3: {
                        return String.valueOf(threadInfo.getUtime());
                    }
                    case 4: {
                        return String.valueOf(threadInfo.getStime());
                    }
                    case 5: {
                        return threadInfo.getThreadName();
                    }
                }
            }
            return null;
        }

        public void addListener(ILabelProviderListener iLabelProviderListener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object object, String string) {
            return false;
        }

        public void removeListener(ILabelProviderListener iLabelProviderListener) {
        }
    }

    private static class ThreadContentProvider
    implements IStructuredContentProvider {
        private ThreadContentProvider() {
        }

        public Object[] getElements(Object object) {
            if (object instanceof Client) {
                return ((Client)object).getClientData().getThreads();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }
}

