/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib.heap;

import com.android.ddmlib.Client;
import com.android.ddmlib.Log;
import com.android.ddmlib.NativeAllocationInfo;
import com.android.ddmlib.NativeLibraryMapInfo;
import com.android.ddmlib.NativeStackCallInfo;
import com.android.ddmuilib.Addr2Line;
import com.android.ddmuilib.BaseHeapPanel;
import com.android.ddmuilib.ITableFocusListener;
import com.android.ddmuilib.ImageLoader;
import com.android.ddmuilib.TableHelper;
import com.android.ddmuilib.heap.NativeHeapDataImporter;
import com.android.ddmuilib.heap.NativeHeapDiffSnapshot;
import com.android.ddmuilib.heap.NativeHeapLabelProvider;
import com.android.ddmuilib.heap.NativeHeapProviderByAllocations;
import com.android.ddmuilib.heap.NativeHeapProviderByLibrary;
import com.android.ddmuilib.heap.NativeHeapSnapshot;
import com.android.ddmuilib.heap.NativeStackContentProvider;
import com.android.ddmuilib.heap.NativeStackLabelProvider;
import com.android.ddmuilib.heap.NativeSymbolResolverTask;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeHeapPanel
extends BaseHeapPanel {
    private static final boolean USE_OLD_RESOLVER;
    private final int MAX_DISPLAYED_ERROR_ITEMS = 5;
    private static final String TOOLTIP_EXPORT_DATA = "Export Heap Data";
    private static final String TOOLTIP_ZYGOTE_ALLOCATIONS = "Show Zygote Allocations";
    private static final String TOOLTIP_DIFFS_ONLY = "Only show new allocations not present in previous snapshot";
    private static final String TOOLTIP_GROUPBY = "Group allocations by library.";
    private static final String EXPORT_DATA_IMAGE = "save.png";
    private static final String ZYGOTE_IMAGE = "zygote.png";
    private static final String DIFFS_ONLY_IMAGE = "diff.png";
    private static final String GROUPBY_IMAGE = "groupby.png";
    private static final String SNAPSHOT_HEAP_BUTTON_TEXT = "Snapshot Current Native Heap Usage";
    private static final String LOAD_HEAP_DATA_BUTTON_TEXT = "Import Heap Data";
    private static final String SYMBOL_SEARCH_PATH_LABEL_TEXT = "Symbol Search Path:";
    private static final String SYMBOL_SEARCH_PATH_TEXT_MESSAGE = "List of colon separated paths to search for symbol debug information. See tooltip for examples.";
    private static final String SYMBOL_SEARCH_PATH_TOOLTIP_TEXT = "Colon separated paths that contain unstripped libraries with debug symbols.\ne.g.: <android-src>/out/target/product/generic/symbols/system/lib:/path/to/my/app/obj/local/armeabi";
    private static final String PREFS_SHOW_DIFFS_ONLY = "nativeheap.show.diffs.only";
    private static final String PREFS_SHOW_ZYGOTE_ALLOCATIONS = "nativeheap.show.zygote";
    private static final String PREFS_GROUP_BY_LIBRARY = "nativeheap.grouby.library";
    private static final String PREFS_SYMBOL_SEARCH_PATH = "nativeheap.search.path";
    private static final String PREFS_SASH_HEIGHT_PERCENT = "nativeheap.sash.percent";
    private static final String PREFS_LAST_IMPORTED_HEAPPATH = "nativeheap.last.import.path";
    private IPreferenceStore mPrefStore;
    private List<NativeHeapSnapshot> mNativeHeapSnapshots;
    private List<NativeHeapSnapshot> mDiffSnapshots;
    private Map<Integer, List<NativeHeapSnapshot>> mImportedSnapshotsPerPid;
    private Button mSnapshotHeapButton;
    private Button mLoadHeapDataButton;
    private Text mSymbolSearchPathText;
    private Combo mSnapshotIndexCombo;
    private Label mMemoryAllocatedText;
    private TreeViewer mDetailsTreeViewer;
    private TreeViewer mStackTraceTreeViewer;
    private NativeHeapProviderByAllocations mContentProviderByAllocations;
    private NativeHeapProviderByLibrary mContentProviderByLibrary;
    private NativeHeapLabelProvider mDetailsTreeLabelProvider;
    private ToolBar mDetailsToolBar;
    private ToolItem mGroupByButton;
    private ToolItem mDiffsOnlyButton;
    private ToolItem mShowZygoteAllocationsButton;
    private ToolItem mExportHeapDataButton;
    private ITableFocusListener mTableFocusListener;

    public NativeHeapPanel(IPreferenceStore iPreferenceStore) {
        this.mPrefStore = iPreferenceStore;
        this.mPrefStore.setDefault(PREFS_SASH_HEIGHT_PERCENT, 75);
        this.mPrefStore.setDefault(PREFS_SYMBOL_SEARCH_PATH, "");
        this.mPrefStore.setDefault(PREFS_GROUP_BY_LIBRARY, false);
        this.mPrefStore.setDefault(PREFS_SHOW_ZYGOTE_ALLOCATIONS, true);
        this.mPrefStore.setDefault(PREFS_SHOW_DIFFS_ONLY, false);
        this.mNativeHeapSnapshots = new ArrayList<NativeHeapSnapshot>();
        this.mDiffSnapshots = new ArrayList<NativeHeapSnapshot>();
        this.mImportedSnapshotsPerPid = new HashMap<Integer, List<NativeHeapSnapshot>>();
    }

    public void clientChanged(final Client client, int n) {
        if (client != this.getCurrentClient()) {
            return;
        }
        if ((n & 0x80) != 128) {
            return;
        }
        List list = client.getClientData().getNativeAllocationList();
        if (list.size() == 0) {
            return;
        }
        final List<NativeAllocationInfo> list2 = this.shallowCloneList(list);
        this.addNativeHeapSnapshot(new NativeHeapSnapshot(list2));
        this.updateDisplay();
        if (USE_OLD_RESOLVER) {
            Thread thread = new Thread(new SymbolResolverTask(list2, client.getClientData().getMappedNativeLibraries()));
            thread.setName("Address to Symbol Resolver");
            thread.start();
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    this.resolveSymbols();
                    NativeHeapPanel.this.mDetailsTreeViewer.refresh();
                    NativeHeapPanel.this.mStackTraceTreeViewer.refresh();
                }

                public void resolveSymbols() {
                    Shell shell = Display.getDefault().getActiveShell();
                    ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(shell);
                    NativeSymbolResolverTask nativeSymbolResolverTask = new NativeSymbolResolverTask(list2, client.getClientData().getMappedNativeLibraries(), NativeHeapPanel.this.mSymbolSearchPathText.getText());
                    try {
                        progressMonitorDialog.run(true, true, (IRunnableWithProgress)nativeSymbolResolverTask);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        MessageDialog.openError((Shell)shell, (String)"Error Resolving Symbols", (String)invocationTargetException.getCause().getMessage());
                        return;
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                    MessageDialog.openInformation((Shell)shell, (String)"Symbol Resolution Status", (String)NativeHeapPanel.this.getResolutionStatusMessage(nativeSymbolResolverTask));
                }
            });
        }
    }

    private String getResolutionStatusMessage(NativeSymbolResolverTask nativeSymbolResolverTask) {
        Set<Long> set;
        Set<String> set2;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Symbol Resolution Complete.\n\n");
        Set<Long> set3 = nativeSymbolResolverTask.getUnmappedAddresses();
        if (set3.size() > 0) {
            stringBuilder.append(String.format("Unmapped addresses (%d): ", set3.size()));
            stringBuilder.append(this.getSampleForDisplay(set3));
            stringBuilder.append('\n');
        }
        if ((set2 = nativeSymbolResolverTask.getNotFoundLibraries()).size() > 0) {
            stringBuilder.append(String.format("Libraries not found on disk (%d): ", set2.size()));
            stringBuilder.append(this.getSampleForDisplay(set2));
            stringBuilder.append('\n');
        }
        if ((set = nativeSymbolResolverTask.getUnresolvableAddresses()).size() > 0) {
            stringBuilder.append(String.format("Unresolved addresses (%d): ", set.size()));
            stringBuilder.append(this.getSampleForDisplay(set));
            stringBuilder.append('\n');
        }
        if (nativeSymbolResolverTask.getAddr2LineErrorMessage() != null) {
            stringBuilder.append("Error launching addr2line: ");
            stringBuilder.append(nativeSymbolResolverTask.getAddr2LineErrorMessage());
        }
        return stringBuilder.toString();
    }

    private String getSampleForDisplay(Collection<?> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 1;
        Iterator<?> iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (obj instanceof Long) {
                stringBuilder.append(String.format("0x%x", obj));
            } else {
                stringBuilder.append(obj);
            }
            if (n == 5 && iterator.hasNext()) {
                stringBuilder.append(", ...");
                break;
            }
            if (iterator.hasNext()) {
                stringBuilder.append(", ");
            }
            ++n;
        }
        return stringBuilder.toString();
    }

    private void addNativeHeapSnapshot(NativeHeapSnapshot nativeHeapSnapshot) {
        this.mNativeHeapSnapshots.add(nativeHeapSnapshot);
        this.mDiffSnapshots.add(null);
    }

    private List<NativeAllocationInfo> shallowCloneList(List<NativeAllocationInfo> list) {
        ArrayList<NativeAllocationInfo> arrayList = new ArrayList<NativeAllocationInfo>(list.size());
        for (NativeAllocationInfo nativeAllocationInfo : list) {
            arrayList.add(nativeAllocationInfo);
        }
        return arrayList;
    }

    @Override
    public void deviceSelected() {
    }

    @Override
    public void clientSelected() {
        Client client = this.getCurrentClient();
        if (client == null) {
            this.mSnapshotHeapButton.setEnabled(false);
            this.mLoadHeapDataButton.setEnabled(false);
            return;
        }
        this.mNativeHeapSnapshots = new ArrayList<NativeHeapSnapshot>();
        this.mDiffSnapshots = new ArrayList<NativeHeapSnapshot>();
        this.mSnapshotHeapButton.setEnabled(true);
        this.mLoadHeapDataButton.setEnabled(true);
        List<NativeHeapSnapshot> list = this.mImportedSnapshotsPerPid.get(client.getClientData().getPid());
        if (list != null) {
            for (NativeHeapSnapshot nativeHeapSnapshot : list) {
                this.addNativeHeapSnapshot(nativeHeapSnapshot);
            }
        }
        List<NativeAllocationInfo> list2 = client.getClientData().getNativeAllocationList();
        if ((list2 = this.shallowCloneList(list2)).size() > 0) {
            this.addNativeHeapSnapshot(new NativeHeapSnapshot(list2));
        }
        this.updateDisplay();
    }

    private void updateDisplay() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                NativeHeapPanel.this.updateSnapshotIndexCombo();
                NativeHeapPanel.this.updateToolbars();
                int n = NativeHeapPanel.this.mNativeHeapSnapshots.size() - 1;
                NativeHeapPanel.this.displaySnapshot(n);
                NativeHeapPanel.this.displayStackTraceForSelection();
            }
        });
    }

    private void displaySelectedSnapshot() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                int n = NativeHeapPanel.this.mSnapshotIndexCombo.getSelectionIndex();
                NativeHeapPanel.this.displaySnapshot(n);
            }
        });
    }

    private void displaySnapshot(int n) {
        if (n < 0 || this.mNativeHeapSnapshots.size() == 0) {
            this.mDetailsTreeViewer.setInput(null);
            this.mMemoryAllocatedText.setText("");
            return;
        }
        assert (n < this.mNativeHeapSnapshots.size()) : "Invalid snapshot index";
        NativeHeapSnapshot nativeHeapSnapshot = this.mNativeHeapSnapshots.get(n);
        if (this.mDiffsOnlyButton.getSelection() && n > 0) {
            nativeHeapSnapshot = this.getDiffSnapshot(n);
        }
        this.mMemoryAllocatedText.setText(nativeHeapSnapshot.getFormattedMemorySize());
        this.mMemoryAllocatedText.pack();
        this.mDetailsTreeLabelProvider.setTotalSize(nativeHeapSnapshot.getTotalSize());
        this.mDetailsTreeViewer.setInput((Object)nativeHeapSnapshot);
        this.mDetailsTreeViewer.refresh();
    }

    private NativeHeapSnapshot getDiffSnapshot(int n) {
        NativeHeapSnapshot nativeHeapSnapshot = this.mDiffSnapshots.get(n);
        if (nativeHeapSnapshot != null) {
            return nativeHeapSnapshot;
        }
        NativeHeapSnapshot nativeHeapSnapshot2 = this.mNativeHeapSnapshots.get(n);
        NativeHeapSnapshot nativeHeapSnapshot3 = this.mNativeHeapSnapshots.get(n - 1);
        nativeHeapSnapshot = new NativeHeapDiffSnapshot(nativeHeapSnapshot2, nativeHeapSnapshot3);
        this.mDiffSnapshots.set(n, nativeHeapSnapshot);
        return nativeHeapSnapshot;
    }

    private void updateDisplayGrouping() {
        boolean bl = this.mGroupByButton.getSelection();
        this.mPrefStore.setValue(PREFS_GROUP_BY_LIBRARY, bl);
        if (bl) {
            this.mDetailsTreeViewer.setContentProvider((IContentProvider)this.mContentProviderByLibrary);
        } else {
            this.mDetailsTreeViewer.setContentProvider((IContentProvider)this.mContentProviderByAllocations);
        }
    }

    private void updateDisplayForZygotes() {
        boolean bl = this.mShowZygoteAllocationsButton.getSelection();
        this.mPrefStore.setValue(PREFS_SHOW_ZYGOTE_ALLOCATIONS, bl);
        this.mContentProviderByLibrary.displayZygoteMemory(bl);
        this.mContentProviderByAllocations.displayZygoteMemory(bl);
        this.mDetailsTreeViewer.refresh();
    }

    private void updateSnapshotIndexCombo() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = this.mNativeHeapSnapshots.size();
        for (int i = 0; i < n; ++i) {
            arrayList.add("Snapshot " + (i + 1));
        }
        this.mSnapshotIndexCombo.setItems(arrayList.toArray(new String[0]));
        if (n > 0) {
            this.mSnapshotIndexCombo.setEnabled(true);
            this.mSnapshotIndexCombo.select(n - 1);
        } else {
            this.mSnapshotIndexCombo.setEnabled(false);
        }
    }

    private void updateToolbars() {
        int n = this.mNativeHeapSnapshots.size();
        this.mExportHeapDataButton.setEnabled(n > 0);
    }

    @Override
    protected Control createControl(Composite composite) {
        composite.setLayout((Layout)new GridLayout(1, false));
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(1, false));
        composite2.setLayoutData((Object)new GridData(1808));
        this.createControlsSection(composite2);
        this.createDetailsSection(composite2);
        this.clientSelected();
        return composite2;
    }

    private void createControlsSection(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(3, false));
        composite2.setLayoutData((Object)new GridData(768));
        this.createGetHeapDataSection(composite2);
        Label label = new Label(composite2, 514);
        label.setLayoutData((Object)new GridData(1040));
        this.createDisplaySection(composite2);
    }

    private void createGetHeapDataSection(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(1, false));
        this.createTakeHeapSnapshotButton(composite2);
        Label label = new Label(composite2, 258);
        label.setLayoutData((Object)new GridData(768));
        this.createLoadHeapDataButton(composite2);
    }

    private void createTakeHeapSnapshotButton(Composite composite) {
        this.mSnapshotHeapButton = new Button(composite, 2056);
        this.mSnapshotHeapButton.setText(SNAPSHOT_HEAP_BUTTON_TEXT);
        this.mSnapshotHeapButton.setLayoutData((Object)new GridData());
        this.mSnapshotHeapButton.setEnabled(false);
        this.mSnapshotHeapButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                NativeHeapPanel.this.snapshotHeap();
            }
        });
    }

    private void snapshotHeap() {
        Client client = this.getCurrentClient();
        assert (client != null) : "Snapshot Heap could not have been enabled w/o a selected client.";
        client.requestNativeHeapInformation();
    }

    private void createLoadHeapDataButton(Composite composite) {
        this.mLoadHeapDataButton = new Button(composite, 2056);
        this.mLoadHeapDataButton.setText(LOAD_HEAP_DATA_BUTTON_TEXT);
        this.mLoadHeapDataButton.setLayoutData((Object)new GridData());
        this.mLoadHeapDataButton.setEnabled(false);
        this.mLoadHeapDataButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                NativeHeapPanel.this.loadHeapDataFromFile();
            }
        });
    }

    private void loadHeapDataFromFile() {
        String string = this.getHeapDumpToImport();
        if (string == null) {
            return;
        }
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        Shell shell = Display.getDefault().getActiveShell();
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(shell);
        NativeHeapDataImporter nativeHeapDataImporter = new NativeHeapDataImporter(fileReader);
        try {
            progressMonitorDialog.run(true, true, (IRunnableWithProgress)nativeHeapDataImporter);
        }
        catch (InvocationTargetException invocationTargetException) {
            MessageDialog.openError((Shell)shell, (String)"Error Importing Heap Data", (String)invocationTargetException.getCause().getMessage());
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        NativeHeapSnapshot nativeHeapSnapshot = nativeHeapDataImporter.getImportedSnapshot();
        this.addToImportedSnapshots(nativeHeapSnapshot);
        this.addNativeHeapSnapshot(nativeHeapSnapshot);
        this.updateDisplay();
    }

    private void addToImportedSnapshots(NativeHeapSnapshot nativeHeapSnapshot) {
        Client client = this.getCurrentClient();
        if (client == null) {
            return;
        }
        Integer n = client.getClientData().getPid();
        List<NativeHeapSnapshot> list = this.mImportedSnapshotsPerPid.get(n);
        if (list == null) {
            list = new ArrayList<NativeHeapSnapshot>();
        }
        list.add(nativeHeapSnapshot);
        this.mImportedSnapshotsPerPid.put(n, list);
    }

    private String getHeapDumpToImport() {
        FileDialog fileDialog = new FileDialog(Display.getDefault().getActiveShell(), 4096);
        fileDialog.setText("Import Heap Dump");
        fileDialog.setFilterExtensions(new String[]{"*.txt"});
        fileDialog.setFilterPath(this.mPrefStore.getString(PREFS_LAST_IMPORTED_HEAPPATH));
        String string = fileDialog.open();
        if (string != null) {
            this.mPrefStore.setValue(PREFS_LAST_IMPORTED_HEAPPATH, new File(string).getParent());
        }
        return string;
    }

    private void createDisplaySection(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        composite2.setLayoutData((Object)new GridData(768));
        this.createLabel(composite2, "Display:");
        this.mSnapshotIndexCombo = new Combo(composite2, 8);
        this.mSnapshotIndexCombo.setItems(new String[]{"No heap snapshots available."});
        this.mSnapshotIndexCombo.setEnabled(false);
        this.mSnapshotIndexCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                NativeHeapPanel.this.displaySelectedSnapshot();
            }
        });
        this.createLabel(composite2, "Memory Allocated:");
        this.mMemoryAllocatedText = new Label(composite2, 0);
        GridData gridData = new GridData();
        gridData.widthHint = 100;
        this.mMemoryAllocatedText.setLayoutData((Object)gridData);
        this.createLabel(composite2, SYMBOL_SEARCH_PATH_LABEL_TEXT);
        this.mSymbolSearchPathText = new Text(composite2, 2048);
        this.mSymbolSearchPathText.setMessage(SYMBOL_SEARCH_PATH_TEXT_MESSAGE);
        this.mSymbolSearchPathText.setToolTipText(SYMBOL_SEARCH_PATH_TOOLTIP_TEXT);
        this.mSymbolSearchPathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                String string = NativeHeapPanel.this.mSymbolSearchPathText.getText();
                NativeHeapPanel.this.updateSearchPath(string);
                NativeHeapPanel.this.mPrefStore.setValue(NativeHeapPanel.PREFS_SYMBOL_SEARCH_PATH, string);
            }
        });
        this.mSymbolSearchPathText.setText(this.mPrefStore.getString(PREFS_SYMBOL_SEARCH_PATH));
        this.mSymbolSearchPathText.setLayoutData((Object)new GridData(768));
    }

    private void updateSearchPath(String string) {
        Addr2Line.setSearchPath(string);
    }

    private void createLabel(Composite composite, String string) {
        Label label = new Label(composite, 0);
        label.setText(string);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 131072;
        label.setLayoutData((Object)gridData);
    }

    private void createDetailsSection(Composite composite) {
        final Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new FormLayout());
        composite2.setLayoutData((Object)new GridData(1808));
        this.mDetailsToolBar = new ToolBar(composite2, 0x800800);
        this.initializeDetailsToolBar(this.mDetailsToolBar);
        Tree tree = new Tree(composite2, 268437506);
        this.initializeDetailsTree(tree);
        final Sash sash = new Sash(composite2, 2304);
        Label label = new Label(composite2, 0);
        label.setText("Stack Trace:");
        Tree tree2 = new Tree(composite2, 2050);
        this.initializeStackTraceTree(tree2);
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        this.mDetailsToolBar.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.mDetailsToolBar, 0);
        formData.bottom = new FormAttachment((Control)sash, 0);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        tree.setLayoutData((Object)formData);
        final FormData formData2 = new FormData();
        formData2.top = new FormAttachment(this.mPrefStore.getInt(PREFS_SASH_HEIGHT_PERCENT), 0);
        formData2.left = new FormAttachment(0, 0);
        formData2.right = new FormAttachment(100, 0);
        sash.setLayoutData((Object)formData2);
        formData = new FormData();
        formData.top = new FormAttachment((Control)sash, 0);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        label.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)label, 0);
        formData.left = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(100, 0);
        formData.right = new FormAttachment(100, 0);
        tree2.setLayoutData((Object)formData);
        sash.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Rectangle rectangle = sash.getBounds();
                Rectangle rectangle2 = composite2.getClientArea();
                int n = rectangle.y * 100 / rectangle2.height;
                NativeHeapPanel.this.mPrefStore.setValue(NativeHeapPanel.PREFS_SASH_HEIGHT_PERCENT, n);
                formData2.top = new FormAttachment(0, event.y);
                composite2.layout();
            }
        });
    }

    private void initializeDetailsToolBar(ToolBar toolBar) {
        this.mGroupByButton = new ToolItem(toolBar, 32);
        this.mGroupByButton.setImage(ImageLoader.getDdmUiLibLoader().loadImage(GROUPBY_IMAGE, toolBar.getDisplay()));
        this.mGroupByButton.setToolTipText(TOOLTIP_GROUPBY);
        this.mGroupByButton.setSelection(this.mPrefStore.getBoolean(PREFS_GROUP_BY_LIBRARY));
        this.mGroupByButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                NativeHeapPanel.this.updateDisplayGrouping();
            }
        });
        this.mDiffsOnlyButton = new ToolItem(toolBar, 32);
        this.mDiffsOnlyButton.setImage(ImageLoader.getDdmUiLibLoader().loadImage(DIFFS_ONLY_IMAGE, toolBar.getDisplay()));
        this.mDiffsOnlyButton.setToolTipText(TOOLTIP_DIFFS_ONLY);
        this.mDiffsOnlyButton.setSelection(this.mPrefStore.getBoolean(PREFS_SHOW_DIFFS_ONLY));
        this.mDiffsOnlyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = NativeHeapPanel.this.mSnapshotIndexCombo.getSelectionIndex();
                NativeHeapPanel.this.displaySnapshot(n);
            }
        });
        this.mShowZygoteAllocationsButton = new ToolItem(toolBar, 32);
        this.mShowZygoteAllocationsButton.setImage(ImageLoader.getDdmUiLibLoader().loadImage(ZYGOTE_IMAGE, toolBar.getDisplay()));
        this.mShowZygoteAllocationsButton.setToolTipText(TOOLTIP_ZYGOTE_ALLOCATIONS);
        this.mShowZygoteAllocationsButton.setSelection(this.mPrefStore.getBoolean(PREFS_SHOW_ZYGOTE_ALLOCATIONS));
        this.mShowZygoteAllocationsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                NativeHeapPanel.this.updateDisplayForZygotes();
            }
        });
        this.mExportHeapDataButton = new ToolItem(toolBar, 8);
        this.mExportHeapDataButton.setImage(ImageLoader.getDdmUiLibLoader().loadImage(EXPORT_DATA_IMAGE, toolBar.getDisplay()));
        this.mExportHeapDataButton.setToolTipText(TOOLTIP_EXPORT_DATA);
        this.mExportHeapDataButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                NativeHeapPanel.this.exportSnapshot();
            }
        });
    }

    private void exportSnapshot() {
        int n = this.mSnapshotIndexCombo.getSelectionIndex();
        String string = this.mSnapshotIndexCombo.getItem(n);
        FileDialog fileDialog = new FileDialog(Display.getDefault().getActiveShell(), 8192);
        fileDialog.setText("Save " + string);
        fileDialog.setFileName("allocations.txt");
        final String string2 = fileDialog.open();
        if (string2 == null) {
            return;
        }
        final NativeHeapSnapshot nativeHeapSnapshot = this.mNativeHeapSnapshots.get(n);
        Thread thread = new Thread(new Runnable(){

            public void run() {
                PrintWriter printWriter;
                try {
                    printWriter = new PrintWriter(new BufferedWriter(new FileWriter(string2)));
                }
                catch (IOException iOException) {
                    this.displayErrorMessage(iOException.getMessage());
                    return;
                }
                for (NativeAllocationInfo nativeAllocationInfo : nativeHeapSnapshot.getAllocations()) {
                    printWriter.println(nativeAllocationInfo.toString());
                }
                printWriter.close();
            }

            private void displayErrorMessage(final String string) {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Failed to export heap data", (String)string);
                    }
                });
            }
        });
        thread.setName("Saving Heap Data to File...");
        thread.start();
    }

    private void initializeDetailsTree(Tree tree) {
        int n;
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        List<String> list = Arrays.asList("Library", "Total", "Percentage", "Count", "Size", "Method");
        List<String> list2 = Arrays.asList("/path/in/device/to/system/library.so", "123456789", " 100%", "123456789", "123456789", "PossiblyLongDemangledMethodName");
        List<Integer> list3 = Arrays.asList(16384, 131072, 131072, 131072, 131072, 16384);
        for (n = 0; n < list.size(); n += 1) {
            String string = list.get(n);
            String string2 = list2.get(n);
            int n2 = list3.get(n);
            TableHelper.createTreeColumn(tree, string, n2, string2, this.getPref("details", string), this.mPrefStore);
        }
        this.mDetailsTreeViewer = new TreeViewer(tree);
        this.mDetailsTreeViewer.setUseHashlookup(true);
        n = this.mPrefStore.getBoolean(PREFS_SHOW_ZYGOTE_ALLOCATIONS) ? 1 : 0;
        this.mContentProviderByAllocations = new NativeHeapProviderByAllocations(this.mDetailsTreeViewer, n != 0);
        this.mContentProviderByLibrary = new NativeHeapProviderByLibrary(this.mDetailsTreeViewer, n != 0);
        if (this.mPrefStore.getBoolean(PREFS_GROUP_BY_LIBRARY)) {
            this.mDetailsTreeViewer.setContentProvider((IContentProvider)this.mContentProviderByLibrary);
        } else {
            this.mDetailsTreeViewer.setContentProvider((IContentProvider)this.mContentProviderByAllocations);
        }
        this.mDetailsTreeLabelProvider = new NativeHeapLabelProvider();
        this.mDetailsTreeViewer.setLabelProvider((IBaseLabelProvider)this.mDetailsTreeLabelProvider);
        this.mDetailsTreeViewer.setInput(null);
        tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                NativeHeapPanel.this.displayStackTraceForSelection();
            }
        });
    }

    private void initializeStackTraceTree(Tree tree) {
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        List<String> list = Arrays.asList("Address", "Library", "Method", "File", "Line");
        List<String> list2 = Arrays.asList("0x1234_5678", "/path/in/device/to/system/library.so", "PossiblyLongDemangledMethodName", "/android/out/prefix/in/home/directory/to/path/in/device/to/system/library.so", "2000");
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            String string2 = list2.get(i);
            TableHelper.createTreeColumn(tree, string, 16384, string2, this.getPref("stack", string), this.mPrefStore);
        }
        this.mStackTraceTreeViewer = new TreeViewer(tree);
        this.mStackTraceTreeViewer.setContentProvider((IContentProvider)new NativeStackContentProvider());
        this.mStackTraceTreeViewer.setLabelProvider((IBaseLabelProvider)new NativeStackLabelProvider());
        this.mStackTraceTreeViewer.setInput(null);
    }

    private void displayStackTraceForSelection() {
        TreeItem[] treeItemArray = this.mDetailsTreeViewer.getTree().getSelection();
        if (treeItemArray.length == 0) {
            this.mStackTraceTreeViewer.setInput(null);
            return;
        }
        Object object = treeItemArray[0].getData();
        if (!(object instanceof NativeAllocationInfo)) {
            this.mStackTraceTreeViewer.setInput(null);
            return;
        }
        NativeAllocationInfo nativeAllocationInfo = (NativeAllocationInfo)object;
        if (nativeAllocationInfo.isStackCallResolved()) {
            this.mStackTraceTreeViewer.setInput((Object)nativeAllocationInfo.getResolvedStackCall());
        } else {
            this.mStackTraceTreeViewer.setInput((Object)nativeAllocationInfo.getStackCallAddresses());
        }
    }

    private String getPref(String string, String string2) {
        return "nativeheap.tree." + string + "." + string2;
    }

    @Override
    public void setFocus() {
    }

    @Override
    public void setTableFocusListener(ITableFocusListener iTableFocusListener) {
        this.mTableFocusListener = iTableFocusListener;
        final Tree tree = this.mDetailsTreeViewer.getTree();
        final ITableFocusListener.IFocusedTableActivator iFocusedTableActivator = new ITableFocusListener.IFocusedTableActivator(){

            public void copy(Clipboard clipboard) {
                TreeItem[] treeItemArray = tree.getSelection();
                NativeHeapPanel.this.copyToClipboard(treeItemArray, clipboard);
            }

            public void selectAll() {
                tree.selectAll();
            }
        };
        tree.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent focusEvent) {
                NativeHeapPanel.this.mTableFocusListener.focusLost(iFocusedTableActivator);
            }

            public void focusGained(FocusEvent focusEvent) {
                NativeHeapPanel.this.mTableFocusListener.focusGained(iFocusedTableActivator);
            }
        });
        final Tree tree2 = this.mStackTraceTreeViewer.getTree();
        final ITableFocusListener.IFocusedTableActivator iFocusedTableActivator2 = new ITableFocusListener.IFocusedTableActivator(){

            public void copy(Clipboard clipboard) {
                TreeItem[] treeItemArray = tree2.getSelection();
                NativeHeapPanel.this.copyToClipboard(treeItemArray, clipboard);
            }

            public void selectAll() {
                tree2.selectAll();
            }
        };
        tree2.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent focusEvent) {
                NativeHeapPanel.this.mTableFocusListener.focusLost(iFocusedTableActivator2);
            }

            public void focusGained(FocusEvent focusEvent) {
                NativeHeapPanel.this.mTableFocusListener.focusGained(iFocusedTableActivator2);
            }
        });
    }

    private void copyToClipboard(TreeItem[] treeItemArray, Clipboard clipboard) {
        StringBuilder stringBuilder = new StringBuilder();
        for (TreeItem treeItem : treeItemArray) {
            Object object = treeItem.getData();
            if (object == null) continue;
            stringBuilder.append(object.toString());
            stringBuilder.append('\n');
        }
        String string = stringBuilder.toString();
        if (string.length() > 0) {
            clipboard.setContents(new Object[]{stringBuilder.toString()}, new Transfer[]{TextTransfer.getInstance()});
        }
    }

    static {
        String string = System.getenv("ANDROID_DDMS_OLD_SYMRESOLVER");
        USE_OLD_RESOLVER = string != null && string.equalsIgnoreCase("true");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SymbolResolverTask
    implements Runnable {
        private List<NativeAllocationInfo> mCallSites;
        private List<NativeLibraryMapInfo> mMappedLibraries;
        private Map<Long, NativeStackCallInfo> mResolvedSymbolCache;

        public SymbolResolverTask(List<NativeAllocationInfo> list, List<NativeLibraryMapInfo> list2) {
            this.mCallSites = list;
            this.mMappedLibraries = list2;
            this.mResolvedSymbolCache = new HashMap<Long, NativeStackCallInfo>();
        }

        @Override
        public void run() {
            for (NativeAllocationInfo nativeAllocationInfo : this.mCallSites) {
                if (nativeAllocationInfo.isStackCallResolved()) continue;
                List list = nativeAllocationInfo.getStackCallAddresses();
                ArrayList<NativeStackCallInfo> arrayList = new ArrayList<NativeStackCallInfo>(list.size());
                for (Long l : list) {
                    NativeStackCallInfo nativeStackCallInfo = this.mResolvedSymbolCache.get(l);
                    if (nativeStackCallInfo != null) {
                        arrayList.add(nativeStackCallInfo);
                        continue;
                    }
                    nativeStackCallInfo = this.resolveAddress(l);
                    arrayList.add(nativeStackCallInfo);
                    this.mResolvedSymbolCache.put(l, nativeStackCallInfo);
                }
                nativeAllocationInfo.setResolvedStackCall(arrayList);
            }
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    NativeHeapPanel.this.mDetailsTreeViewer.refresh();
                    NativeHeapPanel.this.mStackTraceTreeViewer.refresh();
                }
            });
        }

        private NativeStackCallInfo resolveAddress(long l) {
            NativeStackCallInfo nativeStackCallInfo;
            Addr2Line addr2Line;
            NativeLibraryMapInfo nativeLibraryMapInfo = this.getLibraryFor(l);
            if (nativeLibraryMapInfo != null && (addr2Line = Addr2Line.getProcess(nativeLibraryMapInfo)) != null && (nativeStackCallInfo = addr2Line.getAddress(l)) != null) {
                return nativeStackCallInfo;
            }
            return new NativeStackCallInfo(l, nativeLibraryMapInfo != null ? nativeLibraryMapInfo.getLibraryName() : null, Long.toHexString(l), "");
        }

        private NativeLibraryMapInfo getLibraryFor(long l) {
            for (NativeLibraryMapInfo nativeLibraryMapInfo : this.mMappedLibraries) {
                if (!nativeLibraryMapInfo.isWithinLibrary(l)) continue;
                return nativeLibraryMapInfo;
            }
            Log.d((String)"ddm-nativeheap", (String)("Failed finding Library for " + Long.toHexString(l)));
            return null;
        }
    }
}

