/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib.location;

import com.android.ddmuilib.location.LocationPoint;
import com.android.ddmuilib.location.WayPoint;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class KmlParser {
    private static final String NS_KML_2 = "http://earth.google.com/kml/2.";
    private static final String NODE_PLACEMARK = "Placemark";
    private static final String NODE_NAME = "name";
    private static final String NODE_COORDINATES = "coordinates";
    private static final Pattern sLocationPattern = Pattern.compile("([^,]+),([^,]+)(?:,([^,]+))?");
    private static SAXParserFactory sParserFactory = SAXParserFactory.newInstance();
    private String mFileName;
    private KmlHandler mHandler;

    public KmlParser(String string) {
        this.mFileName = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean parse() {
        try {
            SAXParser sAXParser = sParserFactory.newSAXParser();
            this.mHandler = new KmlHandler();
            sAXParser.parse(new InputSource(new FileReader(this.mFileName)), (DefaultHandler)this.mHandler);
            return this.mHandler.getSuccess();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            return false;
        }
        catch (SAXException sAXException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public WayPoint[] getWayPoints() {
        if (this.mHandler != null) {
            return this.mHandler.getWayPoints();
        }
        return null;
    }

    static {
        sParserFactory.setNamespaceAware(true);
    }

    private static class KmlHandler
    extends DefaultHandler {
        List<WayPoint> mWayPoints;
        WayPoint mCurrentWayPoint;
        final StringBuilder mStringAccumulator = new StringBuilder();
        boolean mSuccess = true;

        private KmlHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            try {
                if (string.startsWith(KmlParser.NS_KML_2) && KmlParser.NODE_PLACEMARK.equals(string2)) {
                    if (this.mWayPoints == null) {
                        this.mWayPoints = new ArrayList<WayPoint>();
                    }
                    this.mCurrentWayPoint = new WayPoint();
                    this.mWayPoints.add(this.mCurrentWayPoint);
                }
            }
            finally {
                this.mStringAccumulator.setLength(0);
            }
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            this.mStringAccumulator.append(cArray, n, n2);
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (string.startsWith(KmlParser.NS_KML_2)) {
                if (KmlParser.NODE_PLACEMARK.equals(string2)) {
                    this.mCurrentWayPoint = null;
                } else if (KmlParser.NODE_NAME.equals(string2)) {
                    if (this.mCurrentWayPoint != null) {
                        this.mCurrentWayPoint.setName(this.mStringAccumulator.toString());
                    }
                } else if (KmlParser.NODE_COORDINATES.equals(string2) && this.mCurrentWayPoint != null) {
                    this.parseLocation(this.mCurrentWayPoint, this.mStringAccumulator.toString());
                }
            }
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            this.mSuccess = false;
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.mSuccess = false;
        }

        private void parseLocation(LocationPoint locationPoint, String string) {
            Matcher matcher = sLocationPattern.matcher(string);
            if (matcher.matches()) {
                try {
                    double d = Double.parseDouble(matcher.group(1));
                    double d2 = Double.parseDouble(matcher.group(2));
                    locationPoint.setLocation(d, d2);
                    if (matcher.groupCount() == 3) {
                        locationPoint.setElevation(Double.parseDouble(matcher.group(3)));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        WayPoint[] getWayPoints() {
            if (this.mWayPoints != null) {
                return this.mWayPoints.toArray(new WayPoint[this.mWayPoints.size()]);
            }
            return null;
        }

        boolean getSuccess() {
            return this.mSuccess;
        }
    }
}

