/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib.log.event;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class BugReportImporter {
    private static final String TAG_HEADER = "------ EVENT LOG TAGS ------";
    private static final String LOG_HEADER = "------ EVENT LOG ------";
    private static final String HEADER_TAG = "------";
    private String[] mTags;
    private String[] mLog;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BugReportImporter(String string) throws FileNotFoundException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(string)));
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (!TAG_HEADER.equals(string2)) continue;
                this.readTags(bufferedReader);
                return;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String[] getTags() {
        return this.mTags;
    }

    public String[] getLog() {
        return this.mLog;
    }

    private void readTags(BufferedReader bufferedReader) throws IOException {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((string = bufferedReader.readLine()) != null) {
            if (LOG_HEADER.equals(string)) {
                this.mTags = arrayList.toArray(new String[arrayList.size()]);
                this.readLog(bufferedReader);
                return;
            }
            arrayList.add(string);
        }
    }

    private void readLog(BufferedReader bufferedReader) throws IOException {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((string = bufferedReader.readLine()) != null && !string.startsWith(HEADER_TAG)) {
            arrayList.add(string);
        }
        this.mLog = arrayList.toArray(new String[arrayList.size()]);
    }
}

