/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib.log.event;

import com.android.ddmlib.log.EventContainer;
import com.android.ddmlib.log.EventLogParser;
import com.android.ddmlib.log.EventValueDescription;
import com.android.ddmlib.log.InvalidTypeException;
import com.android.ddmuilib.log.event.EventDisplay;
import com.android.ddmuilib.log.event.OccurrenceRenderer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYAreaRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisplayGraph
extends EventDisplay {
    public DisplayGraph(String string) {
        super(string);
    }

    @Override
    void resetUI() {
        Collection collection = this.mValueTypeDataSetMap.values();
        for (TimeSeriesCollection timeSeriesCollection : collection) {
            timeSeriesCollection.removeAllSeries();
        }
        if (this.mOccurrenceDataSet != null) {
            this.mOccurrenceDataSet.removeAllSeries();
        }
        this.mValueDescriptorSeriesMap.clear();
        this.mOcurrenceDescriptorSeriesMap.clear();
    }

    @Override
    public Control createComposite(Composite composite, EventLogParser eventLogParser, EventDisplay.ILogColumnListener iLogColumnListener) {
        String string = this.getChartTitle(eventLogParser);
        return this.createCompositeChart(composite, eventLogParser, string);
    }

    @Override
    void newEvent(EventContainer eventContainer, EventLogParser eventLogParser) {
        ArrayList<EventDisplay.ValueDisplayDescriptor> arrayList = new ArrayList<EventDisplay.ValueDisplayDescriptor>();
        ArrayList<EventDisplay.OccurrenceDisplayDescriptor> arrayList2 = new ArrayList<EventDisplay.OccurrenceDisplayDescriptor>();
        if (this.filterEvent(eventContainer, arrayList, arrayList2)) {
            this.updateChart(eventContainer, eventLogParser, arrayList, arrayList2);
        }
    }

    private void updateChart(EventContainer eventContainer, EventLogParser eventLogParser, ArrayList<EventDisplay.ValueDisplayDescriptor> arrayList, ArrayList<EventDisplay.OccurrenceDisplayDescriptor> arrayList2) {
        String string;
        Object object;
        HashMap hashMap2;
        Map map = eventLogParser.getTagMap();
        Millisecond millisecond = null;
        long l = -1L;
        boolean bl = false;
        double d = 0.0;
        if (eventContainer.mTag == 2721) {
            bl = true;
            for (EventDisplay.ValueDisplayDescriptor iterator : arrayList) {
                bl &= iterator.valueIndex != 0;
            }
        }
        for (EventDisplay.ValueDisplayDescriptor valueDisplayDescriptor : arrayList) {
            try {
                hashMap2 = (HashMap)this.mValueDescriptorSeriesMap.get(valueDisplayDescriptor);
                if (hashMap2 == null) {
                    hashMap2 = new HashMap();
                    this.mValueDescriptorSeriesMap.put(valueDisplayDescriptor, hashMap2);
                }
                if ((object = (TimeSeries)hashMap2.get(eventContainer.pid)) == null) {
                    String string2 = null;
                    string = this.getSeriesLabel(eventContainer, valueDisplayDescriptor);
                    switch (this.mValueDescriptorCheck) {
                        case 1: {
                            string2 = String.format("%1$s / %2$s", string, valueDisplayDescriptor.valueName);
                            break;
                        }
                        case 2: {
                            string2 = String.format("%1$s", string);
                            break;
                        }
                        default: {
                            string2 = String.format("%1$s / %2$s: %3$s", string, map.get(valueDisplayDescriptor.eventTag), valueDisplayDescriptor.valueName);
                        }
                    }
                    TimeSeriesCollection timeSeriesCollection = this.getValueDataset(((EventValueDescription[])eventLogParser.getEventInfoMap().get(eventContainer.mTag))[valueDisplayDescriptor.valueIndex].getValueType(), bl);
                    object = new TimeSeries((Comparable)((Object)string2), Millisecond.class);
                    if (this.mMaximumChartItemAge != -1L) {
                        object.setMaximumItemAge(this.mMaximumChartItemAge * 1000L);
                    }
                    timeSeriesCollection.addSeries((TimeSeries)object);
                    hashMap2.put(eventContainer.pid, object);
                }
                double d2 = eventContainer.getValueAsDouble(valueDisplayDescriptor.valueIndex);
                if (bl) {
                    d += d2;
                    d2 = d;
                }
                if (millisecond == null) {
                    l = (long)eventContainer.sec * 1000L + (long)eventContainer.nsec / 1000000L;
                    millisecond = new Millisecond(new Date(l));
                }
                object.addOrUpdate(millisecond, d2);
            }
            catch (InvalidTypeException invalidTypeException) {}
        }
        for (EventDisplay.OccurrenceDisplayDescriptor occurrenceDisplayDescriptor : arrayList2) {
            try {
                hashMap2 = (HashMap)this.mOcurrenceDescriptorSeriesMap.get(occurrenceDisplayDescriptor);
                if (hashMap2 == null) {
                    hashMap2 = new HashMap();
                    this.mOcurrenceDescriptorSeriesMap.put(occurrenceDisplayDescriptor, hashMap2);
                }
                if ((object = (TimeSeries)hashMap2.get(eventContainer.pid)) == null) {
                    String string3 = this.getSeriesLabel(eventContainer, occurrenceDisplayDescriptor);
                    string = String.format("[%1$s:%2$s]", map.get(occurrenceDisplayDescriptor.eventTag), string3);
                    object = new TimeSeries((Comparable)((Object)string), Millisecond.class);
                    if (this.mMaximumChartItemAge != -1L) {
                        object.setMaximumItemAge(this.mMaximumChartItemAge);
                    }
                    this.getOccurrenceDataSet().addSeries((TimeSeries)object);
                    hashMap2.put(eventContainer.pid, object);
                }
                if (millisecond == null) {
                    l = (long)eventContainer.sec * 1000L + (long)eventContainer.nsec / 1000000L;
                    millisecond = new Millisecond(new Date(l));
                }
                object.addOrUpdate(millisecond, 0.0);
            }
            catch (InvalidTypeException invalidTypeException) {}
        }
        if (l != -1L && this.mMaximumChartItemAge != -1L) {
            Collection collection = this.mValueDescriptorSeriesMap.values();
            for (HashMap hashMap2 : collection) {
                object = hashMap2.values();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    string = (TimeSeries)iterator.next();
                    string.removeAgedItems(l, true);
                }
            }
            collection = this.mOcurrenceDescriptorSeriesMap.values();
            for (HashMap hashMap2 : collection) {
                object = hashMap2.values();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    string = (TimeSeries)iterator.next();
                    string.removeAgedItems(l, true);
                }
            }
        }
    }

    private TimeSeriesCollection getValueDataset(EventValueDescription.ValueType valueType, boolean bl) {
        TimeSeriesCollection timeSeriesCollection = (TimeSeriesCollection)this.mValueTypeDataSetMap.get(valueType);
        if (timeSeriesCollection == null) {
            XYLineAndShapeRenderer xYLineAndShapeRenderer;
            XYAreaRenderer xYAreaRenderer;
            timeSeriesCollection = new TimeSeriesCollection();
            this.mValueTypeDataSetMap.put(valueType, timeSeriesCollection);
            if (valueType == EventValueDescription.ValueType.PERCENT && bl) {
                xYAreaRenderer = new XYAreaRenderer();
            } else {
                xYLineAndShapeRenderer = new XYLineAndShapeRenderer();
                xYLineAndShapeRenderer.setBaseShapesVisible(valueType != EventValueDescription.ValueType.PERCENT);
                xYAreaRenderer = xYLineAndShapeRenderer;
            }
            xYLineAndShapeRenderer = this.mChart.getXYPlot();
            xYLineAndShapeRenderer.setDataset(this.mDataSetCount, (XYDataset)timeSeriesCollection);
            xYLineAndShapeRenderer.setRenderer(this.mDataSetCount, (XYItemRenderer)xYAreaRenderer);
            NumberAxis numberAxis = new NumberAxis(valueType.toString());
            if (valueType == EventValueDescription.ValueType.PERCENT) {
                numberAxis.setAutoRange(false);
                numberAxis.setRange(0.0, 100.0);
            }
            int n = this.mDataSetCount;
            if (this.mOccurrenceDataSet != null) {
                --n;
            }
            xYLineAndShapeRenderer.setRangeAxis(n, (ValueAxis)numberAxis);
            if (n % 2 == 0) {
                xYLineAndShapeRenderer.setRangeAxisLocation(n, AxisLocation.BOTTOM_OR_LEFT);
            } else {
                xYLineAndShapeRenderer.setRangeAxisLocation(n, AxisLocation.TOP_OR_RIGHT);
            }
            xYLineAndShapeRenderer.mapDatasetToRangeAxis(this.mDataSetCount, n);
            ++this.mDataSetCount;
        }
        return timeSeriesCollection;
    }

    private String getSeriesLabel(EventContainer eventContainer, EventDisplay.OccurrenceDisplayDescriptor occurrenceDisplayDescriptor) throws InvalidTypeException {
        if (occurrenceDisplayDescriptor.seriesValueIndex != -1) {
            if (!occurrenceDisplayDescriptor.includePid) {
                return eventContainer.getValueAsString(occurrenceDisplayDescriptor.seriesValueIndex);
            }
            return String.format("%1$s (%2$d)", eventContainer.getValueAsString(occurrenceDisplayDescriptor.seriesValueIndex), eventContainer.pid);
        }
        return Integer.toString(eventContainer.pid);
    }

    private TimeSeriesCollection getOccurrenceDataSet() {
        if (this.mOccurrenceDataSet == null) {
            this.mOccurrenceDataSet = new TimeSeriesCollection();
            XYPlot xYPlot = this.mChart.getXYPlot();
            xYPlot.setDataset(this.mDataSetCount, (XYDataset)this.mOccurrenceDataSet);
            OccurrenceRenderer occurrenceRenderer = new OccurrenceRenderer();
            occurrenceRenderer.setBaseShapesVisible(false);
            xYPlot.setRenderer(this.mDataSetCount, (XYItemRenderer)occurrenceRenderer);
            ++this.mDataSetCount;
        }
        return this.mOccurrenceDataSet;
    }

    @Override
    int getDisplayType() {
        return 2;
    }

    @Override
    protected void setNewLogParser(EventLogParser eventLogParser) {
        if (this.mChart != null) {
            this.mChart.setTitle(this.getChartTitle(eventLogParser));
        }
    }

    private String getChartTitle(EventLogParser eventLogParser) {
        if (this.mValueDescriptors.size() > 0) {
            String string = null;
            switch (this.mValueDescriptorCheck) {
                case 1: {
                    if (eventLogParser == null) break;
                    string = (String)eventLogParser.getTagMap().get(((EventDisplay.ValueDisplayDescriptor)this.mValueDescriptors.get((int)0)).eventTag);
                    break;
                }
                case 2: {
                    if (eventLogParser == null) break;
                    string = String.format("%1$s / %2$s", eventLogParser.getTagMap().get(((EventDisplay.ValueDisplayDescriptor)this.mValueDescriptors.get((int)0)).eventTag), ((EventDisplay.ValueDisplayDescriptor)this.mValueDescriptors.get((int)0)).valueName);
                }
            }
            if (string != null) {
                return String.format("%1$s - %2$s", this.mName, string);
            }
        }
        return this.mName;
    }
}

