/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib.log.event;

import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.ddmlib.log.EventContainer;
import com.android.ddmlib.log.EventLogParser;
import com.android.ddmlib.log.LogReceiver;
import com.android.ddmuilib.DdmUiPreferences;
import com.android.ddmuilib.TablePanel;
import com.android.ddmuilib.actions.ICommonAction;
import com.android.ddmuilib.log.event.BugReportImporter;
import com.android.ddmuilib.log.event.EventDisplay;
import com.android.ddmuilib.log.event.EventDisplayOptions;
import com.android.ddmuilib.log.event.EventLogImporter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class EventLogPanel
extends TablePanel
implements LogReceiver.ILogListener,
EventDisplay.ILogColumnListener {
    private static final String TAG_FILE_EXT = ".tag";
    private static final String PREFS_EVENT_DISPLAY = "EventLogPanel.eventDisplay";
    private static final String EVENT_DISPLAY_STORAGE_SEPARATOR = "|";
    static final String PREFS_DISPLAY_WIDTH = "EventLogPanel.width";
    static final String PREFS_DISPLAY_HEIGHT = "EventLogPanel.height";
    private static final int DEFAULT_DISPLAY_WIDTH = 500;
    private static final int DEFAULT_DISPLAY_HEIGHT = 400;
    private IDevice mCurrentLoggedDevice;
    private String mCurrentLogFile;
    private LogReceiver mCurrentLogReceiver;
    private EventLogParser mCurrentEventLogParser;
    private Object mLock = new Object();
    private final ArrayList<EventContainer> mEvents = new ArrayList();
    private final ArrayList<EventContainer> mNewEvents = new ArrayList();
    private boolean mPendingDisplay = false;
    private final ArrayList<EventDisplay> mEventDisplays = new ArrayList();
    private final NumberFormat mFormatter = NumberFormat.getInstance();
    private Composite mParent;
    private ScrolledComposite mBottomParentPanel;
    private Composite mBottomPanel;
    private ICommonAction mOptionsAction;
    private ICommonAction mClearAction;
    private ICommonAction mSaveAction;
    private ICommonAction mLoadAction;
    private ICommonAction mImportAction;
    private File mTempFile = null;

    public EventLogPanel() {
        this.mFormatter.setGroupingUsed(true);
    }

    public void setActions(ICommonAction iCommonAction, ICommonAction iCommonAction2, ICommonAction iCommonAction3, ICommonAction iCommonAction4, ICommonAction iCommonAction5) {
        this.mOptionsAction = iCommonAction;
        this.mOptionsAction.setRunnable(new Runnable(){

            public void run() {
                EventLogPanel.this.openOptionPanel();
            }
        });
        this.mClearAction = iCommonAction2;
        this.mClearAction.setRunnable(new Runnable(){

            public void run() {
                EventLogPanel.this.clearLog();
            }
        });
        this.mSaveAction = iCommonAction3;
        this.mSaveAction.setRunnable(new Runnable(){

            public void run() {
                try {
                    FileDialog fileDialog = new FileDialog(EventLogPanel.this.mParent.getShell(), 8192);
                    fileDialog.setText("Save Event Log");
                    fileDialog.setFileName("event.log");
                    String string = fileDialog.open();
                    if (string != null) {
                        EventLogPanel.this.saveLog(string);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        this.mLoadAction = iCommonAction4;
        this.mLoadAction.setRunnable(new Runnable(){

            public void run() {
                FileDialog fileDialog = new FileDialog(EventLogPanel.this.mParent.getShell(), 4096);
                fileDialog.setText("Load Event Log");
                String string = fileDialog.open();
                if (string != null) {
                    EventLogPanel.this.loadLog(string);
                }
            }
        });
        this.mImportAction = iCommonAction5;
        this.mImportAction.setRunnable(new Runnable(){

            public void run() {
                FileDialog fileDialog = new FileDialog(EventLogPanel.this.mParent.getShell(), 4096);
                fileDialog.setText("Import Bug Report");
                String string = fileDialog.open();
                if (string != null) {
                    EventLogPanel.this.importBugReport(string);
                }
            }
        });
        this.mOptionsAction.setEnabled(false);
        this.mClearAction.setEnabled(false);
        this.mSaveAction.setEnabled(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openOptionPanel() {
        block5: {
            try {
                EventDisplayOptions eventDisplayOptions = new EventDisplayOptions(this.mParent.getShell());
                if (!eventDisplayOptions.open(this.mCurrentEventLogParser, this.mEventDisplays, this.mEvents)) break block5;
                Object object = this.mLock;
                synchronized (object) {
                    this.mEventDisplays.clear();
                    this.mEventDisplays.addAll(eventDisplayOptions.getEventDisplays());
                    this.saveEventDisplays();
                    this.rebuildUi();
                }
            }
            catch (SWTException sWTException) {
                Log.e((String)"EventLog", (Throwable)sWTException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearLog() {
        try {
            Object object = this.mLock;
            synchronized (object) {
                this.mEvents.clear();
                this.mNewEvents.clear();
                this.mPendingDisplay = false;
                for (EventDisplay eventDisplay : this.mEventDisplays) {
                    eventDisplay.resetUI();
                }
            }
        }
        catch (SWTException sWTException) {
            Log.e((String)"EventLog", (Throwable)sWTException);
        }
    }

    public void saveLog(String string) throws IOException {
        if (this.mCurrentLoggedDevice != null && this.mCurrentEventLogParser != null) {
            int n;
            File file = new File(string);
            file.createNewFile();
            FileInputStream fileInputStream = new FileInputStream(this.mTempFile);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            byte[] byArray = new byte[1024];
            while ((n = fileInputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileOutputStream.close();
            fileInputStream.close();
            string = string + TAG_FILE_EXT;
            this.mCurrentEventLogParser.saveTags(string);
        }
    }

    public void loadLog(String string) {
        if (new File(string + TAG_FILE_EXT).exists()) {
            this.startEventLogFromFiles(string);
        } else {
            try {
                EventLogImporter eventLogImporter = new EventLogImporter(string);
                String[] stringArray = eventLogImporter.getTags();
                String[] stringArray2 = eventLogImporter.getLog();
                this.startEventLogFromContent(stringArray, stringArray2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                Log.logAndDisplay((Log.LogLevel)Log.LogLevel.ERROR, (String)"EventLog", (String)String.format("Failure to read %1$s", string + TAG_FILE_EXT));
            }
        }
    }

    public void importBugReport(String string) {
        try {
            BugReportImporter bugReportImporter = new BugReportImporter(string);
            String[] stringArray = bugReportImporter.getTags();
            String[] stringArray2 = bugReportImporter.getLog();
            this.startEventLogFromContent(stringArray, stringArray2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Log.logAndDisplay((Log.LogLevel)Log.LogLevel.ERROR, (String)"Import", (String)("Unable to import bug report: " + fileNotFoundException.getMessage()));
        }
    }

    public void clientSelected() {
    }

    public void deviceSelected() {
        this.startEventLog(this.getCurrentDevice());
    }

    public void clientChanged(Client client, int n) {
    }

    protected Control createControl(Composite composite) {
        this.mParent = composite;
        this.mParent.addDisposeListener(new DisposeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void widgetDisposed(DisposeEvent disposeEvent) {
                Object object = EventLogPanel.this.mLock;
                synchronized (object) {
                    if (EventLogPanel.this.mCurrentLogReceiver != null) {
                        EventLogPanel.this.mCurrentLogReceiver.cancel();
                        EventLogPanel.this.mCurrentLogReceiver = null;
                        EventLogPanel.this.mCurrentEventLogParser = null;
                        EventLogPanel.this.mCurrentLoggedDevice = null;
                        EventLogPanel.this.mEventDisplays.clear();
                        EventLogPanel.this.mEvents.clear();
                    }
                }
            }
        });
        IPreferenceStore iPreferenceStore = DdmUiPreferences.getStore();
        iPreferenceStore.setDefault(PREFS_DISPLAY_WIDTH, 500);
        iPreferenceStore.setDefault(PREFS_DISPLAY_HEIGHT, 400);
        this.mBottomParentPanel = new ScrolledComposite(composite, 512);
        this.mBottomParentPanel.setLayoutData((Object)new GridData(1808));
        this.mBottomParentPanel.setExpandHorizontal(true);
        this.mBottomParentPanel.setExpandVertical(true);
        this.mBottomParentPanel.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                if (EventLogPanel.this.mBottomPanel != null) {
                    Rectangle rectangle = EventLogPanel.this.mBottomParentPanel.getClientArea();
                    EventLogPanel.this.mBottomParentPanel.setMinSize(EventLogPanel.this.mBottomPanel.computeSize(rectangle.width, -1));
                }
            }
        });
        this.prepareDisplayUi();
        this.loadEventDisplays();
        this.createDisplayUi();
        return this.mBottomParentPanel;
    }

    protected void postCreation() {
    }

    public void setFocus() {
        this.mBottomParentPanel.setFocus();
    }

    private void startEventLog(final IDevice iDevice) {
        if (iDevice == this.mCurrentLoggedDevice) {
            return;
        }
        if (this.mCurrentLogReceiver != null) {
            this.stopEventLog(false);
        }
        this.mCurrentLoggedDevice = null;
        this.mCurrentLogFile = null;
        if (iDevice != null) {
            this.mCurrentLogReceiver = new LogReceiver((LogReceiver.ILogListener)this);
            new Thread("EventLog"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    while (!iDevice.isOnline() && EventLogPanel.this.mCurrentLogReceiver != null && !EventLogPanel.this.mCurrentLogReceiver.isCancelled()) {
                        try {
                            8.sleep(2000L);
                        }
                        catch (InterruptedException interruptedException) {
                            return;
                        }
                    }
                    if (EventLogPanel.this.mCurrentLogReceiver == null || EventLogPanel.this.mCurrentLogReceiver.isCancelled()) {
                        return;
                    }
                    try {
                        EventLogPanel.this.mCurrentLoggedDevice = iDevice;
                        Object object = EventLogPanel.this.mLock;
                        synchronized (object) {
                            EventLogPanel.this.mCurrentEventLogParser = new EventLogParser();
                            EventLogPanel.this.mCurrentEventLogParser.init(iDevice);
                        }
                        EventLogPanel.this.updateEventDisplays();
                        EventLogPanel.this.mTempFile = File.createTempFile("android-event-", ".log");
                        iDevice.runEventLogService(EventLogPanel.this.mCurrentLogReceiver);
                    }
                    catch (Exception exception) {
                        Log.e((String)"EventLog", (Throwable)exception);
                    }
                }
            }.start();
        }
    }

    private void startEventLogFromFiles(final String string) {
        if (this.mCurrentLogReceiver != null) {
            this.stopEventLog(false);
        }
        this.mCurrentLoggedDevice = null;
        this.mCurrentLogFile = null;
        this.mCurrentLogReceiver = new LogReceiver((LogReceiver.ILogListener)this);
        this.mSaveAction.setEnabled(false);
        new Thread("EventLog"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    EventLogPanel.this.mCurrentLogFile = string;
                    Object object = EventLogPanel.this.mLock;
                    synchronized (object) {
                        EventLogPanel.this.mCurrentEventLogParser = new EventLogParser();
                        if (!EventLogPanel.this.mCurrentEventLogParser.init(string + EventLogPanel.TAG_FILE_EXT)) {
                            EventLogPanel.this.mCurrentEventLogParser = null;
                            Log.logAndDisplay((Log.LogLevel)Log.LogLevel.ERROR, (String)"EventLog", (String)String.format("Failure to read %1$s", string + EventLogPanel.TAG_FILE_EXT));
                            return;
                        }
                    }
                    EventLogPanel.this.updateEventDisplays();
                    EventLogPanel.this.runLocalEventLogService(string, EventLogPanel.this.mCurrentLogReceiver);
                }
                catch (Exception exception) {
                    Log.e((String)"EventLog", (Throwable)exception);
                }
            }
        }.start();
    }

    private void startEventLogFromContent(final String[] stringArray, final String[] stringArray2) {
        if (this.mCurrentLogReceiver != null) {
            this.stopEventLog(false);
        }
        this.mCurrentLoggedDevice = null;
        this.mCurrentLogFile = null;
        this.mCurrentLogReceiver = new LogReceiver((LogReceiver.ILogListener)this);
        this.mSaveAction.setEnabled(false);
        new Thread("EventLog"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    Object object = EventLogPanel.this.mLock;
                    synchronized (object) {
                        EventLogPanel.this.mCurrentEventLogParser = new EventLogParser();
                        if (!EventLogPanel.this.mCurrentEventLogParser.init(stringArray)) {
                            EventLogPanel.this.mCurrentEventLogParser = null;
                            return;
                        }
                    }
                    EventLogPanel.this.updateEventDisplays();
                    EventLogPanel.this.runLocalEventLogService(stringArray2, EventLogPanel.this.mCurrentLogReceiver);
                }
                catch (Exception exception) {
                    Log.e((String)"EventLog", (Throwable)exception);
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopEventLog(boolean bl) {
        if (this.mCurrentLogReceiver != null) {
            this.mCurrentLogReceiver.cancel();
            Object object = this.mLock;
            synchronized (object) {
                this.mCurrentLogReceiver = null;
                this.mCurrentEventLogParser = null;
                this.mCurrentLoggedDevice = null;
                this.mEvents.clear();
                this.mNewEvents.clear();
                this.mPendingDisplay = false;
            }
            this.resetUI(bl);
        }
        if (this.mTempFile != null) {
            this.mTempFile.delete();
            this.mTempFile = null;
        }
    }

    private void resetUI(boolean bl) {
        this.mEvents.clear();
        if (bl) {
            this.resetUiFromUiThread();
        } else {
            try {
                Display display = this.mBottomParentPanel.getDisplay();
                display.syncExec(new Runnable(){

                    public void run() {
                        if (!EventLogPanel.this.mBottomParentPanel.isDisposed()) {
                            EventLogPanel.this.resetUiFromUiThread();
                        }
                    }
                });
            }
            catch (SWTException sWTException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetUiFromUiThread() {
        Object object = this.mLock;
        synchronized (object) {
            for (EventDisplay eventDisplay : this.mEventDisplays) {
                eventDisplay.resetUI();
            }
        }
        this.mOptionsAction.setEnabled(false);
        this.mClearAction.setEnabled(false);
        this.mSaveAction.setEnabled(false);
    }

    private void prepareDisplayUi() {
        this.mBottomPanel = new Composite((Composite)this.mBottomParentPanel, 0);
        this.mBottomParentPanel.setContent((Control)this.mBottomPanel);
    }

    private void createDisplayUi() {
        RowLayout rowLayout = new RowLayout();
        rowLayout.wrap = true;
        rowLayout.pack = false;
        rowLayout.justify = true;
        rowLayout.fill = true;
        rowLayout.type = 256;
        this.mBottomPanel.setLayout((Layout)rowLayout);
        IPreferenceStore iPreferenceStore = DdmUiPreferences.getStore();
        int n = iPreferenceStore.getInt(PREFS_DISPLAY_WIDTH);
        int n2 = iPreferenceStore.getInt(PREFS_DISPLAY_HEIGHT);
        for (EventDisplay eventDisplay : this.mEventDisplays) {
            Table table;
            Control control = eventDisplay.createComposite(this.mBottomPanel, this.mCurrentEventLogParser, this);
            if (control != null) {
                table = new RowData();
                table.height = n2;
                table.width = n;
                control.setLayoutData((Object)table);
            }
            if ((table = eventDisplay.getTable()) == null) continue;
            this.addTableToFocusListener(table);
        }
        this.mBottomPanel.layout();
        this.mBottomParentPanel.setMinSize(this.mBottomPanel.computeSize(-1, -1));
        this.mBottomParentPanel.layout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildUi() {
        Object object = this.mLock;
        synchronized (object) {
            this.mBottomPanel.dispose();
            this.mBottomPanel = null;
            this.prepareDisplayUi();
            this.createDisplayUi();
            boolean bl = false;
            Rectangle rectangle = this.mNewEvents;
            synchronized (rectangle) {
                this.mNewEvents.addAll(0, this.mEvents);
                if (!this.mPendingDisplay) {
                    this.mPendingDisplay = true;
                    bl = true;
                }
            }
            if (bl) {
                this.scheduleUIEventHandler();
            }
            rectangle = this.mBottomParentPanel.getClientArea();
            this.mBottomParentPanel.setMinSize(this.mBottomPanel.computeSize(rectangle.width, -1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newEntry(LogReceiver.LogEntry logEntry) {
        Object object = this.mLock;
        synchronized (object) {
            EventContainer eventContainer;
            if (this.mCurrentEventLogParser != null && (eventContainer = this.mCurrentEventLogParser.parse(logEntry)) != null) {
                this.handleNewEvent(eventContainer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleNewEvent(EventContainer eventContainer) {
        this.mEvents.add(eventContainer);
        boolean bl = false;
        ArrayList<EventContainer> arrayList = this.mNewEvents;
        synchronized (arrayList) {
            this.mNewEvents.add(eventContainer);
            if (!this.mPendingDisplay) {
                this.mPendingDisplay = true;
                bl = true;
            }
        }
        if (!bl) {
            return;
        }
        this.scheduleUIEventHandler();
    }

    private void scheduleUIEventHandler() {
        try {
            Display display = this.mBottomParentPanel.getDisplay();
            display.asyncExec(new Runnable(){

                public void run() {
                    if (!EventLogPanel.this.mBottomParentPanel.isDisposed() && EventLogPanel.this.mCurrentEventLogParser != null) {
                        EventLogPanel.this.displayNewEvents();
                    }
                }
            });
        }
        catch (SWTException sWTException) {
            // empty catch block
        }
    }

    public void newData(byte[] byArray, int n, int n2) {
        if (this.mTempFile != null) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(this.mTempFile, true);
                fileOutputStream.write(byArray, n, n2);
                fileOutputStream.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayNewEvents() {
        int n = 0;
        for (EventDisplay eventDisplay : this.mEventDisplays) {
            eventDisplay.startMultiEventDisplay();
        }
        EventContainer eventContainer = null;
        boolean bl = false;
        do {
            Iterator<EventDisplay> iterator = this.mNewEvents;
            synchronized (iterator) {
                if (this.mNewEvents.size() > 0) {
                    if (n > 200) {
                        bl = true;
                        eventContainer = null;
                    } else {
                        eventContainer = this.mNewEvents.remove(0);
                        ++n;
                    }
                } else {
                    eventContainer = null;
                    this.mPendingDisplay = false;
                }
            }
            if (eventContainer == null) continue;
            for (EventDisplay eventDisplay : this.mEventDisplays) {
                eventDisplay.newEvent(eventContainer, this.mCurrentEventLogParser);
            }
        } while (eventContainer != null);
        for (EventDisplay eventDisplay : this.mEventDisplays) {
            eventDisplay.endMultiEventDisplay();
        }
        if (bl) {
            this.scheduleUIEventHandler();
        }
    }

    private void loadEventDisplays() {
        IPreferenceStore iPreferenceStore = DdmUiPreferences.getStore();
        String string = iPreferenceStore.getString(PREFS_EVENT_DISPLAY);
        if (string.length() > 0) {
            String[] stringArray;
            for (String string2 : stringArray = string.split(Pattern.quote(EVENT_DISPLAY_STORAGE_SEPARATOR))) {
                EventDisplay eventDisplay = EventDisplay.load(string2);
                if (eventDisplay == null) continue;
                this.mEventDisplays.add(eventDisplay);
            }
        }
    }

    private void saveEventDisplays() {
        IPreferenceStore iPreferenceStore = DdmUiPreferences.getStore();
        boolean bl = true;
        StringBuilder stringBuilder = new StringBuilder();
        for (EventDisplay eventDisplay : this.mEventDisplays) {
            String string = eventDisplay.getStorageString();
            if (string == null) continue;
            if (!bl) {
                stringBuilder.append(EVENT_DISPLAY_STORAGE_SEPARATOR);
            } else {
                bl = false;
            }
            stringBuilder.append(string);
        }
        iPreferenceStore.setValue(PREFS_EVENT_DISPLAY, stringBuilder.toString());
    }

    private void updateEventDisplays() {
        try {
            Display display = this.mBottomParentPanel.getDisplay();
            display.asyncExec(new Runnable(){

                public void run() {
                    if (!EventLogPanel.this.mBottomParentPanel.isDisposed()) {
                        for (EventDisplay eventDisplay : EventLogPanel.this.mEventDisplays) {
                            eventDisplay.setNewLogParser(EventLogPanel.this.mCurrentEventLogParser);
                        }
                        EventLogPanel.this.mOptionsAction.setEnabled(true);
                        EventLogPanel.this.mClearAction.setEnabled(true);
                        if (EventLogPanel.this.mCurrentLogFile == null) {
                            EventLogPanel.this.mSaveAction.setEnabled(true);
                        } else {
                            EventLogPanel.this.mSaveAction.setEnabled(false);
                        }
                    }
                }
            });
        }
        catch (SWTException sWTException) {
            // empty catch block
        }
    }

    public void columnResized(int n, TableColumn tableColumn) {
        for (EventDisplay eventDisplay : this.mEventDisplays) {
            eventDisplay.resizeColumn(n, tableColumn);
        }
    }

    private void runLocalEventLogService(String string, LogReceiver logReceiver) throws IOException {
        int n;
        byte[] byArray = new byte[256];
        FileInputStream fileInputStream = new FileInputStream(string);
        while ((n = fileInputStream.read(byArray)) != -1) {
            logReceiver.parseNewData(byArray, 0, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runLocalEventLogService(String[] stringArray, LogReceiver logReceiver) {
        Object object = this.mLock;
        synchronized (object) {
            for (String string : stringArray) {
                EventContainer eventContainer = this.mCurrentEventLogParser.parse(string);
                if (eventContainer == null) continue;
                this.handleNewEvent(eventContainer);
            }
        }
    }
}

