/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib.logcat;

import com.android.ddmlib.Log;
import com.android.ddmuilib.logcat.LogCatMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LogCatFilter {
    private static final String PID_KEYWORD = "pid:";
    private static final String APP_KEYWORD = "app:";
    private static final String TAG_KEYWORD = "tag:";
    private static final String TEXT_KEYWORD = "text:";
    private final String mName;
    private final String mTag;
    private final String mText;
    private final String mPid;
    private final String mAppName;
    private final Log.LogLevel mLogLevel;
    private int mUnreadCount;
    private boolean mTransient;
    private boolean mCheckPid;
    private boolean mCheckAppName;
    private boolean mCheckTag;
    private boolean mCheckText;
    private Pattern mAppNamePattern;
    private Pattern mTagPattern;
    private Pattern mTextPattern;

    public LogCatFilter(String string, String string2, String string3, String string4, String string5, Log.LogLevel logLevel) {
        this.mName = string.trim();
        this.mTag = string2.trim();
        this.mText = string3.trim();
        this.mPid = string4.trim();
        this.mAppName = string5.trim();
        this.mLogLevel = logLevel;
        this.mUnreadCount = 0;
        this.mTransient = false;
        boolean bl = this.mCheckPid = this.mPid.length() != 0;
        if (this.mAppName.length() != 0) {
            try {
                this.mAppNamePattern = Pattern.compile(this.mAppName, this.getPatternCompileFlags(this.mAppName));
                this.mCheckAppName = true;
            }
            catch (PatternSyntaxException patternSyntaxException) {
                Log.e((String)"LogCatFilter", (String)"Ignoring invalid app name regex.");
                Log.e((String)"LogCatFilter", (String)patternSyntaxException.getMessage());
                this.mCheckAppName = false;
            }
        }
        if (this.mTag.length() != 0) {
            try {
                this.mTagPattern = Pattern.compile(this.mTag, this.getPatternCompileFlags(this.mTag));
                this.mCheckTag = true;
            }
            catch (PatternSyntaxException patternSyntaxException) {
                Log.e((String)"LogCatFilter", (String)"Ignoring invalid tag regex.");
                Log.e((String)"LogCatFilter", (String)patternSyntaxException.getMessage());
                this.mCheckTag = false;
            }
        }
        if (this.mText.length() != 0) {
            try {
                this.mTextPattern = Pattern.compile(this.mText, this.getPatternCompileFlags(this.mText));
                this.mCheckText = true;
            }
            catch (PatternSyntaxException patternSyntaxException) {
                Log.e((String)"LogCatFilter", (String)"Ignoring invalid text regex.");
                Log.e((String)"LogCatFilter", (String)patternSyntaxException.getMessage());
                this.mCheckText = false;
            }
        }
    }

    private int getPatternCompileFlags(String string) {
        for (char c : string.toCharArray()) {
            if (!Character.isUpperCase(c)) continue;
            return 0;
        }
        return 2;
    }

    public static List<LogCatFilter> fromString(String string, Log.LogLevel logLevel) {
        ArrayList<LogCatFilter> arrayList = new ArrayList<LogCatFilter>();
        for (String string2 : string.trim().split(" ")) {
            String string3 = "";
            String string4 = "";
            String string5 = "";
            String string6 = "";
            if (string2.startsWith(PID_KEYWORD)) {
                string5 = string2.substring(PID_KEYWORD.length());
            } else if (string2.startsWith(APP_KEYWORD)) {
                string6 = string2.substring(APP_KEYWORD.length());
            } else if (string2.startsWith(TAG_KEYWORD)) {
                string3 = string2.substring(TAG_KEYWORD.length());
            } else {
                string4 = string2.startsWith(TEXT_KEYWORD) ? string2.substring(TEXT_KEYWORD.length()) : string2;
            }
            arrayList.add(new LogCatFilter("livefilter-" + string2, string3, string4, string5, string6, logLevel));
        }
        return arrayList;
    }

    public String getName() {
        return this.mName;
    }

    public String getTag() {
        return this.mTag;
    }

    public String getText() {
        return this.mText;
    }

    public String getPid() {
        return this.mPid;
    }

    public String getAppName() {
        return this.mAppName;
    }

    public Log.LogLevel getLogLevel() {
        return this.mLogLevel;
    }

    public boolean matches(LogCatMessage logCatMessage) {
        Matcher matcher;
        if (logCatMessage.getLogLevel().getPriority() < this.mLogLevel.getPriority()) {
            return false;
        }
        if (this.mCheckPid && !logCatMessage.getPid().equals(this.mPid)) {
            return false;
        }
        if (this.mCheckAppName && !(matcher = this.mAppNamePattern.matcher(logCatMessage.getAppName())).find()) {
            return false;
        }
        if (this.mCheckTag && !(matcher = this.mTagPattern.matcher(logCatMessage.getTag())).find()) {
            return false;
        }
        return !this.mCheckText || (matcher = this.mTextPattern.matcher(logCatMessage.getMessage())).find();
    }

    public void updateUnreadCount(List<LogCatMessage> list) {
        for (LogCatMessage logCatMessage : list) {
            if (!this.matches(logCatMessage)) continue;
            ++this.mUnreadCount;
        }
    }

    public void resetUnreadCount() {
        this.mUnreadCount = 0;
    }

    public int getUnreadCount() {
        return this.mUnreadCount;
    }

    public void setTransient() {
        this.mTransient = true;
    }

    public boolean isTransient() {
        return this.mTransient;
    }
}

