/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib.logcat;

import com.android.ddmlib.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LogCatFilterSettingsDialog
extends TitleAreaDialog {
    private static final String TITLE = "Logcat Message Filter Settings";
    private static final String DEFAULT_MESSAGE = "Filter logcat messages by the source's tag, pid or minimum log level.\nEmpty fields will match all messages.";
    private String mFilterName;
    private String mTag;
    private String mText;
    private String mPid;
    private String mAppName;
    private String mLogLevel;
    private Text mFilterNameText;
    private Text mTagFilterText;
    private Text mTextFilterText;
    private Text mPidFilterText;
    private Text mAppNameFilterText;
    private Combo mLogLevelCombo;
    private Button mOkButton;

    public LogCatFilterSettingsDialog(Shell shell) {
        super(shell);
        this.setDefaults("", "", "", "", "", Log.LogLevel.VERBOSE);
    }

    public void setDefaults(String string, String string2, String string3, String string4, String string5, Log.LogLevel logLevel) {
        this.mFilterName = string;
        this.mTag = string2;
        this.mText = string3;
        this.mPid = string4;
        this.mAppName = string5;
        this.mLogLevel = logLevel.getStringValue();
    }

    protected Control createDialogArea(Composite composite) {
        this.setTitle(TITLE);
        this.setMessage(DEFAULT_MESSAGE);
        Composite composite2 = (Composite)super.createDialogArea(composite);
        Composite composite3 = new Composite(composite2, 2048);
        composite3.setLayout((Layout)new GridLayout(2, false));
        composite3.setLayoutData((Object)new GridData(1808));
        this.createLabel(composite3, "Filter Name:");
        this.mFilterNameText = new Text(composite3, 2048);
        this.mFilterNameText.setLayoutData((Object)new GridData(768));
        this.mFilterNameText.setText(this.mFilterName);
        this.createSeparator(composite3);
        this.createLabel(composite3, "by Log Tag:");
        this.mTagFilterText = new Text(composite3, 2048);
        this.mTagFilterText.setLayoutData((Object)new GridData(768));
        this.mTagFilterText.setText(this.mTag);
        this.createLabel(composite3, "by Log Message:");
        this.mTextFilterText = new Text(composite3, 2048);
        this.mTextFilterText.setLayoutData((Object)new GridData(768));
        this.mTextFilterText.setText(this.mText);
        this.createLabel(composite3, "by PID:");
        this.mPidFilterText = new Text(composite3, 2048);
        this.mPidFilterText.setLayoutData((Object)new GridData(768));
        this.mPidFilterText.setText(this.mPid);
        this.createLabel(composite3, "by Application Name:");
        this.mAppNameFilterText = new Text(composite3, 2048);
        this.mAppNameFilterText.setLayoutData((Object)new GridData(768));
        this.mAppNameFilterText.setText(this.mAppName);
        this.createLabel(composite3, "by Log Level:");
        this.mLogLevelCombo = new Combo(composite3, 12);
        this.mLogLevelCombo.setItems(LogCatFilterSettingsDialog.getLogLevels().toArray(new String[0]));
        this.mLogLevelCombo.select(LogCatFilterSettingsDialog.getLogLevels().indexOf(this.mLogLevel));
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                DialogStatus dialogStatus = LogCatFilterSettingsDialog.this.validateDialog();
                LogCatFilterSettingsDialog.this.mOkButton.setEnabled(dialogStatus.valid);
                LogCatFilterSettingsDialog.this.setErrorMessage(dialogStatus.message);
            }
        };
        this.mFilterNameText.addModifyListener(modifyListener);
        this.mTagFilterText.addModifyListener(modifyListener);
        this.mTextFilterText.addModifyListener(modifyListener);
        this.mPidFilterText.addModifyListener(modifyListener);
        this.mAppNameFilterText.addModifyListener(modifyListener);
        return composite3;
    }

    protected void createButtonsForButtonBar(Composite composite) {
        super.createButtonsForButtonBar(composite);
        this.mOkButton = this.getButton(0);
        DialogStatus dialogStatus = this.validateDialog();
        this.mOkButton.setEnabled(dialogStatus.valid);
    }

    private DialogStatus validateDialog() {
        String string;
        String string2;
        String string3;
        if (this.mFilterNameText.getText().trim().equals("")) {
            return new DialogStatus(false, "Please provide a name for this filter.");
        }
        String string4 = this.mPidFilterText.getText().trim();
        if (string4.trim().length() > 0) {
            int n = 0;
            try {
                n = Integer.parseInt(string4);
            }
            catch (NumberFormatException numberFormatException) {
                return new DialogStatus(false, "PID should be a positive integer.");
            }
            if (n < 0) {
                return new DialogStatus(false, "PID should be a positive integer.");
            }
        }
        if ((string3 = this.mTagFilterText.getText().trim()).trim().length() > 0) {
            try {
                Pattern.compile(string3);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                return new DialogStatus(false, "Invalid regex used in tag field: " + patternSyntaxException.getMessage());
            }
        }
        if ((string2 = this.mTextFilterText.getText().trim()).trim().length() > 0) {
            try {
                Pattern.compile(string2);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                return new DialogStatus(false, "Invalid regex used in text field: " + patternSyntaxException.getMessage());
            }
        }
        if ((string = this.mAppNameFilterText.getText().trim()).trim().length() > 0) {
            try {
                Pattern.compile(string);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                return new DialogStatus(false, "Invalid regex used in application name field: " + patternSyntaxException.getMessage());
            }
        }
        return new DialogStatus(true, null);
    }

    private void createSeparator(Composite composite) {
        Label label = new Label(composite, 258);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
    }

    private void createLabel(Composite composite, String string) {
        Label label = new Label(composite, 0);
        label.setText(string);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 131072;
        label.setLayoutData((Object)gridData);
    }

    protected void okPressed() {
        this.mFilterName = this.mFilterNameText.getText();
        this.mTag = this.mTagFilterText.getText();
        this.mText = this.mTextFilterText.getText();
        this.mLogLevel = this.mLogLevelCombo.getText();
        this.mPid = this.mPidFilterText.getText();
        this.mAppName = this.mAppNameFilterText.getText();
        super.okPressed();
    }

    public String getFilterName() {
        return this.mFilterName;
    }

    public String getTag() {
        return this.mTag;
    }

    public String getText() {
        return this.mText;
    }

    public String getPid() {
        return this.mPid;
    }

    public String getAppName() {
        return this.mAppName;
    }

    public String getLogLevel() {
        return this.mLogLevel;
    }

    public static List<String> getLogLevels() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Log.LogLevel logLevel : Log.LogLevel.values()) {
            arrayList.add(logLevel.getStringValue());
        }
        return arrayList;
    }

    private final class DialogStatus {
        final boolean valid;
        final String message;

        private DialogStatus(boolean bl, String string) {
            this.valid = bl;
            this.message = string;
        }
    }
}

