/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib.logcat;

import com.android.ddmlib.Log;
import com.android.ddmuilib.logcat.LogCatMessage;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;

public final class LogCatMessageLabelProvider
extends ColumnLabelProvider {
    private static final int INDEX_LOGLEVEL = 0;
    private static final int INDEX_LOGTIME = 1;
    private static final int INDEX_PID = 2;
    private static final int INDEX_APPNAME = 3;
    private static final int INDEX_TAG = 4;
    private static final int INDEX_TEXT = 5;
    private static final Color INFO_MSG_COLOR = new Color(null, 0, 127, 0);
    private static final Color DEBUG_MSG_COLOR = new Color(null, 0, 0, 127);
    private static final Color ERROR_MSG_COLOR = new Color(null, 255, 0, 0);
    private static final Color WARN_MSG_COLOR = new Color(null, 255, 127, 0);
    private static final Color VERBOSE_MSG_COLOR = new Color(null, 0, 0, 0);
    private static final Point LOGCAT_TOOLTIP_SHIFT = new Point(10, 10);
    private Font mLogFont;
    private int mWrapWidth = 100;

    public LogCatMessageLabelProvider(Font font) {
        this.mLogFont = font;
    }

    private String getCellText(LogCatMessage logCatMessage, int n) {
        switch (n) {
            case 0: {
                return Character.toString(logCatMessage.getLogLevel().getPriorityLetter());
            }
            case 1: {
                return logCatMessage.getTime();
            }
            case 2: {
                return logCatMessage.getPid();
            }
            case 3: {
                return logCatMessage.getAppName();
            }
            case 4: {
                return logCatMessage.getTag();
            }
            case 5: {
                return logCatMessage.getMessage();
            }
        }
        return "";
    }

    public void update(ViewerCell viewerCell) {
        Object object = viewerCell.getElement();
        if (!(object instanceof LogCatMessage)) {
            return;
        }
        LogCatMessage logCatMessage = (LogCatMessage)object;
        String string = this.getCellText(logCatMessage, viewerCell.getColumnIndex());
        viewerCell.setText(string);
        viewerCell.setFont(this.mLogFont);
        viewerCell.setForeground(this.getForegroundColor(logCatMessage));
    }

    private Color getForegroundColor(LogCatMessage logCatMessage) {
        Log.LogLevel logLevel = logCatMessage.getLogLevel();
        if (logLevel.equals((Object)Log.LogLevel.VERBOSE)) {
            return VERBOSE_MSG_COLOR;
        }
        if (logLevel.equals((Object)Log.LogLevel.INFO)) {
            return INFO_MSG_COLOR;
        }
        if (logLevel.equals((Object)Log.LogLevel.DEBUG)) {
            return DEBUG_MSG_COLOR;
        }
        if (logLevel.equals((Object)Log.LogLevel.ERROR)) {
            return ERROR_MSG_COLOR;
        }
        if (logLevel.equals((Object)Log.LogLevel.WARN)) {
            return WARN_MSG_COLOR;
        }
        return null;
    }

    public void setFont(Font font) {
        if (this.mLogFont != null) {
            this.mLogFont.dispose();
        }
        this.mLogFont = font;
    }

    public void setMinimumLengthForToolTips(int n) {
        this.mWrapWidth = n;
    }

    public String getToolTipText(Object object) {
        String string = object.toString();
        if (string.length() > this.mWrapWidth) {
            return string;
        }
        return null;
    }

    public Point getToolTipShift(Object object) {
        return LOGCAT_TOOLTIP_SHIFT;
    }
}

