/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib.logcat;

import com.android.ddmuilib.logcat.LogCatMessage;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;

public final class LogCatMessageList {
    public static final String MAX_MESSAGES_PREFKEY = "logcat.messagelist.max.size";
    public static final int MAX_MESSAGES_DEFAULT = 5000;
    private int mFifoSize;
    private BlockingQueue<LogCatMessage> mQ;
    private LogCatMessage[] mQArray;

    public LogCatMessageList(int n) {
        this.mFifoSize = n;
        this.mQ = new ArrayBlockingQueue<LogCatMessage>(this.mFifoSize);
        this.mQArray = new LogCatMessage[this.mFifoSize];
    }

    public synchronized void resize(int n) {
        this.mFifoSize = n;
        if (this.mFifoSize > this.mQ.size()) {
            this.mQ = new ArrayBlockingQueue<LogCatMessage>(this.mFifoSize, true, this.mQ);
        } else {
            LogCatMessage[] logCatMessageArray = this.mQ.toArray(new LogCatMessage[this.mQ.size()]);
            this.mQ = new ArrayBlockingQueue<LogCatMessage>(this.mFifoSize);
            for (int i = logCatMessageArray.length - this.mFifoSize; i < logCatMessageArray.length; ++i) {
                this.mQ.offer(logCatMessageArray[i]);
            }
        }
        this.mQArray = new LogCatMessage[this.mFifoSize];
    }

    public synchronized void appendMessage(LogCatMessage logCatMessage) {
        if (this.mQ.remainingCapacity() == 0) {
            this.mQ.poll();
        }
        this.mQ.offer(logCatMessage);
    }

    public synchronized void clear() {
        this.mQ.clear();
    }

    public Object[] toArray() {
        if (this.mQ.size() == this.mFifoSize) {
            return this.mQ.toArray(this.mQArray);
        }
        return this.mQ.toArray();
    }
}

