/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib.logcat;

import com.android.ddmlib.Log;
import com.android.ddmuilib.logcat.LogCatMessage;
import com.android.ddmuilib.logcat.LogCatPidToNameMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LogCatMessageParser {
    private Log.LogLevel mCurLogLevel = Log.LogLevel.WARN;
    private String mCurPid = "?";
    private String mCurTag = "?";
    private String mCurTime = "?:??";
    private static Pattern sLogHeaderPattern = Pattern.compile("^\\[\\s(\\d\\d-\\d\\d\\s\\d\\d:\\d\\d:\\d\\d\\.\\d+)\\s+(\\d*):(0x[0-9a-fA-F]+)\\s([VDIWEAF])/(.*)\\]$");

    public List<LogCatMessage> processLogLines(String[] stringArray, LogCatPidToNameMapper logCatPidToNameMapper) {
        ArrayList<LogCatMessage> arrayList = new ArrayList<LogCatMessage>(stringArray.length);
        for (String string : stringArray) {
            if (string.length() == 0) continue;
            Matcher matcher = sLogHeaderPattern.matcher(string);
            if (matcher.matches()) {
                this.mCurTime = matcher.group(1);
                this.mCurPid = matcher.group(2);
                this.mCurLogLevel = Log.LogLevel.getByLetterString((String)matcher.group(4));
                this.mCurTag = matcher.group(5).trim();
                if (this.mCurLogLevel != null || !matcher.group(4).equals("F")) continue;
                this.mCurLogLevel = Log.LogLevel.ASSERT;
                continue;
            }
            LogCatMessage logCatMessage = new LogCatMessage(this.mCurLogLevel, this.mCurPid, logCatPidToNameMapper.getName(this.mCurPid), this.mCurTag, this.mCurTime, string);
            arrayList.add(logCatMessage);
        }
        return arrayList;
    }
}

