/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib.logcat;

import com.android.ddmlib.DdmConstants;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.ddmuilib.ITableFocusListener;
import com.android.ddmuilib.ImageLoader;
import com.android.ddmuilib.SelectionDependentPanel;
import com.android.ddmuilib.TableHelper;
import com.android.ddmuilib.logcat.ILogCatMessageEventListener;
import com.android.ddmuilib.logcat.ILogCatMessageSelectionListener;
import com.android.ddmuilib.logcat.LogCatFilter;
import com.android.ddmuilib.logcat.LogCatFilterContentProvider;
import com.android.ddmuilib.logcat.LogCatFilterLabelProvider;
import com.android.ddmuilib.logcat.LogCatFilterSettingsDialog;
import com.android.ddmuilib.logcat.LogCatFilterSettingsSerializer;
import com.android.ddmuilib.logcat.LogCatMessage;
import com.android.ddmuilib.logcat.LogCatMessageContentProvider;
import com.android.ddmuilib.logcat.LogCatMessageLabelProvider;
import com.android.ddmuilib.logcat.LogCatMessageList;
import com.android.ddmuilib.logcat.LogCatReceiver;
import com.android.ddmuilib.logcat.LogCatReceiverFactory;
import com.android.ddmuilib.logcat.LogCatViewerFilter;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LogCatPanel
extends SelectionDependentPanel
implements ILogCatMessageEventListener {
    public static final String LOGCAT_FILTERS_LIST = "logcat.view.filters.list";
    public static final String LOGCAT_VIEW_FONT_PREFKEY = "logcat.view.font";
    private static final String FONT_FAMILY = DdmConstants.CURRENT_PLATFORM == 3 ? "Monaco" : "Courier New";
    private static final FontData DEFAULT_LOGCAT_FONTDATA;
    private static final String LOGCAT_VIEW_COLSIZE_PREFKEY_PREFIX = "logcat.view.colsize.";
    private static final String DISPLAY_FILTERS_COLUMN_PREFKEY = "logcat.view.display.filters";
    private static final String DEFAULT_SEARCH_MESSAGE = "Search for messages. Accepts Java regexes. Prefix with pid:, app:, tag: or text: to limit scope.";
    private static final String DEFAULT_SEARCH_TOOLTIP = "Example search patterns:\n    sqlite (search for sqlite in text field)\n    app:browser (search for messages generated by the browser application)";
    private static final String IMAGE_ADD_FILTER = "add.png";
    private static final String IMAGE_DELETE_FILTER = "delete.png";
    private static final String IMAGE_EDIT_FILTER = "edit.png";
    private static final String IMAGE_SAVE_LOG_TO_FILE = "save.png";
    private static final String IMAGE_CLEAR_LOG = "clear.png";
    private static final String IMAGE_DISPLAY_FILTERS = "displayfilters.png";
    private static final String IMAGE_PAUSE_LOGCAT = "pause_logcat.png";
    private static final int[] WEIGHTS_SHOW_FILTERS;
    private static final int[] WEIGHTS_LOGCAT_ONLY;
    private LogCatReceiver mReceiver;
    private IPreferenceStore mPrefStore;
    private List<LogCatFilter> mLogCatFilters;
    private int mCurrentSelectedFilterIndex;
    private ToolItem mNewFilterToolItem;
    private ToolItem mDeleteFilterToolItem;
    private ToolItem mEditFilterToolItem;
    private TableViewer mFiltersTableViewer;
    private Combo mLiveFilterLevelCombo;
    private Text mLiveFilterText;
    private TableViewer mViewer;
    private boolean mShouldScrollToLatestLog = true;
    private ToolItem mPauseLogcatCheckBox;
    private boolean mLastItemPainted = false;
    private String mLogFileExportFolder;
    private LogCatMessageLabelProvider mLogCatMessageLabelProvider;
    private SashForm mSash;
    private LogCatTableRefresherTask mCurrentRefresher;
    private List<ILogCatMessageSelectionListener> mMessageSelectionListeners;
    private ITableFocusListener mTableFocusListener;

    public LogCatPanel(IPreferenceStore iPreferenceStore) {
        this.mPrefStore = iPreferenceStore;
        this.initializeFilters();
        this.setupDefaultPreferences();
        this.initializePreferenceUpdateListeners();
    }

    private void initializeFilters() {
        this.mLogCatFilters = new ArrayList<LogCatFilter>();
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        this.mLogCatFilters.add(new LogCatFilter("All messages (no filters)", string, string2, string3, string4, Log.LogLevel.VERBOSE));
        List<LogCatFilter> list = this.getSavedFilters();
        this.mLogCatFilters.addAll(list);
    }

    private void setupDefaultPreferences() {
        PreferenceConverter.setDefault((IPreferenceStore)this.mPrefStore, (String)LOGCAT_VIEW_FONT_PREFKEY, (FontData)DEFAULT_LOGCAT_FONTDATA);
        this.mPrefStore.setDefault("logcat.messagelist.max.size", 5000);
        this.mPrefStore.setDefault(DISPLAY_FILTERS_COLUMN_PREFKEY, true);
    }

    private void initializePreferenceUpdateListeners() {
        this.mPrefStore.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getProperty();
                if (string.equals(LogCatPanel.LOGCAT_VIEW_FONT_PREFKEY)) {
                    LogCatPanel.this.mLogCatMessageLabelProvider.setFont(LogCatPanel.this.getFontFromPrefStore());
                    LogCatPanel.this.refreshLogCatTable();
                } else if (string.equals("logcat.messagelist.max.size")) {
                    LogCatPanel.this.mReceiver.resizeFifo(LogCatPanel.this.mPrefStore.getInt("logcat.messagelist.max.size"));
                    LogCatPanel.this.refreshLogCatTable();
                }
            }
        });
    }

    private void saveFilterPreferences() {
        LogCatFilterSettingsSerializer logCatFilterSettingsSerializer = new LogCatFilterSettingsSerializer();
        String string = logCatFilterSettingsSerializer.encodeToPreferenceString(this.mLogCatFilters.subList(1, this.mLogCatFilters.size()));
        this.mPrefStore.setValue(LOGCAT_FILTERS_LIST, string);
    }

    private List<LogCatFilter> getSavedFilters() {
        LogCatFilterSettingsSerializer logCatFilterSettingsSerializer = new LogCatFilterSettingsSerializer();
        String string = this.mPrefStore.getString(LOGCAT_FILTERS_LIST);
        return logCatFilterSettingsSerializer.decodeFromPreferenceString(string);
    }

    @Override
    public void deviceSelected() {
        IDevice iDevice = this.getCurrentDevice();
        if (iDevice == null) {
            return;
        }
        if (this.mReceiver != null) {
            this.mReceiver.removeMessageReceivedEventListener(this);
            for (LogCatFilter logCatFilter : this.mLogCatFilters) {
                logCatFilter.resetUnreadCount();
            }
        }
        this.mReceiver = LogCatReceiverFactory.INSTANCE.newReceiver(iDevice, this.mPrefStore);
        this.mReceiver.addMessageReceivedEventListener(this);
        this.mViewer.setInput((Object)this.mReceiver.getMessages());
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                LogCatPanel.this.scrollToLatestLog();
            }
        });
    }

    @Override
    public void clientSelected() {
    }

    @Override
    protected void postCreation() {
    }

    @Override
    protected Control createControl(Composite composite) {
        GridLayout gridLayout = new GridLayout(1, false);
        composite.setLayout((Layout)gridLayout);
        this.createViews(composite);
        this.setupDefaults();
        return null;
    }

    private void createViews(Composite composite) {
        this.mSash = this.createSash(composite);
        this.createListOfFilters(this.mSash);
        this.createLogTableView(this.mSash);
        boolean bl = this.mPrefStore.getBoolean(DISPLAY_FILTERS_COLUMN_PREFKEY);
        this.updateFiltersColumn(bl);
    }

    private SashForm createSash(Composite composite) {
        SashForm sashForm = new SashForm(composite, 256);
        sashForm.setLayoutData((Object)new GridData(1808));
        return sashForm;
    }

    private void createListOfFilters(SashForm sashForm) {
        Composite composite = new Composite((Composite)sashForm, 2048);
        GridLayout gridLayout = new GridLayout(2, false);
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(1808));
        this.createFiltersToolbar(composite);
        this.createFiltersTable(composite);
    }

    private void createFiltersToolbar(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText("Saved Filters");
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 16384;
        label.setLayoutData((Object)gridData);
        ToolBar toolBar = new ToolBar(composite, 0x800000);
        gridData = new GridData();
        gridData.horizontalAlignment = 131072;
        toolBar.setLayoutData((Object)gridData);
        this.mNewFilterToolItem = new ToolItem(toolBar, 8);
        this.mNewFilterToolItem.setImage(ImageLoader.getDdmUiLibLoader().loadImage(IMAGE_ADD_FILTER, toolBar.getDisplay()));
        this.mNewFilterToolItem.setToolTipText("Add a new logcat filter");
        this.mNewFilterToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                LogCatPanel.this.addNewFilter();
            }
        });
        this.mDeleteFilterToolItem = new ToolItem(toolBar, 8);
        this.mDeleteFilterToolItem.setImage(ImageLoader.getDdmUiLibLoader().loadImage(IMAGE_DELETE_FILTER, toolBar.getDisplay()));
        this.mDeleteFilterToolItem.setToolTipText("Delete selected logcat filter");
        this.mDeleteFilterToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                LogCatPanel.this.deleteSelectedFilter();
            }
        });
        this.mEditFilterToolItem = new ToolItem(toolBar, 8);
        this.mEditFilterToolItem.setImage(ImageLoader.getDdmUiLibLoader().loadImage(IMAGE_EDIT_FILTER, toolBar.getDisplay()));
        this.mEditFilterToolItem.setToolTipText("Edit selected logcat filter");
        this.mEditFilterToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                LogCatPanel.this.editSelectedFilter();
            }
        });
    }

    private void addNewFilter() {
        LogCatFilterSettingsDialog logCatFilterSettingsDialog = new LogCatFilterSettingsDialog(Display.getCurrent().getActiveShell());
        if (logCatFilterSettingsDialog.open() != 0) {
            return;
        }
        LogCatFilter logCatFilter = new LogCatFilter(logCatFilterSettingsDialog.getFilterName().trim(), logCatFilterSettingsDialog.getTag().trim(), logCatFilterSettingsDialog.getText().trim(), logCatFilterSettingsDialog.getPid().trim(), logCatFilterSettingsDialog.getAppName().trim(), Log.LogLevel.getByString((String)logCatFilterSettingsDialog.getLogLevel()));
        this.mLogCatFilters.add(logCatFilter);
        this.mFiltersTableViewer.refresh();
        int n = this.mLogCatFilters.size() - 1;
        this.mFiltersTableViewer.getTable().setSelection(n);
        this.filterSelectionChanged();
        this.saveFilterPreferences();
    }

    private void deleteSelectedFilter() {
        int n = this.mFiltersTableViewer.getTable().getSelectionIndex();
        if (n <= 0) {
            return;
        }
        this.mLogCatFilters.remove(n);
        this.mFiltersTableViewer.refresh();
        this.mFiltersTableViewer.getTable().setSelection(n - 1);
        this.filterSelectionChanged();
        this.saveFilterPreferences();
    }

    private void editSelectedFilter() {
        int n = this.mFiltersTableViewer.getTable().getSelectionIndex();
        if (n < 0) {
            return;
        }
        LogCatFilter logCatFilter = this.mLogCatFilters.get(n);
        LogCatFilterSettingsDialog logCatFilterSettingsDialog = new LogCatFilterSettingsDialog(Display.getCurrent().getActiveShell());
        logCatFilterSettingsDialog.setDefaults(logCatFilter.getName(), logCatFilter.getTag(), logCatFilter.getText(), logCatFilter.getPid(), logCatFilter.getAppName(), logCatFilter.getLogLevel());
        if (logCatFilterSettingsDialog.open() != 0) {
            return;
        }
        LogCatFilter logCatFilter2 = new LogCatFilter(logCatFilterSettingsDialog.getFilterName(), logCatFilterSettingsDialog.getTag(), logCatFilterSettingsDialog.getText(), logCatFilterSettingsDialog.getPid(), logCatFilterSettingsDialog.getAppName(), Log.LogLevel.getByString((String)logCatFilterSettingsDialog.getLogLevel()));
        this.mLogCatFilters.set(n, logCatFilter2);
        this.mFiltersTableViewer.refresh();
        this.mFiltersTableViewer.getTable().setSelection(n);
        this.filterSelectionChanged();
        this.saveFilterPreferences();
    }

    public void selectTransientAppFilter(String string) {
        assert (this.mViewer.getTable().getDisplay().getThread() == Thread.currentThread());
        LogCatFilter logCatFilter = this.findTransientAppFilter(string);
        if (logCatFilter == null) {
            logCatFilter = this.createTransientAppFilter(string);
            this.mLogCatFilters.add(logCatFilter);
        }
        this.selectFilterAt(this.mLogCatFilters.indexOf(logCatFilter));
    }

    private LogCatFilter findTransientAppFilter(String string) {
        for (LogCatFilter logCatFilter : this.mLogCatFilters) {
            if (!logCatFilter.isTransient() || !logCatFilter.getAppName().equals(string)) continue;
            return logCatFilter;
        }
        return null;
    }

    private LogCatFilter createTransientAppFilter(String string) {
        LogCatFilter logCatFilter = new LogCatFilter(string + " (Session Filter)", "", "", "", string, Log.LogLevel.VERBOSE);
        logCatFilter.setTransient();
        return logCatFilter;
    }

    private void selectFilterAt(int n) {
        this.mFiltersTableViewer.refresh();
        this.mFiltersTableViewer.getTable().setSelection(n);
        this.filterSelectionChanged();
    }

    private void createFiltersTable(Composite composite) {
        Table table = new Table(composite, 65536);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        table.setLayoutData((Object)gridData);
        this.mFiltersTableViewer = new TableViewer(table);
        this.mFiltersTableViewer.setContentProvider((IContentProvider)new LogCatFilterContentProvider());
        this.mFiltersTableViewer.setLabelProvider((IBaseLabelProvider)new LogCatFilterLabelProvider());
        this.mFiltersTableViewer.setInput(this.mLogCatFilters);
        this.mFiltersTableViewer.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                LogCatPanel.this.filterSelectionChanged();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                LogCatPanel.this.editSelectedFilter();
            }
        });
    }

    private void createLogTableView(SashForm sashForm) {
        Composite composite = new Composite((Composite)sashForm, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.createLiveFilters(composite);
        this.createLogcatViewTable(composite);
    }

    private void createLiveFilters(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(3, false));
        composite2.setLayoutData((Object)new GridData(768));
        this.mLiveFilterText = new Text(composite2, 2176);
        this.mLiveFilterText.setLayoutData((Object)new GridData(768));
        this.mLiveFilterText.setMessage(DEFAULT_SEARCH_MESSAGE);
        this.mLiveFilterText.setToolTipText(DEFAULT_SEARCH_TOOLTIP);
        this.mLiveFilterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                LogCatPanel.this.updateAppliedFilters();
            }
        });
        this.mLiveFilterLevelCombo = new Combo(composite2, 12);
        this.mLiveFilterLevelCombo.setItems(LogCatFilterSettingsDialog.getLogLevels().toArray(new String[0]));
        this.mLiveFilterLevelCombo.select(0);
        this.mLiveFilterLevelCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                LogCatPanel.this.updateAppliedFilters();
            }
        });
        ToolBar toolBar = new ToolBar(composite2, 0x800000);
        ToolItem toolItem = new ToolItem(toolBar, 8);
        toolItem.setImage(ImageLoader.getDdmUiLibLoader().loadImage(IMAGE_SAVE_LOG_TO_FILE, toolBar.getDisplay()));
        toolItem.setToolTipText("Export Selected Items To Text File..");
        toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                LogCatPanel.this.saveLogToFile();
            }
        });
        ToolItem toolItem2 = new ToolItem(toolBar, 8);
        toolItem2.setImage(ImageLoader.getDdmUiLibLoader().loadImage(IMAGE_CLEAR_LOG, toolBar.getDisplay()));
        toolItem2.setToolTipText("Clear Log");
        toolItem2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (LogCatPanel.this.mReceiver != null) {
                    LogCatPanel.this.mReceiver.clearMessages();
                    LogCatPanel.this.refreshLogCatTable();
                    LogCatPanel.this.updateAppliedFilters();
                }
            }
        });
        final ToolItem toolItem3 = new ToolItem(toolBar, 32);
        toolItem3.setImage(ImageLoader.getDdmUiLibLoader().loadImage(IMAGE_DISPLAY_FILTERS, toolBar.getDisplay()));
        toolItem3.setSelection(this.mPrefStore.getBoolean(DISPLAY_FILTERS_COLUMN_PREFKEY));
        toolItem3.setToolTipText("Display Saved Filters View");
        toolItem3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean bl = toolItem3.getSelection();
                LogCatPanel.this.mPrefStore.setValue(LogCatPanel.DISPLAY_FILTERS_COLUMN_PREFKEY, bl);
                LogCatPanel.this.updateFiltersColumn(bl);
            }
        });
        this.mPauseLogcatCheckBox = new ToolItem(toolBar, 32);
        this.mPauseLogcatCheckBox.setImage(ImageLoader.getDdmUiLibLoader().loadImage(IMAGE_PAUSE_LOGCAT, toolBar.getDisplay()));
        this.mPauseLogcatCheckBox.setSelection(false);
        this.mPauseLogcatCheckBox.setToolTipText("Pause receiving new logcat messages.");
        this.mPauseLogcatCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean bl = LogCatPanel.this.mPauseLogcatCheckBox.getSelection();
                LogCatPanel.this.setScrollToLatestLog(!bl, false);
            }
        });
    }

    private void updateFiltersColumn(boolean bl) {
        if (bl) {
            this.mSash.setWeights(WEIGHTS_SHOW_FILTERS);
        } else {
            this.mSash.setWeights(WEIGHTS_LOGCAT_ONLY);
        }
    }

    private void saveLogToFile() {
        final String string = this.getLogFileTargetLocation();
        if (string == null) {
            return;
        }
        final List<LogCatMessage> list = this.getSelectedLogCatMessages();
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
                    for (LogCatMessage logCatMessage : list) {
                        bufferedWriter.append(logCatMessage.toString());
                        bufferedWriter.newLine();
                    }
                    bufferedWriter.close();
                }
                catch (IOException iOException) {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Unable to export selection to file.", (String)("Unexpected error while saving selected messages to file: " + iOException.getMessage()));
                        }
                    });
                }
            }
        });
        thread.setName("Saving selected items to logfile..");
        thread.start();
    }

    private String getLogFileTargetLocation() {
        FileDialog fileDialog = new FileDialog(Display.getCurrent().getActiveShell(), 8192);
        fileDialog.setText("Save Log..");
        fileDialog.setFileName("log.txt");
        if (this.mLogFileExportFolder == null) {
            this.mLogFileExportFolder = System.getProperty("user.home");
        }
        fileDialog.setFilterPath(this.mLogFileExportFolder);
        fileDialog.setFilterNames(new String[]{"Text Files (*.txt)"});
        fileDialog.setFilterExtensions(new String[]{"*.txt"});
        String string = fileDialog.open();
        if (string != null) {
            this.mLogFileExportFolder = fileDialog.getFilterPath();
        }
        return string;
    }

    private List<LogCatMessage> getSelectedLogCatMessages() {
        Table table = this.mViewer.getTable();
        int[] nArray = table.getSelectionIndices();
        Arrays.sort(nArray);
        Object object = this.mViewer.getInput();
        if (!(object instanceof LogCatMessageList)) {
            return Collections.emptyList();
        }
        List<LogCatMessage> list = this.applyCurrentFilters((LogCatMessageList)object);
        ArrayList<LogCatMessage> arrayList = new ArrayList<LogCatMessage>(nArray.length);
        for (int n : nArray) {
            if (n >= list.size()) continue;
            LogCatMessage logCatMessage = list.get(n);
            arrayList.add(logCatMessage);
        }
        return arrayList;
    }

    private List<LogCatMessage> applyCurrentFilters(LogCatMessageList logCatMessageList) {
        Object[] objectArray = logCatMessageList.toArray();
        ArrayList<LogCatMessage> arrayList = new ArrayList<LogCatMessage>(objectArray.length);
        List<LogCatViewerFilter> list = this.getFiltersToApply();
        for (Object object : objectArray) {
            LogCatMessage logCatMessage;
            if (!(object instanceof LogCatMessage) || this.isMessageFiltered(logCatMessage = (LogCatMessage)object, list)) continue;
            arrayList.add(logCatMessage);
        }
        return arrayList;
    }

    private boolean isMessageFiltered(LogCatMessage logCatMessage, List<LogCatViewerFilter> list) {
        for (LogCatViewerFilter logCatViewerFilter : list) {
            if (logCatViewerFilter.select(null, null, logCatMessage)) continue;
            return true;
        }
        return false;
    }

    private void createLogcatViewTable(Composite composite) {
        Table table = new Table(composite, 0x10010002);
        this.mViewer = new TableViewer(table);
        table.setLayoutData((Object)new GridData(1808));
        table.getHorizontalBar().setVisible(true);
        String[] stringArray = new String[]{"Level", "Time", "PID", "Application", "Tag", "Text"};
        String[] stringArray2 = new String[]{"    ", "    00-00 00:00:00.0000 ", "    0000", "    com.android.launcher", "    SampleTagText", "    Log Message field should be pretty long by default. As long as possible for correct display on Mac."};
        this.mLogCatMessageLabelProvider = new LogCatMessageLabelProvider(this.getFontFromPrefStore());
        for (int i = 0; i < stringArray.length; ++i) {
            TableColumn tableColumn = TableHelper.createTableColumn(this.mViewer.getTable(), stringArray[i], 16384, stringArray2[i], this.getColPreferenceKey(stringArray[i]), this.mPrefStore);
            TableViewerColumn tableViewerColumn = new TableViewerColumn(this.mViewer, tableColumn);
            tableViewerColumn.setLabelProvider((CellLabelProvider)this.mLogCatMessageLabelProvider);
        }
        this.mViewer.getTable().setLinesVisible(true);
        this.mViewer.getTable().setHeaderVisible(true);
        this.mViewer.setContentProvider((IContentProvider)new LogCatMessageContentProvider());
        WrappingToolTipSupport.enableFor((ColumnViewer)this.mViewer, 2);
        this.mViewer.getTable().addListener(41, new Listener(){

            public void handleEvent(Event event) {
                event.height = event.gc.getFontMetrics().getHeight();
            }
        });
        TableColumn tableColumn = this.mViewer.getTable().getColumn(stringArray.length - 1);
        tableColumn.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                TableColumn tableColumn = (TableColumn)controlEvent.getSource();
                int n = tableColumn.getWidth();
                GC gC = new GC((Drawable)tableColumn.getParent());
                int n2 = gC.getFontMetrics().getAverageCharWidth();
                gC.dispose();
                if (LogCatPanel.this.mLogCatMessageLabelProvider != null) {
                    LogCatPanel.this.mLogCatMessageLabelProvider.setMinimumLengthForToolTips(n / n2);
                }
            }
        });
        this.setupAutoScrollLockBehavior();
        this.initDoubleClickListener();
    }

    private void setupAutoScrollLockBehavior() {
        if (DdmConstants.CURRENT_PLATFORM == 2) {
            this.mViewer.getTable().addListener(42, new Listener(){

                public void handleEvent(Event event) {
                    TableItem tableItem = (TableItem)event.item;
                    TableItem[] tableItemArray = LogCatPanel.this.mViewer.getTable().getItems();
                    if (tableItemArray.length > 0 && tableItemArray[tableItemArray.length - 1] == tableItem) {
                        LogCatPanel.this.mLastItemPainted = true;
                    }
                }
            });
            this.mViewer.getTable().getVerticalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    boolean bl = selectionEvent.detail == 0x1000001 || selectionEvent.detail == 0x1000005 || selectionEvent.detail == 0x1000007 ? false : LogCatPanel.this.mLastItemPainted;
                    LogCatPanel.this.setScrollToLatestLog(bl, true);
                    LogCatPanel.this.mLastItemPainted = false;
                }
            });
        } else if (DdmConstants.CURRENT_PLATFORM == 1) {
            this.mViewer.getTable().getVerticalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    ScrollBar scrollBar = (ScrollBar)selectionEvent.getSource();
                    boolean bl = scrollBar.getSelection() + scrollBar.getThumb() == scrollBar.getMaximum();
                    LogCatPanel.this.setScrollToLatestLog(bl, true);
                }
            });
        }
    }

    private void setScrollToLatestLog(boolean bl, boolean bl2) {
        this.mShouldScrollToLatestLog = bl;
        if (bl2) {
            this.mPauseLogcatCheckBox.setSelection(!bl);
        }
        if (bl) {
            this.mViewer.refresh();
            this.scrollToLatestLog();
        }
    }

    private String getColPreferenceKey(String string) {
        return LOGCAT_VIEW_COLSIZE_PREFKEY_PREFIX + string;
    }

    private Font getFontFromPrefStore() {
        FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)this.mPrefStore, (String)LOGCAT_VIEW_FONT_PREFKEY);
        return new Font((Device)Display.getDefault(), fontData);
    }

    private void setupDefaults() {
        int n = 0;
        this.mFiltersTableViewer.getTable().setSelection(n);
        this.filterSelectionChanged();
    }

    private void filterSelectionChanged() {
        int n = this.getSelectedSavedFilterIndex();
        if (n == -1) {
            n = 0;
            this.mFiltersTableViewer.getTable().setSelection(n);
        }
        this.mCurrentSelectedFilterIndex = n;
        this.resetUnreadCountForSelectedFilter();
        this.updateFiltersToolBar();
        this.updateAppliedFilters();
    }

    private void resetUnreadCountForSelectedFilter() {
        int n = this.getSelectedSavedFilterIndex();
        this.mLogCatFilters.get(n).resetUnreadCount();
        this.refreshFiltersTable();
    }

    private int getSelectedSavedFilterIndex() {
        return this.mFiltersTableViewer.getTable().getSelectionIndex();
    }

    private void updateFiltersToolBar() {
        boolean bl = this.getSelectedSavedFilterIndex() != 0;
        this.mEditFilterToolItem.setEnabled(bl);
        this.mDeleteFilterToolItem.setEnabled(bl);
    }

    private void updateAppliedFilters() {
        List<LogCatViewerFilter> list = this.getFiltersToApply();
        this.mViewer.setFilters((ViewerFilter[])list.toArray(new LogCatViewerFilter[list.size()]));
        this.scrollToLatestLog();
    }

    private List<LogCatViewerFilter> getFiltersToApply() {
        ArrayList<LogCatViewerFilter> arrayList = new ArrayList<LogCatViewerFilter>();
        arrayList.add(this.getSelectedSavedFilter());
        arrayList.addAll(this.getCurrentLiveFilters());
        return arrayList;
    }

    private List<LogCatViewerFilter> getCurrentLiveFilters() {
        ArrayList<LogCatViewerFilter> arrayList = new ArrayList<LogCatViewerFilter>();
        List<LogCatFilter> list = LogCatFilter.fromString(this.mLiveFilterText.getText(), Log.LogLevel.getByString((String)this.mLiveFilterLevelCombo.getText()));
        for (LogCatFilter logCatFilter : list) {
            arrayList.add(new LogCatViewerFilter(logCatFilter));
        }
        return arrayList;
    }

    private LogCatViewerFilter getSelectedSavedFilter() {
        int n = this.getSelectedSavedFilterIndex();
        return new LogCatViewerFilter(this.mLogCatFilters.get(n));
    }

    @Override
    public void setFocus() {
    }

    @Override
    public void messageReceived(List<LogCatMessage> list) {
        this.refreshLogCatTable();
        this.updateUnreadCount(list);
        this.refreshFiltersTable();
    }

    private void updateUnreadCount(List<LogCatMessage> list) {
        for (int i = 0; i < this.mLogCatFilters.size(); ++i) {
            if (i == this.mCurrentSelectedFilterIndex) continue;
            this.mLogCatFilters.get(i).updateUnreadCount(list);
        }
    }

    private void refreshFiltersTable() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (LogCatPanel.this.mFiltersTableViewer.getTable().isDisposed()) {
                    return;
                }
                LogCatPanel.this.mFiltersTableViewer.refresh();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshLogCatTable() {
        LogCatPanel logCatPanel = this;
        synchronized (logCatPanel) {
            if (this.mCurrentRefresher == null && this.mShouldScrollToLatestLog) {
                this.mCurrentRefresher = new LogCatTableRefresherTask();
                Display.getDefault().asyncExec((Runnable)this.mCurrentRefresher);
            }
        }
    }

    private void scrollToLatestLog() {
        this.mViewer.getTable().setTopIndex(this.mViewer.getTable().getItemCount() - 1);
    }

    private void initDoubleClickListener() {
        this.mMessageSelectionListeners = new ArrayList<ILogCatMessageSelectionListener>(1);
        this.mViewer.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                List list = LogCatPanel.this.getSelectedLogCatMessages();
                if (list.size() == 0) {
                    return;
                }
                for (ILogCatMessageSelectionListener iLogCatMessageSelectionListener : LogCatPanel.this.mMessageSelectionListeners) {
                    iLogCatMessageSelectionListener.messageDoubleClicked((LogCatMessage)list.get(0));
                }
            }
        });
    }

    public void addLogCatMessageSelectionListener(ILogCatMessageSelectionListener iLogCatMessageSelectionListener) {
        this.mMessageSelectionListeners.add(iLogCatMessageSelectionListener);
    }

    public void setTableFocusListener(ITableFocusListener iTableFocusListener) {
        this.mTableFocusListener = iTableFocusListener;
        final Table table = this.mViewer.getTable();
        final ITableFocusListener.IFocusedTableActivator iFocusedTableActivator = new ITableFocusListener.IFocusedTableActivator(){

            public void copy(Clipboard clipboard) {
                LogCatPanel.this.copySelectionToClipboard(clipboard);
            }

            public void selectAll() {
                table.selectAll();
            }
        };
        table.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                LogCatPanel.this.mTableFocusListener.focusGained(iFocusedTableActivator);
            }

            public void focusLost(FocusEvent focusEvent) {
                LogCatPanel.this.mTableFocusListener.focusLost(iFocusedTableActivator);
            }
        });
    }

    public void copySelectionToClipboard(Clipboard clipboard) {
        StringBuilder stringBuilder = new StringBuilder();
        for (LogCatMessage logCatMessage : this.getSelectedLogCatMessages()) {
            stringBuilder.append(logCatMessage.toString());
            stringBuilder.append('\n');
        }
        clipboard.setContents(new Object[]{stringBuilder.toString()}, new Transfer[]{TextTransfer.getInstance()});
    }

    public void selectAll() {
        this.mViewer.getTable().selectAll();
    }

    static {
        int n = Display.getDefault().getSystemFont().getFontData()[0].getHeight();
        DEFAULT_LOGCAT_FONTDATA = new FontData(FONT_FAMILY, n, 0);
        WEIGHTS_SHOW_FILTERS = new int[]{15, 85};
        WEIGHTS_LOGCAT_ONLY = new int[]{0, 100};
    }

    private class LogCatTableRefresherTask
    implements Runnable {
        private LogCatTableRefresherTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (LogCatPanel.this.mViewer.getTable().isDisposed()) {
                return;
            }
            LogCatPanel logCatPanel = LogCatPanel.this;
            synchronized (logCatPanel) {
                LogCatPanel.this.mCurrentRefresher = null;
            }
            if (LogCatPanel.this.mShouldScrollToLatestLog) {
                LogCatPanel.this.mViewer.refresh();
                LogCatPanel.this.scrollToLatestLog();
            }
        }
    }

    private static class WrappingToolTipSupport
    extends ColumnViewerToolTipSupport {
        protected WrappingToolTipSupport(ColumnViewer columnViewer, int n, boolean bl) {
            super(columnViewer, n, bl);
        }

        protected Composite createViewerToolTipContentArea(Event event, ViewerCell viewerCell, Composite composite) {
            Composite composite2 = new Composite(composite, 0);
            GridLayout gridLayout = new GridLayout(1, false);
            gridLayout.horizontalSpacing = 0;
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            gridLayout.verticalSpacing = 0;
            composite2.setLayout((Layout)gridLayout);
            Text text = new Text(composite2, 2624);
            text.setEditable(false);
            text.setText(viewerCell.getElement().toString());
            text.setLayoutData((Object)new GridData(500, 150));
            return composite2;
        }

        public boolean isHideOnMouseDown() {
            return false;
        }

        public static final void enableFor(ColumnViewer columnViewer, int n) {
            new WrappingToolTipSupport(columnViewer, n, false);
        }
    }
}

