/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib.logcat;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class LogCatStackTraceParser {
    private static final String EXCEPTION_LINE_REGEX = "\\s*at\\ (.*)\\((.*)\\..*\\:(\\d+)\\)";
    private static final Pattern EXCEPTION_LINE_PATTERN = Pattern.compile("\\s*at\\ (.*)\\((.*)\\..*\\:(\\d+)\\)");

    public boolean isValidExceptionTrace(String string) {
        return EXCEPTION_LINE_PATTERN.matcher(string).find();
    }

    public String getMethodName(String string) {
        Matcher matcher = EXCEPTION_LINE_PATTERN.matcher(string);
        matcher.find();
        return matcher.group(1);
    }

    public String getFileName(String string) {
        Matcher matcher = EXCEPTION_LINE_PATTERN.matcher(string);
        matcher.find();
        return matcher.group(2);
    }

    public int getLineNumber(String string) {
        Matcher matcher = EXCEPTION_LINE_PATTERN.matcher(string);
        matcher.find();
        try {
            return Integer.parseInt(matcher.group(3));
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }
}

