/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.avd;

import com.android.sdklib.ISdkLog;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HardwareProperties {
    private static final Pattern PATTERN_PROP = Pattern.compile("^([a-zA-Z0-9._-]+)\\s*=\\s*(.*)\\s*$");
    private static final String HW_PROP_NAME = "name";
    private static final String HW_PROP_TYPE = "type";
    private static final String HW_PROP_DEFAULT = "default";
    private static final String HW_PROP_ABSTRACT = "abstract";
    private static final String HW_PROP_DESC = "description";
    private static final String BOOLEAN_YES = "yes";
    private static final String BOOLEAN_NO = "no";
    public static final String[] BOOLEAN_VALUES = new String[]{"yes", "no"};
    public static final Pattern DISKSIZE_PATTERN = Pattern.compile("\\d+[MK]B");

    public static Map<String, HardwareProperty> parseHardwareDefinitions(File file, ISdkLog iSdkLog) {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            TreeMap<String, HardwareProperty> treeMap = new TreeMap<String, HardwareProperty>();
            String string = null;
            HardwareProperty hardwareProperty = null;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.length() <= 0 || string.charAt(0) == '#') continue;
                Matcher matcher = PATTERN_PROP.matcher(string);
                if (matcher.matches()) {
                    String string2 = matcher.group(1);
                    String string3 = matcher.group(2);
                    if (HW_PROP_NAME.equals(string2)) {
                        hardwareProperty = new HardwareProperty();
                        hardwareProperty.mName = string3;
                        treeMap.put(hardwareProperty.mName, hardwareProperty);
                    }
                    if (hardwareProperty == null) {
                        iSdkLog.warning("Error parsing '%1$s': missing '%2$s'", file.getAbsolutePath(), HW_PROP_NAME);
                        return null;
                    }
                    if (HW_PROP_TYPE.equals(string2)) {
                        hardwareProperty.mType = ValueType.getEnum(string3);
                        continue;
                    }
                    if (HW_PROP_DEFAULT.equals(string2)) {
                        hardwareProperty.mDefault = string3;
                        continue;
                    }
                    if (HW_PROP_ABSTRACT.equals(string2)) {
                        hardwareProperty.mAbstract = string3;
                        continue;
                    }
                    if (!HW_PROP_DESC.equals(string2)) continue;
                    hardwareProperty.mDescription = string3;
                    continue;
                }
                iSdkLog.warning("Error parsing '%1$s': \"%2$s\" is not a valid syntax", file.getAbsolutePath(), string);
                return null;
            }
            return treeMap;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            iSdkLog.warning("Error parsing '%1$s': %2$s.", file.getAbsolutePath(), iOException.getMessage());
        }
        return null;
    }

    public static int getBooleanValueIndex(String string) {
        if (BOOLEAN_YES.equals(string)) {
            return 0;
        }
        if (BOOLEAN_NO.equals(string)) {
            return 1;
        }
        return -1;
    }

    public static final class HardwareProperty {
        private String mName = "";
        private ValueType mType;
        private String mDefault = "";
        private String mAbstract = "";
        private String mDescription = "";

        public String getName() {
            return this.mName;
        }

        public ValueType getType() {
            return this.mType;
        }

        public String getDefault() {
            return this.mDefault;
        }

        public String getAbstract() {
            return this.mAbstract;
        }

        public String getDescription() {
            return this.mDescription;
        }

        public boolean isValidForUi() {
            return this.mType != ValueType.STRING;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ValueType {
        INTEGER("integer"),
        BOOLEAN("boolean"),
        DISKSIZE("diskSize"),
        STRING("string");

        private String mValue;

        private ValueType(String string2) {
            this.mValue = string2;
        }

        public String getValue() {
            return this.mValue;
        }

        public static ValueType getEnum(String string) {
            for (ValueType valueType : ValueType.values()) {
                if (!valueType.mValue.equals(string)) continue;
                return valueType;
            }
            return null;
        }
    }
}

