/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.build;

import com.android.appauth.Certificate;
import com.android.sdklib.ISdkLog;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;

public class MakeIdentity {
    private final String mAccount;
    private final String mKeystorePath;
    private final String mKeystorePass;
    private final String mAliasName;
    private final String mAliasPass;

    public MakeIdentity(String string, String string2, String string3, String string4, String string5) {
        this.mAccount = string;
        this.mKeystorePath = string2;
        this.mKeystorePass = string3;
        this.mAliasName = string4;
        this.mAliasPass = string5;
    }

    public boolean make(PrintStream printStream, ISdkLog iSdkLog) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableEntryException {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        FileInputStream fileInputStream = new FileInputStream(this.mKeystorePath);
        keyStore.load(fileInputStream, this.mKeystorePass.toCharArray());
        fileInputStream.close();
        KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(this.mAliasName, new KeyStore.PasswordProtection(this.mAliasPass.toCharArray()));
        if (privateKeyEntry == null) {
            return false;
        }
        Certificate certificate = new Certificate();
        certificate.setVersion("1.0");
        certificate.setType("Identity");
        certificate.setHashAlgo("SHA-256");
        certificate.setPublicKey(privateKeyEntry.getCertificate().getPublicKey());
        certificate.setEntityName(this.mAccount);
        certificate.signWith(certificate, privateKeyEntry.getPrivateKey());
        if (!certificate.isSignedBy(certificate)) {
            System.err.println("signature failed?!");
            return false;
        }
        try {
            certificate.writeTo(printStream);
        }
        catch (Exception exception) {
            iSdkLog.error(exception, null, new Object[0]);
        }
        return true;
    }
}

