/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository;

import com.android.sdklib.internal.repository.ITaskMonitor;
import com.android.sdklib.internal.repository.UserCredentials;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ProxySelector;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.ProxySelectorRoutePlanner;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

public class UrlOpener {
    private static Map<String, UserCredentials> sRealmCache = new HashMap<String, UserCredentials>();

    static InputStream openUrl(String string, ITaskMonitor iTaskMonitor) throws IOException, CanceledByUserException {
        try {
            return UrlOpener.openWithHttpClient(string, iTaskMonitor);
        }
        catch (ClientProtocolException clientProtocolException) {
            URL uRL = new URL(string);
            return uRL.openStream();
        }
    }

    private static InputStream openWithHttpClient(String string, ITaskMonitor iTaskMonitor) throws IOException, ClientProtocolException, CanceledByUserException {
        UserCredentials userCredentials = null;
        String string2 = null;
        final DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
        BasicHttpContext basicHttpContext = new BasicHttpContext();
        HttpGet httpGet = new HttpGet(string);
        ProxySelectorRoutePlanner proxySelectorRoutePlanner = new ProxySelectorRoutePlanner(defaultHttpClient.getConnectionManager().getSchemeRegistry(), ProxySelector.getDefault());
        defaultHttpClient.setRoutePlanner((HttpRoutePlanner)proxySelectorRoutePlanner);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Basic");
        arrayList.add("Digest");
        arrayList.add("NTLM");
        defaultHttpClient.getParams().setParameter("http.auth.proxy-scheme-pref", arrayList);
        defaultHttpClient.getParams().setParameter("http.auth.target-scheme-pref", arrayList);
        boolean bl = true;
        while (bl) {
            AuthScope authScope;
            HttpResponse httpResponse = defaultHttpClient.execute((HttpUriRequest)httpGet, (HttpContext)basicHttpContext);
            int n = httpResponse.getStatusLine().getStatusCode();
            AuthState authState = null;
            if (n == 401) {
                authState = (AuthState)basicHttpContext.getAttribute("http.auth.target-scope");
            }
            if (n == 407) {
                authState = (AuthState)basicHttpContext.getAttribute("http.auth.proxy-scope");
            }
            if (n == 200 && string2 != null && userCredentials != null) {
                sRealmCache.put(string2, userCredentials);
            }
            if (authState != null) {
                authScope = authState.getAuthScope();
                if (string2 != null && !string2.equals(authScope.getRealm())) {
                    sRealmCache.put(string2, userCredentials);
                }
                if (sRealmCache.containsKey(string2 = authScope.getRealm())) {
                    userCredentials = sRealmCache.get(string2);
                } else {
                    userCredentials = iTaskMonitor.displayLoginCredentialsPrompt("Site Authentication", "Please login to the following domain: " + string2 + "\n\nServer requiring authentication:\n" + authScope.getHost());
                    if (userCredentials == null) {
                        throw new CanceledByUserException("User canceled login dialog.");
                    }
                }
                String string3 = userCredentials.getUserName();
                String string4 = userCredentials.getPassword();
                String string5 = userCredentials.getWorkstation();
                String string6 = userCredentials.getDomain();
                if (string3 != null && string3.length() > 0) {
                    NTCredentials nTCredentials = new NTCredentials(string3, string4, string5, string6);
                    defaultHttpClient.getCredentialsProvider().setCredentials(authScope, (Credentials)nTCredentials);
                    bl = true;
                } else {
                    bl = false;
                }
            } else {
                bl = false;
            }
            if ((authScope = httpResponse.getEntity()) == null) continue;
            if (bl) {
                authScope.getContent().close();
                continue;
            }
            return new FilterInputStream(authScope.getContent()){

                public void close() throws IOException {
                    defaultHttpClient.getConnectionManager().shutdown();
                    super.close();
                }
            };
        }
        defaultHttpClient.getConnectionManager().shutdown();
        throw new FileNotFoundException(string);
    }

    public static class CanceledByUserException
    extends Exception {
        private static final long serialVersionUID = -7669346110926032403L;

        public CanceledByUserException(String string) {
            super(string);
        }
    }
}

