/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewerlib;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.ddmlib.RawImage;
import com.android.ddmlib.TimeoutException;
import com.android.hierarchyviewerlib.device.DeviceBridge;
import com.android.hierarchyviewerlib.device.ViewNode;
import com.android.hierarchyviewerlib.device.Window;
import com.android.hierarchyviewerlib.device.WindowUpdater;
import com.android.hierarchyviewerlib.models.DeviceSelectionModel;
import com.android.hierarchyviewerlib.models.PixelPerfectModel;
import com.android.hierarchyviewerlib.models.TreeViewModel;
import com.android.hierarchyviewerlib.ui.CaptureDisplay;
import com.android.hierarchyviewerlib.ui.TreeView;
import com.android.hierarchyviewerlib.ui.util.DrawableViewNode;
import com.android.hierarchyviewerlib.ui.util.PsdFile;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public abstract class HierarchyViewerDirector
implements AndroidDebugBridge.IDeviceChangeListener,
WindowUpdater.IWindowChangeListener {
    protected static HierarchyViewerDirector sDirector;
    public static final String TAG = "hierarchyviewer";
    private int mPixelPerfectRefreshesInProgress = 0;
    private Timer mPixelPerfectRefreshTimer = new Timer();
    private boolean mAutoRefresh = false;
    public static final int DEFAULT_PIXEL_PERFECT_AUTOREFRESH_INTERVAL = 5;
    private int mPixelPerfectAutoRefreshInterval = 5;
    private PixelPerfectAutoRefreshTask mCurrentAutoRefreshTask;
    private String mFilterText = "";

    public void terminate() {
        WindowUpdater.terminate();
        this.mPixelPerfectRefreshTimer.cancel();
    }

    public abstract String getAdbLocation();

    public static HierarchyViewerDirector getDirector() {
        return sDirector;
    }

    public void acquireBridge(AndroidDebugBridge androidDebugBridge) {
        DeviceBridge.acquireBridge(androidDebugBridge);
    }

    public void initDebugBridge() {
        DeviceBridge.initDebugBridge(this.getAdbLocation());
    }

    public void stopDebugBridge() {
        DeviceBridge.terminate();
    }

    public void populateDeviceSelectionModel() {
        IDevice[] iDeviceArray;
        for (IDevice iDevice : iDeviceArray = DeviceBridge.getDevices()) {
            this.deviceConnected(iDevice);
        }
    }

    public void startListenForDevices() {
        DeviceBridge.startListenForDevices(this);
    }

    public void stopListenForDevices() {
        DeviceBridge.stopListenForDevices(this);
    }

    public abstract void executeInBackground(String var1, Runnable var2);

    public void deviceConnected(final IDevice iDevice) {
        this.executeInBackground("Connecting device", new Runnable(){

            public void run() {
                if (DeviceSelectionModel.getModel().containsDevice(iDevice)) {
                    HierarchyViewerDirector.this.windowsChanged(iDevice);
                } else if (iDevice.isOnline()) {
                    DeviceBridge.setupDeviceForward(iDevice);
                    if (!DeviceBridge.isViewServerRunning(iDevice) && !DeviceBridge.startViewServer(iDevice)) {
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (!DeviceBridge.startViewServer(iDevice)) {
                            Log.e(HierarchyViewerDirector.TAG, "Unable to debug device " + iDevice);
                            DeviceBridge.removeDeviceForward(iDevice);
                        } else {
                            HierarchyViewerDirector.this.loadViewServerInfoAndWindows(iDevice);
                        }
                        return;
                    }
                    HierarchyViewerDirector.this.loadViewServerInfoAndWindows(iDevice);
                }
            }
        });
    }

    private void loadViewServerInfoAndWindows(IDevice iDevice) {
        DeviceBridge.ViewServerInfo viewServerInfo = DeviceBridge.loadViewServerInfo(iDevice);
        if (viewServerInfo == null) {
            return;
        }
        Window[] windowArray = DeviceBridge.loadWindows(iDevice);
        DeviceSelectionModel.getModel().addDevice(iDevice, windowArray, viewServerInfo);
        if (viewServerInfo.protocolVersion >= 3) {
            WindowUpdater.startListenForWindowChanges(this, iDevice);
            this.focusChanged(iDevice);
        }
    }

    public void deviceDisconnected(final IDevice iDevice) {
        this.executeInBackground("Disconnecting device", new Runnable(){

            public void run() {
                Window window;
                DeviceBridge.ViewServerInfo viewServerInfo = DeviceBridge.getViewServerInfo(iDevice);
                if (viewServerInfo != null && viewServerInfo.protocolVersion >= 3) {
                    WindowUpdater.stopListenForWindowChanges(HierarchyViewerDirector.this, iDevice);
                }
                DeviceBridge.removeDeviceForward(iDevice);
                DeviceBridge.removeViewServerInfo(iDevice);
                DeviceSelectionModel.getModel().removeDevice(iDevice);
                if (PixelPerfectModel.getModel().getDevice() == iDevice) {
                    PixelPerfectModel.getModel().setData(null, null, null);
                }
                if ((window = TreeViewModel.getModel().getWindow()) != null && window.getDevice() == iDevice) {
                    TreeViewModel.getModel().setData(null, null);
                    HierarchyViewerDirector.this.mFilterText = "";
                }
            }
        });
    }

    public void deviceChanged(IDevice iDevice, int n) {
        if ((n & 1) != 0 && iDevice.isOnline()) {
            this.deviceConnected(iDevice);
        }
    }

    public void windowsChanged(final IDevice iDevice) {
        this.executeInBackground("Refreshing windows", new Runnable(){

            public void run() {
                if (!DeviceBridge.isViewServerRunning(iDevice) && !DeviceBridge.startViewServer(iDevice)) {
                    Log.e(HierarchyViewerDirector.TAG, "Unable to debug device " + iDevice);
                    return;
                }
                Window[] windowArray = DeviceBridge.loadWindows(iDevice);
                DeviceSelectionModel.getModel().updateDevice(iDevice, windowArray);
            }
        });
    }

    public void focusChanged(final IDevice iDevice) {
        this.executeInBackground("Updating focus", new Runnable(){

            public void run() {
                int n = DeviceBridge.getFocusedWindow(iDevice);
                DeviceSelectionModel.getModel().updateFocusedWindow(iDevice, n);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshPixelPerfect() {
        final IDevice iDevice = PixelPerfectModel.getModel().getDevice();
        if (iDevice != null) {
            boolean bl = false;
            HierarchyViewerDirector hierarchyViewerDirector = this;
            synchronized (hierarchyViewerDirector) {
                if (this.mPixelPerfectRefreshesInProgress <= 1) {
                    bl = true;
                    ++this.mPixelPerfectRefreshesInProgress;
                }
            }
            if (bl) {
                this.executeInBackground("Refreshing pixel perfect screenshot", new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Image image = HierarchyViewerDirector.this.getScreenshotImage(iDevice);
                        if (image != null) {
                            PixelPerfectModel.getModel().setImage(image);
                        }
                        HierarchyViewerDirector hierarchyViewerDirector = HierarchyViewerDirector.this;
                        synchronized (hierarchyViewerDirector) {
                            HierarchyViewerDirector.this.mPixelPerfectRefreshesInProgress--;
                        }
                    }
                });
            }
        }
    }

    public void refreshPixelPerfectTree() {
        final IDevice iDevice = PixelPerfectModel.getModel().getDevice();
        if (iDevice != null) {
            this.executeInBackground("Refreshing pixel perfect tree", new Runnable(){

                public void run() {
                    ViewNode viewNode = DeviceBridge.loadWindowData(Window.getFocusedWindow(iDevice));
                    if (viewNode != null) {
                        PixelPerfectModel.getModel().setTree(viewNode);
                    }
                }
            });
        }
    }

    public void loadPixelPerfectData(final IDevice iDevice) {
        this.executeInBackground("Loading pixel perfect data", new Runnable(){

            public void run() {
                ViewNode viewNode;
                Image image = HierarchyViewerDirector.this.getScreenshotImage(iDevice);
                if (image != null && (viewNode = DeviceBridge.loadWindowData(Window.getFocusedWindow(iDevice))) != null) {
                    PixelPerfectModel.getModel().setData(iDevice, image, viewNode);
                }
            }
        });
    }

    private Image getScreenshotImage(IDevice iDevice) {
        try {
            final RawImage rawImage = iDevice.getScreenshot();
            if (rawImage == null) {
                return null;
            }
            class ImageContainer {
                public Image image;

                ImageContainer() {
                }
            }
            final ImageContainer imageContainer = new ImageContainer();
            Display.getDefault().syncExec(new Runnable(){
                {
                }

                public void run() {
                    ImageData imageData = new ImageData(rawImage.width, rawImage.height, rawImage.bpp, new PaletteData(rawImage.getRedMask(), rawImage.getGreenMask(), rawImage.getBlueMask()), 1, rawImage.data);
                    imageContainer.image = new Image((Device)Display.getDefault(), imageData);
                }
            });
            return imageContainer.image;
        }
        catch (IOException iOException) {
            Log.e(TAG, "Unable to load screenshot from device " + iDevice);
        }
        catch (TimeoutException timeoutException) {
            Log.e(TAG, "Timeout loading screenshot from device " + iDevice);
        }
        catch (AdbCommandRejectedException adbCommandRejectedException) {
            Log.e(TAG, "Adb rejected command to load screenshot from device " + iDevice);
        }
        return null;
    }

    public void loadViewTreeData(final Window window) {
        this.executeInBackground("Loading view hierarchy", new Runnable(){

            public void run() {
                HierarchyViewerDirector.this.mFilterText = "";
                ViewNode viewNode = DeviceBridge.loadWindowData(window);
                if (viewNode != null) {
                    DeviceBridge.loadProfileData(window, viewNode);
                    viewNode.setViewCount();
                    TreeViewModel.getModel().setData(window, viewNode);
                }
            }
        });
    }

    public void loadOverlay(final Shell shell) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                FileDialog fileDialog = new FileDialog(shell, 4096);
                fileDialog.setFilterExtensions(new String[]{"*.jpg;*.jpeg;*.png;*.gif;*.bmp"});
                fileDialog.setFilterNames(new String[]{"Image (*.jpg, *.jpeg, *.png, *.gif, *.bmp)"});
                fileDialog.setText("Choose an overlay image");
                String string = fileDialog.open();
                if (string != null) {
                    try {
                        Image image = new Image((Device)Display.getDefault(), string);
                        PixelPerfectModel.getModel().setOverlayImage(image);
                    }
                    catch (SWTException sWTException) {
                        Log.e(HierarchyViewerDirector.TAG, "Unable to load image from " + string);
                    }
                }
            }
        });
    }

    public void showCapture(final Shell shell, final ViewNode viewNode) {
        this.executeInBackground("Capturing node", new Runnable(){

            public void run() {
                final Image image = HierarchyViewerDirector.this.loadCapture(viewNode);
                if (image != null) {
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            CaptureDisplay.show(shell, viewNode, image);
                        }
                    });
                }
            }
        });
    }

    public Image loadCapture(ViewNode viewNode) {
        Image image = DeviceBridge.loadCapture(viewNode.window, viewNode);
        if (image != null) {
            viewNode.image = image;
            TreeViewModel.getModel().notifySelectionChanged();
        }
        return image;
    }

    public void loadCaptureInBackground(final ViewNode viewNode) {
        this.executeInBackground("Capturing node", new Runnable(){

            public void run() {
                HierarchyViewerDirector.this.loadCapture(viewNode);
            }
        });
    }

    public void showCapture(Shell shell) {
        DrawableViewNode drawableViewNode = TreeViewModel.getModel().getSelection();
        if (drawableViewNode != null) {
            this.showCapture(shell, drawableViewNode.viewNode);
        }
    }

    public void refreshWindows() {
        this.executeInBackground("Refreshing windows", new Runnable(){

            public void run() {
                int n;
                IDevice[] iDeviceArray = DeviceSelectionModel.getModel().getDevices();
                IDevice[] iDeviceArray2 = DeviceBridge.getDevices();
                HashSet<IDevice> hashSet = new HashSet<IDevice>();
                for (n = 0; n < iDeviceArray2.length; ++n) {
                    hashSet.add(iDeviceArray2[n]);
                }
                for (n = 0; n < iDeviceArray.length; ++n) {
                    if (hashSet.contains(iDeviceArray[n])) {
                        HierarchyViewerDirector.this.windowsChanged(iDeviceArray[n]);
                        hashSet.remove(iDeviceArray[n]);
                        continue;
                    }
                    HierarchyViewerDirector.this.deviceDisconnected(iDeviceArray[n]);
                }
                for (IDevice iDevice : hashSet) {
                    HierarchyViewerDirector.this.deviceConnected(iDevice);
                }
            }
        });
    }

    public void loadViewHierarchy() {
        Window window = DeviceSelectionModel.getModel().getSelectedWindow();
        if (window != null) {
            this.loadViewTreeData(window);
        }
    }

    public void inspectScreenshot() {
        IDevice iDevice = DeviceSelectionModel.getModel().getSelectedDevice();
        if (iDevice != null) {
            this.loadPixelPerfectData(iDevice);
        }
    }

    public void saveTreeView(final Shell shell) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                final DrawableViewNode drawableViewNode = TreeViewModel.getModel().getTree();
                if (drawableViewNode != null) {
                    FileDialog fileDialog = new FileDialog(shell, 8192);
                    fileDialog.setFilterExtensions(new String[]{"*.png"});
                    fileDialog.setFilterNames(new String[]{"Portable Network Graphics File (*.png)"});
                    fileDialog.setText("Choose where to save the tree image");
                    final String string = fileDialog.open();
                    if (string != null) {
                        HierarchyViewerDirector.this.executeInBackground("Saving tree view", new Runnable(){

                            public void run() {
                                Image image = TreeView.paintToImage(drawableViewNode);
                                ImageLoader imageLoader = new ImageLoader();
                                imageLoader.data = new ImageData[]{image.getImageData()};
                                String string2 = string;
                                if (!string2.toLowerCase().endsWith(".png")) {
                                    string2 = string2 + ".png";
                                }
                                try {
                                    imageLoader.save(string2, 5);
                                }
                                catch (SWTException sWTException) {
                                    Log.e(HierarchyViewerDirector.TAG, "Unable to save tree view as a PNG image at " + string);
                                }
                                image.dispose();
                            }
                        });
                    }
                }
            }
        });
    }

    public void savePixelPerfect(final Shell shell) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                Image image = PixelPerfectModel.getModel().getImage();
                if (image != null) {
                    final ImageData imageData = image.getImageData();
                    FileDialog fileDialog = new FileDialog(shell, 8192);
                    fileDialog.setFilterExtensions(new String[]{"*.png"});
                    fileDialog.setFilterNames(new String[]{"Portable Network Graphics File (*.png)"});
                    fileDialog.setText("Choose where to save the screenshot");
                    final String string = fileDialog.open();
                    if (string != null) {
                        HierarchyViewerDirector.this.executeInBackground("Saving pixel perfect", new Runnable(){

                            public void run() {
                                ImageLoader imageLoader = new ImageLoader();
                                imageLoader.data = new ImageData[]{imageData};
                                String string2 = string;
                                if (!string2.toLowerCase().endsWith(".png")) {
                                    string2 = string2 + ".png";
                                }
                                try {
                                    imageLoader.save(string2, 5);
                                }
                                catch (SWTException sWTException) {
                                    Log.e(HierarchyViewerDirector.TAG, "Unable to save tree view as a PNG image at " + string);
                                }
                            }
                        });
                    }
                }
            }
        });
    }

    public void capturePSD(final Shell shell) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                final Window window = TreeViewModel.getModel().getWindow();
                if (window != null) {
                    FileDialog fileDialog = new FileDialog(shell, 8192);
                    fileDialog.setFilterExtensions(new String[]{"*.psd"});
                    fileDialog.setFilterNames(new String[]{"Photoshop Document (*.psd)"});
                    fileDialog.setText("Choose where to save the window layers");
                    final String string = fileDialog.open();
                    if (string != null) {
                        HierarchyViewerDirector.this.executeInBackground("Saving window layers", new Runnable(){

                            public void run() {
                                PsdFile psdFile = DeviceBridge.captureLayers(window);
                                if (psdFile != null) {
                                    String string2 = string;
                                    if (!string2.toLowerCase().endsWith(".psd")) {
                                        string2 = string2 + ".psd";
                                    }
                                    try {
                                        psdFile.write(new FileOutputStream(string2));
                                    }
                                    catch (FileNotFoundException fileNotFoundException) {
                                        Log.e(HierarchyViewerDirector.TAG, "Unable to write to file " + string);
                                    }
                                }
                            }
                        });
                    }
                }
            }
        });
    }

    public void reloadViewHierarchy() {
        Window window = TreeViewModel.getModel().getWindow();
        if (window != null) {
            this.loadViewTreeData(window);
        }
    }

    public void invalidateCurrentNode() {
        final DrawableViewNode drawableViewNode = TreeViewModel.getModel().getSelection();
        if (drawableViewNode != null) {
            this.executeInBackground("Invalidating view", new Runnable(){

                public void run() {
                    DeviceBridge.invalidateView(drawableViewNode.viewNode);
                }
            });
        }
    }

    public void relayoutCurrentNode() {
        final DrawableViewNode drawableViewNode = TreeViewModel.getModel().getSelection();
        if (drawableViewNode != null) {
            this.executeInBackground("Request layout", new Runnable(){

                public void run() {
                    DeviceBridge.requestLayout(drawableViewNode.viewNode);
                }
            });
        }
    }

    public void dumpDisplayListForCurrentNode() {
        final DrawableViewNode drawableViewNode = TreeViewModel.getModel().getSelection();
        if (drawableViewNode != null) {
            this.executeInBackground("Dump displaylist", new Runnable(){

                public void run() {
                    DeviceBridge.outputDisplayList(drawableViewNode.viewNode);
                }
            });
        }
    }

    public void loadAllViews() {
        this.executeInBackground("Loading all views", new Runnable(){

            public void run() {
                DrawableViewNode drawableViewNode = TreeViewModel.getModel().getTree();
                if (drawableViewNode != null) {
                    HierarchyViewerDirector.this.loadViewRecursive(drawableViewNode.viewNode);
                    TreeViewModel.getModel().notifySelectionChanged();
                }
            }
        });
    }

    private void loadViewRecursive(ViewNode viewNode) {
        Image image = DeviceBridge.loadCapture(viewNode.window, viewNode);
        if (image == null) {
            return;
        }
        viewNode.image = image;
        int n = viewNode.children.size();
        for (int i = 0; i < n; ++i) {
            this.loadViewRecursive(viewNode.children.get(i));
        }
    }

    public void filterNodes(String string) {
        this.mFilterText = string;
        DrawableViewNode drawableViewNode = TreeViewModel.getModel().getTree();
        if (drawableViewNode != null) {
            drawableViewNode.viewNode.filter(string);
            TreeViewModel.getModel().notifySelectionChanged();
        }
    }

    public String getFilterText() {
        return this.mFilterText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPixelPerfectAutoRefresh(boolean bl) {
        Timer timer = this.mPixelPerfectRefreshTimer;
        synchronized (timer) {
            if (bl == this.mAutoRefresh) {
                return;
            }
            this.mAutoRefresh = bl;
            if (this.mAutoRefresh) {
                this.mCurrentAutoRefreshTask = new PixelPerfectAutoRefreshTask();
                this.mPixelPerfectRefreshTimer.schedule((TimerTask)this.mCurrentAutoRefreshTask, this.mPixelPerfectAutoRefreshInterval * 1000, (long)(this.mPixelPerfectAutoRefreshInterval * 1000));
            } else {
                this.mCurrentAutoRefreshTask.cancel();
                this.mCurrentAutoRefreshTask = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPixelPerfectAutoRefreshInterval(int n) {
        Timer timer = this.mPixelPerfectRefreshTimer;
        synchronized (timer) {
            if (this.mPixelPerfectAutoRefreshInterval == n) {
                return;
            }
            this.mPixelPerfectAutoRefreshInterval = n;
            if (this.mAutoRefresh) {
                this.mCurrentAutoRefreshTask.cancel();
                long l = Math.max(0L, (long)(this.mPixelPerfectAutoRefreshInterval * 1000) - (System.currentTimeMillis() - this.mCurrentAutoRefreshTask.scheduledExecutionTime()));
                this.mCurrentAutoRefreshTask = new PixelPerfectAutoRefreshTask();
                this.mPixelPerfectRefreshTimer.schedule((TimerTask)this.mCurrentAutoRefreshTask, l, (long)(this.mPixelPerfectAutoRefreshInterval * 1000));
            }
        }
    }

    public int getPixelPerfectAutoRefreshInverval() {
        return this.mPixelPerfectAutoRefreshInterval;
    }

    private static class PixelPerfectAutoRefreshTask
    extends TimerTask {
        private PixelPerfectAutoRefreshTask() {
        }

        public void run() {
            HierarchyViewerDirector.getDirector().refreshPixelPerfect();
        }
    }
}

