/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewerlib.device;

import com.android.hierarchyviewerlib.device.Window;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.swt.graphics.Image;

public class ViewNode {
    private static final double RED_THRESHOLD = 0.8;
    private static final double YELLOW_THRESHOLD = 0.5;
    public static final String MISCELLANIOUS = "miscellaneous";
    public String id;
    public String name;
    public String hashCode;
    public List<Property> properties = new ArrayList<Property>();
    public Map<String, Property> namedProperties = new HashMap<String, Property>();
    public ViewNode parent;
    public List<ViewNode> children = new ArrayList<ViewNode>();
    public int left;
    public int top;
    public int width;
    public int height;
    public int scrollX;
    public int scrollY;
    public int paddingLeft;
    public int paddingRight;
    public int paddingTop;
    public int paddingBottom;
    public int marginLeft;
    public int marginRight;
    public int marginTop;
    public int marginBottom;
    public int baseline;
    public boolean willNotDraw;
    public boolean hasMargins;
    public boolean hasFocus;
    public int index;
    public double measureTime;
    public double layoutTime;
    public double drawTime;
    public ProfileRating measureRating = ProfileRating.NONE;
    public ProfileRating layoutRating = ProfileRating.NONE;
    public ProfileRating drawRating = ProfileRating.NONE;
    public Set<String> categories = new TreeSet<String>();
    public Window window;
    public Image image;
    public int imageReferences = 1;
    public int viewCount;
    public boolean filtered;
    public int protocolVersion;

    public ViewNode(Window window, ViewNode viewNode, String string) {
        this.window = window;
        this.parent = viewNode;
        int n = this.index = this.parent == null ? 0 : this.parent.children.size();
        if (this.parent != null) {
            this.parent.children.add(this);
        }
        int n2 = string.indexOf(64);
        this.name = string.substring(0, n2);
        string = string.substring(n2 + 1);
        n2 = string.indexOf(32);
        this.hashCode = string.substring(0, n2);
        this.loadProperties(string.substring(n2 + 1).trim());
        this.measureTime = -1.0;
        this.layoutTime = -1.0;
        this.drawTime = -1.0;
    }

    public void dispose() {
        int n = this.children.size();
        for (int i = 0; i < n; ++i) {
            this.children.get(i).dispose();
        }
        this.dereferenceImage();
    }

    public void referenceImage() {
        ++this.imageReferences;
    }

    public void dereferenceImage() {
        --this.imageReferences;
        if (this.image != null && this.imageReferences == 0) {
            this.image.dispose();
        }
    }

    private void loadProperties(String string) {
        int n;
        boolean bl;
        int n2 = 0;
        do {
            int n3 = string.indexOf(61, n2);
            Property object = new Property();
            object.name = string.substring(n2, n3);
            n = string.indexOf(44, n3 + 1);
            int n4 = Integer.parseInt(string.substring(n3 + 1, n));
            n2 = n + 1 + n4;
            object.value = string.substring(n + 1, n + 1 + n4);
            this.properties.add(object);
            this.namedProperties.put(object.name, object);
            boolean bl2 = bl = n2 >= string.length();
            if (bl) continue;
            ++n2;
        } while (!bl);
        Collections.sort(this.properties, new Comparator<Property>(){

            @Override
            public int compare(Property property, Property property2) {
                return property.name.compareTo(property2.name);
            }
        });
        this.id = this.namedProperties.get((Object)"mID").value;
        this.left = this.namedProperties.containsKey("mLeft") ? this.getInt("mLeft", 0) : this.getInt("layout:mLeft", 0);
        this.top = this.namedProperties.containsKey("mTop") ? this.getInt("mTop", 0) : this.getInt("layout:mTop", 0);
        this.width = this.namedProperties.containsKey("getWidth()") ? this.getInt("getWidth()", 0) : this.getInt("layout:getWidth()", 0);
        this.height = this.namedProperties.containsKey("getHeight()") ? this.getInt("getHeight()", 0) : this.getInt("layout:getHeight()", 0);
        this.scrollX = this.namedProperties.containsKey("mScrollX") ? this.getInt("mScrollX", 0) : this.getInt("scrolling:mScrollX", 0);
        this.scrollY = this.namedProperties.containsKey("mScrollY") ? this.getInt("mScrollY", 0) : this.getInt("scrolling:mScrollY", 0);
        this.paddingLeft = this.namedProperties.containsKey("mPaddingLeft") ? this.getInt("mPaddingLeft", 0) : this.getInt("padding:mPaddingLeft", 0);
        this.paddingRight = this.namedProperties.containsKey("mPaddingRight") ? this.getInt("mPaddingRight", 0) : this.getInt("padding:mPaddingRight", 0);
        this.paddingTop = this.namedProperties.containsKey("mPaddingTop") ? this.getInt("mPaddingTop", 0) : this.getInt("padding:mPaddingTop", 0);
        this.paddingBottom = this.namedProperties.containsKey("mPaddingBottom") ? this.getInt("mPaddingBottom", 0) : this.getInt("padding:mPaddingBottom", 0);
        this.marginLeft = this.namedProperties.containsKey("layout_leftMargin") ? this.getInt("layout_leftMargin", Integer.MIN_VALUE) : this.getInt("layout:layout_leftMargin", Integer.MIN_VALUE);
        this.marginRight = this.namedProperties.containsKey("layout_rightMargin") ? this.getInt("layout_rightMargin", Integer.MIN_VALUE) : this.getInt("layout:layout_rightMargin", Integer.MIN_VALUE);
        this.marginTop = this.namedProperties.containsKey("layout_topMargin") ? this.getInt("layout_topMargin", Integer.MIN_VALUE) : this.getInt("layout:layout_topMargin", Integer.MIN_VALUE);
        this.marginBottom = this.namedProperties.containsKey("layout_bottomMargin") ? this.getInt("layout_bottomMargin", Integer.MIN_VALUE) : this.getInt("layout:layout_bottomMargin", Integer.MIN_VALUE);
        this.baseline = this.namedProperties.containsKey("getBaseline()") ? this.getInt("getBaseline()", 0) : this.getInt("layout:getBaseline()", 0);
        this.willNotDraw = this.namedProperties.containsKey("willNotDraw()") ? this.getBoolean("willNotDraw()", false) : this.getBoolean("drawing:willNotDraw()", false);
        this.hasFocus = this.namedProperties.containsKey("hasFocus()") ? this.getBoolean("hasFocus()", false) : this.getBoolean("focus:hasFocus()", false);
        this.hasMargins = this.marginLeft != Integer.MIN_VALUE && this.marginRight != Integer.MIN_VALUE && this.marginTop != Integer.MIN_VALUE && this.marginBottom != Integer.MIN_VALUE;
        for (String string2 : this.namedProperties.keySet()) {
            n = string2.indexOf(58);
            if (n == -1) continue;
            this.categories.add(string2.substring(0, n));
        }
        if (this.categories.size() != 0) {
            this.categories.add(MISCELLANIOUS);
        }
    }

    public void setProfileRatings() {
        int n = this.children.size();
        if (n > 1) {
            ViewNode viewNode;
            int n2;
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            for (n2 = 0; n2 < n; ++n2) {
                viewNode = this.children.get(n2);
                d += viewNode.measureTime;
                d2 += viewNode.layoutTime;
                d3 += viewNode.drawTime;
            }
            for (n2 = 0; n2 < n; ++n2) {
                viewNode = this.children.get(n2);
                viewNode.measureRating = viewNode.measureTime / d >= 0.8 ? ProfileRating.RED : (viewNode.measureTime / d >= 0.5 ? ProfileRating.YELLOW : ProfileRating.GREEN);
                viewNode.layoutRating = viewNode.layoutTime / d2 >= 0.8 ? ProfileRating.RED : (viewNode.layoutTime / d2 >= 0.5 ? ProfileRating.YELLOW : ProfileRating.GREEN);
                viewNode.drawRating = viewNode.drawTime / d3 >= 0.8 ? ProfileRating.RED : (viewNode.drawTime / d3 >= 0.5 ? ProfileRating.YELLOW : ProfileRating.GREEN);
            }
        }
        for (int i = 0; i < n; ++i) {
            this.children.get(i).setProfileRatings();
        }
    }

    public void setViewCount() {
        this.viewCount = 1;
        int n = this.children.size();
        for (int i = 0; i < n; ++i) {
            ViewNode viewNode = this.children.get(i);
            viewNode.setViewCount();
            this.viewCount += viewNode.viewCount;
        }
    }

    public void filter(String string) {
        int n = this.name.lastIndexOf(46);
        String string2 = n == -1 ? this.name : this.name.substring(n + 1);
        this.filtered = !string.equals("") && (string2.toLowerCase().contains(string.toLowerCase()) || !this.id.equals("NO_ID") && this.id.toLowerCase().contains(string.toLowerCase()));
        int n2 = this.children.size();
        for (int i = 0; i < n2; ++i) {
            this.children.get(i).filter(string);
        }
    }

    private boolean getBoolean(String string, boolean bl) {
        Property property = this.namedProperties.get(string);
        if (property != null) {
            try {
                return Boolean.parseBoolean(property.value);
            }
            catch (NumberFormatException numberFormatException) {
                return bl;
            }
        }
        return bl;
    }

    private int getInt(String string, int n) {
        Property property = this.namedProperties.get(string);
        if (property != null) {
            try {
                return Integer.parseInt(property.value);
            }
            catch (NumberFormatException numberFormatException) {
                return n;
            }
        }
        return n;
    }

    public String toString() {
        return this.name + "@" + this.hashCode;
    }

    public static class Property {
        public String name;
        public String value;

        public String toString() {
            return this.name + '=' + this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ProfileRating {
        RED,
        YELLOW,
        GREEN,
        NONE;

    }
}

