/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewerlib.models;

import com.android.ddmlib.IDevice;
import com.android.hierarchyviewerlib.device.ViewNode;
import java.util.ArrayList;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class PixelPerfectModel {
    public static final int MIN_ZOOM = 2;
    public static final int MAX_ZOOM = 24;
    public static final int DEFAULT_ZOOM = 8;
    public static final int DEFAULT_OVERLAY_TRANSPARENCY_PERCENTAGE = 50;
    private IDevice mDevice;
    private Image mImage;
    private Point mCrosshairLocation;
    private ViewNode mViewNode;
    private ViewNode mSelectedNode;
    private int mZoom;
    private final ArrayList<IImageChangeListener> mImageChangeListeners = new ArrayList();
    private Image mOverlayImage;
    private double mOverlayTransparency = 0.5;
    private static PixelPerfectModel sModel;

    public static PixelPerfectModel getModel() {
        if (sModel == null) {
            sModel = new PixelPerfectModel();
        }
        return sModel;
    }

    public void setData(final IDevice iDevice, final Image image, final ViewNode viewNode) {
        final Image image2 = this.mImage;
        final Image image3 = this.mOverlayImage;
        Display.getDefault().syncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                PixelPerfectModel pixelPerfectModel = PixelPerfectModel.this;
                synchronized (pixelPerfectModel) {
                    PixelPerfectModel.this.mDevice = iDevice;
                    PixelPerfectModel.this.mImage = image;
                    PixelPerfectModel.this.mViewNode = viewNode;
                    if (image != null) {
                        PixelPerfectModel.this.mCrosshairLocation = new Point(image.getBounds().width / 2, image.getBounds().height / 2);
                    } else {
                        PixelPerfectModel.this.mCrosshairLocation = null;
                    }
                    PixelPerfectModel.this.mOverlayImage = null;
                    PixelPerfectModel.this.mSelectedNode = null;
                    PixelPerfectModel.this.mZoom = 8;
                }
            }
        });
        this.notifyImageLoaded();
        if (image2 != null) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    image2.dispose();
                }
            });
        }
        if (image3 != null) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    image3.dispose();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCrosshairLocation(int n, int n2) {
        PixelPerfectModel pixelPerfectModel = this;
        synchronized (pixelPerfectModel) {
            this.mCrosshairLocation = new Point(n, n2);
        }
        this.notifyCrosshairMoved();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelected(ViewNode viewNode) {
        PixelPerfectModel pixelPerfectModel = this;
        synchronized (pixelPerfectModel) {
            this.mSelectedNode = viewNode;
        }
        this.notifySelectionChanged();
    }

    public void setTree(final ViewNode viewNode) {
        Display.getDefault().syncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                PixelPerfectModel pixelPerfectModel = PixelPerfectModel.this;
                synchronized (pixelPerfectModel) {
                    PixelPerfectModel.this.mViewNode = viewNode;
                    PixelPerfectModel.this.mSelectedNode = null;
                }
            }
        });
        this.notifyTreeChanged();
    }

    public void setImage(final Image image) {
        final Image image2 = this.mImage;
        Display.getDefault().syncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                PixelPerfectModel pixelPerfectModel = PixelPerfectModel.this;
                synchronized (pixelPerfectModel) {
                    PixelPerfectModel.this.mImage = image;
                }
            }
        });
        this.notifyImageChanged();
        if (image2 != null) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    image2.dispose();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setZoom(int n) {
        PixelPerfectModel pixelPerfectModel = this;
        synchronized (pixelPerfectModel) {
            if (n < 2) {
                n = 2;
            }
            if (n > 24) {
                n = 24;
            }
            this.mZoom = n;
        }
        this.notifyZoomChanged();
    }

    public void setOverlayImage(final Image image) {
        final Image image2 = this.mOverlayImage;
        Display.getDefault().syncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                PixelPerfectModel pixelPerfectModel = PixelPerfectModel.this;
                synchronized (pixelPerfectModel) {
                    PixelPerfectModel.this.mOverlayImage = image;
                }
            }
        });
        this.notifyOverlayChanged();
        if (image2 != null) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    image2.dispose();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOverlayTransparency(double d) {
        PixelPerfectModel pixelPerfectModel = this;
        synchronized (pixelPerfectModel) {
            d = Math.max(d, 0.0);
            this.mOverlayTransparency = d = Math.min(d, 1.0);
        }
        this.notifyOverlayTransparencyChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ViewNode getViewNode() {
        PixelPerfectModel pixelPerfectModel = this;
        synchronized (pixelPerfectModel) {
            return this.mViewNode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point getCrosshairLocation() {
        PixelPerfectModel pixelPerfectModel = this;
        synchronized (pixelPerfectModel) {
            return this.mCrosshairLocation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImage() {
        PixelPerfectModel pixelPerfectModel = this;
        synchronized (pixelPerfectModel) {
            return this.mImage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ViewNode getSelected() {
        PixelPerfectModel pixelPerfectModel = this;
        synchronized (pixelPerfectModel) {
            return this.mSelectedNode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDevice getDevice() {
        PixelPerfectModel pixelPerfectModel = this;
        synchronized (pixelPerfectModel) {
            return this.mDevice;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getZoom() {
        PixelPerfectModel pixelPerfectModel = this;
        synchronized (pixelPerfectModel) {
            return this.mZoom;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getOverlayImage() {
        PixelPerfectModel pixelPerfectModel = this;
        synchronized (pixelPerfectModel) {
            return this.mOverlayImage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getOverlayTransparency() {
        PixelPerfectModel pixelPerfectModel = this;
        synchronized (pixelPerfectModel) {
            return this.mOverlayTransparency;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IImageChangeListener[] getImageChangeListenerList() {
        IImageChangeListener[] iImageChangeListenerArray = null;
        ArrayList<IImageChangeListener> arrayList = this.mImageChangeListeners;
        synchronized (arrayList) {
            if (this.mImageChangeListeners.size() == 0) {
                return null;
            }
            iImageChangeListenerArray = this.mImageChangeListeners.toArray(new IImageChangeListener[this.mImageChangeListeners.size()]);
        }
        return iImageChangeListenerArray;
    }

    public void notifyImageLoaded() {
        IImageChangeListener[] iImageChangeListenerArray = this.getImageChangeListenerList();
        if (iImageChangeListenerArray != null) {
            for (int i = 0; i < iImageChangeListenerArray.length; ++i) {
                iImageChangeListenerArray[i].imageLoaded();
            }
        }
    }

    public void notifyImageChanged() {
        IImageChangeListener[] iImageChangeListenerArray = this.getImageChangeListenerList();
        if (iImageChangeListenerArray != null) {
            for (int i = 0; i < iImageChangeListenerArray.length; ++i) {
                iImageChangeListenerArray[i].imageChanged();
            }
        }
    }

    public void notifyCrosshairMoved() {
        IImageChangeListener[] iImageChangeListenerArray = this.getImageChangeListenerList();
        if (iImageChangeListenerArray != null) {
            for (int i = 0; i < iImageChangeListenerArray.length; ++i) {
                iImageChangeListenerArray[i].crosshairMoved();
            }
        }
    }

    public void notifySelectionChanged() {
        IImageChangeListener[] iImageChangeListenerArray = this.getImageChangeListenerList();
        if (iImageChangeListenerArray != null) {
            for (int i = 0; i < iImageChangeListenerArray.length; ++i) {
                iImageChangeListenerArray[i].selectionChanged();
            }
        }
    }

    public void notifyTreeChanged() {
        IImageChangeListener[] iImageChangeListenerArray = this.getImageChangeListenerList();
        if (iImageChangeListenerArray != null) {
            for (int i = 0; i < iImageChangeListenerArray.length; ++i) {
                iImageChangeListenerArray[i].treeChanged();
            }
        }
    }

    public void notifyZoomChanged() {
        IImageChangeListener[] iImageChangeListenerArray = this.getImageChangeListenerList();
        if (iImageChangeListenerArray != null) {
            for (int i = 0; i < iImageChangeListenerArray.length; ++i) {
                iImageChangeListenerArray[i].zoomChanged();
            }
        }
    }

    public void notifyOverlayChanged() {
        IImageChangeListener[] iImageChangeListenerArray = this.getImageChangeListenerList();
        if (iImageChangeListenerArray != null) {
            for (int i = 0; i < iImageChangeListenerArray.length; ++i) {
                iImageChangeListenerArray[i].overlayChanged();
            }
        }
    }

    public void notifyOverlayTransparencyChanged() {
        IImageChangeListener[] iImageChangeListenerArray = this.getImageChangeListenerList();
        if (iImageChangeListenerArray != null) {
            for (int i = 0; i < iImageChangeListenerArray.length; ++i) {
                iImageChangeListenerArray[i].overlayTransparencyChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImageChangeListener(IImageChangeListener iImageChangeListener) {
        ArrayList<IImageChangeListener> arrayList = this.mImageChangeListeners;
        synchronized (arrayList) {
            this.mImageChangeListeners.add(iImageChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeImageChangeListener(IImageChangeListener iImageChangeListener) {
        ArrayList<IImageChangeListener> arrayList = this.mImageChangeListeners;
        synchronized (arrayList) {
            this.mImageChangeListeners.remove(iImageChangeListener);
        }
    }

    public static interface IImageChangeListener {
        public void imageLoaded();

        public void imageChanged();

        public void crosshairMoved();

        public void selectionChanged();

        public void treeChanged();

        public void zoomChanged();

        public void overlayChanged();

        public void overlayTransparencyChanged();
    }
}

