/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewerlib.ui;

import com.android.hierarchyviewerlib.HierarchyViewerDirector;
import com.android.hierarchyviewerlib.models.TreeViewModel;
import com.android.hierarchyviewerlib.ui.util.DrawableViewNode;
import java.util.ArrayList;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class LayoutViewer
extends Canvas
implements TreeViewModel.ITreeChangeListener {
    private TreeViewModel mModel;
    private DrawableViewNode mTree;
    private DrawableViewNode mSelectedNode;
    private Transform mTransform;
    private Transform mInverse;
    private double mScale;
    private boolean mShowExtras = false;
    private boolean mOnBlack = true;
    private DisposeListener mDisposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent disposeEvent) {
            LayoutViewer.this.mModel.removeTreeChangeListener(LayoutViewer.this);
            LayoutViewer.this.mTransform.dispose();
            LayoutViewer.this.mInverse.dispose();
            if (LayoutViewer.this.mSelectedNode != null) {
                ((LayoutViewer)LayoutViewer.this).mSelectedNode.viewNode.dereferenceImage();
            }
        }
    };
    private Listener mResizeListener = new Listener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleEvent(Event event) {
            2 var2_2 = this;
            synchronized (var2_2) {
                LayoutViewer.this.setTransform();
            }
        }
    };
    private MouseListener mMouseListener = new MouseListener(){

        public void mouseDoubleClick(MouseEvent mouseEvent) {
            if (LayoutViewer.this.mSelectedNode != null) {
                HierarchyViewerDirector.getDirector().showCapture(LayoutViewer.this.getShell(), ((LayoutViewer)LayoutViewer.this).mSelectedNode.viewNode);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseDown(MouseEvent mouseEvent) {
            boolean bl = false;
            DrawableViewNode drawableViewNode = null;
            LayoutViewer layoutViewer = LayoutViewer.this;
            synchronized (layoutViewer) {
                if (LayoutViewer.this.mTree != null) {
                    float[] fArray = new float[]{mouseEvent.x, mouseEvent.y};
                    LayoutViewer.this.mInverse.transform(fArray);
                    drawableViewNode = LayoutViewer.this.updateSelection(LayoutViewer.this.mTree, fArray[0], fArray[1], 0, 0, 0, 0, ((LayoutViewer)LayoutViewer.this).mTree.viewNode.width, ((LayoutViewer)LayoutViewer.this).mTree.viewNode.height);
                    if (LayoutViewer.this.mSelectedNode != drawableViewNode) {
                        bl = true;
                    }
                }
            }
            if (bl) {
                LayoutViewer.this.mModel.setSelection(drawableViewNode);
            }
        }

        public void mouseUp(MouseEvent mouseEvent) {
        }
    };
    private PaintListener mPaintListener = new PaintListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paintControl(PaintEvent paintEvent) {
            LayoutViewer layoutViewer = LayoutViewer.this;
            synchronized (layoutViewer) {
                if (LayoutViewer.this.mOnBlack) {
                    paintEvent.gc.setBackground(Display.getDefault().getSystemColor(2));
                } else {
                    paintEvent.gc.setBackground(Display.getDefault().getSystemColor(1));
                }
                paintEvent.gc.fillRectangle(0, 0, LayoutViewer.this.getBounds().width, LayoutViewer.this.getBounds().height);
                if (LayoutViewer.this.mTree != null) {
                    paintEvent.gc.setLineWidth((int)Math.ceil(0.3 / LayoutViewer.this.mScale));
                    paintEvent.gc.setTransform(LayoutViewer.this.mTransform);
                    if (LayoutViewer.this.mOnBlack) {
                        paintEvent.gc.setForeground(Display.getDefault().getSystemColor(1));
                    } else {
                        paintEvent.gc.setForeground(Display.getDefault().getSystemColor(2));
                    }
                    Rectangle rectangle = paintEvent.gc.getClipping();
                    paintEvent.gc.setClipping(0, 0, ((LayoutViewer)LayoutViewer.this).mTree.viewNode.width + (int)Math.ceil(0.3 / LayoutViewer.this.mScale), ((LayoutViewer)LayoutViewer.this).mTree.viewNode.height + (int)Math.ceil(0.3 / LayoutViewer.this.mScale));
                    LayoutViewer.this.paintRecursive(paintEvent.gc, LayoutViewer.this.mTree, 0, 0, true);
                    if (LayoutViewer.this.mSelectedNode != null) {
                        paintEvent.gc.setClipping(rectangle);
                        ArrayList<DrawableViewNode.Point> arrayList = new ArrayList<DrawableViewNode.Point>();
                        int n = 0;
                        int n2 = 0;
                        DrawableViewNode drawableViewNode = LayoutViewer.this.mSelectedNode;
                        while (drawableViewNode != LayoutViewer.this.mTree) {
                            n += drawableViewNode.viewNode.left;
                            n2 += drawableViewNode.viewNode.top;
                            drawableViewNode = drawableViewNode.parent;
                            arrayList.add(new DrawableViewNode.Point(n -= drawableViewNode.viewNode.scrollX, n2 -= drawableViewNode.viewNode.scrollY));
                        }
                        paintEvent.gc.setForeground(Display.getDefault().getSystemColor(4));
                        drawableViewNode = ((LayoutViewer)LayoutViewer.this).mSelectedNode.parent;
                        int n3 = arrayList.size();
                        for (int i = 0; i < n3; ++i) {
                            paintEvent.gc.drawRectangle((int)((double)n - ((DrawableViewNode.Point)arrayList.get((int)i)).x), (int)((double)n2 - ((DrawableViewNode.Point)arrayList.get((int)i)).y), drawableViewNode.viewNode.width, drawableViewNode.viewNode.height);
                            drawableViewNode = drawableViewNode.parent;
                        }
                        if (LayoutViewer.this.mShowExtras && ((LayoutViewer)LayoutViewer.this).mSelectedNode.viewNode.image != null) {
                            paintEvent.gc.drawImage(((LayoutViewer)LayoutViewer.this).mSelectedNode.viewNode.image, n, n2);
                            if (LayoutViewer.this.mOnBlack) {
                                paintEvent.gc.setForeground(Display.getDefault().getSystemColor(1));
                            } else {
                                paintEvent.gc.setForeground(Display.getDefault().getSystemColor(2));
                            }
                            LayoutViewer.this.paintRecursive(paintEvent.gc, LayoutViewer.this.mSelectedNode, n, n2, true);
                        }
                        paintEvent.gc.setForeground(Display.getDefault().getSystemColor(3));
                        paintEvent.gc.setLineWidth((int)Math.ceil(2.0 / LayoutViewer.this.mScale));
                        paintEvent.gc.drawRectangle(n, n2, ((LayoutViewer)LayoutViewer.this).mSelectedNode.viewNode.width, ((LayoutViewer)LayoutViewer.this).mSelectedNode.viewNode.height);
                    }
                }
            }
        }
    };

    public LayoutViewer(Composite composite) {
        super(composite, 0);
        this.mModel = TreeViewModel.getModel();
        this.mModel.addTreeChangeListener(this);
        this.addDisposeListener(this.mDisposeListener);
        this.addPaintListener(this.mPaintListener);
        this.addListener(11, this.mResizeListener);
        this.addMouseListener(this.mMouseListener);
        this.mTransform = new Transform((Device)Display.getDefault());
        this.mInverse = new Transform((Device)Display.getDefault());
        this.treeChanged();
    }

    public void setShowExtras(boolean bl) {
        this.mShowExtras = bl;
        this.doRedraw();
    }

    public void setOnBlack(boolean bl) {
        this.mOnBlack = bl;
        this.doRedraw();
    }

    public boolean getOnBlack() {
        return this.mOnBlack;
    }

    private DrawableViewNode updateSelection(DrawableViewNode drawableViewNode, float f, float f2, int n, int n2, int n3, int n4, int n5, int n6) {
        if (!drawableViewNode.treeDrawn) {
            return null;
        }
        int n7 = Math.max(n, n3);
        int n8 = Math.min(n + drawableViewNode.viewNode.width, n3 + n5);
        int n9 = Math.max(n2, n4);
        int n10 = Math.min(n2 + drawableViewNode.viewNode.height, n4 + n6);
        n3 = n7;
        n4 = n9;
        n5 = n8 - n7;
        n6 = n10 - n9;
        if (f < (float)n3 || f > (float)(n3 + n5) || f2 < (float)n4 || f2 > (float)(n4 + n6)) {
            return null;
        }
        int n11 = drawableViewNode.children.size();
        for (int i = n11 - 1; i >= 0; --i) {
            DrawableViewNode drawableViewNode2 = drawableViewNode.children.get(i);
            DrawableViewNode drawableViewNode3 = this.updateSelection(drawableViewNode2, f, f2, n + drawableViewNode2.viewNode.left - drawableViewNode.viewNode.scrollX, n2 + drawableViewNode2.viewNode.top - drawableViewNode.viewNode.scrollY, n3, n4, n5, n6);
            if (drawableViewNode3 == null) continue;
            return drawableViewNode3;
        }
        return drawableViewNode;
    }

    private void paintRecursive(GC gC, DrawableViewNode drawableViewNode, int n, int n2, boolean bl) {
        if (!drawableViewNode.treeDrawn) {
            return;
        }
        if (!bl) {
            n += drawableViewNode.viewNode.left;
            n2 += drawableViewNode.viewNode.top;
        }
        Rectangle rectangle = gC.getClipping();
        int n3 = Math.max(rectangle.x, n);
        int n4 = Math.min(rectangle.x + rectangle.width, n + drawableViewNode.viewNode.width + (int)Math.ceil(0.3 / this.mScale));
        int n5 = Math.max(rectangle.y, n2);
        int n6 = Math.min(rectangle.y + rectangle.height, n2 + drawableViewNode.viewNode.height + (int)Math.ceil(0.3 / this.mScale));
        if (n4 <= n3 || n6 <= n5) {
            return;
        }
        gC.setClipping(n3, n5, n4 - n3, n6 - n5);
        int n7 = drawableViewNode.children.size();
        for (int i = 0; i < n7; ++i) {
            this.paintRecursive(gC, drawableViewNode.children.get(i), n - drawableViewNode.viewNode.scrollX, n2 - drawableViewNode.viewNode.scrollY, false);
        }
        gC.setClipping(rectangle);
        if (!drawableViewNode.viewNode.willNotDraw) {
            gC.drawRectangle(n, n2, drawableViewNode.viewNode.width, drawableViewNode.viewNode.height);
        }
    }

    private void doRedraw() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                LayoutViewer.this.redraw();
            }
        });
    }

    private void setTransform() {
        if (this.mTree != null) {
            Rectangle rectangle = this.getBounds();
            int n = rectangle.width <= 30 ? 0 : 5;
            int n2 = rectangle.height <= 30 ? 0 : 5;
            this.mScale = Math.min(1.0 * (double)(rectangle.width - n * 2) / (double)this.mTree.viewNode.width, 1.0 * (double)(rectangle.height - n2 * 2) / (double)this.mTree.viewNode.height);
            int n3 = (int)Math.ceil((double)this.mTree.viewNode.width * this.mScale);
            int n4 = (int)Math.ceil((double)this.mTree.viewNode.height * this.mScale);
            this.mTransform.identity();
            this.mInverse.identity();
            this.mTransform.translate((float)(rectangle.width - n3) / 2.0f, (float)(rectangle.height - n4) / 2.0f);
            this.mInverse.translate((float)(rectangle.width - n3) / 2.0f, (float)(rectangle.height - n4) / 2.0f);
            this.mTransform.scale((float)this.mScale, (float)this.mScale);
            this.mInverse.scale((float)this.mScale, (float)this.mScale);
            if (rectangle.width != 0 && rectangle.height != 0) {
                this.mInverse.invert();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectionChanged() {
        LayoutViewer layoutViewer = this;
        synchronized (layoutViewer) {
            if (this.mSelectedNode != null) {
                this.mSelectedNode.viewNode.dereferenceImage();
            }
            this.mSelectedNode = this.mModel.getSelection();
            if (this.mSelectedNode != null) {
                this.mSelectedNode.viewNode.referenceImage();
            }
        }
        this.doRedraw();
    }

    public void treeChanged() {
        Display.getDefault().syncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                6 var1_1 = this;
                synchronized (var1_1) {
                    if (LayoutViewer.this.mSelectedNode != null) {
                        ((LayoutViewer)LayoutViewer.this).mSelectedNode.viewNode.dereferenceImage();
                    }
                    LayoutViewer.this.mTree = LayoutViewer.this.mModel.getTree();
                    LayoutViewer.this.mSelectedNode = LayoutViewer.this.mModel.getSelection();
                    if (LayoutViewer.this.mSelectedNode != null) {
                        ((LayoutViewer)LayoutViewer.this).mSelectedNode.viewNode.referenceImage();
                    }
                    LayoutViewer.this.setTransform();
                }
            }
        });
        this.doRedraw();
    }

    public void viewportChanged() {
    }

    public void zoomChanged() {
    }
}

