/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewerlib.ui;

import com.android.hierarchyviewerlib.HierarchyViewerDirector;
import com.android.hierarchyviewerlib.models.PixelPerfectModel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Slider;

public class PixelPerfectControls
extends Composite
implements PixelPerfectModel.IImageChangeListener {
    private Slider mOverlaySlider;
    private Slider mZoomSlider;
    private Slider mAutoRefreshSlider;
    private DisposeListener mDisposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent disposeEvent) {
            PixelPerfectModel.getModel().removeImageChangeListener(PixelPerfectControls.this);
        }
    };
    private SelectionListener overlaySliderSelectionListener = new SelectionListener(){
        private int oldValue;

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            int n = PixelPerfectControls.this.mOverlaySlider.getSelection();
            if (this.oldValue != n) {
                PixelPerfectModel.getModel().removeImageChangeListener(PixelPerfectControls.this);
                PixelPerfectModel.getModel().setOverlayTransparency((double)n / 100.0);
                PixelPerfectModel.getModel().addImageChangeListener(PixelPerfectControls.this);
                this.oldValue = n;
            }
        }
    };
    private SelectionListener mRefreshSliderSelectionListener = new SelectionListener(){
        private int oldValue;

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            int n = PixelPerfectControls.this.mAutoRefreshSlider.getSelection();
            if (this.oldValue != n) {
                HierarchyViewerDirector.getDirector().setPixelPerfectAutoRefreshInterval(n);
            }
        }
    };
    private SelectionListener mZoomSliderSelectionListener = new SelectionListener(){
        private int oldValue;

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            int n = PixelPerfectControls.this.mZoomSlider.getSelection();
            if (this.oldValue != n) {
                PixelPerfectModel.getModel().removeImageChangeListener(PixelPerfectControls.this);
                PixelPerfectModel.getModel().setZoom(n);
                PixelPerfectModel.getModel().addImageChangeListener(PixelPerfectControls.this);
                this.oldValue = n;
            }
        }
    };

    public PixelPerfectControls(Composite composite) {
        super(composite, 0);
        this.setLayout((Layout)new FormLayout());
        Label label = new Label((Composite)this, 0);
        label.setText("100%");
        FormData formData = new FormData();
        formData.right = new FormAttachment(100, -2);
        formData.top = new FormAttachment(0, 2);
        label.setLayoutData((Object)formData);
        Label label2 = new Label((Composite)this, 0);
        label2.setText("40s");
        FormData formData2 = new FormData();
        formData2.right = new FormAttachment(100, -2);
        formData2.top = new FormAttachment((Control)label, 2);
        formData2.left = new FormAttachment((Control)label, 0, 16384);
        label2.setLayoutData((Object)formData2);
        Label label3 = new Label((Composite)this, 0);
        label3.setText("24x");
        FormData formData3 = new FormData();
        formData3.right = new FormAttachment(100, -2);
        formData3.top = new FormAttachment((Control)label2, 2);
        formData3.left = new FormAttachment((Control)label, 0, 16384);
        label3.setLayoutData((Object)formData3);
        Label label4 = new Label((Composite)this, 0);
        Label label5 = new Label((Composite)this, 0);
        label4.setText("Overlay:");
        FormData formData4 = new FormData();
        formData4.left = new FormAttachment(0, 2);
        formData4.top = new FormAttachment(0, 2);
        formData4.right = new FormAttachment((Control)label5, 0, 131072);
        label4.setLayoutData((Object)formData4);
        label5.setText("Refresh Rate:");
        FormData formData5 = new FormData();
        formData5.top = new FormAttachment((Control)label4, 2);
        formData5.left = new FormAttachment(0, 2);
        label5.setLayoutData((Object)formData5);
        Label label6 = new Label((Composite)this, 0);
        label6.setText("Zoom:");
        FormData formData6 = new FormData();
        formData6.right = new FormAttachment((Control)label5, 0, 131072);
        formData6.top = new FormAttachment((Control)label5, 2);
        formData6.left = new FormAttachment(0, 2);
        label6.setLayoutData((Object)formData6);
        Label label7 = new Label((Composite)this, 131072);
        label7.setText("0%");
        FormData formData7 = new FormData();
        formData7.top = new FormAttachment(0, 2);
        formData7.left = new FormAttachment((Control)label4, 2);
        label7.setLayoutData((Object)formData7);
        Label label8 = new Label((Composite)this, 131072);
        label8.setText("1s");
        FormData formData8 = new FormData();
        formData8.top = new FormAttachment((Control)label7, 2);
        formData8.left = new FormAttachment((Control)label5, 2);
        label8.setLayoutData((Object)formData8);
        Label label9 = new Label((Composite)this, 131072);
        label9.setText("2x");
        FormData formData9 = new FormData();
        formData9.top = new FormAttachment((Control)label8, 2);
        formData9.left = new FormAttachment((Control)label6, 2);
        label9.setLayoutData((Object)formData9);
        this.mOverlaySlider = new Slider((Composite)this, 256);
        this.mOverlaySlider.setMinimum(0);
        this.mOverlaySlider.setMaximum(101);
        this.mOverlaySlider.setThumb(1);
        this.mOverlaySlider.setSelection((int)Math.round(PixelPerfectModel.getModel().getOverlayTransparency() * 100.0));
        Image image = PixelPerfectModel.getModel().getOverlayImage();
        this.mOverlaySlider.setEnabled(image != null);
        FormData formData10 = new FormData();
        formData10.right = new FormAttachment((Control)label, -4);
        formData10.top = new FormAttachment(0, 2);
        formData10.left = new FormAttachment((Control)label7, 4);
        this.mOverlaySlider.setLayoutData((Object)formData10);
        this.mOverlaySlider.addSelectionListener(this.overlaySliderSelectionListener);
        this.mAutoRefreshSlider = new Slider((Composite)this, 256);
        this.mAutoRefreshSlider.setMinimum(1);
        this.mAutoRefreshSlider.setMaximum(41);
        this.mAutoRefreshSlider.setThumb(1);
        this.mAutoRefreshSlider.setSelection(HierarchyViewerDirector.getDirector().getPixelPerfectAutoRefreshInverval());
        FormData formData11 = new FormData();
        formData11.right = new FormAttachment((Control)label, -4);
        formData11.top = new FormAttachment((Control)label, 2);
        formData11.left = new FormAttachment((Control)this.mOverlaySlider, 0, 16384);
        this.mAutoRefreshSlider.setLayoutData((Object)formData11);
        this.mAutoRefreshSlider.addSelectionListener(this.mRefreshSliderSelectionListener);
        this.mZoomSlider = new Slider((Composite)this, 256);
        this.mZoomSlider.setMinimum(2);
        this.mZoomSlider.setMaximum(25);
        this.mZoomSlider.setThumb(1);
        this.mZoomSlider.setSelection(PixelPerfectModel.getModel().getZoom());
        FormData formData12 = new FormData();
        formData12.right = new FormAttachment((Control)label, -4);
        formData12.top = new FormAttachment((Control)label2, 2);
        formData12.left = new FormAttachment((Control)this.mOverlaySlider, 0, 16384);
        this.mZoomSlider.setLayoutData((Object)formData12);
        this.mZoomSlider.addSelectionListener(this.mZoomSliderSelectionListener);
        this.addDisposeListener(this.mDisposeListener);
        PixelPerfectModel.getModel().addImageChangeListener(this);
    }

    public void crosshairMoved() {
    }

    public void treeChanged() {
    }

    public void imageChanged() {
    }

    public void imageLoaded() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                Image image = PixelPerfectModel.getModel().getOverlayImage();
                PixelPerfectControls.this.mOverlaySlider.setEnabled(image != null);
                if (PixelPerfectModel.getModel().getImage() != null) {
                    PixelPerfectControls.this.mZoomSlider.setSelection(PixelPerfectModel.getModel().getZoom());
                }
            }
        });
    }

    public void overlayChanged() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                Image image = PixelPerfectModel.getModel().getOverlayImage();
                PixelPerfectControls.this.mOverlaySlider.setEnabled(image != null);
            }
        });
    }

    public void overlayTransparencyChanged() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                PixelPerfectControls.this.mOverlaySlider.setSelection((int)(PixelPerfectModel.getModel().getOverlayTransparency() * 100.0));
            }
        });
    }

    public void selectionChanged() {
    }

    public void zoomChanged() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                PixelPerfectControls.this.mZoomSlider.setSelection(PixelPerfectModel.getModel().getZoom());
            }
        });
    }
}

