/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewerlib.ui;

import com.android.hierarchyviewerlib.models.PixelPerfectModel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class PixelPerfectLoupe
extends Canvas
implements PixelPerfectModel.IImageChangeListener {
    private PixelPerfectModel mModel;
    private Image mImage;
    private Image mGrid;
    private Color mCrosshairColor;
    private int mWidth;
    private int mHeight;
    private Point mCrosshairLocation;
    private int mZoom;
    private Transform mTransform;
    private int mCanvasWidth;
    private int mCanvasHeight;
    private Image mOverlayImage;
    private double mOverlayTransparency;
    private boolean mShowOverlay = false;
    private DisposeListener mDisposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent disposeEvent) {
            PixelPerfectLoupe.this.mModel.removeImageChangeListener(PixelPerfectLoupe.this);
            PixelPerfectLoupe.this.mCrosshairColor.dispose();
            PixelPerfectLoupe.this.mTransform.dispose();
            if (PixelPerfectLoupe.this.mGrid != null) {
                PixelPerfectLoupe.this.mGrid.dispose();
            }
        }
    };
    private MouseListener mMouseListener = new MouseListener(){

        public void mouseDoubleClick(MouseEvent mouseEvent) {
        }

        public void mouseDown(MouseEvent mouseEvent) {
            PixelPerfectLoupe.this.handleMouseEvent(mouseEvent);
        }

        public void mouseUp(MouseEvent mouseEvent) {
        }
    };
    private MouseWheelListener mMouseWheelListener = new MouseWheelListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseScrolled(MouseEvent mouseEvent) {
            int n = -1;
            PixelPerfectLoupe pixelPerfectLoupe = PixelPerfectLoupe.this;
            synchronized (pixelPerfectLoupe) {
                if (PixelPerfectLoupe.this.mImage != null && PixelPerfectLoupe.this.mCrosshairLocation != null) {
                    n = mouseEvent.count > 0 ? PixelPerfectLoupe.this.mZoom + 1 : PixelPerfectLoupe.this.mZoom - 1;
                }
            }
            if (n != -1) {
                PixelPerfectLoupe.this.mModel.setZoom(n);
            }
        }
    };
    private KeyListener mKeyListener = new KeyListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void keyPressed(KeyEvent keyEvent) {
            boolean bl = false;
            PixelPerfectLoupe pixelPerfectLoupe = PixelPerfectLoupe.this;
            synchronized (pixelPerfectLoupe) {
                if (PixelPerfectLoupe.this.mImage != null) {
                    switch (keyEvent.keyCode) {
                        case 0x1000001: {
                            if (((PixelPerfectLoupe)PixelPerfectLoupe.this).mCrosshairLocation.y == 0) break;
                            --((PixelPerfectLoupe)PixelPerfectLoupe.this).mCrosshairLocation.y;
                            bl = true;
                            break;
                        }
                        case 0x1000002: {
                            if (((PixelPerfectLoupe)PixelPerfectLoupe.this).mCrosshairLocation.y == PixelPerfectLoupe.this.mHeight - 1) break;
                            ++((PixelPerfectLoupe)PixelPerfectLoupe.this).mCrosshairLocation.y;
                            bl = true;
                            break;
                        }
                        case 0x1000003: {
                            if (((PixelPerfectLoupe)PixelPerfectLoupe.this).mCrosshairLocation.x == 0) break;
                            --((PixelPerfectLoupe)PixelPerfectLoupe.this).mCrosshairLocation.x;
                            bl = true;
                            break;
                        }
                        case 0x1000004: {
                            if (((PixelPerfectLoupe)PixelPerfectLoupe.this).mCrosshairLocation.x == PixelPerfectLoupe.this.mWidth - 1) break;
                            ++((PixelPerfectLoupe)PixelPerfectLoupe.this).mCrosshairLocation.x;
                            bl = true;
                        }
                    }
                }
            }
            if (bl) {
                PixelPerfectLoupe.this.mModel.setCrosshairLocation(((PixelPerfectLoupe)PixelPerfectLoupe.this).mCrosshairLocation.x, ((PixelPerfectLoupe)PixelPerfectLoupe.this).mCrosshairLocation.y);
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }
    };
    private PaintListener mPaintListener = new PaintListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paintControl(PaintEvent paintEvent) {
            PixelPerfectLoupe pixelPerfectLoupe = PixelPerfectLoupe.this;
            synchronized (pixelPerfectLoupe) {
                paintEvent.gc.setBackground(Display.getDefault().getSystemColor(2));
                paintEvent.gc.fillRectangle(0, 0, PixelPerfectLoupe.this.getSize().x, PixelPerfectLoupe.this.getSize().y);
                if (PixelPerfectLoupe.this.mImage != null && PixelPerfectLoupe.this.mCrosshairLocation != null) {
                    int n = -((PixelPerfectLoupe)PixelPerfectLoupe.this).mCrosshairLocation.x * PixelPerfectLoupe.this.mZoom - PixelPerfectLoupe.this.mZoom / 2 + PixelPerfectLoupe.this.getBounds().width / 2;
                    int n2 = -((PixelPerfectLoupe)PixelPerfectLoupe.this).mCrosshairLocation.y * PixelPerfectLoupe.this.mZoom - PixelPerfectLoupe.this.mZoom / 2 + PixelPerfectLoupe.this.getBounds().height / 2;
                    PixelPerfectLoupe.this.mTransform.translate((float)n, (float)n2);
                    PixelPerfectLoupe.this.mTransform.scale((float)PixelPerfectLoupe.this.mZoom, (float)PixelPerfectLoupe.this.mZoom);
                    paintEvent.gc.setInterpolation(0);
                    paintEvent.gc.setTransform(PixelPerfectLoupe.this.mTransform);
                    paintEvent.gc.drawImage(PixelPerfectLoupe.this.mImage, 0, 0);
                    if (PixelPerfectLoupe.this.mShowOverlay && PixelPerfectLoupe.this.mOverlayImage != null) {
                        paintEvent.gc.setAlpha((int)(PixelPerfectLoupe.this.mOverlayTransparency * 255.0));
                        paintEvent.gc.drawImage(PixelPerfectLoupe.this.mOverlayImage, 0, PixelPerfectLoupe.this.mHeight - ((PixelPerfectLoupe)PixelPerfectLoupe.this).mOverlayImage.getBounds().height);
                        paintEvent.gc.setAlpha(255);
                    }
                    PixelPerfectLoupe.this.mTransform.identity();
                    paintEvent.gc.setTransform(PixelPerfectLoupe.this.mTransform);
                    if (PixelPerfectLoupe.this.mGrid != null && (PixelPerfectLoupe.this.mCanvasWidth != PixelPerfectLoupe.this.getBounds().width || PixelPerfectLoupe.this.mCanvasHeight != PixelPerfectLoupe.this.getBounds().height)) {
                        PixelPerfectLoupe.this.mGrid.dispose();
                        PixelPerfectLoupe.this.mGrid = null;
                    }
                    PixelPerfectLoupe.this.mCanvasWidth = PixelPerfectLoupe.this.getBounds().width;
                    PixelPerfectLoupe.this.mCanvasHeight = PixelPerfectLoupe.this.getBounds().height;
                    if (PixelPerfectLoupe.this.mGrid == null) {
                        int n3;
                        ImageData imageData = new ImageData(PixelPerfectLoupe.this.mCanvasWidth + PixelPerfectLoupe.this.mZoom + 1, PixelPerfectLoupe.this.mCanvasHeight + PixelPerfectLoupe.this.mZoom + 1, 1, new PaletteData(new RGB[]{new RGB(0, 0, 0)}));
                        imageData.transparentPixel = 0;
                        PixelPerfectLoupe.this.mGrid = new Image((Device)Display.getDefault(), imageData);
                        GC gC = new GC((Drawable)PixelPerfectLoupe.this.mGrid);
                        gC.setForeground(Display.getDefault().getSystemColor(1));
                        for (n3 = 0; n3 <= PixelPerfectLoupe.this.mCanvasWidth + PixelPerfectLoupe.this.mZoom; n3 += PixelPerfectLoupe.this.mZoom) {
                            gC.drawLine(n3, 0, n3, PixelPerfectLoupe.this.mCanvasHeight + PixelPerfectLoupe.this.mZoom);
                        }
                        for (n3 = 0; n3 <= PixelPerfectLoupe.this.mCanvasHeight + PixelPerfectLoupe.this.mZoom; n3 += PixelPerfectLoupe.this.mZoom) {
                            gC.drawLine(0, n3, PixelPerfectLoupe.this.mCanvasWidth + PixelPerfectLoupe.this.mZoom, n3);
                        }
                        gC.dispose();
                    }
                    paintEvent.gc.setClipping(new Rectangle(n, n2, PixelPerfectLoupe.this.mWidth * PixelPerfectLoupe.this.mZoom + 1, PixelPerfectLoupe.this.mHeight * PixelPerfectLoupe.this.mZoom + 1));
                    paintEvent.gc.setAlpha(76);
                    paintEvent.gc.drawImage(PixelPerfectLoupe.this.mGrid, (PixelPerfectLoupe.this.mCanvasWidth / 2 - PixelPerfectLoupe.this.mZoom / 2) % PixelPerfectLoupe.this.mZoom - PixelPerfectLoupe.this.mZoom, (PixelPerfectLoupe.this.mCanvasHeight / 2 - PixelPerfectLoupe.this.mZoom / 2) % PixelPerfectLoupe.this.mZoom - PixelPerfectLoupe.this.mZoom);
                    paintEvent.gc.setAlpha(255);
                    paintEvent.gc.setForeground(PixelPerfectLoupe.this.mCrosshairColor);
                    paintEvent.gc.drawLine(0, PixelPerfectLoupe.this.mCanvasHeight / 2, PixelPerfectLoupe.this.mCanvasWidth - 1, PixelPerfectLoupe.this.mCanvasHeight / 2);
                    paintEvent.gc.drawLine(PixelPerfectLoupe.this.mCanvasWidth / 2, 0, PixelPerfectLoupe.this.mCanvasWidth / 2, PixelPerfectLoupe.this.mCanvasHeight - 1);
                }
            }
        }
    };

    public PixelPerfectLoupe(Composite composite) {
        super(composite, 0);
        this.mModel = PixelPerfectModel.getModel();
        this.mModel.addImageChangeListener(this);
        this.addPaintListener(this.mPaintListener);
        this.addMouseListener(this.mMouseListener);
        this.addMouseWheelListener(this.mMouseWheelListener);
        this.addDisposeListener(this.mDisposeListener);
        this.addKeyListener(this.mKeyListener);
        this.mCrosshairColor = new Color((Device)Display.getDefault(), new RGB(255, 94, 254));
        this.mTransform = new Transform((Device)Display.getDefault());
        this.imageLoaded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShowOverlay(boolean bl) {
        PixelPerfectLoupe pixelPerfectLoupe = this;
        synchronized (pixelPerfectLoupe) {
            this.mShowOverlay = bl;
        }
        this.doRedraw();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMouseEvent(MouseEvent mouseEvent) {
        int n = -1;
        int n2 = -1;
        PixelPerfectLoupe pixelPerfectLoupe = this;
        synchronized (pixelPerfectLoupe) {
            if (this.mImage == null) {
                return;
            }
            int n3 = -this.mCrosshairLocation.x * this.mZoom - this.mZoom / 2 + this.getBounds().width / 2;
            int n4 = -this.mCrosshairLocation.y * this.mZoom - this.mZoom / 2 + this.getBounds().height / 2;
            int n5 = (mouseEvent.x - n3) / this.mZoom;
            int n6 = (mouseEvent.y - n4) / this.mZoom;
            if (n5 >= 0 && n5 < this.mWidth && n6 >= 0 && n6 < this.mHeight) {
                n = n5;
                n2 = n6;
            }
        }
        if (n != -1) {
            this.mModel.setCrosshairLocation(n, n2);
        }
    }

    private void doRedraw() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                PixelPerfectLoupe.this.redraw();
            }
        });
    }

    private void loadImage() {
        this.mImage = this.mModel.getImage();
        if (this.mImage != null) {
            this.mWidth = this.mImage.getBounds().width;
            this.mHeight = this.mImage.getBounds().height;
        } else {
            this.mWidth = 0;
            this.mHeight = 0;
        }
    }

    public void imageLoaded() {
        Display.getDefault().syncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                7 var1_1 = this;
                synchronized (var1_1) {
                    PixelPerfectLoupe.this.loadImage();
                    PixelPerfectLoupe.this.mCrosshairLocation = PixelPerfectLoupe.this.mModel.getCrosshairLocation();
                    PixelPerfectLoupe.this.mZoom = PixelPerfectLoupe.this.mModel.getZoom();
                    PixelPerfectLoupe.this.mOverlayImage = PixelPerfectLoupe.this.mModel.getOverlayImage();
                    PixelPerfectLoupe.this.mOverlayTransparency = PixelPerfectLoupe.this.mModel.getOverlayTransparency();
                }
            }
        });
        this.doRedraw();
    }

    public void imageChanged() {
        Display.getDefault().syncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                8 var1_1 = this;
                synchronized (var1_1) {
                    PixelPerfectLoupe.this.loadImage();
                }
            }
        });
        this.doRedraw();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void crosshairMoved() {
        PixelPerfectLoupe pixelPerfectLoupe = this;
        synchronized (pixelPerfectLoupe) {
            this.mCrosshairLocation = this.mModel.getCrosshairLocation();
        }
        this.doRedraw();
    }

    public void selectionChanged() {
    }

    public void treeChanged() {
    }

    public void zoomChanged() {
        Display.getDefault().syncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                9 var1_1 = this;
                synchronized (var1_1) {
                    if (PixelPerfectLoupe.this.mGrid != null) {
                        PixelPerfectLoupe.this.mGrid.dispose();
                        PixelPerfectLoupe.this.mGrid = null;
                    }
                    PixelPerfectLoupe.this.mZoom = PixelPerfectLoupe.this.mModel.getZoom();
                }
            }
        });
        this.doRedraw();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void overlayChanged() {
        PixelPerfectLoupe pixelPerfectLoupe = this;
        synchronized (pixelPerfectLoupe) {
            this.mOverlayImage = this.mModel.getOverlayImage();
            this.mOverlayTransparency = this.mModel.getOverlayTransparency();
        }
        this.doRedraw();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void overlayTransparencyChanged() {
        PixelPerfectLoupe pixelPerfectLoupe = this;
        synchronized (pixelPerfectLoupe) {
            this.mOverlayTransparency = this.mModel.getOverlayTransparency();
        }
        this.doRedraw();
    }
}

