/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewerlib.ui;

import com.android.hierarchyviewerlib.HierarchyViewerDirector;
import com.android.hierarchyviewerlib.models.TreeViewModel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Text;

public class TreeViewControls
extends Composite
implements TreeViewModel.ITreeChangeListener {
    private Text mFilterText;
    private Slider mZoomSlider;
    private DisposeListener mDisposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent disposeEvent) {
            TreeViewModel.getModel().removeTreeChangeListener(TreeViewControls.this);
        }
    };
    private SelectionListener mZoomSliderSelectionListener = new SelectionListener(){
        private int oldValue;

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            int n = TreeViewControls.this.mZoomSlider.getSelection();
            if (this.oldValue != n) {
                TreeViewModel.getModel().removeTreeChangeListener(TreeViewControls.this);
                TreeViewModel.getModel().setZoom((double)n / 10.0);
                TreeViewModel.getModel().addTreeChangeListener(TreeViewControls.this);
                this.oldValue = n;
            }
        }
    };
    private ModifyListener mFilterTextModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent modifyEvent) {
            HierarchyViewerDirector.getDirector().filterNodes(TreeViewControls.this.mFilterText.getText());
        }
    };

    public TreeViewControls(Composite composite) {
        super(composite, 0);
        GridLayout gridLayout = new GridLayout(5, false);
        gridLayout.marginHeight = 2;
        gridLayout.marginWidth = 2;
        gridLayout.horizontalSpacing = 4;
        gridLayout.verticalSpacing = 4;
        this.setLayout((Layout)gridLayout);
        Label label = new Label((Composite)this, 0);
        label.setText("Filter by class or id:");
        label.setLayoutData((Object)new GridData(1, 2, false, true));
        this.mFilterText = new Text((Composite)this, 16388);
        this.mFilterText.setLayoutData((Object)new GridData(768));
        this.mFilterText.addModifyListener(this.mFilterTextModifyListener);
        this.mFilterText.setText(HierarchyViewerDirector.getDirector().getFilterText());
        Label label2 = new Label((Composite)this, 0);
        label2.setText(" 20%");
        label2.setLayoutData((Object)new GridData(1, 2, false, true));
        this.mZoomSlider = new Slider((Composite)this, 256);
        GridData gridData = new GridData(2, 2, false, false);
        gridData.widthHint = 190;
        this.mZoomSlider.setLayoutData((Object)gridData);
        this.mZoomSlider.setMinimum(2);
        this.mZoomSlider.setMaximum(21);
        this.mZoomSlider.setThumb(1);
        this.mZoomSlider.setSelection((int)Math.round(TreeViewModel.getModel().getZoom() * 10.0));
        this.mZoomSlider.addSelectionListener(this.mZoomSliderSelectionListener);
        Label label3 = new Label((Composite)this, 0);
        label3.setLayoutData((Object)new GridData(1, 2, false, true));
        label3.setText("200%");
        this.addDisposeListener(this.mDisposeListener);
        TreeViewModel.getModel().addTreeChangeListener(this);
    }

    public void selectionChanged() {
    }

    public void treeChanged() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                if (TreeViewModel.getModel().getTree() != null) {
                    TreeViewControls.this.mZoomSlider.setSelection((int)Math.round(TreeViewModel.getModel().getZoom() * 10.0));
                }
                TreeViewControls.this.mFilterText.setText("");
            }
        });
    }

    public void viewportChanged() {
    }

    public void zoomChanged() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                TreeViewControls.this.mZoomSlider.setSelection((int)Math.round(TreeViewModel.getModel().getZoom() * 10.0));
            }
        });
    }
}

