/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewerlib.ui.util;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class PsdFile {
    private final Header mHeader;
    private final ColorMode mColorMode;
    private final ImageResources mImageResources;
    private final LayersMasksInfo mLayersMasksInfo;
    private final LayersInfo mLayersInfo;
    private final BufferedImage mMergedImage;
    private final Graphics2D mGraphics;

    public PsdFile(int n, int n2) {
        this.mHeader = new Header(n, n2);
        this.mColorMode = new ColorMode();
        this.mImageResources = new ImageResources();
        this.mLayersMasksInfo = new LayersMasksInfo();
        this.mLayersInfo = new LayersInfo();
        this.mMergedImage = new BufferedImage(n, n2, 2);
        this.mGraphics = this.mMergedImage.createGraphics();
    }

    public void addLayer(String string, BufferedImage bufferedImage, Point point) {
        this.addLayer(string, bufferedImage, point, true);
    }

    public void addLayer(String string, BufferedImage bufferedImage, Point point, boolean bl) {
        this.mLayersInfo.addLayer(string, bufferedImage, point, bl);
        if (bl) {
            this.mGraphics.drawImage(bufferedImage, null, point.x, point.y);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(OutputStream outputStream) {
        this.mLayersMasksInfo.setLayersInfo(this.mLayersInfo);
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(outputStream));
        try {
            this.mHeader.write(dataOutputStream);
            dataOutputStream.flush();
            this.mColorMode.write(dataOutputStream);
            this.mImageResources.write(dataOutputStream);
            this.mLayersMasksInfo.write(dataOutputStream);
            this.mLayersInfo.write(dataOutputStream);
            dataOutputStream.flush();
            this.mLayersInfo.writeImageData(dataOutputStream);
            dataOutputStream.flush();
            PsdFile.writeImage(this.mMergedImage, dataOutputStream, false);
            dataOutputStream.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                dataOutputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private static void writeImage(BufferedImage bufferedImage, DataOutputStream dataOutputStream, boolean bl) throws IOException {
        if (!bl) {
            dataOutputStream.writeShort(0);
        }
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int n3 = n * n2;
        int[] nArray = new int[n3];
        bufferedImage.getData().getDataElements(0, 0, n, n2, nArray);
        byte[] byArray = new byte[n3];
        byte[] byArray2 = new byte[n3];
        byte[] byArray3 = new byte[n3];
        byte[] byArray4 = new byte[n3];
        for (int i = 0; i < n3; ++i) {
            int n4 = nArray[i];
            byArray[i] = (byte)(n4 >> 24 & 0xFF);
            byArray2[i] = (byte)(n4 >> 16 & 0xFF);
            byArray3[i] = (byte)(n4 >> 8 & 0xFF);
            byArray4[i] = (byte)(n4 & 0xFF);
        }
        if (bl) {
            dataOutputStream.writeShort(0);
        }
        if (bl) {
            dataOutputStream.write(byArray);
        }
        if (bl) {
            dataOutputStream.writeShort(0);
        }
        dataOutputStream.write(byArray2);
        if (bl) {
            dataOutputStream.writeShort(0);
        }
        dataOutputStream.write(byArray3);
        if (bl) {
            dataOutputStream.writeShort(0);
        }
        dataOutputStream.write(byArray4);
        if (!bl) {
            dataOutputStream.write(byArray);
        }
    }

    static class Channel {
        static final short ID_RED = 0;
        static final short ID_GREEN = 1;
        static final short ID_BLUE = 2;
        static final short ID_ALPHA = -1;
        static final short ID_LAYER_MASK = -2;
        final short mId;
        final int mDataLength;

        Channel(short s, int n) {
            this.mId = s;
            this.mDataLength = n + 2;
        }

        int getLength() {
            return 6 + this.mDataLength;
        }

        void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeShort(this.mId);
            dataOutputStream.writeInt(this.mDataLength);
        }
    }

    static class Layer {
        static final byte OPACITY_TRANSPARENT = 0;
        static final byte OPACITY_OPAQUE = -1;
        static final byte CLIPPING_BASE = 0;
        static final byte CLIPPING_NON_BASE = 1;
        static final byte FLAG_TRANSPARENCY_PROTECTED = 1;
        static final byte FLAG_INVISIBLE = 2;
        final int mTop;
        final int mLeft;
        final int mBottom;
        final int mRight;
        final short mChannelCount = (short)4;
        final Channel[] mChannelInfo = new Channel[4];
        final byte[] mBlendSignature = "8BIM".getBytes();
        final byte[] mBlendMode = "norm".getBytes();
        final byte mOpacity = (byte)-1;
        final byte mClipping = 0;
        byte mFlags = 0;
        final byte mFiller = 0;
        int mExtraSize = 8;
        final int mMaskDataLength = 0;
        final int mBlendRangeDataLength = 0;
        final byte[] mName;
        final byte[] mLayerExtraSignature = "8BIM".getBytes();
        final byte[] mLayerExtraKey = "luni".getBytes();
        int mLayerExtraLength;
        final String mOriginalName;
        private BufferedImage mImage;

        Layer(String string, BufferedImage bufferedImage, Point point, boolean bl) {
            int n = bufferedImage.getHeight();
            int n2 = bufferedImage.getWidth();
            int n3 = n2 * n;
            this.mChannelInfo[0] = new Channel(-1, n3);
            this.mChannelInfo[1] = new Channel(0, n3);
            this.mChannelInfo[2] = new Channel(1, n3);
            this.mChannelInfo[3] = new Channel(2, n3);
            this.mTop = point.y;
            this.mLeft = point.x;
            this.mBottom = point.y + n;
            this.mRight = point.x + n2;
            this.mOriginalName = string;
            byte[] byArray = string.getBytes();
            try {
                this.mLayerExtraLength = 4 + this.mOriginalName.getBytes("UTF-16").length;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
            byte[] byArray2 = new byte[byArray.length + 1];
            byArray2[0] = (byte)(byArray.length & 0xFF);
            System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
            if (byArray2.length % 4 != 0) {
                byArray = new byte[byArray2.length + 4 - byArray2.length % 4];
                System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
                this.mName = byArray;
            } else {
                this.mName = byArray2;
            }
            this.mExtraSize += this.mName.length;
            this.mExtraSize += this.mLayerExtraLength + 4 + this.mLayerExtraKey.length + this.mLayerExtraSignature.length;
            this.mImage = bufferedImage;
            if (!bl) {
                this.mFlags = (byte)(this.mFlags | 2);
            }
        }

        int getLength() {
            int n = 18;
            for (Channel channel : this.mChannelInfo) {
                n += channel.getLength();
            }
            n += this.mBlendSignature.length;
            n += this.mBlendMode.length;
            n += 4;
            n += 4;
            return n += this.mExtraSize;
        }

        void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeInt(this.mTop);
            dataOutputStream.writeInt(this.mLeft);
            dataOutputStream.writeInt(this.mBottom);
            dataOutputStream.writeInt(this.mRight);
            dataOutputStream.writeShort(4);
            for (Channel channel : this.mChannelInfo) {
                channel.write(dataOutputStream);
            }
            dataOutputStream.write(this.mBlendSignature);
            dataOutputStream.write(this.mBlendMode);
            dataOutputStream.write(-1);
            dataOutputStream.write(0);
            dataOutputStream.write(this.mFlags);
            dataOutputStream.write(0);
            dataOutputStream.writeInt(this.mExtraSize);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(0);
            dataOutputStream.write(this.mName);
            dataOutputStream.write(this.mLayerExtraSignature);
            dataOutputStream.write(this.mLayerExtraKey);
            dataOutputStream.writeInt(this.mLayerExtraLength);
            dataOutputStream.writeInt(this.mOriginalName.length() + 1);
            dataOutputStream.write(this.mOriginalName.getBytes("UTF-16"));
        }

        void writeImageData(DataOutputStream dataOutputStream) throws IOException {
            PsdFile.writeImage(this.mImage, dataOutputStream, true);
        }
    }

    static class LayersInfo {
        final List<Layer> mLayers = new ArrayList<Layer>();

        LayersInfo() {
        }

        void addLayer(String string, BufferedImage bufferedImage, Point point, boolean bl) {
            this.mLayers.add(new Layer(string, bufferedImage, point, bl));
        }

        int getLength() {
            int n = 2;
            for (Layer layer : this.mLayers) {
                n += layer.getLength();
            }
            return n;
        }

        void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeShort((short)(-this.mLayers.size()));
            for (Layer layer : this.mLayers) {
                layer.write(dataOutputStream);
            }
        }

        void writeImageData(DataOutputStream dataOutputStream) throws IOException {
            for (Layer layer : this.mLayers) {
                layer.writeImageData(dataOutputStream);
            }
            dataOutputStream.writeInt(0);
        }
    }

    static class LayersMasksInfo {
        int mMiscLength;
        int mLayerInfoLength;

        LayersMasksInfo() {
        }

        void setLayersInfo(LayersInfo layersInfo) {
            this.mLayerInfoLength = layersInfo.getLength();
            if ((this.mLayerInfoLength & 1) == 1) {
                ++this.mLayerInfoLength;
            }
            this.mMiscLength = this.mLayerInfoLength + 8;
        }

        void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeInt(this.mMiscLength);
            dataOutputStream.writeInt(this.mLayerInfoLength);
        }
    }

    static class ImageResources {
        static final short RESOURCE_RESOLUTION_INFO = 1005;
        int mLength = 0;
        final byte[] mSignature = "8BIM".getBytes();
        final short mResourceId = (short)1005;
        final short mPad = 0;
        final int mDataLength = 16;
        final short mHorizontalDisplayUnit = (short)72;
        final int mHorizontalResolution = 1;
        final short mWidthDisplayUnit = 1;
        final short mVerticalDisplayUnit = (short)72;
        final int mVerticalResolution = 1;
        final short mHeightDisplayUnit = 1;

        ImageResources() {
            this.mLength = this.mSignature.length;
            this.mLength += 2;
            this.mLength += 2;
            this.mLength += 4;
            this.mLength += 8;
            this.mLength += 8;
        }

        void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeInt(this.mLength);
            dataOutputStream.write(this.mSignature);
            dataOutputStream.writeShort(1005);
            dataOutputStream.writeShort(0);
            dataOutputStream.writeInt(16);
            dataOutputStream.writeShort(72);
            dataOutputStream.writeInt(1);
            dataOutputStream.writeShort(1);
            dataOutputStream.writeShort(72);
            dataOutputStream.writeInt(1);
            dataOutputStream.writeShort(1);
        }
    }

    static class ColorMode {
        final int mLength = 0;

        ColorMode() {
        }

        void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeInt(0);
        }
    }

    static class Header {
        static final short MODE_BITMAP = 0;
        static final short MODE_GRAYSCALE = 1;
        static final short MODE_INDEXED = 2;
        static final short MODE_RGB = 3;
        static final short MODE_CMYK = 4;
        static final short MODE_MULTI_CHANNEL = 7;
        static final short MODE_DUOTONE = 8;
        static final short MODE_LAB = 9;
        final byte[] mSignature = "8BPS".getBytes();
        final short mVersion = 1;
        final byte[] mReserved = new byte[6];
        final short mChannelCount = (short)4;
        final int mHeight;
        final int mWidth;
        final short mDepth = (short)8;
        final short mMode = (short)3;

        Header(int n, int n2) {
            this.mWidth = n;
            this.mHeight = n2;
        }

        void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.write(this.mSignature);
            dataOutputStream.writeShort(1);
            dataOutputStream.write(this.mReserved);
            dataOutputStream.writeShort(4);
            dataOutputStream.writeInt(this.mHeight);
            dataOutputStream.writeInt(this.mWidth);
            dataOutputStream.writeShort(8);
            dataOutputStream.writeShort(3);
        }
    }
}

