/*
 * Decompiled with CFR 0.152.
 */
package com.android.prefs;

import java.io.File;

public final class AndroidLocation {
    public static final String FOLDER_AVD = "avd";
    private static String sPrefsLocation = null;

    public static final String getFolder() throws AndroidLocationException {
        Object object;
        if (sPrefsLocation == null) {
            object = AndroidLocation.findValidPath("ANDROID_SDK_HOME", "user.home", "HOME");
            if (object == null) {
                throw new AndroidLocationException("Unable to get the Android SDK home directory.\nMake sure the environment variable ANDROID_SDK_HOME is set up.");
            }
            sPrefsLocation = (String)object + File.separator + ".android" + File.separator;
        }
        if (!((File)(object = new File(sPrefsLocation))).exists()) {
            try {
                ((File)object).mkdir();
            }
            catch (SecurityException securityException) {
                AndroidLocationException androidLocationException = new AndroidLocationException(String.format("Unable to create folder '%1$s'. This is the path of preference folder expected by the Android tools.", sPrefsLocation));
                androidLocationException.initCause(securityException);
                throw androidLocationException;
            }
        } else if (((File)object).isFile()) {
            throw new AndroidLocationException(sPrefsLocation + " is not a directory! " + "This is the path of preference folder expected by the Android tools.");
        }
        return sPrefsLocation;
    }

    public static final void resetFolder() {
        sPrefsLocation = null;
    }

    private static String findValidPath(String ... stringArray) {
        for (String string : stringArray) {
            File file;
            String string2 = string.indexOf(46) != -1 ? System.getProperty(string) : System.getenv(string);
            if (string2 == null || !(file = new File(string2)).isDirectory()) continue;
            return string2;
        }
        return null;
    }

    public static final class AndroidLocationException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public AndroidLocationException(String string) {
            super(string);
        }
    }
}

