/*
 * Decompiled with CFR 0.152.
 */
package com.android.traceview;

import com.android.traceview.MethodData;
import java.util.HashMap;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ColorController {
    private static final int[] systemColors = new int[]{9, 3, 5, 13, 11, 10, 4, 6, 8, 14, 12, 2};
    private static RGB[] rgbColors = new RGB[]{new RGB(90, 90, 255), new RGB(0, 240, 0), new RGB(255, 0, 0), new RGB(0, 255, 255), new RGB(255, 80, 255), new RGB(200, 200, 0), new RGB(40, 0, 200), new RGB(150, 255, 150), new RGB(150, 0, 0), new RGB(30, 150, 150), new RGB(200, 200, 255), new RGB(0, 120, 0), new RGB(255, 150, 150), new RGB(140, 80, 140), new RGB(150, 100, 50), new RGB(70, 70, 70)};
    private static HashMap<Integer, Color> colorCache = new HashMap();
    private static HashMap<Integer, Image> imageCache = new HashMap();

    public static Color requestColor(Display display, RGB rGB) {
        return ColorController.requestColor(display, rGB.red, rGB.green, rGB.blue);
    }

    public static Image requestColorSquare(Display display, RGB rGB) {
        return ColorController.requestColorSquare(display, rGB.red, rGB.green, rGB.blue);
    }

    public static Color requestColor(Display display, int n, int n2, int n3) {
        int n4 = n << 16 | n2 << 8 | n3;
        Color color = colorCache.get(n4);
        if (color == null) {
            color = new Color((Device)display, n, n2, n3);
            colorCache.put(n4, color);
        }
        return color;
    }

    public static Image requestColorSquare(Display display, int n, int n2, int n3) {
        int n4 = n << 16 | n2 << 8 | n3;
        Image image = imageCache.get(n4);
        if (image == null) {
            image = new Image((Device)display, 8, 14);
            GC gC = new GC((Drawable)image);
            Color color = ColorController.requestColor(display, n, n2, n3);
            gC.setBackground(color);
            gC.fillRectangle(image.getBounds());
            gC.dispose();
            imageCache.put(n4, image);
        }
        return image;
    }

    public static void assignMethodColors(Display display, MethodData[] methodDataArray) {
        int n = 0;
        for (MethodData methodData : methodDataArray) {
            RGB rGB = rgbColors[n];
            if (++n == rgbColors.length) {
                n = 0;
            }
            Color color = ColorController.requestColor(display, rGB);
            Image image = ColorController.requestColorSquare(display, rGB);
            methodData.setColor(color);
            methodData.setImage(image);
            int n2 = 150 + rGB.red / 4;
            int n3 = 150 + rGB.green / 4;
            int n4 = 150 + rGB.blue / 4;
            RGB rGB2 = new RGB(n2, n3, n4);
            color = ColorController.requestColor(display, rGB2);
            image = ColorController.requestColorSquare(display, rGB2);
            methodData.setFadedColor(color);
            methodData.setFadedImage(image);
        }
    }
}

