/*
 * Decompiled with CFR 0.152.
 */
package com.android.traceview;

import com.android.traceview.MethodData;

public class ProfileData {
    protected MethodData mElement;
    protected MethodData mContext;
    protected boolean mElementIsParent;
    protected long mElapsedInclusiveCpuTime;
    protected long mElapsedInclusiveRealTime;
    protected int mNumCalls;

    public ProfileData() {
    }

    public ProfileData(MethodData methodData, MethodData methodData2, boolean bl) {
        this.mContext = methodData;
        this.mElement = methodData2;
        this.mElementIsParent = bl;
    }

    public String getProfileName() {
        return this.mElement.getProfileName();
    }

    public MethodData getMethodData() {
        return this.mElement;
    }

    public void addElapsedInclusive(long l, long l2) {
        this.mElapsedInclusiveCpuTime += l;
        this.mElapsedInclusiveRealTime += l2;
        ++this.mNumCalls;
    }

    public void setElapsedInclusive(long l, long l2) {
        this.mElapsedInclusiveCpuTime = l;
        this.mElapsedInclusiveRealTime = l2;
    }

    public long getElapsedInclusiveCpuTime() {
        return this.mElapsedInclusiveCpuTime;
    }

    public long getElapsedInclusiveRealTime() {
        return this.mElapsedInclusiveRealTime;
    }

    public void setNumCalls(int n) {
        this.mNumCalls = n;
    }

    public String getNumCalls() {
        int n = this.mElementIsParent ? this.mContext.getTotalCalls() : this.mElement.getTotalCalls();
        return String.format("%d/%d", this.mNumCalls, n);
    }

    public boolean isParent() {
        return this.mElementIsParent;
    }

    public MethodData getContext() {
        return this.mContext;
    }
}

