/*
 * Decompiled with CFR 0.152.
 */
package com.android.traceview;

class TickScaler {
    private double mMinVal;
    private double mMaxVal;
    private double mRangeVal;
    private int mNumPixels;
    private int mPixelsPerTick;
    private double mPixelsPerRange;
    private double mTickIncrement;
    private double mMinMajorTick;

    TickScaler(double d, double d2, int n, int n2) {
        this.mMinVal = d;
        this.mMaxVal = d2;
        this.mNumPixels = n;
        this.mPixelsPerTick = n2;
    }

    public void setMinVal(double d) {
        this.mMinVal = d;
    }

    public double getMinVal() {
        return this.mMinVal;
    }

    public void setMaxVal(double d) {
        this.mMaxVal = d;
    }

    public double getMaxVal() {
        return this.mMaxVal;
    }

    public void setNumPixels(int n) {
        this.mNumPixels = n;
    }

    public int getNumPixels() {
        return this.mNumPixels;
    }

    public void setPixelsPerTick(int n) {
        this.mPixelsPerTick = n;
    }

    public int getPixelsPerTick() {
        return this.mPixelsPerTick;
    }

    public void setPixelsPerRange(double d) {
        this.mPixelsPerRange = d;
    }

    public double getPixelsPerRange() {
        return this.mPixelsPerRange;
    }

    public void setTickIncrement(double d) {
        this.mTickIncrement = d;
    }

    public double getTickIncrement() {
        return this.mTickIncrement;
    }

    public void setMinMajorTick(double d) {
        this.mMinMajorTick = d;
    }

    public double getMinMajorTick() {
        return this.mMinMajorTick;
    }

    public int valueToPixel(double d) {
        return (int)Math.ceil(this.mPixelsPerRange * (d - this.mMinVal) - 0.5);
    }

    public double valueToPixelFraction(double d) {
        return this.mPixelsPerRange * (d - this.mMinVal);
    }

    public double pixelToValue(int n) {
        return this.mMinVal + (double)n / this.mPixelsPerRange;
    }

    public void computeTicks(boolean bl) {
        int n = this.mNumPixels / this.mPixelsPerTick;
        this.mRangeVal = this.mMaxVal - this.mMinVal;
        this.mTickIncrement = this.mRangeVal / (double)n;
        double d = Math.log10(this.mTickIncrement);
        int n2 = (int)Math.floor(d);
        double d2 = Math.pow(10.0, n2);
        double d3 = this.mTickIncrement / d2;
        d3 = d3 > 5.0 ? 10.0 : (d3 > 2.0 ? 5.0 : (d3 > 1.0 ? 2.0 : 1.0));
        this.mTickIncrement = d3 * d2;
        if (!bl) {
            double d4 = this.mTickIncrement / 5.0;
            double d5 = this.mMaxVal / d4;
            int n3 = (int)d5;
            if ((double)n3 != d5) {
                this.mMaxVal = (double)(n3 + 1) * d4;
            }
            n3 = (int)(this.mMinVal / this.mTickIncrement);
            this.mMinMajorTick = this.mMinVal = (double)n3 * this.mTickIncrement;
        } else {
            int n4 = (int)(this.mMinVal / this.mTickIncrement);
            this.mMinMajorTick = (double)n4 * this.mTickIncrement;
            if (this.mMinMajorTick < this.mMinVal) {
                this.mMinMajorTick += this.mTickIncrement;
            }
        }
        this.mRangeVal = this.mMaxVal - this.mMinVal;
        this.mPixelsPerRange = (double)this.mNumPixels / this.mRangeVal;
    }
}

