/*
 * Decompiled with CFR 0.152.
 */
package com.android.traceview;

import com.android.traceview.Call;
import com.android.traceview.MethodData;
import com.android.traceview.Selection;
import com.android.traceview.SelectionController;
import com.android.traceview.TickScaler;
import com.android.traceview.TraceReader;
import com.android.traceview.TraceUnits;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeLineView
extends Composite
implements Observer {
    private HashMap<String, RowData> mRowByName;
    private RowData[] mRows;
    private Segment[] mSegments;
    private HashMap<Integer, String> mThreadLabels;
    private Timescale mTimescale;
    private Surface mSurface;
    private RowLabels mLabels;
    private SashForm mSashForm;
    private int mScrollOffsetY;
    public static final int PixelsPerTick = 50;
    private TickScaler mScaleInfo = new TickScaler(0.0, 0.0, 0, 50);
    private static final int LeftMargin = 10;
    private static final int RightMargin = 60;
    private Color mColorBlack;
    private Color mColorGray;
    private Color mColorDarkGray;
    private Color mColorForeground;
    private Color mColorRowBack;
    private Color mColorZoomSelection;
    private FontRegistry mFontRegistry;
    private static final int rowHeight = 20;
    private static final int rowYMargin = 12;
    private static final int rowYMarginHalf = 6;
    private static final int rowYSpace = 32;
    private static final int majorTickLength = 8;
    private static final int minorTickLength = 4;
    private static final int timeLineOffsetY = 58;
    private static final int tickToFontSpacing = 2;
    private static final int topMargin = 90;
    private int mMouseRow = -1;
    private int mNumRows;
    private int mStartRow;
    private int mEndRow;
    private TraceUnits mUnits;
    private String mClockSource;
    private boolean mHaveCpuTime;
    private boolean mHaveRealTime;
    private int mSmallFontWidth;
    private int mSmallFontHeight;
    private SelectionController mSelectionController;
    private MethodData mHighlightMethodData;
    private Call mHighlightCall;
    private static final int MinInclusiveRange = 3;
    private boolean mSetFonts = false;

    public TimeLineView(Composite composite, TraceReader traceReader, SelectionController selectionController) {
        super(composite, 0);
        this.mRowByName = new HashMap();
        this.mSelectionController = selectionController;
        selectionController.addObserver(this);
        this.mUnits = traceReader.getTraceUnits();
        this.mClockSource = traceReader.getClockSource();
        this.mHaveCpuTime = traceReader.haveCpuTime();
        this.mHaveRealTime = traceReader.haveRealTime();
        this.mThreadLabels = traceReader.getThreadLabels();
        Display display = this.getDisplay();
        this.mColorGray = display.getSystemColor(15);
        this.mColorDarkGray = display.getSystemColor(16);
        this.mColorBlack = display.getSystemColor(2);
        this.mColorForeground = display.getSystemColor(2);
        this.mColorRowBack = new Color((Device)display, 240, 240, 255);
        this.mColorZoomSelection = new Color((Device)display, 230, 230, 230);
        this.mFontRegistry = new FontRegistry(display);
        this.mFontRegistry.put("small", new FontData[]{new FontData("Arial", 8, 0)});
        this.mFontRegistry.put("courier8", new FontData[]{new FontData("Courier New", 8, 1)});
        this.mFontRegistry.put("medium", new FontData[]{new FontData("Courier New", 10, 0)});
        Image image = new Image((Device)display, new Rectangle(100, 100, 100, 100));
        GC gC = new GC((Drawable)image);
        if (this.mSetFonts) {
            gC.setFont(this.mFontRegistry.get("small"));
        }
        this.mSmallFontWidth = gC.getFontMetrics().getAverageCharWidth();
        this.mSmallFontHeight = gC.getFontMetrics().getHeight();
        image.dispose();
        gC.dispose();
        this.setLayout((Layout)new FillLayout());
        this.mSashForm = new SashForm((Composite)this, 256);
        this.mSashForm.setBackground(this.mColorGray);
        this.mSashForm.SASH_WIDTH = 3;
        Composite composite2 = new Composite((Composite)this.mSashForm, 0);
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 1;
        composite2.setLayout((Layout)gridLayout);
        BlankCorner blankCorner = new BlankCorner(composite2);
        GridData gridData = new GridData(768);
        gridData.heightHint = 90;
        blankCorner.setLayoutData(gridData);
        this.mLabels = new RowLabels(composite2);
        gridData = new GridData(1808);
        this.mLabels.setLayoutData(gridData);
        composite2 = new Composite((Composite)this.mSashForm, 0);
        gridLayout = new GridLayout(1, true);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 1;
        composite2.setLayout((Layout)gridLayout);
        this.mTimescale = new Timescale(composite2);
        gridData = new GridData(768);
        gridData.heightHint = 90;
        this.mTimescale.setLayoutData(gridData);
        this.mSurface = new Surface(composite2);
        gridData = new GridData(1808);
        this.mSurface.setLayoutData(gridData);
        this.mSashForm.setWeights(new int[]{1, 5});
        final ScrollBar scrollBar = this.mSurface.getVerticalBar();
        scrollBar.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TimeLineView.this.mScrollOffsetY = scrollBar.getSelection();
                Point point = TimeLineView.this.mSurface.getSize();
                int n = TimeLineView.this.computeVisibleRows(point.y);
                if (n != TimeLineView.this.mScrollOffsetY) {
                    TimeLineView.this.mScrollOffsetY = n;
                    scrollBar.setSelection(n);
                }
                TimeLineView.this.mLabels.redraw();
                TimeLineView.this.mSurface.redraw();
            }
        });
        final ScrollBar scrollBar2 = this.mSurface.getHorizontalBar();
        scrollBar2.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TimeLineView.this.mSurface.setScaleFromHorizontalScrollBar(scrollBar2.getSelection());
                TimeLineView.this.mSurface.redraw();
            }
        });
        this.mSurface.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                Point point = TimeLineView.this.mSurface.getSize();
                if (point.y >= TimeLineView.this.mNumRows * 32) {
                    scrollBar.setVisible(false);
                } else {
                    scrollBar.setVisible(true);
                }
                int n = TimeLineView.this.computeVisibleRows(point.y);
                if (n != TimeLineView.this.mScrollOffsetY) {
                    TimeLineView.this.mScrollOffsetY = n;
                    scrollBar.setSelection(n);
                }
                int n2 = TimeLineView.this.mNumRows * 32;
                scrollBar.setMaximum(n2);
                scrollBar.setThumb(point.y);
                TimeLineView.this.mLabels.redraw();
                TimeLineView.this.mSurface.redraw();
            }
        });
        this.mSurface.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent mouseEvent) {
                TimeLineView.this.mSurface.mouseUp(mouseEvent);
            }

            public void mouseDown(MouseEvent mouseEvent) {
                TimeLineView.this.mSurface.mouseDown(mouseEvent);
            }

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                TimeLineView.this.mSurface.mouseDoubleClick(mouseEvent);
            }
        });
        this.mSurface.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent mouseEvent) {
                TimeLineView.this.mSurface.mouseMove(mouseEvent);
            }
        });
        this.mSurface.addMouseWheelListener(new MouseWheelListener(){

            public void mouseScrolled(MouseEvent mouseEvent) {
                TimeLineView.this.mSurface.mouseScrolled(mouseEvent);
            }
        });
        this.mTimescale.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent mouseEvent) {
                TimeLineView.this.mTimescale.mouseUp(mouseEvent);
            }

            public void mouseDown(MouseEvent mouseEvent) {
                TimeLineView.this.mTimescale.mouseDown(mouseEvent);
            }

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                TimeLineView.this.mTimescale.mouseDoubleClick(mouseEvent);
            }
        });
        this.mTimescale.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent mouseEvent) {
                TimeLineView.this.mTimescale.mouseMove(mouseEvent);
            }
        });
        this.mLabels.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent mouseEvent) {
                TimeLineView.this.mLabels.mouseMove(mouseEvent);
            }
        });
        this.setData(traceReader.getThreadTimeRecords());
    }

    @Override
    public void update(Observable observable, Object object) {
        if (object == "TimeLineView") {
            return;
        }
        boolean bl = false;
        ArrayList<Selection> arrayList = this.mSelectionController.getSelections();
        for (Selection selection : arrayList) {
            Selection.Action action = selection.getAction();
            if (action != Selection.Action.Highlight) continue;
            String string = selection.getName();
            if (string == "MethodData") {
                bl = true;
                this.mHighlightMethodData = (MethodData)selection.getValue();
                this.mHighlightCall = null;
                this.startHighlighting();
                continue;
            }
            if (string != "Call") continue;
            bl = true;
            this.mHighlightCall = (Call)selection.getValue();
            this.mHighlightMethodData = null;
            this.startHighlighting();
        }
        if (!bl) {
            this.mSurface.clearHighlights();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setData(ArrayList<Record> arrayList) {
        void var8_12;
        void var8_10;
        Object object;
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        Collections.sort(arrayList, new Comparator<Record>(){

            @Override
            public int compare(Record record, Record record2) {
                long l;
                long l2;
                long l3 = record.block.getStartTime();
                if (l3 > (l2 = record2.block.getStartTime())) {
                    return 1;
                }
                if (l3 < l2) {
                    return -1;
                }
                long l4 = record.block.getEndTime();
                if (l4 > (l = record2.block.getEndTime())) {
                    return -1;
                }
                if (l4 < l) {
                    return 1;
                }
                return 0;
            }
        });
        ArrayList<Segment> arrayList2 = new ArrayList<Segment>();
        double d = 0.0;
        if (arrayList.size() > 0) {
            d = arrayList.get((int)0).block.getStartTime();
        }
        double d2 = 0.0;
        for (Record object2 : arrayList) {
            Block block;
            object = object2.row;
            Block block2 = object2.block;
            if (block2.isIgnoredBlock()) continue;
            String string = object.getName();
            RowData rowData = this.mRowByName.get(string);
            if (rowData == null) {
                rowData = new RowData((Row)object);
                this.mRowByName.put(string, rowData);
            }
            long l = block2.getStartTime();
            long l2 = block2.getEndTime();
            if (l2 > rowData.mEndTime) {
                long l3 = Math.max(l, rowData.mEndTime);
                rowData.mElapsed += l2 - l3;
                rowData.mEndTime = l2;
            }
            if ((double)l2 > d2) {
                d2 = l2;
            }
            if ((block = rowData.top()) == null) {
                rowData.push(block2);
                continue;
            }
            long l4 = block.getStartTime();
            long l5 = block.getEndTime();
            if (l5 >= l) {
                if (l4 < l) {
                    Segment segment = new Segment(rowData, block, l4, l);
                    arrayList2.add(segment);
                }
                if (l5 == l) {
                    rowData.pop();
                }
                rowData.push(block2);
                continue;
            }
            TimeLineView.popFrames(rowData, block, l, arrayList2);
            rowData.push(block2);
        }
        for (RowData rowData : this.mRowByName.values()) {
            object = rowData.top();
            TimeLineView.popFrames(rowData, (Block)object, Integer.MAX_VALUE, arrayList2);
        }
        this.mSurface.setRange(d, d2);
        this.mSurface.setLimitRange(d, d2);
        Collection<RowData> collection = this.mRowByName.values();
        this.mRows = collection.toArray(new RowData[collection.size()]);
        Arrays.sort(this.mRows, new Comparator<RowData>(){

            @Override
            public int compare(RowData rowData, RowData rowData2) {
                return (int)(rowData2.mElapsed - rowData.mElapsed);
            }
        });
        boolean bl = false;
        while (var8_10 < this.mRows.length) {
            this.mRows[var8_10].mRank = (int)var8_10;
            ++var8_10;
        }
        this.mNumRows = 0;
        boolean bl2 = false;
        while (var8_12 < this.mRows.length && this.mRows[var8_12].mElapsed != 0L) {
            ++this.mNumRows;
            ++var8_12;
        }
        this.mSegments = arrayList2.toArray(new Segment[arrayList2.size()]);
        Arrays.sort(this.mSegments, new Comparator<Segment>(){

            @Override
            public int compare(Segment segment, Segment segment2) {
                RowData rowData = segment.mRowData;
                RowData rowData2 = segment2.mRowData;
                int n = rowData.mRank - rowData2.mRank;
                if (n == 0) {
                    long l = segment.mStartTime - segment2.mStartTime;
                    if (l == 0L) {
                        l = segment.mEndTime - segment2.mEndTime;
                    }
                    return (int)l;
                }
                return n;
            }
        });
    }

    private static void popFrames(RowData rowData, Block block, long l, ArrayList<Segment> arrayList) {
        Segment segment;
        long l2 = block.getEndTime();
        long l3 = block.getStartTime();
        while (l2 <= l) {
            if (l2 > l3) {
                segment = new Segment(rowData, block, l3, l2);
                arrayList.add(segment);
                l3 = l2;
            }
            rowData.pop();
            block = rowData.top();
            if (block == null) {
                return;
            }
            l2 = block.getEndTime();
        }
        if (l3 < l) {
            segment = new Segment(rowData, block, l3, l);
            arrayList.add(segment);
        }
    }

    private int computeVisibleRows(int n) {
        int n2 = this.mScrollOffsetY;
        int n3 = this.mNumRows * 32;
        if (n2 + n > n3 && (n2 = n3 - n) < 0) {
            n2 = 0;
        }
        this.mStartRow = n2 / 32;
        this.mEndRow = (n2 + n) / 32;
        if (this.mEndRow >= this.mNumRows) {
            this.mEndRow = this.mNumRows - 1;
        }
        return n2;
    }

    private void startHighlighting() {
        this.mSurface.mHighlightStep = 0;
        this.mSurface.mFadeColors = true;
        this.mSurface.mCachedEndRow = -1;
        this.getDisplay().timerExec(0, this.mSurface.mHighlightAnimator);
    }

    private static class Range {
        Point mXdim = new Point(0, 0);
        int mY;
        Color mColor;

        Range(int n, int n2, int n3, Color color) {
            this.mXdim.x = n;
            this.mXdim.y = n2;
            this.mY = n3;
            this.mColor = color;
        }
    }

    private static class Pixel {
        int mStart = -2;
        double mMaxWeight;
        Segment mSegment;
        Color mColor;
        RowData mRowData;

        private Pixel() {
        }

        public void setFields(int n, double d, Segment segment, Color color, RowData rowData) {
            this.mStart = n;
            this.mMaxWeight = d;
            this.mSegment = segment;
            this.mColor = color;
            this.mRowData = rowData;
        }
    }

    private static class Strip {
        int mX;
        int mY;
        int mWidth;
        int mHeight;
        RowData mRowData;
        Segment mSegment;
        Color mColor;

        Strip(int n, int n2, int n3, int n4, RowData rowData, Segment segment, Color color) {
            this.mX = n;
            this.mY = n2;
            this.mWidth = n3;
            this.mHeight = n4;
            this.mRowData = rowData;
            this.mSegment = segment;
            this.mColor = color;
        }
    }

    private static class Segment {
        private RowData mRowData;
        private Block mBlock;
        private long mStartTime;
        private long mEndTime;
        private boolean mIsContextSwitch;

        Segment(RowData rowData, Block block, long l, long l2) {
            this.mRowData = rowData;
            if (block.isContextSwitch()) {
                this.mBlock = block.getParentBlock();
                this.mIsContextSwitch = true;
            } else {
                this.mBlock = block;
            }
            this.mStartTime = l;
            this.mEndTime = l2;
        }
    }

    private static class RowData {
        private String mName;
        private int mRank;
        private long mElapsed;
        private long mEndTime;
        private ArrayList<Block> mStack;

        RowData(Row row) {
            this.mName = row.getName();
            this.mStack = new ArrayList();
        }

        public void push(Block block) {
            this.mStack.add(block);
        }

        public Block top() {
            if (this.mStack.size() == 0) {
                return null;
            }
            return this.mStack.get(this.mStack.size() - 1);
        }

        public void pop() {
            if (this.mStack.size() == 0) {
                return;
            }
            this.mStack.remove(this.mStack.size() - 1);
        }
    }

    private class Surface
    extends Canvas {
        private static final int TotalXMargin = 70;
        private static final int yMargin = 1;
        private static final int MinZoomPixelMargin = 10;
        private GraphicsState mGraphicsState;
        private Point mMouse;
        private int mMouseMarkStartX;
        private int mMouseMarkEndX;
        private boolean mDebug;
        private ArrayList<Strip> mStripList;
        private ArrayList<Range> mHighlightExclusive;
        private ArrayList<Range> mHighlightInclusive;
        private int mMinStripHeight;
        private double mCachedMinVal;
        private double mCachedMaxVal;
        private int mCachedStartRow;
        private int mCachedEndRow;
        private double mScalePixelsPerRange;
        private double mScaleMinVal;
        private double mScaleMaxVal;
        private double mLimitMinVal;
        private double mLimitMaxVal;
        private double mMinDataVal;
        private double mMaxDataVal;
        private Cursor mNormalCursor;
        private Cursor mIncreasingCursor;
        private Cursor mDecreasingCursor;
        private static final int ZOOM_TIMER_INTERVAL = 10;
        private static final int HIGHLIGHT_TIMER_INTERVAL = 50;
        private static final int ZOOM_STEPS = 8;
        private int mHighlightHeight;
        private final int[] highlightHeights;
        private final int HIGHLIGHT_STEPS;
        private boolean mFadeColors;
        private boolean mShowHighlightName;
        private double[] mZoomFractions;
        private int mZoomStep;
        private int mZoomMouseStart;
        private int mZoomMouseEnd;
        private int mMouseStartDistance;
        private int mMouseEndDistance;
        private Point mMouseSelect;
        private double mZoomFixed;
        private double mZoomFixedPixel;
        private double mFixedPixelStartDistance;
        private double mFixedPixelEndDistance;
        private double mZoomMin2Fixed;
        private double mMin2ZoomMin;
        private double mFixed2ZoomMax;
        private double mZoomMax2Max;
        private double mZoomMin;
        private double mZoomMax;
        private Runnable mZoomAnimator;
        private Runnable mHighlightAnimator;
        private int mHighlightStep;

        public Surface(Composite composite) {
            super(composite, 262912);
            this.mGraphicsState = GraphicsState.Normal;
            this.mMouse = new Point(10, 0);
            this.mDebug = false;
            this.mStripList = new ArrayList();
            this.mHighlightExclusive = new ArrayList();
            this.mHighlightInclusive = new ArrayList();
            this.mMinStripHeight = 2;
            this.mHighlightHeight = 4;
            this.highlightHeights = new int[]{0, 2, 4, 5, 6, 5, 4, 2, 4, 5, 6};
            this.HIGHLIGHT_STEPS = this.highlightHeights.length;
            this.mMouseSelect = new Point(0, 0);
            Display display = this.getDisplay();
            this.mNormalCursor = new Cursor((Device)display, 2);
            this.mIncreasingCursor = new Cursor((Device)display, 12);
            this.mDecreasingCursor = new Cursor((Device)display, 13);
            this.initZoomFractionsWithExp();
            this.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent paintEvent) {
                    Surface.this.draw(paintEvent.display, paintEvent.gc);
                }
            });
            this.mZoomAnimator = new Runnable(){

                public void run() {
                    Surface.this.animateZoom();
                }
            };
            this.mHighlightAnimator = new Runnable(){

                public void run() {
                    Surface.this.animateHighlight();
                }
            };
        }

        private void initZoomFractionsWithExp() {
            this.mZoomFractions = new double[8];
            int n = 0;
            int n2 = 0;
            while (n2 < 4) {
                this.mZoomFractions[n] = (double)(1 << n2) / 16.0;
                ++n2;
                ++n;
            }
            n2 = 2;
            while (n2 < 6) {
                this.mZoomFractions[n] = (double)((1 << n2) - 1) / (double)(1 << n2);
                ++n2;
                ++n;
            }
        }

        private void initZoomFractionsWithSinWave() {
            this.mZoomFractions = new double[8];
            for (int i = 0; i < 8; ++i) {
                double d = Math.PI * (double)i / 8.0;
                this.mZoomFractions[i] = (Math.sin(4.71238898038469 + d) + 1.0) / 2.0;
            }
        }

        public void setRange(double d, double d2) {
            this.mMinDataVal = d;
            this.mMaxDataVal = d2;
            TimeLineView.this.mScaleInfo.setMinVal(d);
            TimeLineView.this.mScaleInfo.setMaxVal(d2);
        }

        public void setLimitRange(double d, double d2) {
            this.mLimitMinVal = d;
            this.mLimitMaxVal = d2;
        }

        public void resetScale() {
            TimeLineView.this.mScaleInfo.setMinVal(this.mLimitMinVal);
            TimeLineView.this.mScaleInfo.setMaxVal(this.mLimitMaxVal);
        }

        public void setScaleFromHorizontalScrollBar(int n) {
            double d = TimeLineView.this.mScaleInfo.getMinVal();
            double d2 = TimeLineView.this.mScaleInfo.getMaxVal();
            d = this.mLimitMinVal + (double)n;
            double d3 = d2 - d;
            if ((d2 = d + d3) > this.mLimitMaxVal) {
                d2 = this.mLimitMaxVal;
                d = d2 - d3;
            }
            TimeLineView.this.mScaleInfo.setMinVal(d);
            TimeLineView.this.mScaleInfo.setMaxVal(d2);
            this.mGraphicsState = GraphicsState.Scrolling;
        }

        private void updateHorizontalScrollBar() {
            double d = TimeLineView.this.mScaleInfo.getMinVal();
            double d2 = TimeLineView.this.mScaleInfo.getMaxVal();
            double d3 = d2 - d;
            double d4 = this.mLimitMaxVal - this.mLimitMinVal;
            ScrollBar scrollBar = this.getHorizontalBar();
            if (d4 > d3) {
                scrollBar.setVisible(true);
                scrollBar.setMinimum(0);
                scrollBar.setMaximum((int)Math.ceil(d4));
                scrollBar.setThumb((int)Math.ceil(d3));
                scrollBar.setSelection((int)Math.floor(d - this.mLimitMinVal));
            } else {
                scrollBar.setVisible(false);
            }
        }

        /*
         * WARNING - void declaration
         */
        private void draw(Display display, GC gC) {
            int n;
            if (TimeLineView.this.mSegments.length == 0) {
                return;
            }
            Image image = new Image((Device)display, this.getBounds());
            GC gC2 = new GC((Drawable)image);
            if (TimeLineView.this.mSetFonts) {
                gC2.setFont(TimeLineView.this.mFontRegistry.get("small"));
            }
            if (this.mGraphicsState == GraphicsState.Scaling) {
                double d;
                double d2 = this.mMouse.x - this.mMouseMarkStartX;
                if (d2 > 0.0) {
                    d = this.mScaleMinVal - d2 / this.mScalePixelsPerRange;
                    if (d < this.mLimitMinVal) {
                        d = this.mLimitMinVal;
                    }
                    TimeLineView.this.mScaleInfo.setMinVal(d);
                } else if (d2 < 0.0) {
                    d = this.mScaleMaxVal - d2 / this.mScalePixelsPerRange;
                    if (d > this.mLimitMaxVal) {
                        d = this.mLimitMaxVal;
                    }
                    TimeLineView.this.mScaleInfo.setMaxVal(d);
                }
            }
            Point point = this.getSize();
            if (TimeLineView.this.mStartRow != this.mCachedStartRow || TimeLineView.this.mEndRow != this.mCachedEndRow || TimeLineView.this.mScaleInfo.getMinVal() != this.mCachedMinVal || TimeLineView.this.mScaleInfo.getMaxVal() != this.mCachedMaxVal) {
                this.mCachedStartRow = TimeLineView.this.mStartRow;
                this.mCachedEndRow = TimeLineView.this.mEndRow;
                n = point.x - 70;
                TimeLineView.this.mScaleInfo.setNumPixels(n);
                boolean bl = this.mGraphicsState == GraphicsState.Scaling || this.mGraphicsState == GraphicsState.Animating || this.mGraphicsState == GraphicsState.Scrolling;
                TimeLineView.this.mScaleInfo.computeTicks(bl);
                this.mCachedMinVal = TimeLineView.this.mScaleInfo.getMinVal();
                this.mCachedMaxVal = TimeLineView.this.mScaleInfo.getMaxVal();
                if (this.mLimitMinVal > TimeLineView.this.mScaleInfo.getMinVal()) {
                    this.mLimitMinVal = TimeLineView.this.mScaleInfo.getMinVal();
                }
                if (this.mLimitMaxVal < TimeLineView.this.mScaleInfo.getMaxVal()) {
                    this.mLimitMaxVal = TimeLineView.this.mScaleInfo.getMaxVal();
                }
                this.computeStrips();
                this.updateHorizontalScrollBar();
            }
            if (TimeLineView.this.mNumRows > 2) {
                gC2.setBackground(TimeLineView.this.mColorRowBack);
                for (n = 1; n < TimeLineView.this.mNumRows; n += 2) {
                    RowData rowData = TimeLineView.this.mRows[n];
                    int n2 = rowData.mRank * 32 - TimeLineView.this.mScrollOffsetY;
                    gC2.fillRectangle(0, n2, point.x, 32);
                }
            }
            if (this.drawingSelection()) {
                this.drawSelection(display, gC2);
            }
            String string = null;
            Color color = null;
            String string2 = null;
            if (this.mDebug) {
                double d = TimeLineView.this.mScaleInfo.getPixelsPerRange();
                System.out.printf("dim.x %d pixels %d minVal %f, maxVal %f ppr %f rpp %f\n", point.x, point.x - 70, TimeLineView.this.mScaleInfo.getMinVal(), TimeLineView.this.mScaleInfo.getMaxVal(), d, 1.0 / d);
            }
            Block block = null;
            for (Strip object2 : this.mStripList) {
                if (object2.mColor == null) continue;
                gC2.setBackground(object2.mColor);
                gC2.fillRectangle(object2.mX, object2.mY - TimeLineView.this.mScrollOffsetY, object2.mWidth, object2.mHeight);
                if (TimeLineView.this.mMouseRow != object2.mRowData.mRank) continue;
                if (this.mMouse.x >= object2.mX && this.mMouse.x < object2.mX + object2.mWidth) {
                    Block block2 = object2.mSegment.mBlock;
                    string = block2.getName();
                    color = object2.mColor;
                    string2 = TimeLineView.this.mHaveCpuTime ? (TimeLineView.this.mHaveRealTime ? String.format("excl cpu %s, incl cpu %s, excl real %s, incl real %s", TimeLineView.this.mUnits.labelledString(block2.getExclusiveCpuTime()), TimeLineView.this.mUnits.labelledString(block2.getInclusiveCpuTime()), TimeLineView.this.mUnits.labelledString(block2.getExclusiveRealTime()), TimeLineView.this.mUnits.labelledString(block2.getInclusiveRealTime())) : String.format("excl cpu %s, incl cpu %s", TimeLineView.this.mUnits.labelledString(block2.getExclusiveCpuTime()), TimeLineView.this.mUnits.labelledString(block2.getInclusiveCpuTime()))) : String.format("excl real %s, incl real %s", TimeLineView.this.mUnits.labelledString(block2.getExclusiveRealTime()), TimeLineView.this.mUnits.labelledString(block2.getInclusiveRealTime()));
                }
                if (this.mMouseSelect.x < object2.mX || this.mMouseSelect.x >= object2.mX + object2.mWidth) continue;
                block = object2.mSegment.mBlock;
            }
            this.mMouseSelect.x = 0;
            this.mMouseSelect.y = 0;
            if (block != null) {
                ArrayList arrayList = new ArrayList();
                RowData rowData = TimeLineView.this.mRows[TimeLineView.this.mMouseRow];
                arrayList.add(Selection.highlight("Thread", rowData.mName));
                arrayList.add(Selection.highlight("Call", block));
                int n2 = this.mMouse.x - 10;
                double d = TimeLineView.this.mScaleInfo.pixelToValue(n2);
                arrayList.add(Selection.highlight("Time", d));
                TimeLineView.this.mSelectionController.change(arrayList, "TimeLineView");
                TimeLineView.this.mHighlightMethodData = null;
                TimeLineView.this.mHighlightCall = (Call)block;
                TimeLineView.this.startHighlighting();
            }
            if (TimeLineView.this.mMouseRow >= 0 && TimeLineView.this.mMouseRow < TimeLineView.this.mNumRows && this.mHighlightStep == 0) {
                gC2.setForeground(TimeLineView.this.mColorGray);
                int n4 = TimeLineView.this.mMouseRow * 32 - TimeLineView.this.mScrollOffsetY;
                gC2.drawLine(0, n4, point.x, n4);
                gC2.drawLine(0, n4 + 32, point.x, n4 + 32);
            }
            this.drawHighlights(gC2, point);
            gC2.setForeground(TimeLineView.this.mColorDarkGray);
            int n5 = Math.min(point.y, TimeLineView.this.mNumRows * 32);
            gC2.drawLine(this.mMouse.x, 0, this.mMouse.x, n5);
            if (string != null) {
                TimeLineView.this.mTimescale.setMethodName(string);
                TimeLineView.this.mTimescale.setMethodColor(color);
                TimeLineView.this.mTimescale.setDetails(string2);
                this.mShowHighlightName = false;
            } else if (this.mShowHighlightName) {
                void var11_25;
                MethodData methodData = TimeLineView.this.mHighlightMethodData;
                if (methodData == null && TimeLineView.this.mHighlightCall != null) {
                    MethodData methodData2 = TimeLineView.this.mHighlightCall.getMethodData();
                }
                if (var11_25 == null) {
                    System.out.printf("null highlight?\n", new Object[0]);
                }
                if (var11_25 != null) {
                    TimeLineView.this.mTimescale.setMethodName(var11_25.getProfileName());
                    TimeLineView.this.mTimescale.setMethodColor(var11_25.getColor());
                    TimeLineView.this.mTimescale.setDetails(null);
                }
            } else {
                TimeLineView.this.mTimescale.setMethodName(null);
                TimeLineView.this.mTimescale.setMethodColor(null);
                TimeLineView.this.mTimescale.setDetails(null);
            }
            TimeLineView.this.mTimescale.redraw();
            gC.drawImage(image, 0, 0);
            image.dispose();
            gC2.dispose();
        }

        private void drawHighlights(GC gC, Point point) {
            int n;
            int n2;
            int n3 = this.mHighlightHeight;
            if (n3 <= 0) {
                return;
            }
            for (Range range : this.mHighlightExclusive) {
                gC.setBackground(range.mColor);
                n2 = range.mXdim.x;
                n = range.mXdim.y;
                gC.fillRectangle(n2, range.mY - n3 - TimeLineView.this.mScrollOffsetY, n, n3);
            }
            if (--n3 <= 0) {
                n3 = 1;
            }
            gC.setForeground(TimeLineView.this.mColorDarkGray);
            gC.setBackground(TimeLineView.this.mColorDarkGray);
            for (Range range : this.mHighlightInclusive) {
                int[] nArray;
                n2 = range.mXdim.x;
                n = range.mXdim.y;
                boolean bl = false;
                boolean bl2 = false;
                if (n2 >= 10) {
                    bl = true;
                } else {
                    n2 = 10;
                }
                if (n >= 10) {
                    bl2 = true;
                } else {
                    n = point.x - 60;
                }
                int n4 = range.mY + 20 + 2 - TimeLineView.this.mScrollOffsetY;
                if (n - n2 < 3) {
                    int n5 = n - n2;
                    if (n5 < 2) {
                        n5 = 2;
                    }
                    gC.fillRectangle(n2, n4, n5, n3);
                    continue;
                }
                if (bl) {
                    if (bl2) {
                        nArray = new int[]{n2, n4, n2, n4 + n3, n, n4 + n3, n, n4};
                        gC.drawPolyline(nArray);
                    } else {
                        nArray = new int[]{n2, n4, n2, n4 + n3, n, n4 + n3};
                        gC.drawPolyline(nArray);
                    }
                } else if (bl2) {
                    nArray = new int[]{n2, n4 + n3, n, n4 + n3, n, n4};
                    gC.drawPolyline(nArray);
                } else {
                    nArray = new int[]{n2, n4 + n3, n, n4 + n3};
                    gC.drawPolyline(nArray);
                }
                if (!bl) {
                    nArray = new int[]{n2 + 7, n4 + n3 - 4, n2, n4 + n3, n2 + 7, n4 + n3 + 4};
                    gC.fillPolygon(nArray);
                }
                if (bl2) continue;
                nArray = new int[]{n - 7, n4 + n3 - 4, n, n4 + n3, n - 7, n4 + n3 + 4};
                gC.fillPolygon(nArray);
            }
        }

        private boolean drawingSelection() {
            return this.mGraphicsState == GraphicsState.Marking || this.mGraphicsState == GraphicsState.Animating;
        }

        private void drawSelection(Display display, GC gC) {
            int n;
            int n2;
            int n3;
            Point point = this.getSize();
            gC.setForeground(TimeLineView.this.mColorGray);
            gC.drawLine(this.mMouseMarkStartX, 0, this.mMouseMarkStartX, point.y);
            gC.setBackground(TimeLineView.this.mColorZoomSelection);
            int n4 = n3 = this.mGraphicsState == GraphicsState.Animating ? this.mMouseMarkEndX : this.mMouse.x;
            if (this.mMouseMarkStartX < n3) {
                n2 = this.mMouseMarkStartX;
                n = n3 - this.mMouseMarkStartX;
            } else {
                n2 = n3;
                n = this.mMouseMarkStartX - n3;
            }
            gC.fillRectangle(n2, 0, n, point.y);
        }

        private void computeStrips() {
            Color color;
            int n;
            double d = TimeLineView.this.mScaleInfo.getMinVal();
            double d2 = TimeLineView.this.mScaleInfo.getMaxVal();
            Pixel[] pixelArray = new Pixel[TimeLineView.this.mNumRows];
            for (n = 0; n < TimeLineView.this.mNumRows; ++n) {
                pixelArray[n] = new Pixel();
            }
            for (n = 0; n < TimeLineView.this.mSegments.length; ++n) {
                TimeLineView.this.mSegments[n].mBlock.clearWeight();
            }
            this.mStripList.clear();
            this.mHighlightExclusive.clear();
            this.mHighlightInclusive.clear();
            MethodData methodData = null;
            long l = 0L;
            long l2 = -1L;
            RowData rowData = null;
            int n2 = -1;
            int n3 = -1;
            int n4 = -1;
            int n5 = -1;
            if (TimeLineView.this.mHighlightCall != null) {
                int n6 = -1;
                int n7 = -1;
                l = TimeLineView.this.mHighlightCall.getStartTime();
                l2 = TimeLineView.this.mHighlightCall.getEndTime();
                methodData = TimeLineView.this.mHighlightCall.getMethodData();
                if ((double)l >= d) {
                    n6 = TimeLineView.this.mScaleInfo.valueToPixel(l);
                }
                if ((double)l2 <= d2) {
                    n7 = TimeLineView.this.mScaleInfo.valueToPixel(l2);
                }
                int n8 = TimeLineView.this.mHighlightCall.getThreadId();
                String object = (String)TimeLineView.this.mThreadLabels.get(n8);
                rowData = (RowData)TimeLineView.this.mRowByName.get(object);
                int n9 = rowData.mRank * 32 + 6;
                color = methodData.getColor();
                this.mHighlightInclusive.add(new Range(n6 + 10, n7 + 10, n9, color));
            }
            for (Segment segment : TimeLineView.this.mSegments) {
                int d6;
                double d3;
                double d4;
                Block block;
                if ((double)segment.mEndTime <= d || (double)segment.mStartTime >= d2 || (color = (block = segment.mBlock).getColor()) == null || (d4 = Math.max((double)segment.mStartTime, d)) == (d3 = Math.min((double)segment.mEndTime, d2))) continue;
                int n10 = TimeLineView.this.mScaleInfo.valueToPixel(d4);
                int n11 = TimeLineView.this.mScaleInfo.valueToPixel(d3);
                int n12 = n11 - n10;
                boolean bl = segment.mIsContextSwitch;
                RowData rowData2 = segment.mRowData;
                MethodData methodData2 = block.getMethodData();
                int n13 = rowData2.mRank * 32 + 6;
                if (rowData2.mRank > TimeLineView.this.mEndRow) break;
                if (TimeLineView.this.mHighlightMethodData != null) {
                    if (TimeLineView.this.mHighlightMethodData == methodData2) {
                        if (n2 != n10 || n3 != n11) {
                            n2 = n10;
                            n3 = n11;
                            int n14 = n12;
                            if (n14 == 0) {
                                n14 = 1;
                            }
                            this.mHighlightExclusive.add(new Range(n10 + 10, n14, n13, color));
                            l = block.getStartTime();
                            d6 = -1;
                            if ((double)l >= d) {
                                d6 = TimeLineView.this.mScaleInfo.valueToPixel(l);
                            }
                            int n15 = -1;
                            l2 = block.getEndTime();
                            if ((double)l2 <= d2) {
                                n15 = TimeLineView.this.mScaleInfo.valueToPixel(l2);
                            }
                            if (n4 != d6 || n5 != n15) {
                                n4 = d6;
                                n5 = n15;
                                this.mHighlightInclusive.add(new Range(d6 + 10, n15 + 10, n13, color));
                            }
                        }
                    } else if (this.mFadeColors) {
                        color = methodData2.getFadedColor();
                    }
                } else if (TimeLineView.this.mHighlightCall != null) {
                    if (segment.mStartTime >= l && segment.mEndTime <= l2 && methodData == methodData2 && rowData == rowData2) {
                        if (n2 != n10 || n3 != n11) {
                            n2 = n10;
                            n3 = n11;
                            int n16 = n12;
                            if (n16 == 0) {
                                n16 = 1;
                            }
                            this.mHighlightExclusive.add(new Range(n10 + 10, n16, n13, color));
                        }
                    } else if (this.mFadeColors) {
                        color = methodData2.getFadedColor();
                    }
                }
                Pixel n17 = pixelArray[rowData2.mRank];
                if (n17.mStart != n10) {
                    if (n17.mSegment != null) {
                        this.emitPixelStrip(rowData2, n13, n17);
                    }
                    if (n12 == 0) {
                        double d5 = this.computeWeight(d4, d3, bl, n10);
                        d5 = block.addWeight(n10, rowData2.mRank, d5);
                        if (!(d5 > n17.mMaxWeight)) continue;
                        n17.setFields(n10, d5, segment, color, rowData2);
                        continue;
                    }
                    d6 = n10 + 10;
                    Strip strip = new Strip(d6, bl ? n13 + 20 - 1 : n13, n12, bl ? 1 : 20, rowData2, segment, color);
                    this.mStripList.add(strip);
                    continue;
                }
                double d7 = this.computeWeight(d4, d3, bl, n10);
                d7 = block.addWeight(n10, rowData2.mRank, d7);
                if (d7 > n17.mMaxWeight) {
                    n17.setFields(n10, d7, segment, color, rowData2);
                }
                if (n12 == 1) {
                    this.emitPixelStrip(rowData2, n13, n17);
                    d7 = this.computeWeight(d4, d3, bl, ++n10);
                    d7 = block.addWeight(n10, rowData2.mRank, d7);
                    n17.setFields(n10, d7, segment, color, rowData2);
                    continue;
                }
                if (n12 <= 1) continue;
                this.emitPixelStrip(rowData2, n13, n17);
                int n18 = ++n10 + 10;
                Strip strip = new Strip(n18, bl ? n13 + 20 - 1 : n13, --n12, bl ? 1 : 20, rowData2, segment, color);
                this.mStripList.add(strip);
            }
            for (int i = 0; i < TimeLineView.this.mNumRows; ++i) {
                Pixel pixel = pixelArray[i];
                if (pixel.mSegment == null) continue;
                RowData rowData3 = pixel.mRowData;
                int n19 = rowData3.mRank * 32 + 6;
                this.emitPixelStrip(rowData3, n19, pixel);
            }
        }

        private double computeWeight(double d, double d2, boolean bl, int n) {
            if (bl) {
                return 0.0;
            }
            double d3 = TimeLineView.this.mScaleInfo.valueToPixelFraction(d);
            double d4 = TimeLineView.this.mScaleInfo.valueToPixelFraction(d2);
            double d5 = Math.max(d3, (double)n - 0.5);
            double d6 = Math.min(d4, (double)n + 0.5);
            double d7 = d6 - d5;
            return d7;
        }

        private void emitPixelStrip(RowData rowData, int n, Pixel pixel) {
            Strip strip;
            int n2;
            if (pixel.mSegment == null) {
                return;
            }
            int n3 = pixel.mStart + 10;
            int n4 = (int)(pixel.mMaxWeight * 20.0 * 0.75);
            if (n4 < this.mMinStripHeight) {
                n4 = this.mMinStripHeight;
            }
            if ((n2 = 20 - n4) > 0) {
                strip = new Strip(n3, n, 1, n2, rowData, pixel.mSegment, this.mFadeColors ? TimeLineView.this.mColorGray : TimeLineView.this.mColorBlack);
                this.mStripList.add(strip);
            }
            strip = new Strip(n3, n + n2, 1, n4, rowData, pixel.mSegment, pixel.mColor);
            this.mStripList.add(strip);
            pixel.mSegment = null;
            pixel.mMaxWeight = 0.0;
        }

        private void mouseMove(MouseEvent mouseEvent) {
            Point point = TimeLineView.this.mSurface.getSize();
            int n = mouseEvent.x;
            if (n < 10) {
                n = 10;
            }
            if (n > point.x - 60) {
                n = point.x - 60;
            }
            this.mMouse.x = n;
            this.mMouse.y = mouseEvent.y;
            TimeLineView.this.mTimescale.setVbarPosition(n);
            if (this.mGraphicsState == GraphicsState.Marking) {
                TimeLineView.this.mTimescale.setMarkEnd(n);
            }
            if (this.mGraphicsState == GraphicsState.Normal) {
                TimeLineView.this.mSurface.setCursor(this.mNormalCursor);
            } else if (this.mGraphicsState == GraphicsState.Marking) {
                if (this.mMouse.x >= this.mMouseMarkStartX) {
                    TimeLineView.this.mSurface.setCursor(this.mIncreasingCursor);
                } else {
                    TimeLineView.this.mSurface.setCursor(this.mDecreasingCursor);
                }
            }
            int n2 = (this.mMouse.y + TimeLineView.this.mScrollOffsetY) / 32;
            if (mouseEvent.y < 0 || mouseEvent.y >= point.y) {
                n2 = -1;
            }
            if (TimeLineView.this.mMouseRow != n2) {
                TimeLineView.this.mMouseRow = n2;
                TimeLineView.this.mLabels.redraw();
            }
            this.redraw();
        }

        private void mouseDown(MouseEvent mouseEvent) {
            Point point = TimeLineView.this.mSurface.getSize();
            int n = mouseEvent.x;
            if (n < 10) {
                n = 10;
            }
            if (n > point.x - 60) {
                n = point.x - 60;
            }
            this.mMouseMarkStartX = n;
            this.mGraphicsState = GraphicsState.Marking;
            TimeLineView.this.mSurface.setCursor(this.mIncreasingCursor);
            TimeLineView.this.mTimescale.setMarkStart(this.mMouseMarkStartX);
            TimeLineView.this.mTimescale.setMarkEnd(this.mMouseMarkStartX);
            this.redraw();
        }

        private void mouseUp(MouseEvent mouseEvent) {
            TimeLineView.this.mSurface.setCursor(this.mNormalCursor);
            if (this.mGraphicsState != GraphicsState.Marking) {
                this.mGraphicsState = GraphicsState.Normal;
                return;
            }
            this.mGraphicsState = GraphicsState.Animating;
            Point point = TimeLineView.this.mSurface.getSize();
            if (mouseEvent.y <= 0 || mouseEvent.y >= point.y) {
                this.mGraphicsState = GraphicsState.Normal;
                this.redraw();
                return;
            }
            int n = mouseEvent.x;
            if (n < 10) {
                n = 10;
            }
            if (n > point.x - 60) {
                n = point.x - 60;
            }
            this.mMouseMarkEndX = n;
            int n2 = this.mMouseMarkEndX - this.mMouseMarkStartX;
            if (n2 < 0) {
                n2 = -n2;
            }
            if (n2 <= 2) {
                this.mGraphicsState = GraphicsState.Normal;
                this.mMouseSelect.x = this.mMouseMarkStartX;
                this.mMouseSelect.y = mouseEvent.y;
                this.redraw();
                return;
            }
            if (this.mMouseMarkEndX < this.mMouseMarkStartX) {
                int n3 = this.mMouseMarkEndX;
                this.mMouseMarkEndX = this.mMouseMarkStartX;
                this.mMouseMarkStartX = n3;
            }
            if (this.mMouseMarkStartX <= 20 && this.mMouseMarkEndX >= point.x - 60 - 10) {
                this.mGraphicsState = GraphicsState.Normal;
                this.redraw();
                return;
            }
            double d = TimeLineView.this.mScaleInfo.getMinVal();
            double d2 = TimeLineView.this.mScaleInfo.getMaxVal();
            double d3 = TimeLineView.this.mScaleInfo.getPixelsPerRange();
            this.mZoomMin = d + (double)(this.mMouseMarkStartX - 10) / d3;
            this.mZoomMax = d + (double)(this.mMouseMarkEndX - 10) / d3;
            if (this.mZoomMin < this.mMinDataVal) {
                this.mZoomMin = this.mMinDataVal;
            }
            if (this.mZoomMax > this.mMaxDataVal) {
                this.mZoomMax = this.mMaxDataVal;
            }
            int n4 = point.x - 70;
            TickScaler tickScaler = new TickScaler(this.mZoomMin, this.mZoomMax, n4, 50);
            tickScaler.computeTicks(false);
            this.mZoomMin = tickScaler.getMinVal();
            this.mZoomMax = tickScaler.getMaxVal();
            this.mMouseMarkStartX = (int)((this.mZoomMin - d) * d3 + 10.0);
            this.mMouseMarkEndX = (int)((this.mZoomMax - d) * d3 + 10.0);
            TimeLineView.this.mTimescale.setMarkStart(this.mMouseMarkStartX);
            TimeLineView.this.mTimescale.setMarkEnd(this.mMouseMarkEndX);
            this.mMouseEndDistance = point.x - 60 - this.mMouseMarkEndX;
            this.mMouseStartDistance = this.mMouseMarkStartX - 10;
            this.mZoomMouseStart = this.mMouseMarkStartX;
            this.mZoomMouseEnd = this.mMouseMarkEndX;
            this.mZoomStep = 0;
            this.mMin2ZoomMin = this.mZoomMin - d;
            this.mZoomMax2Max = d2 - this.mZoomMax;
            this.mZoomFixed = this.mZoomMin + (this.mZoomMax - this.mZoomMin) * this.mMin2ZoomMin / (this.mMin2ZoomMin + this.mZoomMax2Max);
            this.mZoomFixedPixel = (this.mZoomFixed - d) * d3 + 10.0;
            this.mFixedPixelStartDistance = this.mZoomFixedPixel - 10.0;
            this.mFixedPixelEndDistance = (double)(point.x - 60) - this.mZoomFixedPixel;
            this.mZoomMin2Fixed = this.mZoomFixed - this.mZoomMin;
            this.mFixed2ZoomMax = this.mZoomMax - this.mZoomFixed;
            this.getDisplay().timerExec(10, this.mZoomAnimator);
            this.redraw();
            this.update();
        }

        private void mouseScrolled(MouseEvent mouseEvent) {
            double d;
            double d2;
            this.mGraphicsState = GraphicsState.Scrolling;
            double d3 = TimeLineView.this.mScaleInfo.getMinVal();
            double d4 = TimeLineView.this.mScaleInfo.getMaxVal();
            double d5 = 2.0;
            double d6 = this.mLimitMinVal;
            double d7 = this.mLimitMaxVal;
            if (mouseEvent.count > 0) {
                Point point = TimeLineView.this.mSurface.getSize();
                int n = mouseEvent.x;
                if (n < 10) {
                    n = 10;
                }
                if (n > point.x - 60) {
                    n = point.x - 60;
                }
                double d8 = TimeLineView.this.mScaleInfo.getPixelsPerRange();
                double d9 = d3 + (double)(n - 10) / d8;
                d2 = Math.max(d6, d9 - (d9 - d3) / d5);
                d = Math.min(d7, d9 + (d4 - d9) / d5);
            } else {
                double d10 = (d4 - d3) / (d7 - d6);
                if (d10 < 1.0) {
                    double d11 = (d10 * d6 - d3) / (d10 - 1.0);
                    d2 = Math.max(d6, d11 - d5 * (d11 - d3));
                    d = Math.min(d7, d11 + d5 * (d4 - d11));
                } else {
                    return;
                }
            }
            TimeLineView.this.mScaleInfo.setMinVal(d2);
            TimeLineView.this.mScaleInfo.setMaxVal(d);
            TimeLineView.this.mSurface.redraw();
        }

        private void mouseDoubleClick(MouseEvent mouseEvent) {
        }

        public void startScaling(int n) {
            Point point = TimeLineView.this.mSurface.getSize();
            int n2 = n;
            if (n2 < 10) {
                n2 = 10;
            }
            if (n2 > point.x - 60) {
                n2 = point.x - 60;
            }
            this.mMouseMarkStartX = n2;
            this.mGraphicsState = GraphicsState.Scaling;
            this.mScalePixelsPerRange = TimeLineView.this.mScaleInfo.getPixelsPerRange();
            this.mScaleMinVal = TimeLineView.this.mScaleInfo.getMinVal();
            this.mScaleMaxVal = TimeLineView.this.mScaleInfo.getMaxVal();
        }

        public void stopScaling(int n) {
            this.mGraphicsState = GraphicsState.Normal;
        }

        private void animateHighlight() {
            ++this.mHighlightStep;
            if (this.mHighlightStep >= this.HIGHLIGHT_STEPS) {
                this.mFadeColors = false;
                this.mHighlightStep = 0;
                this.mCachedEndRow = -1;
            } else {
                this.mFadeColors = true;
                this.mShowHighlightName = true;
                this.mHighlightHeight = this.highlightHeights[this.mHighlightStep];
                this.getDisplay().timerExec(50, this.mHighlightAnimator);
            }
            this.redraw();
        }

        private void clearHighlights() {
            this.mShowHighlightName = false;
            this.mHighlightHeight = 0;
            TimeLineView.this.mHighlightMethodData = null;
            TimeLineView.this.mHighlightCall = null;
            this.mFadeColors = false;
            this.mHighlightStep = 0;
            this.mCachedEndRow = -1;
            this.redraw();
        }

        private void animateZoom() {
            ++this.mZoomStep;
            if (this.mZoomStep > 8) {
                this.mGraphicsState = GraphicsState.Normal;
                this.mCachedMinVal = TimeLineView.this.mScaleInfo.getMinVal() + 1.0;
            } else if (this.mZoomStep == 8) {
                TimeLineView.this.mScaleInfo.setMinVal(this.mZoomMin);
                TimeLineView.this.mScaleInfo.setMaxVal(this.mZoomMax);
                this.mMouseMarkStartX = 10;
                Point point = this.getSize();
                this.mMouseMarkEndX = point.x - 60;
                TimeLineView.this.mTimescale.setMarkStart(this.mMouseMarkStartX);
                TimeLineView.this.mTimescale.setMarkEnd(this.mMouseMarkEndX);
                this.getDisplay().timerExec(10, this.mZoomAnimator);
            } else {
                double d = this.mZoomFractions[this.mZoomStep];
                this.mMouseMarkStartX = (int)((double)this.mZoomMouseStart - d * (double)this.mMouseStartDistance);
                this.mMouseMarkEndX = (int)((double)this.mZoomMouseEnd + d * (double)this.mMouseEndDistance);
                TimeLineView.this.mTimescale.setMarkStart(this.mMouseMarkStartX);
                TimeLineView.this.mTimescale.setMarkEnd(this.mMouseMarkEndX);
                double d2 = this.mZoomMin2Fixed >= this.mFixed2ZoomMax ? (this.mZoomFixedPixel - (double)this.mMouseMarkStartX) / this.mZoomMin2Fixed : ((double)this.mMouseMarkEndX - this.mZoomFixedPixel) / this.mFixed2ZoomMax;
                double d3 = this.mZoomFixed - this.mFixedPixelStartDistance / d2;
                double d4 = this.mZoomFixed + this.mFixedPixelEndDistance / d2;
                TimeLineView.this.mScaleInfo.setMinVal(d3);
                TimeLineView.this.mScaleInfo.setMaxVal(d4);
                this.getDisplay().timerExec(10, this.mZoomAnimator);
            }
            this.redraw();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum GraphicsState {
        Normal,
        Marking,
        Scaling,
        Animating,
        Scrolling;

    }

    private class Timescale
    extends Canvas {
        private Point mMouse;
        private Cursor mZoomCursor;
        private String mMethodName;
        private Color mMethodColor;
        private String mDetails;
        private int mMethodStartY;
        private int mDetailsStartY;
        private int mMarkStartX;
        private int mMarkEndX;
        private static final int METHOD_BLOCK_MARGIN = 10;

        public Timescale(Composite composite) {
            super(composite, 0);
            this.mMouse = new Point(10, 0);
            this.mMethodName = null;
            this.mMethodColor = null;
            Display display = this.getDisplay();
            this.mZoomCursor = new Cursor((Device)display, 9);
            this.setCursor(this.mZoomCursor);
            this.mMethodStartY = TimeLineView.this.mSmallFontHeight + 1;
            this.mDetailsStartY = this.mMethodStartY + TimeLineView.this.mSmallFontHeight + 1;
            this.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent paintEvent) {
                    Timescale.this.draw(paintEvent.display, paintEvent.gc);
                }
            });
        }

        public void setVbarPosition(int n) {
            this.mMouse.x = n;
        }

        public void setMarkStart(int n) {
            this.mMarkStartX = n;
        }

        public void setMarkEnd(int n) {
            this.mMarkEndX = n;
        }

        public void setMethodName(String string) {
            this.mMethodName = string;
        }

        public void setMethodColor(Color color) {
            this.mMethodColor = color;
        }

        public void setDetails(String string) {
            this.mDetails = string;
        }

        private void mouseMove(MouseEvent mouseEvent) {
            mouseEvent.y = -1;
            TimeLineView.this.mSurface.mouseMove(mouseEvent);
        }

        private void mouseDown(MouseEvent mouseEvent) {
            TimeLineView.this.mSurface.startScaling(mouseEvent.x);
            TimeLineView.this.mSurface.redraw();
        }

        private void mouseUp(MouseEvent mouseEvent) {
            TimeLineView.this.mSurface.stopScaling(mouseEvent.x);
        }

        private void mouseDoubleClick(MouseEvent mouseEvent) {
            TimeLineView.this.mSurface.resetScale();
            TimeLineView.this.mSurface.redraw();
        }

        private void draw(Display display, GC gC) {
            Point point = this.getSize();
            Image image = new Image((Device)display, this.getBounds());
            GC gC2 = new GC((Drawable)image);
            if (TimeLineView.this.mSetFonts) {
                gC2.setFont(TimeLineView.this.mFontRegistry.get("medium"));
            }
            if (TimeLineView.this.mSurface.drawingSelection()) {
                this.drawSelection(display, gC2);
            }
            this.drawTicks(display, gC2);
            gC2.setForeground(TimeLineView.this.mColorDarkGray);
            gC2.drawLine(this.mMouse.x, 58, this.mMouse.x, point.y);
            this.drawTickLegend(display, gC2);
            this.drawMethod(display, gC2);
            this.drawDetails(display, gC2);
            gC.drawImage(image, 0, 0);
            image.dispose();
            gC2.dispose();
        }

        private void drawSelection(Display display, GC gC) {
            int n;
            int n2;
            Point point = this.getSize();
            gC.setForeground(TimeLineView.this.mColorGray);
            gC.drawLine(this.mMarkStartX, 58, this.mMarkStartX, point.y);
            gC.setBackground(TimeLineView.this.mColorZoomSelection);
            if (this.mMarkStartX < this.mMarkEndX) {
                n2 = this.mMarkStartX;
                n = this.mMarkEndX - this.mMarkStartX;
            } else {
                n2 = this.mMarkEndX;
                n = this.mMarkStartX - this.mMarkEndX;
            }
            if (n > 1) {
                gC.fillRectangle(n2, 58, n, point.y);
            }
        }

        private void drawTickLegend(Display display, GC gC) {
            int n = this.mMouse.x - 10;
            double d = TimeLineView.this.mScaleInfo.pixelToValue(n);
            String string = TimeLineView.this.mUnits.labelledString(d);
            gC.setForeground(TimeLineView.this.mColorForeground);
            gC.drawString(string, 12, 1, true);
            double d2 = TimeLineView.this.mScaleInfo.getMaxVal();
            string = TimeLineView.this.mUnits.labelledString(d2);
            string = TimeLineView.this.mClockSource != null ? String.format(" max %s (%s)", string, TimeLineView.this.mClockSource) : String.format(" max %s ", string);
            Point point = gC.stringExtent(string);
            Point point2 = this.getSize();
            int n2 = point2.x - 60 - point.x;
            gC.drawString(string, n2, 1, true);
        }

        private void drawMethod(Display display, GC gC) {
            if (this.mMethodName == null) {
                return;
            }
            int n = 10;
            int n2 = this.mMethodStartY;
            gC.setBackground(this.mMethodColor);
            int n3 = 2 * TimeLineView.this.mSmallFontWidth;
            gC.fillRectangle(n, n2, n3, TimeLineView.this.mSmallFontHeight);
            gC.drawString(this.mMethodName, n += n3 + 10, n2, true);
        }

        private void drawDetails(Display display, GC gC) {
            if (this.mDetails == null) {
                return;
            }
            int n = 10 + 2 * TimeLineView.this.mSmallFontWidth + 10;
            int n2 = this.mDetailsStartY;
            gC.drawString(this.mDetails, n, n2, true);
        }

        private void drawTicks(Display display, GC gC) {
            int n;
            double d;
            Point point = this.getSize();
            int n2 = 66;
            int n3 = 62;
            int n4 = n2 + 2;
            gC.setForeground(TimeLineView.this.mColorForeground);
            gC.drawLine(10, 58, point.x - 60, 58);
            double d2 = TimeLineView.this.mScaleInfo.getMinVal();
            double d3 = TimeLineView.this.mScaleInfo.getMaxVal();
            double d4 = TimeLineView.this.mScaleInfo.getMinMajorTick();
            double d5 = TimeLineView.this.mScaleInfo.getTickIncrement();
            double d6 = d5 / 5.0;
            double d7 = TimeLineView.this.mScaleInfo.getPixelsPerRange();
            if (d2 < d4) {
                gC.setForeground(TimeLineView.this.mColorGray);
                d = d4;
                for (n = 1; n <= 4 && !((d -= d6) < d2); ++n) {
                    int n5 = 10 + (int)(0.5 + (d - d2) * d7);
                    gC.drawLine(n5, 58, n5, n3);
                }
            }
            if (d5 <= 10.0) {
                return;
            }
            for (d = d4; d <= d3; d += d5) {
                n = 10 + (int)(0.5 + (d - d2) * d7);
                gC.setForeground(TimeLineView.this.mColorForeground);
                gC.drawLine(n, 58, n, n2);
                if (d > d3) break;
                String string = TimeLineView.this.mUnits.valueOf(d);
                gC.drawString(string, n, n4, true);
                gC.setForeground(TimeLineView.this.mColorGray);
                double d8 = d;
                for (int i = 1; i <= 4 && !((d8 += d6) > d3); ++i) {
                    n = 10 + (int)(0.5 + (d8 - d2) * d7);
                    gC.drawLine(n, 58, n, n3);
                }
            }
        }
    }

    private class BlankCorner
    extends Canvas {
        public BlankCorner(Composite composite) {
            super(composite, 0);
            this.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent paintEvent) {
                    BlankCorner.this.draw(paintEvent.display, paintEvent.gc);
                }
            });
        }

        private void draw(Display display, GC gC) {
            Image image = new Image((Device)display, this.getBounds());
            gC.drawImage(image, 0, 0);
            image.dispose();
        }
    }

    private class RowLabels
    extends Canvas {
        private static final int labelMarginX = 2;

        public RowLabels(Composite composite) {
            super(composite, 262144);
            this.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent paintEvent) {
                    RowLabels.this.draw(paintEvent.display, paintEvent.gc);
                }
            });
        }

        private void mouseMove(MouseEvent mouseEvent) {
            int n = (mouseEvent.y + TimeLineView.this.mScrollOffsetY) / 32;
            if (TimeLineView.this.mMouseRow != n) {
                TimeLineView.this.mMouseRow = n;
                this.redraw();
                TimeLineView.this.mSurface.redraw();
            }
        }

        private void draw(Display display, GC gC) {
            int n;
            int n2;
            if (TimeLineView.this.mSegments.length == 0) {
                return;
            }
            Point point = this.getSize();
            Image image = new Image((Device)display, this.getBounds());
            GC gC2 = new GC((Drawable)image);
            if (TimeLineView.this.mSetFonts) {
                gC2.setFont(TimeLineView.this.mFontRegistry.get("medium"));
            }
            if (TimeLineView.this.mNumRows > 2) {
                gC2.setBackground(TimeLineView.this.mColorRowBack);
                for (n2 = 1; n2 < TimeLineView.this.mNumRows; n2 += 2) {
                    RowData rowData = TimeLineView.this.mRows[n2];
                    int n3 = rowData.mRank * 32 - TimeLineView.this.mScrollOffsetY;
                    gC2.fillRectangle(0, n3, point.x, 32);
                }
            }
            n2 = 6 - TimeLineView.this.mScrollOffsetY;
            for (n = TimeLineView.this.mStartRow; n <= TimeLineView.this.mEndRow; ++n) {
                RowData rowData = TimeLineView.this.mRows[n];
                int n4 = rowData.mRank * 32 + n2;
                Point point2 = gC2.stringExtent(rowData.mName);
                int n5 = point.x - point2.x - 2;
                gC2.drawString(rowData.mName, n5, n4, true);
            }
            if (TimeLineView.this.mMouseRow >= TimeLineView.this.mStartRow && TimeLineView.this.mMouseRow <= TimeLineView.this.mEndRow) {
                gC2.setForeground(TimeLineView.this.mColorGray);
                n = TimeLineView.this.mMouseRow * 32 - TimeLineView.this.mScrollOffsetY;
                gC2.drawRectangle(0, n, point.x, 32);
            }
            gC.drawImage(image, 0, 0);
            image.dispose();
            gC2.dispose();
        }
    }

    public static class Record {
        Row row;
        Block block;

        public Record(Row row, Block block) {
            this.row = row;
            this.block = block;
        }
    }

    public static interface Row {
        public int getId();

        public String getName();
    }

    public static interface Block {
        public String getName();

        public MethodData getMethodData();

        public long getStartTime();

        public long getEndTime();

        public Color getColor();

        public double addWeight(int var1, int var2, double var3);

        public void clearWeight();

        public long getExclusiveCpuTime();

        public long getInclusiveCpuTime();

        public long getExclusiveRealTime();

        public long getInclusiveRealTime();

        public boolean isContextSwitch();

        public boolean isIgnoredBlock();

        public Block getParentBlock();
    }
}

