/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.report;

import com.vladium.emma.EMMARuntimeException;
import com.vladium.emma.IAppErrorCodes;
import com.vladium.emma.report.AllItem;
import com.vladium.emma.report.ClassItem;
import com.vladium.emma.report.MethodItem;
import com.vladium.emma.report.PackageItem;
import com.vladium.emma.report.SrcFileItem;
import com.vladium.util.Files;
import com.vladium.util.IProperties;
import com.vladium.util.IntIntMap;
import com.vladium.util.IntVector;
import com.vladium.util.ObjectIntMap;
import com.vladium.util.Property;
import java.io.File;
import java.util.HashSet;
import java.util.StringTokenizer;

public abstract class ReportProperties
implements IAppErrorCodes {
    public static final IProperties.IMapper REPORT_PROPERTY_MAPPER = new ReportPropertyMapper();
    private static final boolean REMOVE_DUPLICATE_COLUMNS = true;
    private static final ObjectIntMap COLUMNS;

    public static ParsedProperties parseProperties(IProperties iProperties, String string) {
        String string2;
        String string3;
        Object object;
        Object object2;
        ParsedProperties parsedProperties = new ParsedProperties();
        parsedProperties.setOutEncoding(ReportProperties.getReportProperty(iProperties, string, "out.encoding", false));
        Object object3 = ReportProperties.getReportProperty(iProperties, string, "out.dir", true);
        String string4 = ReportProperties.getReportProperty(iProperties, string, "out.file", false);
        if (string4 != null) {
            object2 = Files.newFile((String)object3, string4);
            object = ((File)object2).getParentFile();
            if (object != null) {
                parsedProperties.setOutDir((File)object);
            }
            parsedProperties.setOutFile(new File(((File)object2).getName()));
        } else if (object3 != null) {
            parsedProperties.setOutDir(new File((String)object3));
        }
        object3 = ReportProperties.getReportProperty(iProperties, string, "units", true, "instr");
        parsedProperties.setUnitsType("count".equals(object3) ? 0 : 1);
        parsedProperties.setViewType(1);
        object3 = ReportProperties.getReportProperty(iProperties, string, "hideclasses", true, "true");
        parsedProperties.setHideClasses(Property.toBoolean((String)object3));
        if (parsedProperties.getViewType() == 0) {
            parsedProperties.setHideClasses(false);
        }
        if ("all".equals(object3 = ReportProperties.getReportProperty(iProperties, string, "depth", false, "package"))) {
            parsedProperties.setDepth(AllItem.getTypeMetadata().getTypeID());
        } else if ("package".equals(object3)) {
            parsedProperties.setDepth(PackageItem.getTypeMetadata().getTypeID());
        } else if ("source".equals(object3)) {
            parsedProperties.setDepth(SrcFileItem.getTypeMetadata().getTypeID());
        } else if ("class".equals(object3)) {
            parsedProperties.setDepth(ClassItem.getTypeMetadata().getTypeID());
        } else if ("method".equals(object3)) {
            parsedProperties.setDepth(MethodItem.getTypeMetadata().getTypeID());
        } else {
            throw new EMMARuntimeException("INVALID_PARAMETER_VALUE", new Object[]{"depth", object3});
        }
        if (parsedProperties.getHideClasses() && parsedProperties.getViewType() == 1 && parsedProperties.getDepth() == 3) {
            parsedProperties.setDepth(2);
        }
        object3 = new HashSet();
        string4 = ReportProperties.getReportProperty(iProperties, string, "columns", false, "class,method,block,line,name");
        object2 = new IntVector();
        object = new int[1];
        StringTokenizer stringTokenizer = new StringTokenizer(string4, ",");
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken().trim();
            if (!COLUMNS.get(string3, (int[])object)) {
                throw new EMMARuntimeException("INVALID_COLUMN_NAME", new Object[]{string3});
            }
            if (object3.contains(string3)) continue;
            object3.add(string3);
            ((IntVector)object2).add((int)object[0]);
        }
        parsedProperties.setColumnOrder(((IntVector)object2).values());
        string4 = ReportProperties.getReportProperty(iProperties, string, "sort", false, "+block,+name");
        object2 = new IntVector();
        object = new int[1];
        stringTokenizer = new StringTokenizer(string4, ",");
        while (stringTokenizer.hasMoreTokens()) {
            int n;
            string3 = stringTokenizer.nextToken().trim();
            switch (string3.charAt(0)) {
                case '+': {
                    n = 1;
                    string2 = string3.substring(1);
                    break;
                }
                case '-': {
                    n = -1;
                    string2 = string3.substring(1);
                    break;
                }
                default: {
                    n = 1;
                    string2 = string3;
                }
            }
            if (object3.contains(string2)) {
                COLUMNS.get(string2, (int[])object);
                ((IntVector)object2).add((int)object[0]);
                ((IntVector)object2).add(n);
            }
            parsedProperties.setSortOrder(((IntVector)object2).values());
        }
        string4 = ReportProperties.getReportProperty(iProperties, string, "metrics", true, "method:70,block:80,line:80,class:100");
        object2 = new IntIntMap();
        object = new int[1];
        stringTokenizer = new StringTokenizer(string4, ",");
        while (stringTokenizer.hasMoreTokens()) {
            double d;
            int n;
            block28: {
                string3 = stringTokenizer.nextToken().trim();
                n = string3.indexOf(58);
                if (n <= 0) continue;
                try {
                    d = Double.parseDouble(string3.substring(n + 1));
                    if (d < 0.0) continue;
                    if (d > 101.0) {
                    }
                    break block28;
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace(System.out);
                }
                continue;
            }
            string2 = string3.substring(0, n);
            if (!object3.contains(string2)) continue;
            COLUMNS.get(string2, (int[])object);
            ((IntIntMap)object2).put((int)object[0], (int)Math.round(d * 100.0 / 100.0));
        }
        parsedProperties.setMetrics((IntIntMap)object2);
        parsedProperties.validate();
        return parsedProperties;
    }

    private ReportProperties() {
    }

    private static String getReportProperty(IProperties iProperties, String string, String string2, boolean bl) {
        return ReportProperties.getReportProperty(iProperties, string, string2, bl, null);
    }

    private static String getReportProperty(IProperties iProperties, String string, String string2, boolean bl, String string3) {
        String string4 = iProperties.getProperty("report.".concat(string).concat(".").concat(string2), string3);
        if (!bl && string4 != null && string4.trim().length() == 0) {
            return string3;
        }
        return string4;
    }

    static {
        ObjectIntMap objectIntMap = new ObjectIntMap();
        objectIntMap.put("name", 0);
        objectIntMap.put("class", 1);
        objectIntMap.put("method", 2);
        objectIntMap.put("block", 3);
        objectIntMap.put("line", 4);
        COLUMNS = objectIntMap;
    }

    private static final class ReportPropertyMapper
    implements IProperties.IMapper {
        private ReportPropertyMapper() {
        }

        public String getMappedKey(String string) {
            int n;
            if (string != null && string.startsWith("report.") && (n = string.indexOf(46, "report.".length())) > 0) {
                return "report.".concat(string.substring(n + 1));
            }
            return null;
        }
    }

    public static final class ParsedProperties {
        private String m_outEncoding;
        private File m_outDir;
        private File m_outFile;
        private int m_unitsType;
        private int m_viewType;
        private boolean m_hideClasses;
        private int m_depth;
        private int[] m_columnOrder;
        private int[] m_sortOrder;
        private IntIntMap m_metrics;

        public void setOutEncoding(String string) {
            this.m_outEncoding = string;
        }

        public String getOutEncoding() {
            return this.m_outEncoding;
        }

        public void setOutDir(File file) {
            this.m_outDir = file;
        }

        public File getOutDir() {
            return this.m_outDir;
        }

        public void setOutFile(File file) {
            this.m_outFile = file;
        }

        public File getOutFile() {
            return this.m_outFile;
        }

        public void setUnitsType(int n) {
            this.m_unitsType = n;
        }

        public int getUnitsType() {
            return this.m_unitsType;
        }

        public void setViewType(int n) {
            this.m_viewType = n;
        }

        public int getViewType() {
            return this.m_viewType;
        }

        public void setDepth(int n) {
            this.m_depth = n;
        }

        public int getDepth() {
            return this.m_depth;
        }

        public void setHideClasses(boolean bl) {
            this.m_hideClasses = bl;
        }

        public boolean getHideClasses() {
            return this.m_hideClasses;
        }

        public void setColumnOrder(int[] nArray) {
            this.m_columnOrder = nArray;
        }

        public int[] getColumnOrder() {
            return this.m_columnOrder;
        }

        public void setSortOrder(int[] nArray) {
            this.m_sortOrder = nArray;
        }

        public int[] getSortOrder() {
            return this.m_sortOrder;
        }

        public void setMetrics(IntIntMap intIntMap) {
            this.m_metrics = intIntMap;
        }

        public IntIntMap getMetrics() {
            return this.m_metrics;
        }

        void validate() throws IllegalArgumentException {
        }
    }
}

