/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.jcd.cls.attribute;

import com.vladium.jcd.cls.ElementFactory;
import com.vladium.jcd.cls.IAttributeCollection;
import com.vladium.jcd.cls.IConstantCollection;
import com.vladium.jcd.cls.attribute.AttributeElementFactory;
import com.vladium.jcd.cls.attribute.Attribute_info;
import com.vladium.jcd.cls.attribute.Exception_info;
import com.vladium.jcd.cls.attribute.IAttributeVisitor;
import com.vladium.jcd.cls.attribute.IExceptionHandlerTable;
import com.vladium.jcd.lib.UDataInputStream;
import com.vladium.jcd.lib.UDataOutputStream;
import java.io.IOException;

public final class CodeAttribute_info
extends Attribute_info {
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public int m_max_stack;
    public int m_max_locals;
    private byte[] m_code;
    private int m_codeSize;
    private IExceptionHandlerTable m_exceptionHandlerTable;
    private IAttributeCollection m_attributes;
    private static final boolean DEBUG = false;

    public CodeAttribute_info(int n, int n2, int n3, byte[] byArray, IExceptionHandlerTable iExceptionHandlerTable, IAttributeCollection iAttributeCollection) {
        super(n, (long)(8 + (byArray != null ? byArray.length : 0)) + iExceptionHandlerTable.length() + iAttributeCollection.length());
        this.m_max_stack = n2;
        this.m_max_locals = n3;
        this.m_code = byArray != null ? byArray : EMPTY_BYTE_ARRAY;
        this.m_codeSize = this.m_code.length;
        this.m_exceptionHandlerTable = iExceptionHandlerTable;
        this.m_attributes = iAttributeCollection;
    }

    public final byte[] getCode() {
        return this.m_code;
    }

    public final int getCodeSize() {
        return this.m_codeSize;
    }

    public IAttributeCollection getAttributes() {
        return this.m_attributes;
    }

    public IExceptionHandlerTable getExceptionTable() {
        return this.m_exceptionHandlerTable;
    }

    public long length() {
        return (long)(14 + this.m_codeSize) + this.m_exceptionHandlerTable.length() + this.m_attributes.length();
    }

    public void accept(IAttributeVisitor iAttributeVisitor, Object object) {
        iAttributeVisitor.visit(this, object);
    }

    public String toString() {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CodeAttribute_info: [attribute_name_index = " + this.m_name_index + ", attribute_length = " + this.m_attribute_length + "]" + string);
        stringBuffer.append("    max_stack/max_locals = " + this.m_max_stack + '/' + this.m_max_locals + string);
        stringBuffer.append("    code [length " + this.m_codeSize + "]" + string);
        for (int i = 0; i < this.m_attributes.size(); ++i) {
            stringBuffer.append("         " + this.m_attributes.get(i) + string);
        }
        return stringBuffer.toString();
    }

    public Object clone() {
        CodeAttribute_info codeAttribute_info = (CodeAttribute_info)super.clone();
        codeAttribute_info.m_code = this.m_codeSize == 0 ? EMPTY_BYTE_ARRAY : (byte[])this.m_code.clone();
        codeAttribute_info.m_exceptionHandlerTable = (IExceptionHandlerTable)this.m_exceptionHandlerTable.clone();
        codeAttribute_info.m_attributes = (IAttributeCollection)this.m_attributes.clone();
        return codeAttribute_info;
    }

    public void writeInClassFormat(UDataOutputStream uDataOutputStream) throws IOException {
        super.writeInClassFormat(uDataOutputStream);
        uDataOutputStream.writeU2(this.m_max_stack);
        uDataOutputStream.writeU2(this.m_max_locals);
        uDataOutputStream.writeU4(this.m_codeSize);
        uDataOutputStream.write(this.m_code, 0, this.m_codeSize);
        this.m_exceptionHandlerTable.writeInClassFormat(uDataOutputStream);
        this.m_attributes.writeInClassFormat(uDataOutputStream);
    }

    public void setCode(byte[] byArray, int n) {
        this.m_code = byArray;
        this.m_codeSize = n;
    }

    CodeAttribute_info(IConstantCollection iConstantCollection, int n, long l, UDataInputStream uDataInputStream) throws IOException {
        super(n, l);
        int n2;
        this.m_max_stack = uDataInputStream.readU2();
        this.m_max_locals = uDataInputStream.readU2();
        long l2 = uDataInputStream.readU4();
        this.m_code = new byte[(int)l2];
        uDataInputStream.readFully(this.m_code);
        this.m_codeSize = (int)l2;
        int n3 = uDataInputStream.readU2();
        this.m_exceptionHandlerTable = AttributeElementFactory.newExceptionHandlerTable(n3);
        for (n2 = 0; n2 < n3; ++n2) {
            Exception_info exception_info = new Exception_info(uDataInputStream);
            this.m_exceptionHandlerTable.add(exception_info);
        }
        n2 = uDataInputStream.readU2();
        this.m_attributes = ElementFactory.newAttributeCollection(n2);
        for (int i = 0; i < n2; ++i) {
            Attribute_info attribute_info = Attribute_info.new_Attribute_info(iConstantCollection, uDataInputStream);
            this.m_attributes.add(attribute_info);
        }
    }
}

