/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.jcd.parser;

import com.vladium.jcd.cls.ClassDef;
import com.vladium.jcd.cls.Field_info;
import com.vladium.jcd.cls.IAttributeCollection;
import com.vladium.jcd.cls.IConstantCollection;
import com.vladium.jcd.cls.Method_info;
import com.vladium.jcd.cls.attribute.Attribute_info;
import com.vladium.jcd.cls.attribute.ConstantValueAttribute_info;
import com.vladium.jcd.cls.constant.CONSTANT_Double_info;
import com.vladium.jcd.cls.constant.CONSTANT_Long_info;
import com.vladium.jcd.cls.constant.CONSTANT_info;
import com.vladium.jcd.cls.constant.CONSTANT_literal_info;
import com.vladium.jcd.lib.UDataInputStream;
import com.vladium.util.ByteArrayIStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class ClassDefParser {
    static final boolean PARSE_SERIAL_VERSION_UID = true;
    static final String SERIAL_VERSION_UID_FIELD_NAME = "serialVersionUID";
    static final int SERIAL_VERSION_UID_FIELD_MASK = 24;

    public static ClassDef parseClass(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("null input: bytes");
        }
        classParser classParser2 = new classParser(new UDataInputStream(new ByteArrayIStream(byArray)));
        return classParser2.class_table();
    }

    public static ClassDef parseClass(byte[] byArray, int n) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("null input: bytes");
        }
        classParser classParser2 = new classParser(new UDataInputStream(new ByteArrayIStream(byArray, n)));
        return classParser2.class_table();
    }

    public static ClassDef parseClass(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("null input: bytes");
        }
        classParser classParser2 = new classParser(new UDataInputStream(inputStream));
        return classParser2.class_table();
    }

    private static final class classParser {
        private final UDataInputStream m_bytes;
        private ClassDef m_table;
        private static final boolean DEBUG = false;
        private static final String s_line = "------------------------------------------------------------------------";

        classParser(UDataInputStream uDataInputStream) {
            this.m_bytes = uDataInputStream;
        }

        ClassDef class_table() throws IOException {
            this.m_table = new ClassDef();
            this.magic();
            this.version();
            this.constant_pool();
            this.access_flags();
            this.this_class();
            this.super_class();
            this.interfaces();
            this.fields();
            this.methods();
            this.attributes();
            return this.m_table;
        }

        void magic() throws IOException {
            long l = this.m_bytes.readU4();
            this.m_table.setMagic(l);
        }

        void version() throws IOException {
            int n = this.m_bytes.readU2();
            int n2 = this.m_bytes.readU2();
            this.m_table.setVersion(new int[]{n2, n});
        }

        void constant_pool() throws IOException {
            int n = this.m_bytes.readU2();
            IConstantCollection iConstantCollection = this.m_table.getConstants();
            for (int i = 1; i < n; ++i) {
                CONSTANT_info cONSTANT_info = CONSTANT_info.new_CONSTANT_info(this.m_bytes);
                iConstantCollection.add(cONSTANT_info);
                if (!(cONSTANT_info instanceof CONSTANT_Long_info) && !(cONSTANT_info instanceof CONSTANT_Double_info)) continue;
                ++i;
            }
        }

        void access_flags() throws IOException {
            int n = this.m_bytes.readU2();
            this.m_table.setAccessFlags(n);
        }

        void this_class() throws IOException {
            int n = this.m_bytes.readU2();
            this.m_table.setThisClassIndex(n);
        }

        void super_class() throws IOException {
            int n = this.m_bytes.readU2();
            this.m_table.setSuperClassIndex(n);
        }

        void interfaces() throws IOException {
            int n = this.m_bytes.readU2();
            for (int i = 0; i < n; ++i) {
                int n2 = this.m_bytes.readU2();
                this.m_table.getInterfaces().add(n2);
            }
        }

        void fields() throws IOException {
            int n = this.m_bytes.readU2();
            IConstantCollection iConstantCollection = this.m_table.getConstants();
            for (int i = 0; i < n; ++i) {
                Field_info field_info = new Field_info(iConstantCollection, this.m_bytes);
                this.m_table.getFields().add(field_info);
                if ((field_info.getAccessFlags() & 0x18) != 24 || !ClassDefParser.SERIAL_VERSION_UID_FIELD_NAME.equals(field_info.getName(this.m_table))) continue;
                IAttributeCollection iAttributeCollection = field_info.getAttributes();
                int n2 = iAttributeCollection.size();
                for (int j = 0; j < n2; ++j) {
                    CONSTANT_literal_info cONSTANT_literal_info;
                    Attribute_info attribute_info = iAttributeCollection.get(j);
                    if (!(attribute_info instanceof ConstantValueAttribute_info) || !((cONSTANT_literal_info = ((ConstantValueAttribute_info)attribute_info).getValue(this.m_table)) instanceof CONSTANT_Long_info)) continue;
                    this.m_table.setDeclaredSUID(((CONSTANT_Long_info)cONSTANT_literal_info).m_value);
                }
            }
        }

        void methods() throws IOException {
            int n = this.m_bytes.readU2();
            IConstantCollection iConstantCollection = this.m_table.getConstants();
            for (int i = 0; i < n; ++i) {
                Method_info method_info = new Method_info(iConstantCollection, this.m_bytes);
                this.m_table.getMethods().add(method_info);
            }
        }

        void attributes() throws IOException {
            int n = this.m_bytes.readU2();
            IConstantCollection iConstantCollection = this.m_table.getConstants();
            for (int i = 0; i < n; ++i) {
                Attribute_info attribute_info = Attribute_info.new_Attribute_info(iConstantCollection, this.m_bytes);
                this.m_table.getAttributes().add(attribute_info);
            }
        }
    }
}

