/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.util;

import com.vladium.util.ClassLoadContext;
import com.vladium.util.IClassLoadStrategy;

public abstract class ClassLoaderResolver {
    private static IClassLoadStrategy s_strategy;
    private static final int CALL_CONTEXT_OFFSET = 2;
    private static final CallerResolver CALLER_RESOLVER;

    public static synchronized ClassLoader getClassLoader(Class clazz) {
        ClassLoadContext classLoadContext = new ClassLoadContext(clazz);
        return s_strategy.getClassLoader(classLoadContext);
    }

    public static synchronized ClassLoader getClassLoader() {
        Class clazz = ClassLoaderResolver.getCallerClass(1);
        ClassLoadContext classLoadContext = new ClassLoadContext(clazz);
        return s_strategy.getClassLoader(classLoadContext);
    }

    public static Class getCallerClass(int n) {
        if (CALLER_RESOLVER == null) {
            return null;
        }
        return CALLER_RESOLVER.getClassContext()[2 + n];
    }

    public static boolean isChild(ClassLoader classLoader, ClassLoader classLoader2) {
        if (classLoader == classLoader2) {
            return true;
        }
        if (classLoader2 == null) {
            return false;
        }
        if (classLoader == null) {
            return true;
        }
        while (classLoader2 != null) {
            if (classLoader2 == classLoader) {
                return true;
            }
            classLoader2 = classLoader2.getParent();
        }
        return false;
    }

    public static synchronized IClassLoadStrategy getStrategy() {
        return s_strategy;
    }

    public static synchronized IClassLoadStrategy setStrategy(IClassLoadStrategy iClassLoadStrategy) {
        if (iClassLoadStrategy == null) {
            throw new IllegalArgumentException("null input: strategy");
        }
        IClassLoadStrategy iClassLoadStrategy2 = s_strategy;
        s_strategy = iClassLoadStrategy;
        return iClassLoadStrategy2;
    }

    private ClassLoaderResolver() {
    }

    static {
        CallerResolver callerResolver = null;
        try {
            callerResolver = new CallerResolver();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        CALLER_RESOLVER = callerResolver;
        s_strategy = new DefaultClassLoadStrategy();
    }

    private static final class CallerResolver
    extends SecurityManager {
        private CallerResolver() {
        }

        protected Class[] getClassContext() {
            return super.getClassContext();
        }
    }

    private static final class DefaultClassLoadStrategy
    implements IClassLoadStrategy {
        private DefaultClassLoadStrategy() {
        }

        public ClassLoader getClassLoader(ClassLoadContext classLoadContext) {
            ClassLoader classLoader;
            if (classLoadContext == null) {
                throw new IllegalArgumentException("null input: ctx");
            }
            Class clazz = classLoadContext.getCallerClass();
            ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
            ClassLoader classLoader3 = clazz == null ? classLoader2 : (ClassLoaderResolver.isChild(classLoader = clazz.getClassLoader(), classLoader2) ? classLoader2 : classLoader);
            if (ClassLoaderResolver.isChild(classLoader3, classLoader = ClassLoader.getSystemClassLoader())) {
                classLoader3 = classLoader;
            }
            return classLoader3;
        }
    }
}

