/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Arrays;
import java.util.Collection;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessibilityDetector
extends LayoutDetector {
    public static final Issue ISSUE = Issue.create("ContentDescription", "Ensures that image widgets provide a contentDescription", "Non-textual widgets like ImageViews and ImageButtons should use the contentDescription attribute to specify a textual description of the widget such that screen readers and other accessibility tools can adequately describe the user interface.", Category.A11Y, 3, Severity.WARNING, AccessibilityDetector.class, Scope.RESOURCE_FILE_SCOPE);

    @Override
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public Collection<String> getApplicableElements() {
        return Arrays.asList("ImageButton", "ImageView");
    }

    @Override
    public void visitElement(XmlContext xmlContext, Element element) {
        if (!element.hasAttributeNS("http://schemas.android.com/apk/res/android", "contentDescription")) {
            xmlContext.report(ISSUE, element, xmlContext.getLocation(element), "[Accessibility] Missing contentDescription attribute on image", null);
        } else {
            Attr attr = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "contentDescription");
            String string = attr.getValue();
            if (string.length() == 0 || string.equals("TODO")) {
                xmlContext.report(ISSUE, attr, xmlContext.getLocation(attr), "[Accessibility] Empty contentDescription attribute on image", null);
            }
        }
    }
}

