/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.ApiClass;
import com.android.tools.lint.checks.ApiParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Api {
    private final Map<String, ApiClass> mClasses;

    public static Api parseApi(File file) {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            ApiParser apiParser = new ApiParser();
            sAXParser.parse((InputStream)new FileInputStream(file), (DefaultHandler)apiParser);
            return new Api(apiParser.getClasses());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }

    private Api(Map<String, ApiClass> map) {
        this.mClasses = new HashMap<String, ApiClass>(map);
    }

    public ApiClass getClass(String string) {
        return this.mClasses.get(string);
    }

    public Map<String, ApiClass> getClasses() {
        return Collections.unmodifiableMap(this.mClasses);
    }
}

