/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeprecationDetector
extends LayoutDetector {
    public static final Issue ISSUE = Issue.create("Deprecated", "Looks for usages of deprecated layouts, attributes, and so on.", "Deprecated views, attributes and so on are deprecated because there is a better way to do something. Do it that new way. You've been warned.", Category.CORRECTNESS, 2, Severity.WARNING, DeprecationDetector.class, Scope.RESOURCE_FILE_SCOPE);

    @Override
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public Collection<String> getApplicableElements() {
        return Collections.singletonList("AbsoluteLayout");
    }

    @Override
    public Collection<String> getApplicableAttributes() {
        return Arrays.asList("editable", "inputMethod", "autoText", "capitalize", "enabled", "numeric", "phoneNumber", "password");
    }

    @Override
    public void visitElement(XmlContext xmlContext, Element element) {
        xmlContext.report(ISSUE, element, xmlContext.getLocation(element), String.format("%1$s is deprecated", element.getTagName()), null);
    }

    @Override
    public void visitAttribute(XmlContext xmlContext, Attr attr) {
        String string;
        if (!"http://schemas.android.com/apk/res/android".equals(attr.getNamespaceURI())) {
            return;
        }
        String string2 = attr.getLocalName();
        int n = 1;
        if (string2.equals("editable")) {
            string = "Use an <EditText> to make it editable";
        } else if (string2.equals("enabled")) {
            string = "Use state_enabled instead";
        } else if (string2.equals("singleLine")) {
            string = "Use maxLines=\"1\" instead";
        } else {
            assert (string2.equals("inputMethod") || string2.equals("capitalize") || string2.equals("numeric") || string2.equals("phoneNumber") || string2.equals("password") || string2.equals("autoText"));
            string = "Use inputType instead";
            n = 3;
        }
        if (xmlContext.getProject().getMinSdk() < n) {
            return;
        }
        xmlContext.report(ISSUE, attr, xmlContext.getLocation(attr), String.format("%1$s is deprecated: %2$s", attr.getName(), string), null);
    }
}

