/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DetectMissingPrefix
extends LayoutDetector {
    public static final Issue MISSING_NAMESPACE = Issue.create("MissingPrefix", "Detect XML attributes not using the Android namespace", "Most Android views have attributes in the Android namespace. When referencing these attributes you *must* include the namespace prefix, or your attribute will be interpreted by aapt as just a custom attribute.", Category.CORRECTNESS, 8, Severity.WARNING, DetectMissingPrefix.class, Scope.RESOURCE_FILE_SCOPE);
    private static final Set<String> NO_PREFIX_ATTRS = new HashSet<String>();

    @Override
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public Collection<String> getApplicableAttributes() {
        return ALL;
    }

    @Override
    public void visitAttribute(XmlContext xmlContext, Attr attr) {
        String string = attr.getNamespaceURI();
        if (string == null || string.length() == 0) {
            String string2 = attr.getName();
            if (string2 == null) {
                return;
            }
            if (NO_PREFIX_ATTRS.contains(string2)) {
                return;
            }
            Element element = attr.getOwnerElement();
            if (DetectMissingPrefix.isCustomView(element)) {
                return;
            }
            if (string2.startsWith("xmlns:")) {
                return;
            }
            xmlContext.report(MISSING_NAMESPACE, attr, xmlContext.getLocation(attr), "Attribute is missing the Android namespace prefix", null);
        }
    }

    private static boolean isCustomView(Element element) {
        String string = element.getTagName();
        if (string.equals("view")) {
            return true;
        }
        return string.indexOf(46) != -1 && !string.startsWith("android.");
    }

    static {
        NO_PREFIX_ATTRS.add("class");
        NO_PREFIX_ATTRS.add("style");
        NO_PREFIX_ATTRS.add("layout");
    }
}

