/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceFolderType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DuplicateIdDetector
extends LayoutDetector {
    private Set<String> mIds;
    private Map<File, Set<String>> mFileToIds;
    private Map<File, List<String>> mIncludes;
    private Multimap<File, Multimap<String, Occurrence>> mLocations;
    private List<Occurrence> mErrors;
    public static final Issue WITHIN_LAYOUT = Issue.create("DuplicateIds", "Checks for duplicate ids within a single layout", "Within a layout, id's should be unique since otherwise findViewById() can return an unexpected view.", Category.CORRECTNESS, 7, Severity.WARNING, DuplicateIdDetector.class, Scope.RESOURCE_FILE_SCOPE);
    public static final Issue CROSS_LAYOUT = Issue.create("DuplicateIncludedIds", "Checks for duplicate ids across layouts that are combined with include tags", "It's okay for two independent layouts to use the same ids. However, if layouts are combined with include tags, then the id's need to be unique within any chain of included layouts, or Activity#findViewById() can return an unexpected view.", Category.CORRECTNESS, 6, Severity.WARNING, DuplicateIdDetector.class, Scope.ALL_RESOURCES_SCOPE);

    @Override
    public boolean appliesTo(ResourceFolderType resourceFolderType) {
        return resourceFolderType == ResourceFolderType.LAYOUT || resourceFolderType == ResourceFolderType.MENU;
    }

    @Override
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public Collection<String> getApplicableAttributes() {
        return Collections.singletonList("id");
    }

    @Override
    public Collection<String> getApplicableElements() {
        return Collections.singletonList("include");
    }

    @Override
    public void beforeCheckFile(Context context) {
        if (context.getPhase() == 1) {
            this.mIds = new HashSet<String>();
        }
    }

    @Override
    public void afterCheckFile(Context context) {
        if (context.getPhase() == 1) {
            this.mFileToIds.put(context.file, this.mIds);
            this.mIds = null;
        }
    }

    @Override
    public void beforeCheckProject(Context context) {
        if (context.getPhase() == 1) {
            this.mFileToIds = new HashMap<File, Set<String>>();
            this.mIncludes = new HashMap<File, List<String>>();
        }
    }

    @Override
    public void afterCheckProject(Context context) {
        if (context.getPhase() == 1) {
            if (this.mIncludes.size() > 0 && context.isEnabled(CROSS_LAYOUT) && context.getScope().contains((Object)Scope.ALL_RESOURCE_FILES)) {
                IncludeGraph includeGraph = new IncludeGraph(context);
                includeGraph.check();
            }
        } else {
            assert (context.getPhase() == 2);
            if (this.mErrors != null) {
                for (Occurrence occurrence : this.mErrors) {
                    Object object;
                    ArrayList<Object> arrayList;
                    Location location = occurrence.location;
                    if (location == null) {
                        location = Location.create(occurrence.file);
                    } else {
                        arrayList = location.getClientData();
                        if (arrayList instanceof Node) {
                            object = (Node)((Object)arrayList);
                            if (context.getDriver().isSuppressed(CROSS_LAYOUT, (Node)object)) continue;
                        }
                    }
                    arrayList = new ArrayList<Object>();
                    object = occurrence.next;
                    while (object != null) {
                        arrayList.add(object);
                        object = ((Occurrence)object).next;
                    }
                    Collections.sort(arrayList);
                    Location location2 = location;
                    for (Occurrence occurrence2 : arrayList) {
                        if (occurrence2.location == null) continue;
                        location2.setSecondary(occurrence2.location);
                        location2 = occurrence2.location;
                    }
                    context.report(CROSS_LAYOUT, location, occurrence.message, null);
                }
            }
        }
    }

    @Override
    public void visitElement(XmlContext xmlContext, Element element) {
        String string = element.getAttribute("layout");
        if (string.startsWith("@layout/")) {
            string = string.substring("@layout/".length());
            if (xmlContext.getPhase() == 1) {
                List<String> list = this.mIncludes.get(xmlContext.file);
                if (list == null) {
                    list = new ArrayList<String>();
                    this.mIncludes.put(xmlContext.file, list);
                }
                list.add(string);
            } else {
                assert (xmlContext.getPhase() == 2);
                Collection<Multimap<String, Occurrence>> collection = this.mLocations.get(xmlContext.file);
                if (collection != null && collection.size() > 0) {
                    for (Multimap<String, Occurrence> multimap : collection) {
                        Collection<Occurrence> collection2;
                        if (collection.size() <= 0 || (collection2 = multimap.get(string)) == null || collection2.size() <= 0) continue;
                        for (Occurrence occurrence : collection2) {
                            Location location = xmlContext.getLocation(element);
                            location.setClientData(element);
                            location.setMessage(occurrence.message);
                            location.setSecondary(occurrence.location);
                            occurrence.location = location;
                        }
                    }
                }
            }
        }
    }

    @Override
    public void visitAttribute(XmlContext xmlContext, Attr attr) {
        block9: {
            String string;
            block7: {
                block8: {
                    assert (attr.getName().equals("id") || attr.getLocalName().equals("id"));
                    string = attr.getValue();
                    if (xmlContext.getPhase() != 1) break block7;
                    if (!this.mIds.contains(string)) break block8;
                    Location location = xmlContext.getLocation(attr);
                    Attr attr2 = this.findIdAttribute(attr.getOwnerDocument(), string);
                    if (attr2 != null && attr2 != attr) {
                        Location location2 = xmlContext.getLocation(attr2);
                        location2.setMessage(String.format("%1$s originally defined here", string));
                        location.setSecondary(location2);
                    }
                    xmlContext.report(WITHIN_LAYOUT, attr, location, String.format("Duplicate id %1$s, already defined earlier in this layout", string), null);
                    break block9;
                }
                if (!string.startsWith("@+id/")) break block9;
                if (attr.getOwnerElement().getTagName().equals("include")) {
                    return;
                }
                this.mIds.add(string);
                break block9;
            }
            Collection<Multimap<String, Occurrence>> collection = this.mLocations.get(xmlContext.file);
            if (collection != null && collection.size() > 0) {
                for (Multimap<String, Occurrence> multimap : collection) {
                    Collection<Occurrence> collection2;
                    if (collection.size() <= 0 || (collection2 = multimap.get(string)) == null || collection2.size() <= 0) continue;
                    for (Occurrence occurrence : collection2) {
                        if (xmlContext.getDriver().isSuppressed(CROSS_LAYOUT, attr)) {
                            return;
                        }
                        Location location = xmlContext.getLocation(attr);
                        location.setClientData(attr);
                        location.setMessage(occurrence.message);
                        location.setSecondary(occurrence.location);
                        occurrence.location = location;
                    }
                }
            }
        }
    }

    private Attr findIdAttribute(Node node, String string) {
        Object object;
        if (node.getNodeType() == 1 && (object = ((Element)node).getAttributeNodeNS("http://schemas.android.com/apk/res/android", "id")) != null && object.getValue().equals(string)) {
            return object;
        }
        object = node.getChildNodes();
        int n = object.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = object.item(i);
            Attr attr = this.findIdAttribute(node2, string);
            if (attr == null) continue;
            return attr;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Occurrence
    implements Comparable<Occurrence> {
        public Occurrence next;
        public File file;
        public Location location;
        public String message;
        public String includePath;

        public Occurrence(File file, String string, String string2) {
            this.file = file;
            this.message = string;
            this.includePath = string2;
        }

        public String toString() {
            return this.includePath != null ? this.includePath : this.message;
        }

        @Override
        public int compareTo(Occurrence occurrence) {
            int n = this.toString().length() - occurrence.toString().length();
            if (n != 0) {
                return n;
            }
            return this.toString().compareTo(occurrence.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IncludeGraph {
        private final Context mContext;
        private final Map<File, Layout> mFileToLayout;

        public IncludeGraph(Context context) {
            Object object;
            this.mContext = context;
            this.mFileToLayout = new HashMap<File, Layout>(2 * DuplicateIdDetector.this.mIncludes.size());
            for (Object object2 : DuplicateIdDetector.this.mIncludes.keySet()) {
                if (this.mFileToLayout.containsKey(object2)) continue;
                this.mFileToLayout.put((File)object2, new Layout((File)object2, (Set)DuplicateIdDetector.this.mFileToIds.get(object2)));
            }
            for (Object object2 : DuplicateIdDetector.this.mFileToIds.keySet()) {
                Set object3 = (Set)DuplicateIdDetector.this.mFileToIds.get(object2);
                if (object3 == null || object3.size() <= 0 || this.mFileToLayout.containsKey(object2)) continue;
                this.mFileToLayout.put((File)object2, new Layout((File)object2, object3));
            }
            ArrayListMultimap arrayListMultimap = ArrayListMultimap.create(this.mFileToLayout.size(), 4);
            for (File file : this.mFileToLayout.keySet()) {
                object = LintUtils.getLayoutName(file);
                arrayListMultimap.put(object, this.mFileToLayout.get(file));
            }
            for (File file : DuplicateIdDetector.this.mIncludes.keySet()) {
                object = this.mFileToLayout.get(file);
                assert (object != null) : file;
                List list = (List)DuplicateIdDetector.this.mIncludes.get(file);
                for (String string : list) {
                    Collection collection = arrayListMultimap.get(string);
                    if (collection == null || collection.size() <= 0) continue;
                    if (collection.size() == 1) {
                        ((Layout)object).include((Layout)collection.iterator().next());
                        continue;
                    }
                    File file2 = ((Layout)object).getFile().getParentFile();
                    File file3 = new File(file2, string + ".xml");
                    Layout layout = this.mFileToLayout.get(file3);
                    if (layout != null) {
                        ((Layout)object).include(layout);
                        continue;
                    }
                    if (DuplicateIdDetector.this.mFileToIds.containsKey(file3)) continue;
                    for (Layout layout2 : collection) {
                        if (!this.isCompatible((Layout)object, layout2)) continue;
                        ((Layout)object).include(layout2);
                    }
                }
            }
        }

        boolean isCompatible(Layout layout, Layout layout2) {
            File file;
            File file2 = layout.mFile.getParentFile();
            if (file2.equals(file = layout2.mFile.getParentFile())) {
                return true;
            }
            String[] stringArray = file2.getName().split("-");
            String[] stringArray2 = file.getName().split("-");
            return this.isPortrait(stringArray) == this.isPortrait(stringArray2);
        }

        private boolean isPortrait(String[] stringArray) {
            for (String string : stringArray) {
                if (string.equals("port")) {
                    return true;
                }
                if (!string.equals("land")) continue;
                return false;
            }
            return true;
        }

        public void check() {
            for (Layout layout : this.mFileToLayout.values()) {
                if (layout.isIncluded()) continue;
                ArrayDeque<Layout> arrayDeque = new ArrayDeque<Layout>();
                this.getIds(layout, arrayDeque, new HashSet<Layout>());
            }
        }

        private Set<String> getIds(Layout layout, Deque<Layout> deque, Set<Layout> set) {
            set.add(layout);
            Set<String> set2 = layout.getIds();
            List<Layout> list = layout.getIncludes();
            if (list != null) {
                HashSet<String> hashSet = new HashSet<String>();
                if (set2 != null) {
                    hashSet.addAll(set2);
                }
                deque.push(layout);
                ArrayListMultimap<String, Set<String>> arrayListMultimap = ArrayListMultimap.create(list.size(), 4);
                for (Layout layout2 : list) {
                    Set<String> set3;
                    if (set.contains(layout2) || (set3 = this.getIds(layout2, deque, set)) == null) continue;
                    String string = layout2.getLayoutName();
                    block1: for (String string2 : set3) {
                        if (hashSet.contains(string2)) {
                            Collection<Object> collection32;
                            Collection collection2 = arrayListMultimap.get(string);
                            if (collection2 != null) {
                                for (Collection<Object> collection32 : collection2) {
                                    if (!collection32.contains(string2)) continue;
                                    continue block1;
                                }
                            }
                            if (DuplicateIdDetector.this.mLocations == null) {
                                DuplicateIdDetector.this.mErrors = new ArrayList();
                                DuplicateIdDetector.this.mLocations = ArrayListMultimap.create();
                                this.mContext.getDriver().requestRepeat(DuplicateIdDetector.this, Scope.ALL_RESOURCES_SCOPE);
                            }
                            HashMap hashMap = new HashMap();
                            this.findId(layout, string2, new ArrayDeque<Layout>(), hashMap, new HashSet<Layout>());
                            assert (hashMap.size() >= 2);
                            collection32 = hashMap.values();
                            ArrayList arrayList = new ArrayList(collection32);
                            Collections.sort(arrayList);
                            String string3 = String.format("Duplicate id %1$s, defined or included multiple times in %2$s: %3$s", string2, layout.getDisplayName(), ((Object)arrayList).toString());
                            Occurrence occurrence = new Occurrence(layout.getFile(), string3, null);
                            ArrayListMultimap<String, Occurrence> arrayListMultimap2 = ArrayListMultimap.create();
                            arrayListMultimap2.put(string, occurrence);
                            DuplicateIdDetector.this.mLocations.put(layout.getFile(), arrayListMultimap2);
                            DuplicateIdDetector.this.mErrors.add(occurrence);
                            Occurrence occurrence2 = occurrence;
                            for (Occurrence occurrence3 : collection32) {
                                occurrence3.message = occurrence3.file.equals(layout.getFile()) ? "Defined here" : String.format("Defined here, included via %1$s", occurrence3.includePath);
                                arrayListMultimap2 = ArrayListMultimap.create();
                                arrayListMultimap2.put(string2, occurrence3);
                                DuplicateIdDetector.this.mLocations.put(occurrence3.file, arrayListMultimap2);
                                occurrence2.next = occurrence3;
                                occurrence2 = occurrence3;
                            }
                        }
                        hashSet.add(string2);
                    }
                    arrayListMultimap.put(string, set3);
                }
                Layout layout3 = deque.pop();
                assert (layout3 == layout);
                return hashSet;
            }
            return set2;
        }

        private void findId(Layout layout, String string, Deque<Layout> deque, Map<Layout, Occurrence> map, Set<Layout> set) {
            Object object;
            Object object2;
            set.add(layout);
            Set<String> set2 = layout.getIds();
            if (set2 != null && set2.contains(string)) {
                object2 = new StringBuilder();
                if (!deque.isEmpty()) {
                    object = deque.descendingIterator();
                    while (object.hasNext()) {
                        ((StringBuilder)object2).append(((Layout)object.next()).getDisplayName());
                        ((StringBuilder)object2).append(" => ");
                    }
                }
                ((StringBuilder)object2).append(layout.getDisplayName());
                ((StringBuilder)object2).append(" defines ");
                ((StringBuilder)object2).append(string);
                assert (map.get(layout) == null) : string + "," + layout;
                map.put(layout, new Occurrence(layout.getFile(), null, ((StringBuilder)object2).toString()));
            }
            if ((object2 = layout.getIncludes()) != null) {
                deque.push(layout);
                object = object2.iterator();
                while (object.hasNext()) {
                    Layout layout2 = (Layout)object.next();
                    if (set.contains(layout2)) continue;
                    this.findId(layout2, string, deque, map, set);
                }
                object = deque.pop();
                assert (object == layout);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Layout {
        private File mFile;
        private List<Layout> mIncludes;
        private List<Layout> mIncludedBy;
        private Set<String> mIds;

        Layout(File file, Set<String> set) {
            this.mFile = file;
            this.mIds = set;
        }

        Set<String> getIds() {
            return this.mIds;
        }

        String getLayoutName() {
            return LintUtils.getLayoutName(this.mFile);
        }

        String getDisplayName() {
            return this.mFile.getParentFile().getName() + File.separator + this.mFile.getName();
        }

        void include(Layout layout) {
            if (this.mIncludes == null) {
                this.mIncludes = new ArrayList<Layout>();
            }
            this.mIncludes.add(layout);
            if (layout.mIncludedBy == null) {
                layout.mIncludedBy = new ArrayList<Layout>();
            }
            layout.mIncludedBy.add(this);
        }

        boolean isIncluded() {
            return this.mIncludedBy != null && this.mIncludedBy.size() > 0;
        }

        File getFile() {
            return this.mFile;
        }

        List<Layout> getIncludes() {
            return this.mIncludes;
        }

        public String toString() {
            return this.getDisplayName();
        }
    }
}

