/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldGetterDetector
extends Detector
implements Detector.ClassScanner {
    public static final Issue ISSUE = Issue.create("FieldGetter", "Suggests replacing uses of getters with direct field access within a class", "Accessing a field within the class that defines a getter for that field is at least 3 times faster than calling the getter. For simple getters that do nothing other than return the field, you might want to just reference the local field directly instead.", Category.PERFORMANCE, 4, Severity.WARNING, FieldGetterDetector.class, EnumSet.of(Scope.CLASS_FILE)).setEnabledByDefault(false).setMoreInfo("http://developer.android.com/guide/practices/design/performance.html#internal_get_set");

    @Override
    public boolean appliesTo(Context context, File file) {
        return true;
    }

    @Override
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public void checkClass(ClassContext classContext, ClassNode classNode) {
        Object object;
        Object object2;
        Object object3;
        ArrayList<Entry> arrayList = null;
        int n = 0;
        List list = classNode.methods;
        for (Object object5 : list) {
            MethodNode object42 = (MethodNode)object5;
            object3 = object42.instructions;
            int n2 = ((InsnList)object3).size();
            for (int i = 0; i < n2; ++i) {
                AbstractInsnNode abstractInsnNode = ((InsnList)object3).get(i);
                int n3 = abstractInsnNode.getType();
                if (n3 == 15) {
                    n = ((LineNumberNode)abstractInsnNode).line;
                    continue;
                }
                if (n3 != 5) continue;
                object2 = (MethodInsnNode)abstractInsnNode;
                String string = ((MethodInsnNode)object2).name;
                object = ((MethodInsnNode)object2).owner;
                if ((!string.startsWith("get") || string.length() <= 3 || !Character.isUpperCase(string.charAt(3))) && (!string.startsWith("is") || string.length() <= 2 || !Character.isUpperCase(string.charAt(2))) || !((String)object).equals(classNode.name)) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<Entry>();
                }
                arrayList.add(new Entry(string, n, object42));
            }
        }
        if (arrayList != null) {
            Object object5;
            HashSet hashSet = new HashSet(arrayList.size());
            for (Entry entry : arrayList) {
                hashSet.add(entry.name);
            }
            object5 = FieldGetterDetector.checkMethods(classContext.getClassNode(), hashSet);
            if (object5.size() > 0) {
                File file = classContext.getSourceFile();
                object3 = classContext.getSourceContents();
                for (String string : object5.keySet()) {
                    for (Entry entry : arrayList) {
                        object2 = entry.name;
                        if (!((String)object2).equals(string)) continue;
                        int n4 = entry.lineNumber;
                        object = null;
                        object = file != null ? Location.create(file, (String)object3, n4 - 1, (String)object2, null) : Location.create(classContext.file);
                        String string2 = (String)object5.get(string);
                        if (string2 == null) {
                            string2 = "";
                        }
                        classContext.report(ISSUE, entry.method, (Location)object, String.format("Calling getter method %1$s() on self is slower than field access (%2$s)", string, string2), (Object)string2);
                    }
                }
            }
        }
    }

    private static Map<String, String> checkMethods(ClassNode classNode, Set<String> set) {
        HashMap<String, String> hashMap = Maps.newHashMap();
        List list = classNode.methods;
        String string = null;
        block6: for (Object e : list) {
            MethodNode methodNode = (MethodNode)e;
            if (!set.contains(methodNode.name) || !methodNode.desc.startsWith("()")) continue;
            InsnList insnList = methodNode.instructions;
            int n = 1;
            block7: for (AbstractInsnNode abstractInsnNode = insnList.getFirst(); abstractInsnNode != null; abstractInsnNode = abstractInsnNode.getNext()) {
                switch (abstractInsnNode.getOpcode()) {
                    case -1: {
                        continue block7;
                    }
                    case 25: {
                        if (n != true) continue block6;
                        string = null;
                        n = 2;
                        continue block7;
                    }
                    case 180: {
                        if (n != 2) continue block6;
                        FieldInsnNode fieldInsnNode = (FieldInsnNode)abstractInsnNode;
                        string = fieldInsnNode.name;
                        n = 3;
                        continue block7;
                    }
                    case 172: 
                    case 173: 
                    case 174: 
                    case 175: 
                    case 176: 
                    case 177: {
                        if (n != 3) continue block6;
                        hashMap.put(methodNode.name, string);
                        continue block6;
                    }
                    default: {
                        continue block6;
                    }
                }
            }
        }
        return hashMap;
    }

    private static class Entry {
        public final String name;
        public final int lineNumber;
        public final MethodNode method;

        public Entry(String string, int n, MethodNode methodNode) {
            this.name = string;
            this.lineNumber = n;
            this.method = methodNode;
        }
    }
}

