/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import java.io.File;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class MathDetector
extends Detector
implements Detector.ClassScanner {
    public static final Issue ISSUE = Issue.create("FloatMath", "Suggests replacing java.lang.Math calls with android.util.FloatMath to avoid conversions", "On modern hardware, \"double\" is just as fast as \"float\" though of course it takes more memory. However, if you are using floats and you need to compute the sine, cosine or square root, then it is better to use the android.util.FloatMath class instead of java.lang.Math since you can call methods written to operate on floats, so you avoid conversions back and forth to double.", Category.PERFORMANCE, 3, Severity.WARNING, MathDetector.class, EnumSet.of(Scope.CLASS_FILE)).setMoreInfo("http://developer.android.com/guide/practices/design/performance.html#avoidfloat");
    private static final Set<String> sFloatMethods = new HashSet<String>();

    public boolean appliesTo(Context context, File file) {
        return true;
    }

    public Speed getSpeed() {
        return Speed.FAST;
    }

    public void checkClass(ClassContext classContext, ClassNode classNode) {
        List list = classNode.methods;
        for (Object e : list) {
            MethodNode methodNode = (MethodNode)e;
            InsnList insnList = methodNode.instructions;
            int n = insnList.size();
            for (int i = 0; i < n; ++i) {
                boolean bl;
                AbstractInsnNode abstractInsnNode = insnList.get(i);
                int n2 = abstractInsnNode.getType();
                if (n2 != 5) continue;
                MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
                String string = methodInsnNode.name;
                String string2 = methodInsnNode.owner;
                if (!sFloatMethods.contains(string) || !string2.equals("java/lang/Math")) continue;
                boolean bl2 = this.getPrevOpcode(insnList, i) == 141;
                boolean bl3 = bl = this.getNextOpcode(insnList, i) == 144;
                if (!bl2 && !bl) continue;
                String string3 = bl2 ? String.format("Use android.util.FloatMath#%1$s() instead of java.lang.Math#%1$s to avoid argument float to double conversion", string) : String.format("Use android.util.FloatMath#%1$s() instead of java.lang.Math#%1$s to avoid double to float return value conversion", string);
                int n3 = ClassContext.findLineNumber(abstractInsnNode);
                Location location = classContext.getLocationForLine(n3, string, null);
                classContext.report(ISSUE, methodNode, location, string3, null);
            }
        }
    }

    private int getPrevOpcode(InsnList insnList, int n) {
        --n;
        while (n >= 0) {
            AbstractInsnNode abstractInsnNode = insnList.get(n);
            int n2 = abstractInsnNode.getType();
            if (n2 != 15 && n2 != 8) {
                return abstractInsnNode.getOpcode();
            }
            --n;
        }
        return 0;
    }

    private int getNextOpcode(InsnList insnList, int n) {
        ++n;
        while (n < insnList.size()) {
            AbstractInsnNode abstractInsnNode = insnList.get(n);
            int n2 = abstractInsnNode.getType();
            if (n2 != 15 && n2 != 8) {
                return abstractInsnNode.getOpcode();
            }
            ++n;
        }
        return 0;
    }

    static {
        sFloatMethods.add("sin");
        sFloatMethods.add("cos");
        sFloatMethods.add("ceil");
        sFloatMethods.add("sqrt");
        sFloatMethods.add("floor");
    }
}

