/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.util.Pair;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.ast.AstVisitor;
import lombok.ast.Expression;
import lombok.ast.MethodInvocation;
import lombok.ast.Select;
import lombok.ast.StrictListAccessor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeRootFrameLayoutDetector
extends LayoutDetector
implements Detector.JavaScanner {
    private Set<String> mWhitelistedLayouts;
    private List<Pair<String, Location.Handle>> mPending;
    public static final Issue ISSUE = Issue.create("MergeRootFrame", "Checks whether a root <FrameLayout> can be replaced with a <merge> tag", "If a <FrameLayout> is the root of a layout and does not provide background or padding etc, it can often be replaced with a <merge> tag which is slightly more efficient. Note that this depends on context, so make sure you understand how the <merge> tag works before proceeding.", Category.PERFORMANCE, 4, Severity.WARNING, MergeRootFrameLayoutDetector.class, EnumSet.of(Scope.ALL_RESOURCE_FILES, Scope.JAVA_FILE)).setMoreInfo("http://android-developers.blogspot.com/2009/03/android-layout-tricks-3-optimize-by.html");

    @Override
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public boolean appliesTo(Context context, File file) {
        return LintUtils.isXmlFile(file) || LintUtils.endsWith(file.getName(), ".java");
    }

    @Override
    public void afterCheckProject(Context context) {
        if (this.mPending != null && this.mWhitelistedLayouts != null) {
            for (Pair<String, Location.Handle> pair : this.mPending) {
                String string = pair.getFirst();
                if (!this.mWhitelistedLayouts.contains(string)) continue;
                Location.Handle handle = pair.getSecond();
                Object object = handle.getClientData();
                if (object instanceof Node && context.getDriver().isSuppressed(ISSUE, (Node)object)) {
                    return;
                }
                Location location = handle.resolve();
                context.report(ISSUE, location, "This <FrameLayout> can be replaced with a <merge> tag", null);
            }
        }
    }

    @Override
    public Collection<String> getApplicableElements() {
        return Arrays.asList("include", "FrameLayout");
    }

    @Override
    public void visitElement(XmlContext xmlContext, Element element) {
        String string = element.getTagName();
        if (string.equals("include")) {
            String string2 = element.getAttribute("layout");
            if (string2.startsWith("@layout/")) {
                string2 = string2.substring("@layout/".length());
                this.whiteListLayout(string2);
            }
        } else {
            assert (string.equals("FrameLayout"));
            if (LintUtils.isRootElement(element) && (MergeRootFrameLayoutDetector.isWidthFillParent(element) && MergeRootFrameLayoutDetector.isHeightFillParent(element) || !element.hasAttributeNS("http://schemas.android.com/apk/res/android", "layout_gravity")) && !element.hasAttributeNS("http://schemas.android.com/apk/res/android", "background") && !element.hasAttributeNS("http://schemas.android.com/apk/res/android", "foreground") && !this.hasPadding(element)) {
                String string3 = LintUtils.getLayoutName(xmlContext.file);
                Location.Handle handle = xmlContext.parser.createLocationHandle(xmlContext, element);
                handle.setClientData(element);
                if (this.mPending == null) {
                    this.mPending = new ArrayList<Pair<String, Location.Handle>>();
                }
                this.mPending.add(Pair.of(string3, handle));
            }
        }
    }

    private void whiteListLayout(String string) {
        if (this.mWhitelistedLayouts == null) {
            this.mWhitelistedLayouts = new HashSet<String>();
        }
        this.mWhitelistedLayouts.add(string);
    }

    @Override
    public List<String> getApplicableMethodNames() {
        return Collections.singletonList("setContentView");
    }

    @Override
    public void visitMethod(JavaContext javaContext, AstVisitor astVisitor, MethodInvocation methodInvocation) {
        String string;
        Expression expression;
        StrictListAccessor strictListAccessor = methodInvocation.astArguments();
        if (strictListAccessor != null && strictListAccessor.size() == 1 && (expression = (Expression)strictListAccessor.first()) instanceof Select && (string = expression.toString()).startsWith("R.layout.")) {
            this.whiteListLayout(string.substring("R.layout.".length()));
        }
    }
}

